/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.score.noteProcessorChain;

import blue.noteProcessor.Code;
import blue.soundObject.pianoRoll.Scale;
import blue.ui.core.score.noteProcessorChain.CodeEditor;
import blue.ui.core.score.noteProcessorChain.ScaleEditor;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;

class PropertyEditProxyEditor
implements TableCellEditor,
ActionListener {
    protected transient Vector listeners = new Vector();
    JTextField textField = new JTextField();
    ScaleEditor scaleEditor = new ScaleEditor();
    CodeEditor codeEditor = new CodeEditor();
    EditorDelegate textDelegate;
    EditorDelegate scaleDelegate;
    EditorDelegate codeDelegate;
    Component editor;
    EditorDelegate delegate;

    public PropertyEditProxyEditor() {
        this.textField.addActionListener(this);
        this.textField.setBorder(null);
        this.scaleEditor.addActionListener(this);
        this.textDelegate = new EditorDelegate(){

            @Override
            public void setValue(Object value) {
                PropertyEditProxyEditor.this.textField.setText(value != null ? value.toString() : "");
            }

            @Override
            public Object getValue() {
                return PropertyEditProxyEditor.this.textField.getText();
            }
        };
        this.scaleDelegate = new EditorDelegate(){

            @Override
            public void setValue(Object val) {
                PropertyEditProxyEditor.this.scaleEditor.setScale((Scale)val);
            }

            @Override
            public Object getValue() {
                return PropertyEditProxyEditor.this.scaleEditor.getScale();
            }
        };
        this.codeDelegate = new EditorDelegate(){

            @Override
            public void setValue(Object val) {
                PropertyEditProxyEditor.this.codeEditor.setCode((Code)val);
            }

            @Override
            public Object getValue() {
                return PropertyEditProxyEditor.this.codeEditor.getCode();
            }
        };
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.editor = this.getCellEditorComponent(value);
        this.delegate = this.getEditorDelegate(value);
        this.editor.setVisible(true);
        this.delegate.setValue(value);
        return this.editor;
    }

    private Component getCellEditorComponent(Object obj) {
        if (!(obj instanceof File || obj instanceof Boolean || obj instanceof Number)) {
            if (obj instanceof Scale) {
                return this.scaleEditor;
            }
            if (obj instanceof Code) {
                return this.codeEditor;
            }
        }
        return this.textField;
    }

    private EditorDelegate getEditorDelegate(Object obj) {
        if (!(obj instanceof File || obj instanceof Boolean || obj instanceof Number)) {
            if (obj instanceof Scale) {
                return this.scaleDelegate;
            }
            if (obj instanceof Code) {
                return this.codeDelegate;
            }
        }
        return this.textDelegate;
    }

    @Override
    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    @Override
    public boolean stopCellEditing() {
        this.fireEditingStopped();
        return true;
    }

    @Override
    public Object getCellEditorValue() {
        if (this.delegate == null) {
            return null;
        }
        return this.delegate.getValue();
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        this.listeners.addElement(l);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        this.listeners.remove(l);
    }

    private void fireEditingCanceled() {
        ChangeEvent ce = new ChangeEvent(this);
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            CellEditorListener listener = (CellEditorListener)this.listeners.get(i);
            listener.editingCanceled(ce);
        }
        if (this.editor != null) {
            this.editor.setVisible(false);
        }
    }

    private void fireEditingStopped() {
        ChangeEvent ce = new ChangeEvent(this);
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            CellEditorListener listener = (CellEditorListener)this.listeners.get(i);
            listener.editingStopped(ce);
        }
        if (this.editor != null) {
            this.editor.setVisible(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.fireEditingStopped();
    }

    static interface EditorDelegate {
        public void setValue(Object var1);

        public Object getValue();
    }
}

