/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.score;

import blue.ui.core.score.ModeListener;
import blue.ui.core.score.ScoreMode;
import java.util.Vector;

public class ModeManager {
    private static ModeManager instance = null;
    private ScoreMode mode = ScoreMode.SCORE;
    private Vector listeners = null;

    private ModeManager() {
    }

    public static ModeManager getInstance() {
        if (instance == null) {
            instance = new ModeManager();
        }
        return instance;
    }

    public ScoreMode getMode() {
        return this.mode;
    }

    public void setMode(ScoreMode mode) {
        this.mode = mode;
        this.fireModeChanged(mode);
    }

    public void nextMode() {
        this.mode = this.mode.ordinal() < ScoreMode.MULTI_LINE.ordinal() ? ScoreMode.values()[this.mode.ordinal() + 1] : ScoreMode.SCORE;
        this.fireModeChanged(this.mode);
    }

    public void previousMode() {
        this.mode = this.mode.ordinal() > ScoreMode.SCORE.ordinal() ? ScoreMode.values()[this.mode.ordinal() - 1] : ScoreMode.MULTI_LINE;
        this.fireModeChanged(this.mode);
    }

    public void addModeListener(ModeListener listener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.add(listener);
    }

    public void removeModeListener(ModeListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    public void fireModeChanged(ScoreMode mode) {
        if (this.listeners != null) {
            for (ModeListener listener : new Vector(this.listeners)) {
                listener.modeChanged(mode);
            }
        }
    }
}

