/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.render;

import blue.BlueData;
import blue.BlueSystem;
import blue.SoundLayer;
import blue.event.PlayModeListener;
import blue.gui.ExceptionDialog;
import blue.mixer.Mixer;
import blue.score.layers.LayerGroup;
import blue.services.render.CsoundBinding;
import blue.services.render.RealtimeRenderService;
import blue.services.render.RealtimeRenderServiceFactory;
import blue.settings.RealtimeRenderSettings;
import blue.soundObject.PolyObject;
import blue.soundObject.SoundObject;
import blue.soundObject.SoundObjectException;
import blue.ui.core.render.BlueLiveBinding;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.openide.awt.StatusDisplayer;
import org.openide.windows.WindowManager;

public final class RealtimeRenderManager {
    private boolean looping = false;
    private static RealtimeRenderManager instance = null;
    private ArrayList<PlayModeListener> listeners = new ArrayList();
    private ArrayList<PlayModeListener> blueLiveListeners = new ArrayList();
    private RealtimeRenderServiceFactory currentRenderServiceFactory = null;
    private RealtimeRenderService currentRenderService = null;
    private RealtimeRenderService currentBlueLiveRenderService = null;
    private PlayModeListener realtimeListener = playMode -> {
        if (this.shuttingDown) {
            return;
        }
        if (playMode == 0) {
            this.auditioning = false;
        }
        for (PlayModeListener listener : this.listeners) {
            listener.playModeChanged(playMode);
        }
    };
    private PlayModeListener blueLiveListener = playMode -> {
        if (this.shuttingDown) {
            return;
        }
        for (PlayModeListener listener : this.blueLiveListeners) {
            listener.playModeChanged(playMode);
        }
    };
    private boolean auditioning = false;
    private boolean shuttingDown = false;

    private RealtimeRenderManager() {
    }

    public static RealtimeRenderManager getInstance() {
        if (instance == null) {
            instance = new RealtimeRenderManager();
        }
        return instance;
    }

    public void addPlayModeListener(PlayModeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removePlayModeListener(PlayModeListener listener) {
        this.listeners.remove(listener);
    }

    public void addBlueLivePlayModeListener(PlayModeListener listener) {
        if (!this.blueLiveListeners.contains(listener)) {
            this.blueLiveListeners.add(listener);
        }
    }

    public void removeBlueLivePlayModeListener(PlayModeListener listener) {
        this.blueLiveListeners.remove(listener);
    }

    public void renderProject(BlueData data) {
        this.renderProject(data, false);
    }

    protected void renderProject(BlueData data, boolean auditioning) {
        if (this.isRendering()) {
            this.stopRendering();
        }
        if (data == null) {
            this.auditioning = false;
            return;
        }
        this.auditioning = auditioning;
        StatusDisplayer.getDefault().setStatusText(BlueSystem.getString((String)"message.generatingCSD"));
        RealtimeRenderServiceFactory factory = RealtimeRenderSettings.getInstance().renderServiceFactory;
        if (this.currentRenderServiceFactory != factory || this.currentRenderService == null || this.currentRenderService.getClass() != factory.getRenderServiceClass()) {
            if (this.currentRenderService != null) {
                this.currentRenderService.removePlayModeListener(this.realtimeListener);
            }
            this.currentRenderServiceFactory = factory;
            this.currentRenderService = factory.createInstance();
            this.currentRenderService.addPlayModeListener(this.realtimeListener);
        }
        this.currentRenderService.setData(data);
        try {
            this.currentRenderService.render();
        }
        catch (SoundObjectException soe) {
            ExceptionDialog.showExceptionDialog(WindowManager.getDefault().getMainWindow(), soe);
        }
    }

    public void renderForBlueLive(BlueData data) {
        if (this.currentBlueLiveRenderService != null && this.currentBlueLiveRenderService.isRunning()) {
            this.currentBlueLiveRenderService.stop();
        }
        if (data == null) {
            return;
        }
        StatusDisplayer.getDefault().setStatusText(BlueSystem.getString((String)"message.generatingCSD"));
        RealtimeRenderServiceFactory factory = RealtimeRenderSettings.getInstance().renderServiceFactory;
        if (this.currentRenderServiceFactory != factory || this.currentBlueLiveRenderService == null || this.currentBlueLiveRenderService.getClass() != factory.getRenderServiceClass()) {
            if (this.currentBlueLiveRenderService != null) {
                this.currentBlueLiveRenderService.removePlayModeListener(this.blueLiveListener);
            }
            this.currentRenderServiceFactory = factory;
            this.currentBlueLiveRenderService = factory.createInstance();
            this.currentBlueLiveRenderService.addPlayModeListener(this.blueLiveListener);
        }
        this.currentBlueLiveRenderService.addBinding((CsoundBinding)new BlueLiveBinding(data));
        this.currentBlueLiveRenderService.setData(data);
        try {
            this.currentBlueLiveRenderService.renderForBlueLive();
        }
        catch (SoundObjectException soe) {
            ExceptionDialog.showExceptionDialog(WindowManager.getDefault().getMainWindow(), soe);
        }
    }

    public void addBlueLiveBinding(CsoundBinding binding) {
        if (this.currentBlueLiveRenderService != null) {
            this.currentBlueLiveRenderService.addBinding(binding);
        }
    }

    public void auditionSoundObjects(BlueData data, SoundObject[] soundObjects) {
        LayerGroup slg;
        if (soundObjects == null || soundObjects.length == 0) {
            return;
        }
        if (this.isRendering()) {
            this.stopRendering();
        }
        BlueData tempData = new BlueData(data);
        List<PolyObject> path = null;
        Iterator iterator = data.getScore().iterator();
        while (iterator.hasNext() && (!((slg = (LayerGroup)iterator.next()) instanceof PolyObject) || (path = this.getPolyObjectPath((PolyObject)slg, soundObjects[0])) == null)) {
        }
        if (path == null) {
            throw new RuntimeException("Error: unable to find root PolyObject...");
        }
        PolyObject tempPObj = new PolyObject(true);
        tempData.getScore().getAllLayers().stream().forEach(e -> e.clearScoreObjects());
        PolyObject base = tempPObj;
        SoundLayer sLayer = tempPObj.newLayerAt(-1);
        double minTime = Double.MAX_VALUE;
        double maxTime = Double.MIN_VALUE;
        for (int i = 0; i < soundObjects.length; ++i) {
            SoundObject sObj = soundObjects[i];
            double startTime = sObj.getStartTime();
            double endTime = startTime + sObj.getSubjectiveDuration();
            if (startTime < minTime) {
                minTime = startTime;
            }
            if (endTime > maxTime) {
                maxTime = endTime;
            }
            ((SoundLayer)base.get(0)).add(sObj.deepCopy());
        }
        tempData.getScore().add((Object)tempPObj);
        Mixer m = tempData.getMixer();
        if (m.isEnabled()) {
            maxTime += m.getExtraRenderTime();
        }
        tempData.setRenderStartTime(minTime);
        tempData.setRenderEndTime(maxTime);
        this.renderProject(tempData, true);
    }

    public void stopRendering() {
        if (this.isRendering()) {
            this.currentRenderService.stop();
            this.realtimeListener.playModeChanged(0);
        }
    }

    public void stopBlueLiveRendering() {
        if (this.isBlueLiveRendering()) {
            this.currentBlueLiveRenderService.stop();
            this.blueLiveListener.playModeChanged(0);
        }
    }

    public void stopAuditioning() {
        if (this.isAuditioning()) {
            this.stopRendering();
        }
    }

    public boolean isAuditioning() {
        return this.isRendering() && this.auditioning;
    }

    public boolean isRendering() {
        return this.currentRenderService != null && this.currentRenderService.isRunning();
    }

    public boolean isBlueLiveRendering() {
        return this.currentBlueLiveRenderService != null && this.currentBlueLiveRenderService.isRunning();
    }

    public void passToStdin(String score) {
        if (this.isBlueLiveRendering()) {
            this.currentBlueLiveRenderService.passToStdin(score);
        }
    }

    public void shutdown() {
        this.shuttingDown = true;
        this.stopRendering();
        this.stopBlueLiveRendering();
    }

    private List<PolyObject> getPolyObjectPath(PolyObject pObj, SoundObject soundObject) {
        List allSObj = pObj.getSoundObjects(true);
        List<PolyObject> retVal = null;
        if (allSObj.contains(soundObject)) {
            retVal = new ArrayList<PolyObject>();
            retVal.add(pObj);
        } else {
            List pObjs = allSObj.stream().filter(a -> a instanceof PolyObject).collect(Collectors.toList());
            for (SoundObject obj : pObjs) {
                PolyObject tempPObj = (PolyObject)obj;
                retVal = this.getPolyObjectPath(tempPObj, soundObject);
                if (retVal == null) continue;
                retVal.add(0, pObj);
                break;
            }
        }
        return retVal;
    }
}

