/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.render;

import java.util.ArrayList;
import java.util.StringTokenizer;

public class CommandProcessor {
    private static final int COMMAND_SEARCH = 0;
    private static final int COMMAND_ARG_FIND = 1;
    private static final int COMMAND_SEARCH_FINISH = 2;
    private static final int STRIP_READ = 0;
    private static final int STRIP_ICONDITION_TRUE = 1;
    private static final int STRIP_ICONDITION_FALSE = 2;

    public static String processCommandBlocks(String string) {
        StringTokenizer st = new StringTokenizer(string, "\n");
        StringBuffer buffer = new StringBuffer();
        StringBuffer preBuffer = new StringBuffer();
        ArrayList<String> onceList = new ArrayList<String>();
        int mode = 0;
        String command = "";
        StringBuffer commandArgument = new StringBuffer();
        block12: while (st.hasMoreTokens()) {
            String line = st.nextToken();
            String trimLine = line.trim();
            switch (mode) {
                case 0: {
                    if (trimLine.startsWith(";[") && trimLine.endsWith("]{")) {
                        command = trimLine.substring(2, trimLine.indexOf("]{"));
                        mode = 1;
                        commandArgument = new StringBuffer();
                        continue block12;
                    }
                    buffer.append(line).append("\n");
                    continue block12;
                }
                case 1: {
                    if (trimLine.startsWith(";}")) {
                        mode = 0;
                        String commandString = commandArgument.toString();
                        switch (command) {
                            case "pre": {
                                preBuffer.append(commandString).append("\n");
                                break;
                            }
                            case "once": {
                                if (CommandProcessor.containsString(onceList, commandString)) break;
                                onceList.add(commandString);
                                buffer.append(commandString).append("\n");
                            }
                        }
                        continue block12;
                    }
                    commandArgument.append(line).append("\n");
                    continue block12;
                }
            }
            buffer.append(line).append("\n");
        }
        preBuffer.append(buffer);
        return preBuffer.toString();
    }

    private static boolean containsString(ArrayList list, String string) {
        for (String element : list) {
            if (!element.equals(string)) continue;
            return true;
        }
        return false;
    }

    private static String stripInstrumentConditionals(String string, ArrayList instrumentNumbers) {
        StringTokenizer st = new StringTokenizer(string, "\n");
        StringBuffer buffer = new StringBuffer();
        int mode = 0;
        while (st.hasMoreTokens()) {
            String line = st.nextToken();
            switch (mode) {
                case 0: {
                    if (line.startsWith(";[i") && line.endsWith("]{")) {
                        Integer iNum = new Integer(line.substring(3, line.length() - 2));
                        if (instrumentNumbers.contains(iNum)) {
                            mode = 1;
                            break;
                        }
                        mode = 2;
                        break;
                    }
                    buffer.append(line).append("\n");
                    break;
                }
                case 1: {
                    if (line.equals(";}")) {
                        mode = 0;
                        break;
                    }
                    buffer.append(line).append("\n");
                    break;
                }
                case 2: {
                    if (!line.equals(";}")) break;
                    mode = 0;
                }
            }
        }
        return buffer.toString();
    }
}

