/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.project;

import blue.BlueData;
import blue.BlueSystem;
import blue.gui.ExceptionDialog;
import blue.projects.BlueProjectManager;
import blue.services.render.CSDRenderService;
import blue.services.render.CsdRenderResult;
import blue.ui.utilities.FileChooserManager;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import org.openide.awt.StatusDisplayer;
import org.openide.windows.WindowManager;

public final class GenerateCsdAction
implements ActionListener {
    private static String FILE_GEN = "blueMainFrame.generateCSD";

    @Override
    public void actionPerformed(ActionEvent e) {
        Frame mainWindow = WindowManager.getDefault().getMainWindow();
        File rValue = FileChooserManager.getDefault().showSaveDialog((Object)FILE_GEN, (Component)mainWindow);
        if (rValue != null) {
            BlueData data = BlueProjectManager.getInstance().getCurrentBlueData();
            File temp = rValue;
            if (!temp.getName().trim().endsWith(".csd")) {
                temp = new File(temp.getAbsolutePath() + ".csd");
            }
            try {
                try (PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(temp)));){
                    CsdRenderResult renderResult = CSDRenderService.getDefault().generateCSD(data, data.getRenderStartTime(), data.getRenderEndTime(), false, false);
                    out.print(renderResult.getCsdText());
                    out.flush();
                }
                StatusDisplayer.getDefault().setStatusText(BlueSystem.getString((String)"message.generateScore.success") + " " + temp.getName());
            }
            catch (Exception ex) {
                ExceptionDialog.showExceptionDialog(mainWindow, ex);
                throw new RuntimeException("CSDRender Failed");
            }
        }
    }
}

