/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.orchestra.editor.blueX7;

import blue.gui.LabelledRangeBar;
import blue.orchestra.blueX7.Operator;
import blue.utility.GUI;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.event.ChangeListener;

public class ModulationSensitivityPanel
extends JComponent {
    LabelledRangeBar amplitude = new LabelledRangeBar("Amplitude ", 0, 3);
    public LabelledRangeBar pitch = new LabelledRangeBar("Pitch (*) ", 0, 7);
    Operator op;
    boolean isUpdatingData = false;

    public ModulationSensitivityPanel() {
        this.setLayout(new GridLayout(3, 1));
        this.add(new JLabel("[ Modulation Sensitivity ]"));
        this.add(this.amplitude);
        this.add(this.pitch);
        ChangeListener cl = e -> this.checkData();
        this.amplitude.addChangeListener(cl);
        this.pitch.addChangeListener(cl);
    }

    public void checkData() {
        if (this.isUpdatingData) {
            return;
        }
        if (this.op == null) {
            return;
        }
        this.op.modulationAmplitude = this.amplitude.getValue();
        this.op.modulationPitch = this.pitch.getValue();
    }

    public void editOperator(Operator op) {
        this.isUpdatingData = true;
        this.op = op;
        if (op == null) {
            return;
        }
        this.amplitude.setValue(op.modulationAmplitude);
        this.pitch.setValue(op.modulationPitch);
        this.isUpdatingData = false;
    }

    public static void main(String[] args) {
        ModulationSensitivityPanel modulationSensitivityPanel1 = new ModulationSensitivityPanel();
        GUI.showComponentAsStandalone((Component)modulationSensitivityPanel1, (String)"ModulationSensitivityPanel Test", (boolean)true);
    }
}

