/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.mixer;

import blue.mixer.Channel;
import blue.mixer.ChannelList;
import blue.util.ObservableListEvent;
import blue.util.ObservableListListener;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class ChannelOutComboBoxModel
implements ComboBoxModel,
ObservableListListener<Channel> {
    ChannelList channels = null;
    String selectedItem = null;
    Vector listeners = null;
    private Vector copies = null;

    public void setChannels(ChannelList channels) {
        if (this.channels != null) {
            this.channels.removeListener((ObservableListListener)this);
        }
        this.channels = channels;
        this.channels.addListener((ObservableListListener)this);
    }

    public void clearListeners() {
        if (this.channels != null) {
            this.channels.removeListener((ObservableListListener)this);
        }
        this.channels = null;
    }

    @Override
    public void setSelectedItem(Object anItem) {
        int index;
        this.selectedItem = "Master".equals(anItem) ? "Master" : ((index = this.channels.indexByName(anItem)) < 0 ? "Master" : (String)anItem);
        ListDataEvent lde = new ListDataEvent(this, 0, -1, -1);
        this.fireListEvent(lde);
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedItem;
    }

    @Override
    public int getSize() {
        if (this.channels == null) {
            return 1;
        }
        return this.channels.size() + 1;
    }

    @Override
    public Object getElementAt(int index) {
        if (index == 0) {
            return "Master";
        }
        if (this.channels == null) {
            return null;
        }
        return ((Channel)this.channels.get(index - 1)).getName();
    }

    @Override
    public void addListDataListener(ListDataListener l) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.add(l);
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(l);
    }

    private void fireListEvent(ListDataEvent lde) {
        if (this.listeners == null) {
            return;
        }
        for (ListDataListener listener : this.listeners) {
            switch (lde.getType()) {
                case 1: {
                    listener.intervalAdded(lde);
                    break;
                }
                case 2: {
                    listener.intervalRemoved(lde);
                    break;
                }
                case 0: {
                    listener.contentsChanged(lde);
                }
            }
        }
    }

    public void reconcile(String oldName, String newName) {
        if (this.getSelectedItem().toString().equals(oldName)) {
            this.setSelectedItem(newName);
        }
        if (this.copies != null) {
            for (int i = 0; i < this.copies.size(); ++i) {
                ((ChannelOutComboBoxModel)this.copies.get(i)).reconcile(oldName, newName);
            }
        }
    }

    public ChannelOutComboBoxModel getCopy() {
        ChannelOutComboBoxModel copy = new ChannelOutComboBoxModel();
        copy.setChannels(this.channels);
        if (this.copies == null) {
            this.copies = new Vector();
        }
        this.copies.add(copy);
        return copy;
    }

    public void listChanged(ObservableListEvent<Channel> listEvent) {
        switch (listEvent.getType()) {
            case 0: {
                this.intervalAdded(listEvent);
                break;
            }
            case 1: {
                this.intervalRemoved(listEvent);
                break;
            }
            case 2: {
                this.contentsChanged();
            }
        }
    }

    public void intervalAdded(ObservableListEvent<Channel> e) {
        ListDataEvent lde = new ListDataEvent(this, 0, -1, -1);
        this.fireListEvent(lde);
    }

    public void intervalRemoved(ObservableListEvent<Channel> e) {
        if (this.channels.indexByName((Object)this.selectedItem) < 0) {
            this.setSelectedItem("Master");
        }
    }

    public void contentsChanged() {
    }
}

