/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core;

import blue.projects.BlueProject;
import blue.projects.BlueProjectManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JOptionPane;
import org.openide.windows.WindowManager;

public class TempFileCleaner
implements PropertyChangeListener {
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        int retVal;
        BlueProjectManager bpm = BlueProjectManager.getInstance();
        BlueProject currentProject = bpm.getCurrentProject();
        if (currentProject.isTempCsdFilesChecked()) {
            return;
        }
        currentProject.setTempCsdFilesChecked(true);
        File curProjFile = currentProject.getDataFile();
        if (curProjFile == null) {
            return;
        }
        File parentProjDir = curProjFile.getParentFile();
        int size = bpm.getNumProjects();
        boolean otherOpenProjectsFound = false;
        for (int i = 0; i < size; ++i) {
            File parentDir;
            BlueProject project = bpm.getProject(i);
            if (project == currentProject || project.getDataFile() == null || !(parentDir = project.getDataFile().getParentFile()).equals(parentProjDir)) continue;
            otherOpenProjectsFound = true;
            break;
        }
        if (otherOpenProjectsFound) {
            return;
        }
        File[] tempFiles = parentProjDir.listFiles((dir, name) -> name.startsWith("tempCsd") && name.endsWith(".csd"));
        if (tempFiles.length > 0 && (retVal = JOptionPane.showConfirmDialog(WindowManager.getDefault().getMainWindow(), "Temporary CSD files were found.  These are probably from a previous Blue session that crashed.  Would you like to delete these?", "Temp CSD Files Found", 0)) == 0) {
            this.deleteTempFiles(tempFiles);
        }
    }

    public void deleteTempFiles(File[] tempFiles) {
        int filesDeleted = 0;
        for (File f : tempFiles) {
            if (!f.delete()) {
                JOptionPane.showMessageDialog(WindowManager.getDefault().getMainWindow(), "Unable to delete temp file: " + f.getAbsolutePath(), "Error", 0);
                continue;
            }
            ++filesDeleted;
        }
        JOptionPane.showMessageDialog(WindowManager.getDefault().getMainWindow(), "Deleted " + filesDeleted + " temp files out of " + tempFiles.length + " found.", "Complete", 1);
    }
}

