/*
 * Decompiled with CFR 0.152.
 */
package blue.tools.codeRepository;

import blue.BlueSystem;
import blue.settings.GeneralSettings;
import blue.tools.codeRepository.CodeRepositoryDialog;
import blue.tools.codeRepository.CodeRepositoryTreeNode;
import blue.tools.codeRepository.ElementHolder;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

class CodeRepositoryPopup
extends JPopupMenu
implements ActionListener {
    CodeRepositoryDialog repository;
    ElementHolder elem;
    CodeRepositoryTreeNode node;
    JMenuItem addGroup = new JMenuItem(BlueSystem.getString((String)"codeRepository.addGroup"));
    JMenuItem removeGroup = new JMenuItem(BlueSystem.getString((String)"codeRepository.removeGroup"));
    JMenuItem addCode = new JMenuItem(BlueSystem.getString((String)"codeRepository.addCodeSnippet"));
    JMenuItem removeCode = new JMenuItem(BlueSystem.getString((String)"codeRepository.removeCodeSnippet"));

    public CodeRepositoryPopup() {
        this.addGroup.addActionListener(this);
        this.add(this.addGroup);
        this.removeGroup.addActionListener(this);
        this.add(this.removeGroup);
        this.addCode.addActionListener(this);
        this.add(this.addCode);
        this.removeCode.addActionListener(this);
        this.add(this.removeCode);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.addGroup) {
            ElementHolder elem = new ElementHolder();
            elem.isGroup = true;
            elem.title = BlueSystem.getString((String)"codeRepository.newGroup");
            CodeRepositoryTreeNode newNode = new CodeRepositoryTreeNode();
            newNode.setUserObject(elem);
            newNode.setAllowsChildren(true);
            this.repository.treeModel.insertNodeInto(newNode, this.node, this.node.getChildCount());
        } else if (ae.getSource() == this.removeGroup) {
            this.repository.treeModel.removeNodeFromParent(this.node);
            this.repository.cards.show(this.repository.editPanel, "disabled");
        } else if (ae.getSource() == this.addCode) {
            ElementHolder elem = new ElementHolder();
            elem.isGroup = false;
            elem.title = BlueSystem.getString((String)"codeRepository.newCode");
            elem.text = GeneralSettings.getInstance().isNewUserDefaultsEnabled() ? BlueSystem.getString((String)"codeRepository.insertYourCode") : "";
            CodeRepositoryTreeNode newNode = new CodeRepositoryTreeNode();
            newNode.setUserObject(elem);
            newNode.setAllowsChildren(false);
            this.repository.treeModel.insertNodeInto(newNode, this.node, this.node.getChildCount());
        } else if (ae.getSource() == this.removeCode) {
            this.repository.treeModel.removeNodeFromParent(this.node);
            this.repository.cards.show(this.repository.editPanel, "disabled");
        }
    }

    public void show(CodeRepositoryDialog repository, CodeRepositoryTreeNode node, ElementHolder elem, int x, int y) {
        this.repository = repository;
        this.elem = elem;
        this.node = node;
        if (elem.isGroup) {
            this.addGroup.setVisible(true);
            if (elem.title.equals(BlueSystem.getString((String)"codeRepository.title"))) {
                this.removeGroup.setVisible(false);
            } else {
                this.removeGroup.setVisible(true);
            }
            this.addCode.setVisible(true);
            this.removeCode.setVisible(false);
        } else {
            this.addGroup.setVisible(false);
            this.removeGroup.setVisible(false);
            this.addCode.setVisible(false);
            this.removeCode.setVisible(true);
        }
        super.show(repository, x, y);
    }
}

