/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.editor.pattern;

import blue.gui.LabelledItemPanel;
import blue.soundObject.PatternObject;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeListener;

public class PatternObjectPropertiesPanel
extends JComponent {
    SpinnerNumberModel intModel = new SpinnerNumberModel(1, 1, Integer.MAX_VALUE, 1);
    SpinnerNumberModel intModel2 = new SpinnerNumberModel(1, 1, Integer.MAX_VALUE, 1);
    JSpinner beatsSpinner = new JSpinner(this.intModel);
    JSpinner subDivisionsSpinner = new JSpinner(this.intModel2);
    private PatternObject patternObj = null;
    private boolean isUpdating = false;

    public PatternObjectPropertiesPanel() {
        this.setLayout(new BoxLayout(this, 1));
        this.setPreferredSize(new Dimension(150, 200));
        LabelledItemPanel timePropsPanel = new LabelledItemPanel();
        timePropsPanel.setBorder(BorderFactory.createTitledBorder("Time Properties"));
        timePropsPanel.addItem("Beats", this.beatsSpinner);
        timePropsPanel.addItem("Subdivisions", this.subDivisionsSpinner);
        this.add(timePropsPanel);
        ChangeListener cl = e -> this.updateProperties();
        this.beatsSpinner.addChangeListener(cl);
        this.subDivisionsSpinner.addChangeListener(cl);
    }

    protected void updateProperties() {
        if (this.patternObj == null || this.isUpdating) {
            return;
        }
        int beats = (Integer)this.beatsSpinner.getValue();
        int subDivisions = (Integer)this.subDivisionsSpinner.getValue();
        this.patternObj.setTime(beats, subDivisions);
    }

    public void setPatternObject(PatternObject p) {
        this.isUpdating = true;
        this.patternObj = p;
        this.beatsSpinner.setValue(new Integer(p.getBeats()));
        this.subDivisionsSpinner.setValue(new Integer(p.getSubDivisions()));
        this.isUpdating = false;
    }
}

