/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.editor.jmask.probability;

import blue.soundObject.editor.jmask.DurationSettable;
import blue.soundObject.editor.jmask.TableEditor;
import blue.soundObject.jmask.probability.Beta;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BetaEditor
extends JPanel
implements DurationSettable {
    private Beta beta = null;
    private ButtonGroup aButtonGroup;
    private JSpinner aSpinner;
    private TableEditor aTableEditor;
    private JComboBox aTypeComboBox;
    private ButtonGroup bButtonGroup;
    private JSpinner bSpinner;
    private TableEditor bTableEditor;
    private JComboBox bTypeComboBox;

    public BetaEditor(Beta beta) {
        this.initComponents();
        this.aTableEditor.setMinMaxEnabled(false);
        this.bTableEditor.setMinMaxEnabled(false);
        this.aTableEditor.setTable(beta.getATable());
        this.bTableEditor.setTable(beta.getBTable());
        this.aSpinner.setModel(new SpinnerNumberModel(beta.getA(), 0.0, 1.0, 0.1));
        this.bSpinner.setModel(new SpinnerNumberModel(beta.getB(), 0.0, 1.0, 0.1));
        this.aTypeComboBox.setSelectedIndex(beta.isATableEnabled() ? 1 : 0);
        this.bTypeComboBox.setSelectedIndex(beta.isBTableEnabled() ? 1 : 0);
        this.beta = beta;
        this.updateDisplay();
    }

    private void updateDisplay() {
        this.aSpinner.setVisible(!this.beta.isATableEnabled());
        this.aTableEditor.setVisible(this.beta.isATableEnabled());
        this.bSpinner.setVisible(!this.beta.isBTableEnabled());
        this.bTableEditor.setVisible(this.beta.isBTableEnabled());
    }

    private void initComponents() {
        this.aButtonGroup = new ButtonGroup();
        this.bButtonGroup = new ButtonGroup();
        this.aSpinner = new JSpinner();
        this.aTableEditor = new TableEditor();
        this.bSpinner = new JSpinner();
        this.bTableEditor = new TableEditor();
        this.aTypeComboBox = new JComboBox();
        this.bTypeComboBox = new JComboBox();
        this.aSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                BetaEditor.this.aSpinnerStateChanged(evt);
            }
        });
        this.bSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                BetaEditor.this.bSpinnerStateChanged(evt);
            }
        });
        this.aTypeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"a (Constant)", "a (Table)"}));
        this.aTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BetaEditor.this.aTypeComboBoxActionPerformed(evt);
            }
        });
        this.bTypeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"b (Constant)", "b (Table)"}));
        this.bTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BetaEditor.this.bTypeComboBoxActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.aTableEditor, -2, 414, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.bTypeComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bSpinner, -2, 84, -2)).addGroup(layout.createSequentialGroup().addComponent(this.aTypeComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.aSpinner, -2, 84, -2)).addComponent(this.bTableEditor, GroupLayout.Alignment.TRAILING, -2, 414, Short.MAX_VALUE)).addContainerGap()));
        layout.linkSize(0, this.aTypeComboBox, this.bTypeComboBox);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.aTypeComboBox, -2, -1, -2).addComponent(this.aSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.aTableEditor, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.bTypeComboBox, -2, -1, -2).addComponent(this.bSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bTableEditor, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void aSpinnerStateChanged(ChangeEvent evt) {
        if (this.beta != null) {
            this.beta.setA(((Double)this.aSpinner.getValue()).doubleValue());
        }
    }

    private void bSpinnerStateChanged(ChangeEvent evt) {
        if (this.beta != null) {
            this.beta.setB(((Double)this.bSpinner.getValue()).doubleValue());
        }
    }

    private void aTypeComboBoxActionPerformed(ActionEvent evt) {
        if (this.beta != null) {
            this.beta.setATableEnabled(this.aTypeComboBox.getSelectedIndex() == 1);
            this.updateDisplay();
        }
    }

    private void bTypeComboBoxActionPerformed(ActionEvent evt) {
        if (this.beta != null) {
            this.beta.setBTableEnabled(this.bTypeComboBox.getSelectedIndex() == 1);
            this.updateDisplay();
        }
    }

    @Override
    public void setDuration(double duration) {
        this.aTableEditor.setDuration(duration);
        this.bTableEditor.setDuration(duration);
    }
}

