/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.editor.jmask;

import blue.gui.ListLayoutManager;
import blue.soundObject.editor.jmask.AccumulatorEditor;
import blue.soundObject.editor.jmask.DurationSettable;
import blue.soundObject.editor.jmask.GeneratorEditorFactory;
import blue.soundObject.editor.jmask.MaskEditor;
import blue.soundObject.editor.jmask.ParameterEditListener;
import blue.soundObject.editor.jmask.QuantizerEditor;
import blue.soundObject.jmask.Accumulatable;
import blue.soundObject.jmask.Accumulator;
import blue.soundObject.jmask.Generator;
import blue.soundObject.jmask.GeneratorRegistry;
import blue.soundObject.jmask.Mask;
import blue.soundObject.jmask.Maskable;
import blue.soundObject.jmask.Parameter;
import blue.soundObject.jmask.Quantizable;
import blue.soundObject.jmask.Quantizer;
import blue.ui.utilities.UiUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

public class ParameterEditor
extends JPanel
implements PropertyChangeListener {
    Parameter parameter = null;
    private transient List<ParameterEditListener> listeners = null;
    int parameterNum = -1;
    double duration = 1.0;
    JComponent generatorEditor = null;
    JComponent maskEditor = null;
    JComponent quantizerEditor = null;
    JComponent accumulatorEditor = null;
    private JCheckBoxMenuItem accumulatorCheckBoxMenuItem;
    private JMenuItem addParameterAfter;
    private JMenuItem addParameterBefore;
    private JMenuItem changeParameter;
    private JPanel emptyPanel;
    private JPopupMenu jPopupMenu1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JCheckBoxMenuItem maskCheckBoxMenuItem;
    private JLabel paramLabelPanel;
    private JMenuItem pushDown;
    private JMenuItem pushUp;
    private JCheckBoxMenuItem quantizeCheckBoxMenuItem;
    private JMenuItem removeParameter;

    public ParameterEditor() {
        this.initComponents();
        this.setBorder(new LineBorder(Color.BLACK));
        this.emptyPanel.setLayout(new ListLayoutManager());
        this.paramLabelPanel.setBackground(this.paramLabelPanel.getBackground().darker());
    }

    public void setDuration(double duration) {
        this.duration = duration;
        ((DurationSettable)((Object)this.generatorEditor)).setDuration(duration);
        if (this.maskEditor != null) {
            ((DurationSettable)((Object)this.maskEditor)).setDuration(duration);
        }
        if (this.quantizerEditor != null) {
            ((DurationSettable)((Object)this.quantizerEditor)).setDuration(duration);
        }
        if (this.accumulatorEditor != null) {
            ((DurationSettable)((Object)this.accumulatorEditor)).setDuration(duration);
        }
    }

    public void setParameter(Parameter parameter, int num) {
        this.parameter = parameter;
        this.setParameterNumber(num);
        Generator generator = parameter.getGenerator();
        this.generatorEditor = GeneratorEditorFactory.getView(generator);
        this.generatorEditor.setBorder(BorderFactory.createBevelBorder(0));
        this.emptyPanel.add(this.generatorEditor);
        if (generator instanceof Maskable) {
            Mask mask = parameter.getMask();
            if (mask.isEnabled()) {
                this.maskEditor = new MaskEditor(mask);
                this.maskEditor.setBorder(BorderFactory.createBevelBorder(0));
                this.emptyPanel.add(this.maskEditor);
            }
            this.maskCheckBoxMenuItem.setVisible(true);
            this.maskCheckBoxMenuItem.setSelected(mask.isEnabled());
        } else {
            this.maskCheckBoxMenuItem.setVisible(false);
        }
        if (generator instanceof Quantizable) {
            Quantizer quantizer = parameter.getQuantizer();
            if (quantizer.isEnabled()) {
                this.quantizerEditor = new QuantizerEditor(quantizer);
                this.quantizerEditor.setBorder(BorderFactory.createBevelBorder(0));
                this.emptyPanel.add(this.quantizerEditor);
            }
            this.quantizeCheckBoxMenuItem.setVisible(true);
            this.quantizeCheckBoxMenuItem.setSelected(quantizer.isEnabled());
        } else {
            this.quantizeCheckBoxMenuItem.setVisible(false);
        }
        if (generator instanceof Accumulatable) {
            Accumulator accumulator = parameter.getAccumulator();
            if (accumulator.isEnabled()) {
                this.accumulatorEditor = new AccumulatorEditor(accumulator);
                this.accumulatorEditor.setBorder(BorderFactory.createBevelBorder(0));
                this.emptyPanel.add(this.accumulatorEditor);
            }
            this.accumulatorCheckBoxMenuItem.setVisible(true);
            this.accumulatorCheckBoxMenuItem.setSelected(accumulator.isEnabled());
        } else {
            this.accumulatorCheckBoxMenuItem.setVisible(false);
        }
        this.parameter.addPropertyChangeListener((PropertyChangeListener)this);
        this.setVisible(this.parameter.isVisible());
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.parameter.addPropertyChangeListener((PropertyChangeListener)this);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.parameter.removePropertyChangeListener((PropertyChangeListener)this);
    }

    public void setParameterNumber(int num) {
        this.parameterNum = num;
        String label = "p" + num;
        String fieldName = this.parameter.getName();
        if (fieldName != null && !fieldName.equals("")) {
            label = label + " - " + fieldName;
        }
        String newLabel = label;
        SwingUtilities.invokeLater(() -> {
            this.paramLabelPanel.setText(newLabel);
            this.repaint();
        });
    }

    public void addParameterEditListener(ParameterEditListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ParameterEditListener>(1);
        }
        this.listeners.add(listener);
    }

    public void removeParameterEditListener(ParameterEditListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    private void fireParameterEdit(int editType, int parameterNum, Generator generator) {
        if (this.listeners == null) {
            return;
        }
        for (ParameterEditListener listener : new ArrayList<ParameterEditListener>(this.listeners)) {
            listener.parameterEdit(editType, parameterNum, generator);
        }
    }

    private void updateInterface() {
        this.emptyPanel.removeAll();
        this.emptyPanel.add(this.generatorEditor);
        if (this.maskEditor != null) {
            this.emptyPanel.add(this.maskEditor);
        }
        if (this.quantizerEditor != null) {
            this.emptyPanel.add(this.quantizerEditor);
        }
        if (this.accumulatorEditor != null) {
            this.emptyPanel.add(this.accumulatorEditor);
        }
        this.revalidate();
    }

    private void initComponents() {
        this.jPopupMenu1 = new JPopupMenu();
        this.addParameterBefore = new JMenuItem();
        this.addParameterAfter = new JMenuItem();
        this.removeParameter = new JMenuItem();
        this.changeParameter = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.pushUp = new JMenuItem();
        this.pushDown = new JMenuItem();
        this.jSeparator2 = new JSeparator();
        this.maskCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.quantizeCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.accumulatorCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.emptyPanel = new JPanel();
        this.paramLabelPanel = new JLabel();
        this.addParameterBefore.setText("Add Parameter Before");
        this.addParameterBefore.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ParameterEditor.this.addParameterBeforeActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.addParameterBefore);
        this.addParameterAfter.setText("Add Parameter After");
        this.addParameterAfter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ParameterEditor.this.addParameterAfterActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.addParameterAfter);
        this.removeParameter.setText("Remove Parameter");
        this.removeParameter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ParameterEditor.this.removeParameterActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.removeParameter);
        this.changeParameter.setText("Change Parameter Type");
        this.changeParameter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ParameterEditor.this.changeParameterActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.changeParameter);
        this.jPopupMenu1.add(this.jSeparator1);
        this.pushUp.setText("Push Up");
        this.pushUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ParameterEditor.this.pushUpActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.pushUp);
        this.pushDown.setText("Push Down");
        this.pushDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ParameterEditor.this.pushDownActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.pushDown);
        this.jPopupMenu1.add(this.jSeparator2);
        this.maskCheckBoxMenuItem.setSelected(true);
        this.maskCheckBoxMenuItem.setText("Mask");
        this.maskCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ParameterEditor.this.maskCheckBoxMenuItemActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.maskCheckBoxMenuItem);
        this.quantizeCheckBoxMenuItem.setSelected(true);
        this.quantizeCheckBoxMenuItem.setText("Quantize");
        this.quantizeCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ParameterEditor.this.quantizeCheckBoxMenuItemActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.quantizeCheckBoxMenuItem);
        this.accumulatorCheckBoxMenuItem.setSelected(true);
        this.accumulatorCheckBoxMenuItem.setText("Accumulator");
        this.accumulatorCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ParameterEditor.this.accumulatorCheckBoxMenuItemActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.accumulatorCheckBoxMenuItem);
        this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.setLayout(new BorderLayout());
        GroupLayout emptyPanelLayout = new GroupLayout(this.emptyPanel);
        this.emptyPanel.setLayout(emptyPanelLayout);
        emptyPanelLayout.setHorizontalGroup(emptyPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 521, Short.MAX_VALUE));
        emptyPanelLayout.setVerticalGroup(emptyPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 133, Short.MAX_VALUE));
        this.add((Component)this.emptyPanel, "Center");
        this.paramLabelPanel.setText("jLabel1");
        this.paramLabelPanel.setVerticalAlignment(1);
        this.paramLabelPanel.setBorder(BorderFactory.createBevelBorder(0));
        this.paramLabelPanel.setMinimumSize(new Dimension(20, 19));
        this.paramLabelPanel.setOpaque(true);
        this.paramLabelPanel.setPreferredSize(new Dimension(20, 19));
        this.paramLabelPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                ParameterEditor.this.paramLabelPanelMouseReleased(evt);
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                ParameterEditor.this.labelMouseClicked(evt);
            }
        });
        this.add((Component)this.paramLabelPanel, "North");
    }

    private void maskCheckBoxMenuItemActionPerformed(ActionEvent evt) {
        boolean enabled = this.maskCheckBoxMenuItem.isSelected();
        this.parameter.getMask().setEnabled(enabled);
        if (enabled) {
            this.maskEditor = new MaskEditor(this.parameter.getMask());
            this.maskEditor.setBorder(BorderFactory.createBevelBorder(0));
            ((DurationSettable)((Object)this.maskEditor)).setDuration(this.duration);
        } else {
            this.maskEditor = null;
        }
        this.updateInterface();
    }

    private void quantizeCheckBoxMenuItemActionPerformed(ActionEvent evt) {
        boolean enabled = this.quantizeCheckBoxMenuItem.isSelected();
        this.parameter.getQuantizer().setEnabled(enabled);
        if (enabled) {
            this.quantizerEditor = new QuantizerEditor(this.parameter.getQuantizer());
            this.quantizerEditor.setBorder(BorderFactory.createBevelBorder(0));
            ((DurationSettable)((Object)this.quantizerEditor)).setDuration(this.duration);
        } else {
            this.quantizerEditor = null;
        }
        this.updateInterface();
    }

    private void accumulatorCheckBoxMenuItemActionPerformed(ActionEvent evt) {
        boolean enabled = this.accumulatorCheckBoxMenuItem.isSelected();
        this.parameter.getAccumulator().setEnabled(enabled);
        if (enabled) {
            this.accumulatorEditor = new AccumulatorEditor(this.parameter.getAccumulator());
            this.accumulatorEditor.setBorder(BorderFactory.createBevelBorder(0));
            ((DurationSettable)((Object)this.accumulatorEditor)).setDuration(this.duration);
        } else {
            this.accumulatorEditor = null;
        }
        this.updateInterface();
    }

    private void pushUpActionPerformed(ActionEvent evt) {
        this.fireParameterEdit(4, this.parameterNum, null);
    }

    private void pushDownActionPerformed(ActionEvent evt) {
        this.fireParameterEdit(5, this.parameterNum, null);
    }

    private void labelMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            String oldVal = this.parameter.getName();
            NotifyDescriptor.InputLine descriptor = new NotifyDescriptor.InputLine("Enter Field Name", "Field Name", 2, -1);
            descriptor.setInputText(this.parameter.getName());
            Object status = DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
            if (status == NotifyDescriptor.OK_OPTION) {
                this.parameter.setName(descriptor.getInputText());
                this.setParameterNumber(this.parameterNum);
            }
        }
    }

    private void changeParameterActionPerformed(ActionEvent evt) {
        Generator gen;
        Object[] options = GeneratorRegistry.getGeneratorEntries();
        Object val = JOptionPane.showInputDialog(this.getParent(), "Select Generator Type", "Change Generator Type", -1, null, options, options[0]);
        if (val != null && (gen = ((GeneratorRegistry.GeneratorEntry)val).createGenerator()).getClass() != this.parameter.getGenerator().getClass()) {
            this.fireParameterEdit(3, this.parameterNum, gen);
        }
    }

    private void paramLabelPanelMouseReleased(MouseEvent evt) {
        if (UiUtilities.isRightMouseButton((MouseEvent)evt)) {
            this.removeParameter.setEnabled(this.parameterNum > 3);
            this.jPopupMenu1.show(this.paramLabelPanel, evt.getX(), evt.getY());
        }
    }

    private void removeParameterActionPerformed(ActionEvent evt) {
        this.fireParameterEdit(2, this.parameterNum, null);
    }

    private void addParameterAfterActionPerformed(ActionEvent evt) {
        Object[] options = GeneratorRegistry.getGeneratorEntries();
        Object val = JOptionPane.showInputDialog(this.getParent(), "Select Generator Type", "Add Generator After", -1, null, options, options[0]);
        if (val != null) {
            Generator gen = ((GeneratorRegistry.GeneratorEntry)val).createGenerator();
            this.fireParameterEdit(1, this.parameterNum, gen);
        }
    }

    private void addParameterBeforeActionPerformed(ActionEvent evt) {
        Object[] options = GeneratorRegistry.getGeneratorEntries();
        Object val = JOptionPane.showInputDialog(this.getParent(), "Select Generator Type", "Add Generator Before", -1, null, options, options[0]);
        if (val != null) {
            Generator gen = ((GeneratorRegistry.GeneratorEntry)val).createGenerator();
            this.fireParameterEdit(0, this.parameterNum, gen);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("visible")) {
            this.setVisible(this.parameter.isVisible());
        }
    }
}

