/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.editor.jmask;

import blue.soundObject.editor.jmask.DurationSettable;
import blue.soundObject.jmask.ItemList;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class ItemListEditor
extends JPanel
implements DurationSettable {
    ItemList itemList;
    private JButton addButton;
    private JTable itemsTable;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JComboBox optionsComboBox;
    private JButton pushDownButton;
    private JButton pushUpButton;
    private JButton removeButton;

    public ItemListEditor(ItemList itemList) {
        this.itemList = itemList;
        this.initComponents();
        this.itemsTable.setModel((TableModel)itemList);
        this.itemsTable.setSelectionMode(0);
        this.optionsComboBox.setSelectedIndex(itemList.getListType());
        itemList.addTableModelListener((TableModelListener)this.itemsTable);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.optionsComboBox = new JComboBox();
        this.jScrollPane1 = new JScrollPane();
        this.itemsTable = new JTable();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.pushDownButton = new JButton();
        this.pushUpButton = new JButton();
        this.jLabel1.setText("Item List");
        this.optionsComboBox.setModel(new DefaultComboBoxModel<String>(ItemList.MODES));
        this.optionsComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ItemListEditor.this.optionsComboBoxActionPerformed(evt);
            }
        });
        this.itemsTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane1.setViewportView(this.itemsTable);
        this.addButton.setText("+");
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ItemListEditor.this.addButtonActionPerformed(evt);
            }
        });
        this.removeButton.setText("-");
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ItemListEditor.this.removeButtonActionPerformed(evt);
            }
        });
        this.pushDownButton.setText("V");
        this.pushDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ItemListEditor.this.pushDownButtonActionPerformed(evt);
            }
        });
        this.pushUpButton.setText("^");
        this.pushUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ItemListEditor.this.pushUpButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 413, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.optionsComboBox, 0, 353, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.pushUpButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pushDownButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addButton))).addContainerGap()));
        layout.linkSize(0, this.addButton, this.pushDownButton, this.pushUpButton, this.removeButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.optionsComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 86, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.addButton).addComponent(this.removeButton).addComponent(this.pushDownButton).addComponent(this.pushUpButton)).addContainerGap()));
    }

    private void optionsComboBoxActionPerformed(ActionEvent evt) {
        this.itemList.setListType(this.optionsComboBox.getSelectedIndex());
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        this.itemList.addListItem(new Double(0.0), this.itemsTable.getSelectedRow());
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        int selectedIndex = this.itemsTable.getSelectedRow();
        if (selectedIndex >= 0 && selectedIndex < this.itemList.getRowCount()) {
            this.itemList.removeListItem(selectedIndex);
        }
    }

    private void pushDownButtonActionPerformed(ActionEvent evt) {
        int selectedIndex = this.itemsTable.getSelectedRow();
        if (selectedIndex >= 0 && selectedIndex < this.itemList.getRowCount() - 1) {
            this.itemList.pushDown(selectedIndex);
            this.itemsTable.setRowSelectionInterval(selectedIndex + 1, selectedIndex + 1);
        }
    }

    private void pushUpButtonActionPerformed(ActionEvent evt) {
        int selectedIndex = this.itemsTable.getSelectedRow();
        if (selectedIndex > 0 && selectedIndex < this.itemList.getRowCount()) {
            this.itemList.pushUp(selectedIndex);
            this.itemsTable.setRowSelectionInterval(selectedIndex - 1, selectedIndex - 1);
        }
    }

    @Override
    public void setDuration(double duration) {
    }
}

