/*
 * Decompiled with CFR 0.152.
 */
package blue.orchestra.editor.blueSynthBuilder.jfx.editors;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.function.Predicate;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.TextField;
import org.controlsfx.control.PropertySheet;

public class NumberPropertyEditor
extends TextField {
    Predicate<String> validator = null;
    PropertySheet.Item item;
    boolean editing = false;

    public NumberPropertyEditor(PropertySheet.Item item) {
        this.item = item;
        ChangeListener focusListener = (obs, o, n) -> {
            if (o.booleanValue() && !n.booleanValue()) {
                this.editing = false;
                this.updateTextFromTextField();
            } else {
                this.editing = true;
            }
        };
        this.setOnAction(e -> {
            this.focusedProperty().removeListener(focusListener);
            this.updateTextFromTextField();
            this.focusedProperty().addListener(focusListener);
        });
        this.focusedProperty().addListener(focusListener);
        ChangeListener listener = (obs, old, newVal) -> {
            if (!this.editing) {
                this.setText(newVal.toString());
            }
        };
        this.sceneProperty().addListener((obs, old, newVal) -> {
            if (newVal == null) {
                if (item.getObservableValue().isPresent()) {
                    ((ObservableValue)item.getObservableValue().get()).removeListener(listener);
                }
            } else if (item.getObservableValue().isPresent()) {
                ((ObservableValue)item.getObservableValue().get()).addListener(listener);
            }
        });
    }

    private synchronized void updateTextFromTextField() {
        String newValue = this.getText();
        String old = this.item.getValue().toString();
        if (old.equals(newValue)) {
            return;
        }
        if (this.validator == null || this.validator.test(newValue)) {
            try {
                this.item.setValue((Object)this.getValueAsNumber());
                this.setText(this.item.getValue().toString());
            }
            catch (Exception e) {
                e.printStackTrace();
                this.setText(this.item.getValue().toString());
            }
        }
    }

    public void setValidator(Predicate<String> validator) {
        this.validator = validator;
    }

    public Number getValueAsNumber() {
        Class type = this.item.getType();
        if (type == Byte.TYPE || type == Byte.class) {
            return new Byte(this.getText());
        }
        if (type == Short.TYPE || type == Short.class) {
            return new Short(this.getText());
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return new Integer(this.getText());
        }
        if (type == Long.TYPE || type == Long.class) {
            return new Long(this.getText());
        }
        if (type == BigInteger.class) {
            return new BigInteger(this.getText());
        }
        if (type == BigDecimal.class) {
            return new BigDecimal(this.getText());
        }
        if (type == Float.TYPE || type == Float.class) {
            return new Float(this.getText());
        }
        if (type == Double.TYPE || type == Double.class) {
            return new Double(this.getText());
        }
        return null;
    }
}

