/*
 * Decompiled with CFR 0.152.
 */
package blue.orchestra.editor.blueSynthBuilder.jfx;

import blue.jfx.BlueFX;
import blue.orchestra.blueSynthBuilder.BSBGraphicInterface;
import blue.orchestra.blueSynthBuilder.Preset;
import blue.orchestra.blueSynthBuilder.PresetGroup;
import blue.orchestra.editor.blueSynthBuilder.PresetsManagerDialog;
import blue.orchestra.editor.blueSynthBuilder.PresetsUtilities;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputDialog;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javax.swing.SwingUtilities;
import org.openide.util.Exceptions;
import org.openide.windows.WindowManager;

public class PresetPane
extends HBox {
    private ObjectProperty<PresetGroup> presetGroup;
    private BSBGraphicInterface bsbInterface = null;
    ContextMenu rootMenu = new ContextMenu();
    PresetsManagerDialog presetsManager = null;
    TextField currentPresetText = new TextField();
    Button updateButton = new Button("Update");
    EventHandler<ActionEvent> addFolderAction = e -> {
        MenuItem source = (MenuItem)e.getSource();
        PresetGroup pGroup = (PresetGroup)source.getUserData();
        this.addFolder(pGroup);
    };
    EventHandler<ActionEvent> addPresetAction = e -> {
        MenuItem source = (MenuItem)e.getSource();
        PresetGroup pGroup = (PresetGroup)source.getUserData();
        this.addPreset(pGroup);
    };
    EventHandler<ActionEvent> presetSelectedAction = e -> {
        MenuItem source = (MenuItem)e.getSource();
        Preset preset = (Preset)source.getUserData();
        preset.setInterfaceValues(this.bsbInterface);
        this.getPresetGroup().setCurrentPresetUniqueId(preset.getUniqueId());
        this.getPresetGroup().setCurrentPresetModified(false);
        this.updateCurrentPresetUI();
    };

    public PresetPane() {
        this.presetGroup = new SimpleObjectProperty();
        Button presetsButton = new Button("Presets");
        presetsButton.setOnAction(e -> this.rootMenu.show((Node)presetsButton, Side.TOP, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY));
        this.currentPresetText.setEditable(false);
        this.updateButton.setOnAction(e -> {
            PresetGroup pGroup = this.getPresetGroup();
            Preset preset = pGroup.findPresetByUniqueId(pGroup.getCurrentPresetUniqueId());
            if (preset != null) {
                preset.updatePresets(this.bsbInterface);
                pGroup.setCurrentPresetModified(false);
                this.updateCurrentPresetUI();
            }
        });
        HBox.setHgrow((Node)this.currentPresetText, (Priority)Priority.ALWAYS);
        this.getChildren().addAll((Object[])new Node[]{presetsButton, this.currentPresetText, this.updateButton});
        PresetPane.setMargin((Node)presetsButton, (Insets)new Insets(5.0));
        PresetPane.setMargin((Node)this.currentPresetText, (Insets)new Insets(5.0, 0.0, 5.0, 0.0));
        PresetPane.setMargin((Node)this.updateButton, (Insets)new Insets(5.0, 5.0, 5.0, 0.0));
        this.setAlignment(Pos.CENTER);
        presetsButton.visibleProperty().bind((ObservableValue)this.presetGroupProperty().isNotNull());
        this.currentPresetText.visibleProperty().bind((ObservableValue)this.presetGroupProperty().isNotNull());
        this.updateButton.visibleProperty().bind((ObservableValue)this.presetGroupProperty().isNotNull());
    }

    public PresetGroup getPresetGroup() {
        return (PresetGroup)this.presetGroup.get();
    }

    public void setPresetGroup(PresetGroup presetGroup) {
        this.presetGroup.set((Object)presetGroup);
        this.updatePresetMenu();
        this.updateCurrentPresetUI();
    }

    public ObjectProperty<PresetGroup> presetGroupProperty() {
        return this.presetGroup;
    }

    public void setBSBInterface(BSBGraphicInterface bsbInterface) {
        this.bsbInterface = bsbInterface;
    }

    public void updatePresetMenu() {
        this.rootMenu.getItems().clear();
        if (this.getPresetGroup() != null) {
            this.setPresetsMenu(this.getPresetGroup(), null);
        }
    }

    private void setPresetsMenu(PresetGroup pGroup, Menu parent) {
        for (PresetGroup subGroup : pGroup.getSubGroups()) {
            Menu menu = new Menu(subGroup.getPresetGroupName());
            this.setPresetsMenu(subGroup, menu);
            if (parent == null) {
                this.rootMenu.getItems().add((Object)menu);
                continue;
            }
            parent.getItems().add((Object)menu);
        }
        for (Preset preset : pGroup.getPresets()) {
            MenuItem item = new MenuItem(preset.getPresetName());
            item.setUserData((Object)preset);
            item.setOnAction(this.presetSelectedAction);
            if (parent == null) {
                this.rootMenu.getItems().add((Object)item);
                continue;
            }
            parent.getItems().add((Object)item);
        }
        if (parent == null) {
            this.rootMenu.getItems().add((Object)new SeparatorMenuItem());
        } else {
            parent.getItems().add((Object)new SeparatorMenuItem());
        }
        MenuItem addFolder = new MenuItem("Add Folder");
        addFolder.setUserData((Object)pGroup);
        addFolder.setOnAction(this.addFolderAction);
        MenuItem addPreset = new MenuItem("Add Preset");
        addPreset.setUserData((Object)pGroup);
        addPreset.setOnAction(this.addPresetAction);
        if (parent == null) {
            MenuItem syncPresets = new MenuItem("Synchronize Presets");
            syncPresets.setOnAction(e -> PresetsUtilities.synchronizePresets(this.getPresetGroup(), this.bsbInterface));
            MenuItem managePresets = new MenuItem("Manage Presets");
            managePresets.setOnAction(e -> {
                PresetGroup[] retVal = new PresetGroup[1];
                CountDownLatch latch = new CountDownLatch(1);
                SwingUtilities.invokeLater(() -> {
                    try {
                        if (this.presetsManager == null) {
                            this.presetsManager = new PresetsManagerDialog(WindowManager.getDefault().getMainWindow());
                        }
                        retVal[0] = this.presetsManager.editPresetGroup(pGroup);
                    }
                    finally {
                        latch.countDown();
                    }
                });
                try {
                    latch.await();
                }
                catch (InterruptedException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                if (retVal[0] != null) {
                    pGroup.setPresets(retVal[0].getPresets());
                    pGroup.setSubGroups(retVal[0].getSubGroups());
                    this.updatePresetMenu();
                    Preset preset = pGroup.findPresetByUniqueId(pGroup.getCurrentPresetUniqueId());
                    if (preset == null) {
                        pGroup.setCurrentPresetUniqueId(null);
                        pGroup.setCurrentPresetModified(false);
                    }
                    this.updateCurrentPresetUI();
                }
            });
            this.rootMenu.getItems().addAll((Object[])new MenuItem[]{addFolder, addPreset, new SeparatorMenuItem(), syncPresets, managePresets});
        } else {
            parent.getItems().addAll((Object[])new MenuItem[]{addFolder, addPreset});
        }
    }

    protected void updateCurrentPresetUI() {
        if (this.getPresetGroup() == null) {
            return;
        }
        if (this.getPresetGroup().getCurrentPresetUniqueId() == null) {
            this.currentPresetText.setText(" No Preset Selected");
            this.updateButton.setDisable(true);
        } else {
            PresetGroup pGroup = this.getPresetGroup();
            Preset preset = pGroup.findPresetByUniqueId(pGroup.getCurrentPresetUniqueId());
            String presetText = " Current Preset: ";
            if (preset != null) {
                String presetPath = pGroup.getPresetFullPathName(pGroup.getCurrentPresetUniqueId());
                presetText = presetText + presetPath;
            }
            this.currentPresetText.setText(presetText);
            this.updateButton.setDisable(false);
        }
    }

    private void addPreset(PresetGroup currentPresetGroup) {
        TextInputDialog dlg = new TextInputDialog();
        dlg.setTitle("Enter Preset Name");
        dlg.setHeaderText("Enter Preset Name");
        dlg.setGraphic(null);
        BlueFX.style((Region)dlg.getDialogPane());
        Optional str = dlg.showAndWait();
        if (!str.isPresent() || ((String)str.get()).length() == 0) {
            return;
        }
        Preset preset = Preset.createPreset((BSBGraphicInterface)this.bsbInterface);
        preset.setPresetName((String)str.get());
        currentPresetGroup.getPresets().add(preset);
        Collections.sort(currentPresetGroup.getPresets());
        this.getPresetGroup().setCurrentPresetUniqueId(preset.getUniqueId());
        this.getPresetGroup().setCurrentPresetModified(false);
        this.updatePresetMenu();
        this.updateCurrentPresetUI();
    }

    protected void addFolder(PresetGroup presetGroup) {
        TextInputDialog dlg = new TextInputDialog();
        dlg.setTitle("Enter Folder Name");
        dlg.setHeaderText("Enter Folder Name");
        dlg.setGraphic(null);
        BlueFX.style((Region)dlg.getDialogPane());
        Optional str = dlg.showAndWait();
        if (!str.isPresent() || ((String)str.get()).length() == 0) {
            return;
        }
        String folderName = (String)str.get();
        if (folderName.length() == 0) {
            return;
        }
        PresetGroup newFolder = new PresetGroup();
        newFolder.setPresetGroupName(folderName);
        presetGroup.getSubGroups().add(newFolder);
        Collections.sort(presetGroup.getSubGroups());
        this.updatePresetMenu();
    }
}

