/*
 * Decompiled with CFR 0.152.
 */
package blue.orchestra.editor.blueSynthBuilder.jfx;

import blue.jfx.controls.ValuePanel;
import blue.orchestra.blueSynthBuilder.BSBVSlider;
import blue.orchestra.editor.blueSynthBuilder.jfx.ResizeableView;
import blue.utility.NumberUtilities;
import java.math.BigDecimal;
import java.util.concurrent.CountDownLatch;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Slider;
import javafx.scene.layout.BorderPane;
import javafx.util.StringConverter;
import org.openide.util.Exceptions;

public class BSBVSliderView
extends BorderPane
implements ResizeableView {
    Slider slider;
    ValuePanel valuePanel;
    BSBVSlider bsbVSlider;

    public BSBVSliderView(BSBVSlider bsbVSlider) {
        this.setUserData(bsbVSlider);
        this.bsbVSlider = bsbVSlider;
        this.slider = new Slider();
        this.slider.setOrientation(Orientation.VERTICAL);
        this.slider.setPrefWidth(30.0);
        this.valuePanel = new ValuePanel();
        this.valuePanel.setPrefHeight(30.0);
        this.valuePanel.setPrefWidth(50.0);
        this.setCenter((Node)this.slider);
        ChangeListener vdeListener = (obs, old, newVal) -> {
            if (newVal.booleanValue()) {
                this.setBottom((Node)this.valuePanel);
            } else {
                this.setBottom(null);
            }
        };
        StringConverter<Number> converter = new StringConverter<Number>(){

            public String toString(Number object) {
                return object == null ? "" : NumberUtilities.formatDouble((double)object.doubleValue());
            }

            public Number fromString(String string) {
                try {
                    return Double.parseDouble(string);
                }
                catch (NumberFormatException nfe) {
                    return 0.0;
                }
            }
        };
        boolean[] val = new boolean[]{false};
        ChangeListener sliderToViewListener = (obs, old, newVal) -> {
            if (!val[0]) {
                val[0] = true;
                if (!Platform.isFxApplicationThread()) {
                    CountDownLatch latch = new CountDownLatch(1);
                    Platform.runLater(() -> {
                        try {
                            this.slider.setValue(bsbVSlider.getValue());
                        }
                        finally {
                            latch.countDown();
                        }
                    });
                    try {
                        latch.await();
                    }
                    catch (InterruptedException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                } else {
                    this.slider.setValue(bsbVSlider.getValue());
                }
                val[0] = false;
            }
        };
        ChangeListener viewToSliderListener = (obs, old, newVal) -> {
            if (!val[0]) {
                val[0] = true;
                bsbVSlider.setValue(this.slider.getValue());
                val[0] = false;
            }
        };
        ChangeListener tickListener = (obs, old, newVal) -> this.updateTickCount();
        this.sceneProperty().addListener((arg_0, arg_1, arg_2) -> this.lambda$new$5(viewToSliderListener, bsbVSlider, sliderToViewListener, vdeListener, tickListener, (StringConverter)converter, arg_0, arg_1, arg_2));
    }

    protected void updateTickCount() {
        BigDecimal bd = this.bsbVSlider.getResolution();
        if (bd.doubleValue() <= 0.0) {
            this.slider.setSnapToTicks(false);
            return;
        }
        this.slider.setSnapToTicks(true);
        BigDecimal range = new BigDecimal(this.bsbVSlider.getMaximum() - this.bsbVSlider.getMinimum());
        this.slider.setMajorTickUnit(this.bsbVSlider.getResolution().doubleValue());
    }

    @Override
    public boolean canResizeWidgetWidth() {
        return false;
    }

    @Override
    public boolean canResizeWidgetHeight() {
        return true;
    }

    @Override
    public int getWidgetMinimumWidth() {
        return -1;
    }

    @Override
    public int getWidgetMinimumHeight() {
        int base = this.bsbVSlider.isValueDisplayEnabled() ? 30 : 0;
        return 45 + base;
    }

    @Override
    public int getWidgetWidth() {
        return -1;
    }

    @Override
    public void setWidgetWidth(int width) {
    }

    @Override
    public int getWidgetHeight() {
        int base = this.bsbVSlider.isValueDisplayEnabled() ? 30 : 0;
        return base + this.bsbVSlider.getSliderHeight();
    }

    @Override
    public void setWidgetHeight(int height) {
        int base = this.bsbVSlider.isValueDisplayEnabled() ? 30 : 0;
        this.bsbVSlider.setSliderHeight(Math.max(45, height - base));
    }

    @Override
    public void setWidgetX(int x) {
    }

    @Override
    public int getWidgetX() {
        return -1;
    }

    @Override
    public void setWidgetY(int y) {
        this.bsbVSlider.setY(y);
    }

    @Override
    public int getWidgetY() {
        return this.bsbVSlider.getY();
    }

    private /* synthetic */ void lambda$new$5(ChangeListener viewToSliderListener, BSBVSlider bsbVSlider, ChangeListener sliderToViewListener, ChangeListener vdeListener, ChangeListener tickListener, StringConverter converter, ObservableValue obs, Scene old, Scene newVal) {
        if (newVal == null) {
            this.slider.maxProperty().unbind();
            this.slider.minProperty().unbind();
            this.slider.prefWidthProperty().unbind();
            this.slider.valueProperty().removeListener(viewToSliderListener);
            bsbVSlider.valueProperty().removeListener(sliderToViewListener);
            bsbVSlider.valueDisplayEnabledProperty().removeListener(vdeListener);
            Bindings.unbindBidirectional((Object)this.valuePanel.valueProperty(), (Object)bsbVSlider.valueProperty());
            bsbVSlider.maximumProperty().removeListener(tickListener);
            bsbVSlider.minimumProperty().removeListener(tickListener);
            bsbVSlider.resolutionProperty().removeListener(tickListener);
        } else {
            this.slider.maxProperty().bind((ObservableValue)bsbVSlider.maximumProperty());
            this.slider.minProperty().bind((ObservableValue)bsbVSlider.minimumProperty());
            this.slider.prefHeightProperty().bind((ObservableValue)bsbVSlider.sliderHeightProperty());
            bsbVSlider.valueDisplayEnabledProperty().addListener(vdeListener);
            this.slider.setValue(bsbVSlider.getValue());
            this.slider.valueProperty().addListener(viewToSliderListener);
            bsbVSlider.valueProperty().addListener(sliderToViewListener);
            Bindings.bindBidirectional((Property)this.valuePanel.valueProperty(), (Property)bsbVSlider.valueProperty(), (StringConverter)converter);
            if (bsbVSlider.isValueDisplayEnabled()) {
                this.setBottom((Node)this.valuePanel);
            } else {
                this.setBottom(null);
            }
            this.slider.setMinorTickCount(0);
            this.updateTickCount();
            bsbVSlider.maximumProperty().addListener(tickListener);
            bsbVSlider.minimumProperty().addListener(tickListener);
            bsbVSlider.resolutionProperty().addListener(tickListener);
        }
    }
}

