/*
 * Decompiled with CFR 0.152.
 */
package blue.orchestra.editor.blueSynthBuilder;

import blue.orchestra.blueSynthBuilder.Preset;
import blue.orchestra.blueSynthBuilder.PresetGroup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class PresetsTreeModel
implements TreeModel {
    PresetGroup rootGroup;
    transient List<TreeModelListener> listeners = Collections.synchronizedList(new ArrayList());

    public PresetsTreeModel(PresetGroup rootGroup) {
        this.rootGroup = rootGroup;
    }

    public void addPreset(PresetGroup parent, Preset preset) {
        parent.addPreset(preset);
        int index = this.getIndexOfChild(parent, preset);
        int[] childIndices = new int[]{index};
        Object[] children = new Object[]{preset};
        TreeModelEvent e = new TreeModelEvent((Object)this, this.getPathForObject(preset), childIndices, children);
        this.fireNodesInserted(e);
    }

    public void addPresetGroup(PresetGroup parent, PresetGroup presetGroup) {
        parent.addPresetGroup(presetGroup);
        int index = this.getIndexOfChild(parent, presetGroup);
        int[] childIndices = new int[]{index};
        Object[] children = new Object[]{presetGroup};
        TreeModelEvent e = new TreeModelEvent((Object)this, this.getPathForObject(presetGroup), childIndices, children);
        this.fireNodesInserted(e);
    }

    public void removePreset(Preset preset) {
        PresetGroup parent = this.findParent(this.rootGroup, preset);
        int index = this.getIndexOfChild(parent, preset);
        int[] childIndices = new int[]{index};
        Object[] children = new Object[]{preset};
        TreeModelEvent e = new TreeModelEvent((Object)this, this.getPathForObject(preset), childIndices, children);
        this.rootGroup.removePreset(preset);
        this.fireNodesRemoved(e);
    }

    public void removePresetGroup(PresetGroup presetGroup) {
        PresetGroup parent = this.findParent(this.rootGroup, presetGroup);
        int index = this.getIndexOfChild(parent, presetGroup);
        int[] childIndices = new int[]{index};
        Object[] children = new Object[]{presetGroup};
        TreeModelEvent e = new TreeModelEvent((Object)this, this.getPathForObject(presetGroup), childIndices, children);
        this.rootGroup.removePresetGroup(presetGroup);
        this.fireNodesRemoved(e);
    }

    @Override
    public Object getRoot() {
        return this.rootGroup;
    }

    @Override
    public Object getChild(Object parent, int index) {
        PresetGroup presetGroup = (PresetGroup)parent;
        if (presetGroup == null) {
            return null;
        }
        if (index >= presetGroup.getSubGroups().size()) {
            return presetGroup.getPresets().get(index - presetGroup.getSubGroups().size());
        }
        return presetGroup.getSubGroups().get(index);
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent instanceof Preset) {
            return 0;
        }
        if (parent instanceof PresetGroup) {
            PresetGroup presetGroup = (PresetGroup)parent;
            return presetGroup.getSubGroups().size() + presetGroup.getPresets().size();
        }
        return 0;
    }

    @Override
    public boolean isLeaf(Object node) {
        return node instanceof Preset;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        Object obj = path.getLastPathComponent();
        if (obj instanceof PresetGroup) {
            ((PresetGroup)obj).setPresetGroupName(newValue.toString());
        } else if (obj instanceof Preset) {
            ((Preset)obj).setPresetName(newValue.toString());
        }
        TreeModelEvent e = new TreeModelEvent((Object)this, path);
        this.fireNodesChanged(e);
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        PresetGroup presetGroup = (PresetGroup)parent;
        if (presetGroup == null || child == null) {
            return -1;
        }
        int retVal = presetGroup.getSubGroups().indexOf(child);
        if (retVal >= 0) {
            return retVal;
        }
        retVal = presetGroup.getPresets().indexOf(child);
        if (retVal >= 0) {
            return retVal + presetGroup.getSubGroups().size();
        }
        return -1;
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireNodesChanged(TreeModelEvent e) {
        List<TreeModelListener> list = this.listeners;
        synchronized (list) {
            for (TreeModelListener listener : this.listeners) {
                listener.treeNodesChanged(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireNodesInserted(TreeModelEvent e) {
        List<TreeModelListener> list = this.listeners;
        synchronized (list) {
            for (TreeModelListener listener : this.listeners) {
                listener.treeNodesInserted(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireNodesRemoved(TreeModelEvent e) {
        List<TreeModelListener> list = this.listeners;
        synchronized (list) {
            for (TreeModelListener listener : this.listeners) {
                listener.treeNodesRemoved(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTreeStructureChanged(TreeModelEvent e) {
        List<TreeModelListener> list = this.listeners;
        synchronized (list) {
            for (TreeModelListener listener : this.listeners) {
                listener.treeStructureChanged(e);
            }
        }
    }

    private Object[] getPathForObject(Object obj) {
        ArrayList<Object> v = new ArrayList<Object>();
        this.getPathForObject(this.rootGroup, obj, v);
        Collections.reverse(v);
        return v.toArray();
    }

    private Object getPathForObject(PresetGroup current, Object obj, List<Object> v) {
        if (current == obj) {
            return v;
        }
        if (current.getPresets().contains(obj)) {
            v.add(current);
            return v;
        }
        for (PresetGroup pGroup : current.getSubGroups()) {
            Object pathObj = this.getPathForObject(pGroup, obj, v);
            if (pathObj == null) continue;
            v.add(current);
            return v;
        }
        return null;
    }

    private PresetGroup findParent(PresetGroup presetGroup, Object obj) {
        if (presetGroup.getPresets().contains(obj) || presetGroup.getSubGroups().contains(obj)) {
            return presetGroup;
        }
        for (PresetGroup grp : presetGroup.getSubGroups()) {
            PresetGroup temp = this.findParent(grp, obj);
            if (temp == null) continue;
            return temp;
        }
        return null;
    }
}

