/*
 * Decompiled with CFR 0.152.
 */
package blue.score.layers.patterns.core;

import electric.xml.Element;

public class PatternData {
    protected static final int BLOCK_SIZE = 16;
    boolean[] patterns = new boolean[16];
    int maxSelected = -1;

    public PatternData() {
    }

    public PatternData(PatternData pd) {
        this.patterns = (boolean[])pd.patterns.clone();
        this.maxSelected = pd.maxSelected;
    }

    public boolean isPatternSet(int index) {
        if (index < 0 || index >= this.patterns.length) {
            return false;
        }
        return this.patterns[index];
    }

    public void setPattern(int index, boolean selected) {
        if (index < 0 || this.isPatternSet(index) == selected) {
            return;
        }
        if (index >= this.patterns.length) {
            if (selected) {
                this.resizePatterns(index);
            } else {
                return;
            }
        }
        this.patterns[index] = selected;
        if (index >= this.maxSelected) {
            this.maxSelected = selected ? index : this.calculateMaxSelected();
        }
    }

    public int getSize() {
        return this.patterns.length;
    }

    public int getMaxSelected() {
        return this.maxSelected;
    }

    protected int calculateMaxSelected() {
        for (int i = this.patterns.length - 1; i >= 0; --i) {
            if (!this.patterns[i]) continue;
            return i;
        }
        return -1;
    }

    protected void resizePatterns(int index) {
        int newSize = (index / 16 + 1) * 16;
        if (newSize == this.patterns.length) {
            return;
        }
        boolean[] newPatterns = new boolean[newSize];
        int length = Math.min(this.patterns.length, newPatterns.length);
        System.arraycopy(this.patterns, 0, newPatterns, 0, length);
        this.patterns = newPatterns;
    }

    public Element saveAsXML() {
        Element retVal = new Element("patternData");
        this.resizePatterns(this.calculateMaxSelected());
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < this.patterns.length; ++i) {
            if (this.patterns[i]) {
                buffer.append("1");
                continue;
            }
            buffer.append("0");
        }
        retVal.setText(buffer.toString());
        return retVal;
    }

    public static PatternData loadFromXML(Element data) {
        PatternData patternData = new PatternData();
        String valStr = data.getTextString();
        patternData.patterns = new boolean[valStr.length()];
        for (int i = 0; i < valStr.length(); ++i) {
            patternData.patterns[i] = valStr.charAt(i) == '1';
        }
        return patternData;
    }
}

