/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.nbutilities.lazyplugin;

import blue.ui.nbutilities.lazyplugin.LazyPlugin;
import blue.ui.nbutilities.lazyplugin.LazyPluginFactory;
import java.util.logging.Logger;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public class ClassAssociationProcessor
implements LazyPluginFactory.MetaDataProcessor {
    private static final Logger LOGGER = Logger.getLogger("ClassAssociationProcessor");
    private final String attribute;

    public ClassAssociationProcessor(String attribute) {
        this.attribute = attribute;
    }

    @Override
    public void process(FileObject fObj, LazyPlugin plugin) {
        ClassLoader cl = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        if (fObj.getAttribute(this.attribute) == null) {
            String message = String.format("ClassAssocationProcessor did not find attribute %s with plugin %s", this.attribute, fObj.getPath());
            LOGGER.warning(message);
            return;
        }
        try {
            plugin.setMetaData("association", cl.loadClass((String)fObj.getAttribute(this.attribute)));
        }
        catch (ClassNotFoundException ex) {
            String message = String.format("ClassAssocationProcessor unable to load class %s for attribute %s with plugin %s", (String)fObj.getAttribute(this.attribute), this.attribute, fObj.getPath());
            LOGGER.warning(message);
        }
    }
}

