/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */


#include <core/core.h>

#include "snap_options.h"

SnapOptions::SnapOptions (bool init /* = true */) :
    mOptions (SnapOptions::OptionNum),
    mNotify (SnapOptions::OptionNum)
{
    if (init)
        initOptions ();
}

void
SnapOptions::initOptions ()
{
    CompOption::Value::Vector list;
    CompOption::Value value;

    // avoid_snap
    mOptions[SnapOptions::AvoidSnap].setName ("avoid_snap", CompOption::TypeList);
    mOptions[SnapOptions::AvoidSnap].rest ().set (0, 3);
    list.clear ();
    value.set((int) 0);
    list.push_back (value);
    mOptions[SnapOptions::AvoidSnap].value().set (CompOption::TypeInt, list);

    // snap_type
    mOptions[SnapOptions::SnapType].setName ("snap_type", CompOption::TypeList);
    mOptions[SnapOptions::SnapType].rest ().set (0, 1);
    list.clear ();
    value.set((int) 0);
    list.push_back (value);
    mOptions[SnapOptions::SnapType].value().set (CompOption::TypeInt, list);

    // edges_categories
    mOptions[SnapOptions::EdgesCategories].setName ("edges_categories", CompOption::TypeList);
    mOptions[SnapOptions::EdgesCategories].rest ().set (0, 1);
    list.clear ();
    value.set((int) 0);
    list.push_back (value);
    mOptions[SnapOptions::EdgesCategories].value().set (CompOption::TypeInt, list);

    // resistance_distance
    mOptions[SnapOptions::ResistanceDistance].setName ("resistance_distance", CompOption::TypeInt);
    mOptions[SnapOptions::ResistanceDistance].rest ().set (1, 100);
    mOptions[SnapOptions::ResistanceDistance].value().set((int) 30);

    // attraction_distance
    mOptions[SnapOptions::AttractionDistance].setName ("attraction_distance", CompOption::TypeInt);
    mOptions[SnapOptions::AttractionDistance].rest ().set (1, 100);
    mOptions[SnapOptions::AttractionDistance].value().set((int) 20);

    mAvoidSnapMask = 0;
    foreach (CompOption::Value &val, mOptions[SnapOptions::AvoidSnap].value ().list ())
        mAvoidSnapMask |= (1 << val.i ());

    mSnapTypeMask = 0;
    foreach (CompOption::Value &val, mOptions[SnapOptions::SnapType].value ().list ())
        mSnapTypeMask |= (1 << val.i ());

    mEdgesCategoriesMask = 0;
    foreach (CompOption::Value &val, mOptions[SnapOptions::EdgesCategories].value ().list ())
        mEdgesCategoriesMask |= (1 << val.i ());

}

SnapOptions::~SnapOptions ()
{
}


CompOption::Vector &
SnapOptions::getOptions ()
{
    return mOptions;
}

bool
SnapOptions::setOption (const CompString &name, CompOption::Value &value)
{
    CompOption   *o;
    unsigned int index;

    o = CompOption::findOption (mOptions, name, &index);

    if (!o)
        return false;

    switch (index)
    {
        case SnapOptions::AvoidSnap:
            if (o->set (value))
            {
                mAvoidSnapMask = 0;
                foreach (CompOption::Value &val, o->value ().list ())
                    mAvoidSnapMask |= (1 << val.i ());
                if (!mNotify[SnapOptions::AvoidSnap].empty ())
                    mNotify[SnapOptions::AvoidSnap] (o, SnapOptions::AvoidSnap);
                return true;
            }
            break;
        case SnapOptions::SnapType:
            if (o->set (value))
            {
                mSnapTypeMask = 0;
                foreach (CompOption::Value &val, o->value ().list ())
                    mSnapTypeMask |= (1 << val.i ());
                if (!mNotify[SnapOptions::SnapType].empty ())
                    mNotify[SnapOptions::SnapType] (o, SnapOptions::SnapType);
                return true;
            }
            break;
        case SnapOptions::EdgesCategories:
            if (o->set (value))
            {
                mEdgesCategoriesMask = 0;
                foreach (CompOption::Value &val, o->value ().list ())
                    mEdgesCategoriesMask |= (1 << val.i ());
                if (!mNotify[SnapOptions::EdgesCategories].empty ())
                    mNotify[SnapOptions::EdgesCategories] (o, SnapOptions::EdgesCategories);
                return true;
            }
            break;
        case SnapOptions::ResistanceDistance:
            if (o->set (value))
            {
                if (!mNotify[SnapOptions::ResistanceDistance].empty ())
                    mNotify[SnapOptions::ResistanceDistance] (o, SnapOptions::ResistanceDistance);
                return true;
            }
            break;
        case SnapOptions::AttractionDistance:
            if (o->set (value))
            {
                if (!mNotify[SnapOptions::AttractionDistance].empty ())
                    mNotify[SnapOptions::AttractionDistance] (o, SnapOptions::AttractionDistance);
                return true;
            }
            break;
        default:
            break;
    }
    return false;

}

