/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */


#include <core/core.h>

#include "composite_options.h"

CompositeOptions::CompositeOptions (bool init /* = true */) :
    mOptions (CompositeOptions::OptionNum),
    mNotify (CompositeOptions::OptionNum)
{
    if (init)
        initOptions ();
}

void
CompositeOptions::initOptions ()
{
    unsigned int state;
    CompAction action;

    // slow_animations_key
    mOptions[CompositeOptions::SlowAnimationsKey].setName ("slow_animations_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    mOptions[CompositeOptions::SlowAnimationsKey].value().set (action);
    if (screen) screen->addAction (&mOptions[CompositeOptions::SlowAnimationsKey].value ().action ());

    // detect_refresh_rate
    mOptions[CompositeOptions::DetectRefreshRate].setName ("detect_refresh_rate", CompOption::TypeBool);
    mOptions[CompositeOptions::DetectRefreshRate].value().set(true);

    // refresh_rate
    mOptions[CompositeOptions::RefreshRate].setName ("refresh_rate", CompOption::TypeInt);
    mOptions[CompositeOptions::RefreshRate].rest ().set (1, 200);
    mOptions[CompositeOptions::RefreshRate].value().set((int) 60);

    // unredirect_fullscreen_windows
    mOptions[CompositeOptions::UnredirectFullscreenWindows].setName ("unredirect_fullscreen_windows", CompOption::TypeBool);
    mOptions[CompositeOptions::UnredirectFullscreenWindows].value().set(true);

    // unredirect_match
    mOptions[CompositeOptions::UnredirectMatch].setName ("unredirect_match", CompOption::TypeMatch);
    mOptions[CompositeOptions::UnredirectMatch].value().set(CompMatch ("(any) & !(class=Totem) & !(class=MPlayer) & !(class=vlc) & !(class=Plugin-container) & !(class=QtQmlViewer) & !(class=Firefox) & !(class=google-chrome) & !(class=google-chrome-unstable) & !(class=chromium-browser)"));
    mOptions[CompositeOptions::UnredirectMatch].value().match ().update ();

    // force_independent_output_painting
    mOptions[CompositeOptions::ForceIndependentOutputPainting].setName ("force_independent_output_painting", CompOption::TypeBool);
    mOptions[CompositeOptions::ForceIndependentOutputPainting].value().set(false);

}

CompositeOptions::~CompositeOptions ()
{
}


CompOption::Vector &
CompositeOptions::getOptions ()
{
    return mOptions;
}

bool
CompositeOptions::setOption (const CompString &name, CompOption::Value &value)
{
    CompOption   *o;
    unsigned int index;

    o = CompOption::findOption (mOptions, name, &index);

    if (!o)
        return false;

    switch (index)
    {
        case CompositeOptions::SlowAnimationsKey:
            if (o->set (value))
            {
                if (!mNotify[CompositeOptions::SlowAnimationsKey].empty ())
                    mNotify[CompositeOptions::SlowAnimationsKey] (o, CompositeOptions::SlowAnimationsKey);
                return true;
            }
            break;
        case CompositeOptions::DetectRefreshRate:
            if (o->set (value))
            {
                if (!mNotify[CompositeOptions::DetectRefreshRate].empty ())
                    mNotify[CompositeOptions::DetectRefreshRate] (o, CompositeOptions::DetectRefreshRate);
                return true;
            }
            break;
        case CompositeOptions::RefreshRate:
            if (o->set (value))
            {
                if (!mNotify[CompositeOptions::RefreshRate].empty ())
                    mNotify[CompositeOptions::RefreshRate] (o, CompositeOptions::RefreshRate);
                return true;
            }
            break;
        case CompositeOptions::UnredirectFullscreenWindows:
            if (o->set (value))
            {
                if (!mNotify[CompositeOptions::UnredirectFullscreenWindows].empty ())
                    mNotify[CompositeOptions::UnredirectFullscreenWindows] (o, CompositeOptions::UnredirectFullscreenWindows);
                return true;
            }
            break;
        case CompositeOptions::UnredirectMatch:
            if (o->set (value))
            {
                if (!mNotify[CompositeOptions::UnredirectMatch].empty ())
                    mNotify[CompositeOptions::UnredirectMatch] (o, CompositeOptions::UnredirectMatch);
                return true;
            }
            break;
        case CompositeOptions::ForceIndependentOutputPainting:
            if (o->set (value))
            {
                if (!mNotify[CompositeOptions::ForceIndependentOutputPainting].empty ())
                    mNotify[CompositeOptions::ForceIndependentOutputPainting] (o, CompositeOptions::ForceIndependentOutputPainting);
                return true;
            }
            break;
        default:
            break;
    }
    return false;

}

