/*
 * Decompiled with CFR 0.152.
 */
package beast.app.beauti;

import beast.app.beauti.BeautiDoc;
import beast.app.beauti.GuessPatternDialog;
import beast.app.draw.InputEditor;
import beast.core.BEASTInterface;
import beast.core.Input;
import beast.evolution.alignment.Alignment;
import beast.evolution.alignment.FilteredAlignment;
import beast.evolution.alignment.Sequence;
import beast.evolution.alignment.Taxon;
import beast.evolution.alignment.TaxonSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class TaxonSetInputEditor
extends InputEditor.Base {
    private static final long serialVersionUID = 1L;
    List<Taxon> m_taxonset;
    List<Taxon> m_lineageset;
    Map<String, String> m_taxonMap;
    JTable m_table;
    DefaultTableModel m_model = new DefaultTableModel();
    JTextField filterEntry;
    String m_sFilter = ".*";
    int m_sortByColumn = 0;
    boolean m_bIsAscending = true;
    String m_sPattern = "^(.+)[-_\\. ](.*)$";

    public TaxonSetInputEditor(BeautiDoc beautiDoc) {
        super(beautiDoc);
    }

    @Override
    public Class<?> type() {
        return TaxonSet.class;
    }

    @Override
    public void init(Input<?> input, BEASTInterface bEASTInterface, int n, InputEditor.ExpandOption expandOption, boolean bl) {
        this.m_input = input;
        this.m_beastObject = bEASTInterface;
        this.itemNr = n;
        TaxonSet taxonSet = (TaxonSet)this.m_input.get();
        if (taxonSet == null) {
            return;
        }
        ArrayList<Taxon> arrayList = new ArrayList<Taxon>();
        List<Taxon> list = taxonSet.taxonsetInput.get();
        for (Taxon taxon : list) {
            arrayList.add(taxon);
        }
        this.add(this.getContent(arrayList));
        if (list.size() == 1 && list.get(0).getID().equals("Beauti2DummyTaxonSet") || list.size() == 0) {
            list.clear();
            try {
                this.guessTaxonSets("(.).*", 0);
                for (Taxon taxon : this.m_taxonset) {
                    for (Taxon taxon2 : ((TaxonSet)taxon).taxonsetInput.get()) {
                        this.m_lineageset.add(taxon2);
                        this.m_taxonMap.put(taxon2.getID(), taxon.getID());
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.taxonSetToModel();
            this.modelToTaxonset();
        }
    }

    private Component getContent(List<Taxon> list) {
        this.m_taxonset = list;
        this.m_taxonMap = new HashMap<String, String>();
        this.m_lineageset = new ArrayList<Taxon>();
        for (Taxon object22 : this.m_taxonset) {
            if (!(object22 instanceof TaxonSet)) continue;
            for (Taxon taxon : ((TaxonSet)object22).taxonsetInput.get()) {
                this.m_lineageset.add(taxon);
                this.m_taxonMap.put(taxon.getID(), object22.getID());
            }
        }
        this.m_model = new DefaultTableModel();
        this.m_model.addColumn("Taxon");
        this.m_model.addColumn("Species/Population");
        this.taxonSetToModel();
        this.m_table = new JTable(this.m_model){
            private static final long serialVersionUID = 1L;

            @Override
            public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
                Component component = super.prepareRenderer(tableCellRenderer, n, n2);
                if (this.isCellSelected(n, n2)) {
                    component.setBackground(Color.gray);
                } else if (n % 2 == 0) {
                    component.setBackground(new Color(237, 243, 255));
                } else {
                    component.setBackground(Color.white);
                }
                return component;
            }
        };
        this.m_table.setDefaultEditor(Object.class, new TableCellEditor(){
            JTextField m_textField = new JTextField();
            int m_iRow;
            int m_iCol;

            @Override
            public boolean stopCellEditing() {
                TaxonSetInputEditor.this.m_table.removeEditor();
                String string = this.m_textField.getText();
                TaxonSetInputEditor.this.m_model.setValueAt(string, this.m_iRow, this.m_iCol);
                TaxonSetInputEditor.this.modelToTaxonset();
                return true;
            }

            @Override
            public boolean isCellEditable(EventObject eventObject) {
                return TaxonSetInputEditor.this.m_table.getSelectedColumn() == 1;
            }

            @Override
            public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
                if (!bl) {
                    return null;
                }
                this.m_iRow = n;
                this.m_iCol = n2;
                this.m_textField.setText((String)object);
                return this.m_textField;
            }

            @Override
            public boolean shouldSelectCell(EventObject eventObject) {
                return false;
            }

            @Override
            public void removeCellEditorListener(CellEditorListener cellEditorListener) {
            }

            @Override
            public Object getCellEditorValue() {
                return null;
            }

            @Override
            public void cancelCellEditing() {
            }

            @Override
            public void addCellEditorListener(CellEditorListener cellEditorListener) {
            }
        });
        this.m_table.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.m_table.setAutoResizeMode(0);
        int n = this.m_table.getFont().getSize();
        this.m_table.setRowHeight(20 * n / 13);
        this.m_table.getColumnModel().getColumn(0).setPreferredWidth(250 * n / 13);
        this.m_table.getColumnModel().getColumn(1).setPreferredWidth(250 * n / 13);
        JTableHeader jTableHeader = this.m_table.getTableHeader();
        jTableHeader.addMouseListener(new ColumnHeaderListener());
        JScrollPane jScrollPane = new JScrollPane(this.m_table);
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        box.add(jScrollPane);
        box.add(Box.createHorizontalGlue());
        Box box2 = Box.createVerticalBox();
        box2.add(this.createFilterBox());
        box2.add(box);
        box2.add(this.createButtonBox());
        return box2;
    }

    private Component createButtonBox() {
        Box box = Box.createHorizontalBox();
        JButton jButton = new JButton("Fill down");
        jButton.setName("Fill down");
        jButton.setToolTipText("replaces all taxons in selection with the one that is selected at the top");
        jButton.addActionListener(actionEvent -> {
            int[] nArray = this.m_table.getSelectedRows();
            if (nArray.length < 2) {
                return;
            }
            String string = (String)this.m_model.getDataVector().elementAt(nArray[0]).elementAt(1);
            for (int i = 1; i < nArray.length; ++i) {
                this.m_model.setValueAt(string, nArray[i], 1);
            }
            this.modelToTaxonset();
        });
        JButton jButton2 = new JButton("Guess");
        jButton2.setName("Guess");
        jButton2.addActionListener(actionEvent -> this.guess());
        box.add(Box.createHorizontalGlue());
        box.add(jButton);
        box.add(Box.createHorizontalGlue());
        box.add(jButton2);
        box.add(Box.createHorizontalGlue());
        return box;
    }

    private void guess() {
        GuessPatternDialog guessPatternDialog = new GuessPatternDialog(this, this.m_sPattern);
        switch (guessPatternDialog.showDialog("Guess taxon sets")) {
            case canceled: {
                return;
            }
            case pattern: {
                String string = guessPatternDialog.getPattern();
                try {
                    this.guessTaxonSets(string, 0);
                    this.m_sPattern = string;
                    break;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            case trait: {
                String object = guessPatternDialog.getTrait();
                this.parseTrait(object);
            }
        }
        this.m_lineageset.clear();
        for (Taxon taxon : this.m_taxonset) {
            for (Taxon taxon2 : ((TaxonSet)taxon).taxonsetInput.get()) {
                this.m_lineageset.add(taxon2);
                this.m_taxonMap.put(taxon2.getID(), taxon.getID());
            }
        }
        this.taxonSetToModel();
        this.modelToTaxonset();
    }

    /*
     * WARNING - void declaration
     */
    public int guessTaxonSets(String string, int n) {
        void var8_11;
        Taxon taxon;
        Object object;
        this.m_taxonset.clear();
        HashMap<Object, TaxonSet> hashMap = new HashMap<Object, TaxonSet>();
        Pattern pattern = Pattern.compile(string);
        HashSet<Taxon> hashSet = new HashSet<Taxon>();
        HashSet<Object> hashSet2 = new HashSet<Object>();
        for (Alignment object2 : this.getDoc().alignments) {
            for (String string2 : object2.getTaxaNames()) {
                if (hashSet2.contains(string2)) continue;
                object = this.getDoc().getTaxon(string2);
                hashSet.add((Taxon)object);
                hashSet2.add(string2);
            }
            for (Sequence sequence : object2.sequenceInput.get()) {
                object = sequence.taxonInput.get();
                if (hashSet2.contains(object)) continue;
                taxon = this.getDoc().getTaxon(sequence.taxonInput.get());
                if (sequence.getID().equals(sequence.taxonInput.get())) {
                    sequence.setID("_" + sequence.getID());
                }
                hashSet.add(taxon);
                hashSet2.add(object);
            }
        }
        ArrayList arrayList = new ArrayList();
        for (Taxon taxon2 : hashSet) {
            if (taxon2 instanceof TaxonSet) continue;
            Matcher matcher = pattern.matcher(taxon2.getID());
            if (matcher.find()) {
                object = matcher.group(1);
            } else {
                object = "UNKNOWN";
                arrayList.add(taxon2.getID());
            }
            try {
                if (hashMap.containsKey(object)) {
                    taxon = (TaxonSet)hashMap.get(object);
                    taxon.taxonsetInput.setValue(taxon2, taxon);
                    continue;
                }
                taxon = this.newTaxonSet((String)object);
                taxon.taxonsetInput.setValue(taxon2, taxon);
                hashMap.put(object, (TaxonSet)taxon);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (arrayList.size() > 0) {
            this.showMisMatchMessage(arrayList);
        }
        boolean bl = false;
        for (TaxonSet taxonSet : hashMap.values()) {
            if (taxonSet.taxonsetInput.get().size() > n) {
                this.m_taxonset.add(taxonSet);
                continue;
            }
            var8_11 += taxonSet.taxonsetInput.get().size();
        }
        return (int)var8_11;
    }

    private TaxonSet newTaxonSet(String string) {
        Taxon taxon;
        if (this.getDoc().taxaset.containsKey(string) && (taxon = this.doc.taxaset.get(string)) instanceof TaxonSet) {
            Taxon taxon2 = taxon;
            taxon2.taxonsetInput.get().clear();
            return taxon2;
        }
        taxon = new TaxonSet();
        taxon.setID(string);
        return taxon;
    }

    /*
     * WARNING - void declaration
     */
    void parseTrait(String string) {
        Object object;
        Object object2;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String object32 : string.split(",")) {
            object2 = object32.split("=");
            if (((String[])object2).length != 2) continue;
            hashMap.put(object2[0].trim(), object2[1].trim());
        }
        this.m_taxonset.clear();
        HashSet hashSet = new HashSet();
        HashSet<String> hashSet2 = new HashSet<String>();
        for (Alignment alignment : this.getDoc().alignments) {
            void var6_12;
            if (alignment instanceof FilteredAlignment) {
                Alignment alignment2 = ((FilteredAlignment)alignment).alignmentInput.get();
            }
            for (String string2 : var6_12.getTaxaNames()) {
                if (hashSet2.contains(string2)) continue;
                object = this.getDoc().getTaxon(string2);
                hashSet.add(object);
                hashSet2.add(string2);
            }
        }
        HashMap hashMap2 = new HashMap();
        ArrayList<String> arrayList = new ArrayList<String>();
        object2 = hashSet.iterator();
        while (object2.hasNext()) {
            Taxon taxon = (Taxon)object2.next();
            if (taxon instanceof TaxonSet) continue;
            object = (String)hashMap.get(taxon.getID());
            if (object == null) {
                object = "UNKNOWN";
                arrayList.add(taxon.getID());
            }
            try {
                TaxonSet taxonSet;
                if (hashMap2.containsKey(object)) {
                    taxonSet = (TaxonSet)hashMap2.get(object);
                    taxonSet.taxonsetInput.setValue(taxon, taxonSet);
                    continue;
                }
                taxonSet = this.newTaxonSet((String)object);
                taxonSet.taxonsetInput.setValue(taxon, taxonSet);
                hashMap2.put(object, taxonSet);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        for (TaxonSet taxonSet : hashMap2.values()) {
            this.m_taxonset.add(taxonSet);
        }
        if (arrayList.size() > 0) {
            this.showMisMatchMessage(arrayList);
        }
    }

    private void showMisMatchMessage(List<String> list) {
        JOptionPane.showMessageDialog(this, "Some taxa did not have a match and are set to UNKNOWN:\n" + list.toString().replaceAll(",", "\n"), "Warning", 1);
    }

    private Component createFilterBox() {
        Box box = Box.createHorizontalBox();
        box.add(new JLabel("filter: "));
        this.filterEntry = new JTextField();
        this.filterEntry.setColumns(20);
        this.filterEntry.setToolTipText("Enter regular expression to match taxa");
        int n = this.filterEntry.getFont().getSize();
        this.filterEntry.setMaximumSize(new Dimension(1024, 20 * n / 13));
        box.add(this.filterEntry);
        box.add(Box.createHorizontalGlue());
        this.filterEntry.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.processFilter();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.processFilter();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.processFilter();
            }

            private void processFilter() {
                String string = ".*" + TaxonSetInputEditor.this.filterEntry.getText() + ".*";
                try {
                    string.matches(string);
                    TaxonSetInputEditor.this.m_sFilter = string;
                    TaxonSetInputEditor.this.taxonSetToModel();
                    TaxonSetInputEditor.this.m_table.repaint();
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    // empty catch block
                }
            }
        });
        return box;
    }

    private void taxonSetToModel() {
        while (this.m_model.getRowCount() > 0) {
            this.m_model.removeRow(0);
        }
        for (String string : this.m_taxonMap.keySet()) {
            if (!string.matches(this.m_sFilter)) continue;
            Object[] objectArray = new Object[]{string, this.m_taxonMap.get(string)};
            this.m_model.addRow(objectArray);
        }
        Vector<Vector> vector3 = this.m_model.getDataVector();
        Collections.sort(vector3, (vector, vector2) -> {
            String string;
            String string2 = (String)vector.get(this.m_sortByColumn);
            if (string2.equals(string = (String)vector2.get(this.m_sortByColumn))) {
                string2 = (String)vector.get(1 - this.m_sortByColumn);
                string = (String)vector2.get(1 - this.m_sortByColumn);
            }
            if (this.m_bIsAscending) {
                return string2.compareTo(string);
            }
            return string.compareTo(string2);
        });
        this.m_model.fireTableRowsInserted(0, this.m_model.getRowCount());
    }

    private void modelToTaxonset() {
        for (int i = 0; i < this.m_model.getRowCount(); ++i) {
            String iterator = (String)this.m_model.getDataVector().elementAt(i).elementAt(0);
            String string = (String)this.m_model.getDataVector().elementAt(i).elementAt(1);
            if (!this.m_taxonMap.containsValue(string)) {
                Taxon taxon = this.newTaxonSet(string);
                this.m_taxonset.add(taxon);
            }
            this.m_taxonMap.put(iterator, string);
        }
        for (Taxon taxon : this.m_taxonset) {
            TaxonSet taxonSet = (TaxonSet)taxon;
            taxonSet.taxonsetInput.get().clear();
            this.doc.registerPlugin(taxonSet);
        }
        for (String string : this.m_taxonMap.keySet()) {
            for (Taxon taxon : this.m_lineageset) {
                if (!taxon.getID().equals(string)) continue;
                String string2 = this.m_taxonMap.get(string);
                for (Taxon taxon2 : this.m_taxonset) {
                    TaxonSet taxonSet = (TaxonSet)taxon2;
                    if (!taxonSet.getID().equals(string2)) continue;
                    try {
                        taxonSet.taxonsetInput.setValue(taxon, taxonSet);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }
        for (int i = this.m_taxonset.size() - 1; i >= 0; --i) {
            if (((TaxonSet)this.m_taxonset.get((int)i)).taxonsetInput.get().size() != 0) continue;
            this.doc.unregisterPlugin(this.m_taxonset.get(i));
            this.m_taxonset.remove(i);
        }
        TaxonSet taxonSet = (TaxonSet)this.m_input.get();
        taxonSet.taxonsetInput.get().clear();
        for (Taxon taxon : this.m_taxonset) {
            try {
                taxonSet.taxonsetInput.setValue(taxon, taxonSet);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public class ColumnHeaderListener
    extends MouseAdapter {
        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            int n = TaxonSetInputEditor.this.m_table.getColumnModel().getColumnIndexAtX(mouseEvent.getX());
            if (n == -1) {
                return;
            }
            if (n != TaxonSetInputEditor.this.m_sortByColumn) {
                TaxonSetInputEditor.this.m_sortByColumn = n;
                TaxonSetInputEditor.this.m_bIsAscending = true;
            } else {
                TaxonSetInputEditor.this.m_bIsAscending = !TaxonSetInputEditor.this.m_bIsAscending;
            }
            TaxonSetInputEditor.this.taxonSetToModel();
        }
    }
}

