/*
 * Decompiled with CFR 0.152.
 */
package beast.app.beauti;

import beast.app.beauti.BeautiDoc;
import beast.app.draw.BEASTObjectInputEditor;
import beast.app.draw.InputEditor;
import beast.app.draw.IntegerInputEditor;
import beast.app.draw.ParameterInputEditor;
import beast.app.draw.SmallLabel;
import beast.core.BEASTInterface;
import beast.core.BEASTObject;
import beast.core.Distribution;
import beast.core.Input;
import beast.core.MCMC;
import beast.core.Operator;
import beast.core.parameter.IntegerParameter;
import beast.core.parameter.RealParameter;
import beast.core.util.CompoundDistribution;
import beast.evolution.alignment.Alignment;
import beast.evolution.likelihood.GenericTreeLikelihood;
import beast.evolution.operators.DeltaExchangeOperator;
import beast.evolution.sitemodel.SiteModel;
import beast.evolution.sitemodel.SiteModelInterface;
import java.awt.Color;
import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class SiteModelInputEditor
extends BEASTObjectInputEditor {
    private static final long serialVersionUID = 1L;
    IntegerInputEditor categoryCountEditor;
    JTextField categoryCountEntry;
    InputEditor gammaShapeEditor;
    ParameterInputEditor inVarEditor;
    JCheckBox fixMeanRatesCheckBox;
    DeltaExchangeOperator operator;
    protected SmallLabel fixMeanRatesValidateLabel;

    public SiteModelInputEditor(BeautiDoc beautiDoc) {
        super(beautiDoc);
    }

    @Override
    public Class<?> type() {
        return SiteModelInterface.Base.class;
    }

    @Override
    public void init(Input<?> input, BEASTInterface bEASTInterface, int n, InputEditor.ExpandOption expandOption, boolean bl) {
        this.fixMeanRatesCheckBox = new JCheckBox("Fix mean substitution rate");
        this.fixMeanRatesCheckBox.setName("FixMeanMutationRate");
        this.fixMeanRatesCheckBox.setEnabled(!this.doc.autoUpdateFixMeanSubstRate);
        super.init(input, bEASTInterface, n, expandOption, bl);
        List<Operator> list = ((MCMC)this.doc.mcmc.get()).operatorsInput.get();
        this.fixMeanRatesCheckBox.addActionListener(actionEvent -> {
            JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
            this.doFixMeanRates(jCheckBox.isSelected());
            if (jCheckBox.isSelected()) {
                this.setUpOperator();
            }
        });
        this.operator = (DeltaExchangeOperator)this.doc.pluginmap.get("FixMeanMutationRatesOperator");
        if (this.operator == null) {
            this.operator = new DeltaExchangeOperator();
            try {
                this.operator.setID("FixMeanMutationRatesOperator");
                this.operator.initByName("weight", 2.0, "delta", 0.75);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.doc.addPlugin(this.operator);
        }
        this.fixMeanRatesCheckBox.setSelected(list.contains(this.operator));
        Box box = Box.createHorizontalBox();
        box.add(this.fixMeanRatesCheckBox);
        box.add(Box.createHorizontalGlue());
        this.fixMeanRatesValidateLabel = new SmallLabel("x", Color.GREEN);
        this.fixMeanRatesValidateLabel.setVisible(false);
        box.add(this.fixMeanRatesValidateLabel);
        if (this.doc.alignments.size() >= 1 && this.operator != null) {
            JComponent jComponent = (JComponent)this.getComponents()[0];
            jComponent.add(box);
        }
        this.setUpOperator();
    }

    private void doFixMeanRates(boolean bl) {
        List<Operator> list = ((MCMC)this.doc.mcmc.get()).operatorsInput.get();
        if (bl) {
            if (!list.contains(this.operator)) {
                list.add(this.operator);
            }
        } else {
            list.remove(this.operator);
            this.fixMeanRatesValidateLabel.setVisible(false);
            this.repaint();
        }
    }

    public InputEditor createMutationRateEditor() {
        SiteModel siteModel = (SiteModel)this.m_input.get();
        Input<RealParameter> input = siteModel.muParameterInput;
        ParameterInputEditor parameterInputEditor = new ParameterInputEditor(this.doc);
        parameterInputEditor.init(input, siteModel, -1, InputEditor.ExpandOption.FALSE, true);
        parameterInputEditor.getEntry().setEnabled(!this.doc.autoUpdateFixMeanSubstRate);
        return parameterInputEditor;
    }

    public InputEditor createGammaCategoryCountEditor() {
        SiteModel siteModel = (SiteModel)this.m_input.get();
        Input<Integer> input = siteModel.gammaCategoryCount;
        this.categoryCountEditor = new IntegerInputEditor(this.doc){
            private static final long serialVersionUID = 1L;

            @Override
            public void validateInput() {
                super.validateInput();
                SiteModel siteModel = (SiteModel)this.m_beastObject;
                if (siteModel.gammaCategoryCount.get() < 2 && ((Boolean)siteModel.shapeParameterInput.get().isEstimatedInput.get()).booleanValue()) {
                    this.m_validateLabel.m_circleColor = Color.orange;
                    this.m_validateLabel.setToolTipText("shape parameter is estimated, but not used");
                    this.m_validateLabel.setVisible(true);
                }
            }
        };
        this.categoryCountEditor.init(input, siteModel, -1, InputEditor.ExpandOption.FALSE, true);
        this.categoryCountEntry = this.categoryCountEditor.getEntry();
        this.categoryCountEntry.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                SiteModelInputEditor.this.processEntry2();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                SiteModelInputEditor.this.processEntry2();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                SiteModelInputEditor.this.processEntry2();
            }
        });
        this.categoryCountEditor.validateInput();
        return this.categoryCountEditor;
    }

    void processEntry2() {
        String string = this.categoryCountEntry.getText();
        try {
            int n = Integer.parseInt(string);
            RealParameter realParameter = ((SiteModel)this.m_input.get()).shapeParameterInput.get();
            if (!this.gammaShapeEditor.getComponent().isVisible() && n >= 2) {
                realParameter.isEstimatedInput.setValue(true, realParameter);
            } else if (this.gammaShapeEditor.getComponent().isVisible() && n < 2) {
                realParameter.isEstimatedInput.setValue(false, realParameter);
            }
            Component component = ((ParameterInputEditor)this.gammaShapeEditor).getComponent();
            if (component instanceof ParameterInputEditor) {
                ParameterInputEditor parameterInputEditor = (ParameterInputEditor)component;
                parameterInputEditor.m_isEstimatedBox.setSelected((Boolean)realParameter.isEstimatedInput.get());
            }
            this.gammaShapeEditor.getComponent().setVisible(n >= 2);
            this.repaint();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public InputEditor createShapeEditor() throws NoSuchMethodException, SecurityException, ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Input<RealParameter> input = ((SiteModel)this.m_input.get()).shapeParameterInput;
        this.gammaShapeEditor = this.doc.getInputEditorFactory().createInputEditor(input, (BEASTInterface)this.m_input.get(), this.doc);
        this.gammaShapeEditor.getComponent().setVisible(((SiteModel)this.m_input.get()).gammaCategoryCount.get() >= 2);
        return this.gammaShapeEditor;
    }

    public InputEditor createProportionInvariantEditor() {
        Input<RealParameter> input = ((SiteModel)this.m_input.get()).invarParameterInput;
        this.inVarEditor = new ParameterInputEditor(this.doc){
            private static final long serialVersionUID = 1L;

            @Override
            public void validateInput() {
                RealParameter realParameter = (RealParameter)this.m_input.get();
                if (((Boolean)realParameter.isEstimatedInput.get()).booleanValue() && (Double)((List)realParameter.valuesInput.get()).get(0) <= 0.0) {
                    this.m_validateLabel.setVisible(true);
                    this.m_validateLabel.setToolTipText("<html><p>Proportion invariant should be non-zero when estimating</p></html>");
                    return;
                }
                if ((Double)((List)realParameter.valuesInput.get()).get(0) < 0.0 || (Double)((List)realParameter.valuesInput.get()).get(0) >= 1.0) {
                    this.m_validateLabel.setVisible(true);
                    this.m_validateLabel.setToolTipText("<html><p>Proportion invariant should be from 0 to 1 (exclusive 1)</p></html>");
                    return;
                }
                super.validateInput();
            }
        };
        this.inVarEditor.init(input, (BEASTInterface)this.m_input.get(), -1, InputEditor.ExpandOption.FALSE, true);
        this.inVarEditor.addValidationListener(this);
        return this.inVarEditor;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean customConnector(BeautiDoc beautiDoc) {
        try {
            Object object;
            Object object2;
            DeltaExchangeOperator deltaExchangeOperator = (DeltaExchangeOperator)beautiDoc.pluginmap.get("FixMeanMutationRatesOperator");
            if (deltaExchangeOperator == null) {
                return false;
            }
            List<RealParameter> list = deltaExchangeOperator.parameterInput.get();
            list.clear();
            CompoundDistribution compoundDistribution = (CompoundDistribution)beautiDoc.pluginmap.get("likelihood");
            boolean bl = false;
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            for (Distribution object3 : compoundDistribution.pDistributions.get()) {
                object2 = (GenericTreeLikelihood)object3;
                Alignment alignment = ((GenericTreeLikelihood)object2).dataInput.get();
                int n = alignment.getSiteCount();
                if (alignment.isAscertained) {
                    n -= alignment.getExcludedPatternCount();
                }
                if (!(((GenericTreeLikelihood)object2).siteModelInput.get() instanceof SiteModel)) continue;
                SiteModel siteModel = (SiteModel)((GenericTreeLikelihood)object2).siteModelInput.get();
                RealParameter realParameter = siteModel.muParameterInput.get();
                if (!((Boolean)realParameter.isEstimatedInput.get()).booleanValue()) continue;
                bl = true;
                if (arrayList.indexOf(realParameter.getID()) == -1) {
                    list.add(realParameter);
                    arrayList2.add(n);
                    arrayList.add(realParameter.getID());
                    continue;
                }
                int n2 = arrayList.indexOf(realParameter.getID());
                arrayList2.set(n2, (Integer)arrayList2.get(n2) + n);
            }
            if (arrayList2.size() == 0) {
                object = new IntegerParameter();
            } else {
                void var8_11;
                String string = "";
                object2 = arrayList2.iterator();
                while (object2.hasNext()) {
                    int n = (Integer)object2.next();
                    String string2 = (String)var8_11 + n + " ";
                }
                object = new IntegerParameter((String)var8_11);
                ((BEASTObject)object).setID("weightparameter");
            }
            ((IntegerParameter)object).isEstimatedInput.setValue(false, (BEASTInterface)object);
            deltaExchangeOperator.parameterWeightsInput.setValue(object, deltaExchangeOperator);
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void setUpOperator() {
        boolean bl = true;
        try {
            boolean bl2 = SiteModelInputEditor.customConnector(this.doc);
            if (this.doc.autoUpdateFixMeanSubstRate) {
                this.fixMeanRatesCheckBox.setSelected(bl2);
                this.doFixMeanRates(bl2);
            }
            try {
                double d = -1.0;
                CompoundDistribution compoundDistribution = (CompoundDistribution)this.doc.pluginmap.get("likelihood");
                for (Distribution distribution : compoundDistribution.pDistributions.get()) {
                    GenericTreeLikelihood genericTreeLikelihood = (GenericTreeLikelihood)distribution;
                    if (!(genericTreeLikelihood.siteModelInput.get() instanceof SiteModel)) continue;
                    SiteModel siteModel = (SiteModel)genericTreeLikelihood.siteModelInput.get();
                    RealParameter realParameter = siteModel.muParameterInput.get();
                    if (!((Boolean)realParameter.isEstimatedInput.get()).booleanValue()) continue;
                    if (d < 0.0) {
                        d = (Double)((List)realParameter.valuesInput.get()).get(0);
                        continue;
                    }
                    if (!(Math.abs(d - (Double)((List)realParameter.valuesInput.get()).get(0)) > 1.0E-10)) continue;
                    bl = false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            List<RealParameter> list = this.operator.parameterInput.get();
            if (!this.fixMeanRatesCheckBox.isSelected()) {
                this.fixMeanRatesValidateLabel.setVisible(false);
                this.repaint();
                return;
            }
            if (list.size() == 0) {
                this.fixMeanRatesValidateLabel.setVisible(true);
                this.fixMeanRatesValidateLabel.m_circleColor = Color.red;
                this.fixMeanRatesValidateLabel.setToolTipText("The model is invalid: At least one substitution rate should be estimated.");
                this.repaint();
                return;
            }
            if (!bl) {
                this.fixMeanRatesValidateLabel.setVisible(true);
                this.fixMeanRatesValidateLabel.m_circleColor = Color.orange;
                this.fixMeanRatesValidateLabel.setToolTipText("Not all substitution rates are equal. Are you sure this is what you want?");
            } else if (list.size() == 1) {
                this.fixMeanRatesValidateLabel.setVisible(true);
                this.fixMeanRatesValidateLabel.m_circleColor = Color.orange;
                this.fixMeanRatesValidateLabel.setToolTipText("At least 2 clock models should have their rate estimated");
            } else if (list.size() < this.doc.getPartitions("SiteModel").size()) {
                this.fixMeanRatesValidateLabel.setVisible(true);
                this.fixMeanRatesValidateLabel.m_circleColor = Color.orange;
                this.fixMeanRatesValidateLabel.setToolTipText("Not all partitions have their rate estimated");
            } else {
                this.fixMeanRatesValidateLabel.setVisible(false);
            }
            this.repaint();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

