/*
 * Decompiled with CFR 0.152.
 */
package beast.app.beauti;

import beast.app.beauti.BeautiDoc;
import beast.app.draw.BEASTObjectInputEditor;
import beast.app.draw.InputEditor;
import beast.core.BEASTInterface;
import beast.core.Input;
import beast.evolution.tree.TreeDistribution;
import beast.math.distributions.MRCAPrior;
import beast.math.distributions.ParametricDistribution;
import beast.math.distributions.Prior;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.apache.commons.math.MathException;

public class ParametricDistributionInputEditor
extends BEASTObjectInputEditor {
    private static final long serialVersionUID = 1L;
    boolean useDefaultBehavior;
    boolean mayBeUnstable;
    static final int[] NR_OF_TICKS = new int[]{5, 10, 8, 6, 8, 10, 6, 7, 8, 9, 10};

    public ParametricDistributionInputEditor(BeautiDoc beautiDoc) {
        super(beautiDoc);
    }

    @Override
    public Class<?> type() {
        return ParametricDistribution.class;
    }

    @Override
    public void init(Input<?> input, BEASTInterface bEASTInterface, int n, InputEditor.ExpandOption expandOption, boolean bl) {
        this.useDefaultBehavior = !(bEASTInterface instanceof Prior) && !(bEASTInterface instanceof MRCAPrior) && !(bEASTInterface instanceof TreeDistribution);
        this.m_bAddButtons = bl;
        this.m_input = input;
        this.m_beastObject = bEASTInterface;
        this.itemNr = n;
        if (input.get() != null) {
            super.init(input, bEASTInterface, n, InputEditor.ExpandOption.TRUE, bl);
        }
        this.add(this.createGraph());
    }

    @Override
    protected void addComboBox(JComponent jComponent, Input<?> input, BEASTInterface bEASTInterface) {
        if (this.useDefaultBehavior) {
            super.addComboBox(jComponent, input, bEASTInterface);
        }
    }

    @Override
    protected void addInputLabel() {
        if (this.useDefaultBehavior) {
            super.addInputLabel();
        }
    }

    private double getDensityForPlot(ParametricDistribution parametricDistribution, double d) {
        if (parametricDistribution.isIntegerDistribution()) {
            return parametricDistribution.density((int)Math.round(d));
        }
        return parametricDistribution.density(d);
    }

    private Component createGraph() {
        PDPanel pDPanel = new PDPanel();
        int n = UIManager.getFont("Label.font").getSize();
        Dimension dimension = new Dimension(200 * n / 13, 200 * n / 13);
        pDPanel.setSize(dimension);
        pDPanel.setPreferredSize(dimension);
        pDPanel.setMinimumSize(dimension);
        Box box = Box.createHorizontalBox();
        box.setBorder(BorderFactory.createEmptyBorder());
        box.add(pDPanel);
        return box;
    }

    @Override
    public void validate() {
        super.validate();
        this.repaint();
    }

    class PDPanel
    extends JPanel {
        private static final int TICK_LENGTH = 5;
        private static final int RIGHT_MARGIN = 20;
        private static final int MARGIN_LEFT_OF_Y_LABELS = 5;
        private static final int TOP_MARGIN = 10;
        int m_nTicks;
        private static final long serialVersionUID = 1L;

        PDPanel() {
        }

        @Override
        public void paintComponent(Graphics graphics) {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int n6 = this.getWidth();
            int n7 = this.getHeight();
            ParametricDistribution parametricDistribution = (ParametricDistribution)ParametricDistributionInputEditor.this.m_input.get();
            if (parametricDistribution == null) {
                return;
            }
            try {
                parametricDistribution.initAndValidate();
            }
            catch (Exception exception) {
                // empty catch block
            }
            double d = 0.1;
            double d2 = 1.0;
            try {
                d = parametricDistribution.inverseCumulativeProbability(0.01);
                d2 = parametricDistribution.inverseCumulativeProbability(0.99);
            }
            catch (Exception exception) {
                // empty catch block
            }
            double d3 = d2 - d;
            double d4 = d;
            int n8 = 0;
            double d5 = d3;
            double d6 = d4;
            while (d5 > 10.0) {
                d5 /= 10.0;
                d6 /= 10.0;
                ++n8;
            }
            while (d5 < 1.0 && d5 > 0.0) {
                d5 *= 10.0;
                d6 *= 10.0;
                --n8;
            }
            d5 = Math.ceil(d5);
            d6 = Math.floor(d6);
            for (n5 = 0; n5 < n8; ++n5) {
                d5 *= 10.0;
                d6 *= 10.0;
            }
            for (n5 = n8; n5 < 0; ++n5) {
                d5 /= 10.0;
                d6 /= 10.0;
            }
            d3 = d3 + d - d6;
            d3 = this.adjust(d3);
            n5 = this.m_nTicks;
            d = d6;
            int n9 = !parametricDistribution.isIntegerDistribution() ? 100 : (int)d3;
            int[] nArray = new int[n9];
            int[] nArray2 = new int[n9];
            double[] dArray = new double[n9];
            double d7 = 0.0;
            for (n4 = 0; n4 < n9; ++n4) {
                dArray[n4] = ParametricDistributionInputEditor.this.getDensityForPlot(parametricDistribution, d + d3 * (double)n4 / (double)n9);
                if (Double.isInfinite(dArray[n4]) || Double.isNaN(dArray[n4])) {
                    dArray[n4] = 0.0;
                }
                d7 = Math.max(d7, dArray[n4]);
            }
            d7 = this.adjust(d7);
            n4 = this.m_nTicks;
            Font font = graphics.getFont();
            Font font2 = new Font(font.getName(), font.getStyle(), font.getSize() * 2 / 3);
            graphics.setFont(font2);
            String[] stringArray = new String[n4 + 1];
            int n10 = 0;
            FontMetrics fontMetrics = this.getFontMetrics(font2);
            for (int i = 0; i <= n4; ++i) {
                stringArray[i] = this.format(d7 * (double)i / (double)n4);
                n3 = fontMetrics.stringWidth(stringArray[i]);
                if (n3 <= n10) continue;
                n10 = n3;
            }
            String[] stringArray2 = new String[n5 + 1];
            for (n3 = 0; n3 <= n5; ++n3) {
                stringArray2[n3] = this.format(d + d3 * (double)n3 / (double)n5);
            }
            n3 = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent();
            int n11 = n10 + 5 + 1 + 5;
            int n12 = n3 + 5 + 1;
            int n13 = n6 - n11 - 20;
            int n14 = n7 - 10 - n12 - 50;
            graphics.setColor(Color.WHITE);
            graphics.fillRect(n11, 10, n13, n14);
            graphics.setColor(Color.BLACK);
            graphics.drawRect(n11, 10, n13, n14);
            for (n2 = 0; n2 < n9; ++n2) {
                nArray[n2] = n11 + n13 * n2 / n9;
                nArray2[n2] = 1 + (int)((double)(10 + n14) - (double)n14 * dArray[n2] / d7);
            }
            if (!parametricDistribution.isIntegerDistribution()) {
                graphics.drawPolyline(nArray, nArray2, n9);
            } else {
                n2 = 11 + n14;
                n = n14 / 20;
                for (int i = 0; i < n9; ++i) {
                    graphics.drawLine(nArray[i], n2, nArray[i], nArray2[i]);
                    graphics.fillOval(nArray[i] - n / 2, nArray2[i] - n / 2, n, n);
                }
            }
            for (n2 = 0; n2 <= n5; ++n2) {
                n = n11 + n2 * n13 / n5;
                graphics.drawLine(n, 10 + n14, n, 10 + n14 + 5);
                graphics.drawString(stringArray2[n2], n - fontMetrics.stringWidth(stringArray2[n2]) / 2, 10 + n14 + 5 + 1 + fontMetrics.getMaxAscent());
            }
            for (n2 = 0; n2 <= n4; ++n2) {
                n = 10 + n14 - n2 * n14 / n4;
                graphics.drawLine(n11 - 5, n, n11, n);
                graphics.drawString(stringArray[n2], n11 - 5 - 1 - fontMetrics.stringWidth(stringArray[n2]), n + 3);
            }
            n2 = font.getSize() * 10 / 12;
            graphics.setFont(new Font(font.getName(), font.getStyle(), n2));
            try {
                int n15;
                FontMetrics fontMetrics2 = graphics.getFontMetrics();
                String[] stringArray3 = new String[]{"2.5% Quantile", "5% Quantile", "Median", "95% Quantile", "97.5% Quantile"};
                Double[] doubleArray = new Double[]{0.025, 0.05, 0.5, 0.95, 0.975};
                ParametricDistributionInputEditor.this.mayBeUnstable = false;
                for (n8 = 0; n8 < 5; ++n8) {
                    n15 = 10 + n14 + n12 + graphics.getFontMetrics().getMaxAscent() + n8 * n2;
                    try {
                        graphics.drawString(this.format(parametricDistribution.inverseCumulativeProbability(doubleArray[n8])), n13 / 2 + n11, n15);
                    }
                    catch (MathException mathException) {
                        graphics.drawString("not available", n13 / 2 + n11, n15);
                    }
                    graphics.drawString(stringArray3[n8], n13 / 2 - fontMetrics2.stringWidth(stringArray3[n8]) + n11 - n2, n15);
                }
                if (ParametricDistributionInputEditor.this.mayBeUnstable) {
                    n15 = n13 * 3 / 4 + n11;
                    int n16 = 10 + n14 + n12 + n2;
                    graphics.drawString("* numbers", n15, n16 + 2 * n2);
                    graphics.drawString("may not be", n15, n16 + 3 * n2);
                    graphics.drawString("accurate", n15, n16 + 4 * n2);
                }
                try {
                    graphics.drawString("mean " + this.format(parametricDistribution.getMean()), n13 * 3 / 4 + n11, 10 + n14 + n12 + n2);
                }
                catch (RuntimeException runtimeException) {}
            }
            catch (Exception exception) {
                graphics.drawString("Improper parameters", n11, 10 + n14 + n12 + graphics.getFontMetrics().getMaxAscent());
            }
        }

        private String format(double d) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            printWriter.printf("%.3g", d);
            if (d != 0.0 && Math.abs(d) / 1000.0 < 1.0E-320) {
                ParametricDistributionInputEditor.this.mayBeUnstable = true;
                printWriter.printf("*", new Object[0]);
            }
            printWriter.flush();
            return stringWriter.toString();
        }

        private double adjust(double d) {
            int n;
            int n2 = 0;
            double d2 = d;
            while (d2 > 10.0) {
                d2 /= 10.0;
                ++n2;
            }
            while (d2 < 1.0 && d2 > 0.0) {
                d2 *= 10.0;
                --n2;
            }
            d2 = Math.ceil(d2);
            this.m_nTicks = NR_OF_TICKS[(int)d2];
            for (n = 0; n < n2; ++n) {
                d2 *= 10.0;
            }
            for (n = n2; n < 0; ++n) {
                d2 /= 10.0;
            }
            return d2;
        }
    }
}

