/*
 * Decompiled with CFR 0.152.
 */
package viz.panel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import viz.DensiTree;
import viz.panel.RoundedButton;
import viz.util.Util;

public class ColorPanel
extends JPanel
implements ChangeListener {
    public static final String HELP_LINE_COLOR = "Determines line color for the complete tree set. So, this does not affect the consensus trees or root canal tree.\nDEFAULT: color 1 for most frequently occurring topology, color 2 for the second most popular, color 3 for the third, and color 4 for the remaining trees. Colors can be changed using the line colors button.\nCOLOR_BY_CLADE: draw clades in one color.\nCOLOR_BY_META_DATA_PATTERN: draw trees matching the regular expression specified in the pattern entry below.\nmeta data attribute: only available if any meta data attribute is specified. Use value of the attribute to color branches.";
    public static final String HELP_SHOW_LEGEND = "Show legend mapping colors to attribute values in the DensiTree. This only works when a discrete attribute is selected for line coloring.";
    public static final String HELP_MULTI_COLOR_CONSENSUS_TREES = "Use different colours for consensus trees instead of the standard color.";
    public static final String HELP_CATEGORICAL = "Interpret value of attribute as categorical data.";
    public static final String HELP_PATTERN = "Regular expression used for coloring trees when COLOR_BY_META_DATA_PATTERN is chosen. The string of the pattern between brackets is selected as value.";
    public static final String HELP_LINE_COLORS = "Specify custom colors.";
    private static final long serialVersionUID = 1L;
    DensiTree m_dt;
    JComboBox<String> comboBox;
    private JTextField txtPattern;
    private JButton btnLineColors;
    private JCheckBox chckbxShowLegend;
    private JCheckBox chckbxCategorical;

    public ColorPanel(DensiTree dt) {
        this.m_dt = dt;
        this.m_dt.addChangeListener(this);
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[3];
        gridBagLayout.rowHeights = new int[7];
        gridBagLayout.columnWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE, 0.0};
        this.setLayout(gridBagLayout);
        this.comboBox = new JComboBox();
        this.stateChanged(null);
        this.comboBox.setSelectedItem((Object)this.m_dt.m_lineColorMode);
        this.comboBox.setPreferredSize(new Dimension(130, 20));
        this.comboBox.setMaximumSize(new Dimension(130, 200));
        this.comboBox.addActionListener(e -> SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String selected = ColorPanel.this.comboBox.getSelectedItem().toString();
                DensiTree.LineColorMode oldMode = ColorPanel.this.m_dt.m_lineColorMode;
                String oldTag = ColorPanel.this.m_dt.m_lineColorTag;
                if (selected.equals(DensiTree.LineColorMode.DEFAULT.toString())) {
                    ColorPanel.this.m_dt.m_lineColorMode = DensiTree.LineColorMode.DEFAULT;
                } else if (selected.equals(DensiTree.LineColorMode.BY_METADATA_PATTERN.toString())) {
                    ColorPanel.this.m_dt.m_lineColorMode = DensiTree.LineColorMode.BY_METADATA_PATTERN;
                } else if (selected.equals(DensiTree.LineColorMode.COLOR_BY_CLADE.toString())) {
                    ColorPanel.this.m_dt.m_lineColorMode = DensiTree.LineColorMode.COLOR_BY_CLADE;
                } else {
                    ColorPanel.this.m_dt.m_lineColorTag = selected;
                    ColorPanel.this.m_dt.m_lineColorMode = DensiTree.LineColorMode.COLOR_BY_METADATA_TAG;
                }
                ColorPanel.this.txtPattern.setEnabled(ColorPanel.this.m_dt.m_lineColorMode == DensiTree.LineColorMode.BY_METADATA_PATTERN);
                ColorPanel.this.chckbxShowLegend.setEnabled(ColorPanel.this.m_dt.m_lineColorMode == DensiTree.LineColorMode.BY_METADATA_PATTERN || ColorPanel.this.m_dt.m_lineColorMode == DensiTree.LineColorMode.COLOR_BY_METADATA_TAG);
                ColorPanel.this.chckbxCategorical.setEnabled(ColorPanel.this.m_dt.m_lineColorMode == DensiTree.LineColorMode.COLOR_BY_METADATA_TAG);
                if (ColorPanel.this.m_dt.m_lineColorMode != oldMode || ColorPanel.this.m_dt.m_lineColorTag != null && !ColorPanel.this.m_dt.m_lineColorTag.equals(oldTag)) {
                    ColorPanel.this.m_dt.calcColors(false);
                    ColorPanel.this.m_dt.makeDirty();
                }
            }
        }));
        GridBagConstraints gbc_comboBox = new GridBagConstraints();
        gbc_comboBox.gridwidth = 2;
        gbc_comboBox.insets = new Insets(0, 0, 5, 5);
        gbc_comboBox.gridx = 0;
        gbc_comboBox.gridy = 0;
        this.add(this.comboBox, gbc_comboBox);
        this.chckbxShowLegend = new JCheckBox("Show legend");
        this.chckbxShowLegend.addActionListener(e -> {
            this.m_dt.m_showLegend = !this.m_dt.m_showLegend;
            this.m_dt.makeDirty();
        });
        this.chckbxShowLegend.setEnabled(false);
        GridBagConstraints gbc_chckbxShowLegend = new GridBagConstraints();
        gbc_chckbxShowLegend.anchor = 17;
        gbc_chckbxShowLegend.gridwidth = 2;
        gbc_chckbxShowLegend.insets = new Insets(0, 0, 5, 5);
        gbc_chckbxShowLegend.gridx = 0;
        gbc_chckbxShowLegend.gridy = 1;
        this.add((Component)this.chckbxShowLegend, gbc_chckbxShowLegend);
        JCheckBox chckbxMultiColorConsensus = new JCheckBox("<html>Multi color<br>cons-trees</html>");
        chckbxMultiColorConsensus.addActionListener(e -> {
            this.m_dt.m_bViewMultiColor = ((JCheckBox)e.getSource()).isSelected();
            this.m_dt.makeDirty();
        });
        GridBagConstraints gbc_chckbxMultiColorConsensus = new GridBagConstraints();
        gbc_chckbxMultiColorConsensus.anchor = 17;
        gbc_chckbxMultiColorConsensus.gridwidth = 3;
        gbc_chckbxMultiColorConsensus.insets = new Insets(0, 0, 5, 0);
        gbc_chckbxMultiColorConsensus.gridx = 0;
        gbc_chckbxMultiColorConsensus.gridy = 2;
        this.add((Component)chckbxMultiColorConsensus, gbc_chckbxMultiColorConsensus);
        this.txtPattern = new JTextField(this.m_dt.m_sLineColorPattern);
        this.txtPattern.addActionListener(e -> {
            String oldPattern = this.m_dt.m_sLineColorPattern;
            this.m_dt.m_sLineColorPattern = this.txtPattern.getText();
            if (oldPattern.equals(this.m_dt.m_sLineColorPattern)) {
                this.m_dt.calcColors(false);
                this.m_dt.makeDirty();
            }
        });
        this.chckbxCategorical = new JCheckBox("categorical");
        this.chckbxCategorical.addActionListener(e -> {
            this.m_dt.m_bColorByCategory = ((JCheckBox)e.getSource()).isSelected();
            this.m_dt.calcColors(true);
            this.m_dt.makeDirty();
        });
        this.chckbxCategorical.setToolTipText("indicate that the meta data item shoud be interpreted as categorical");
        this.chckbxCategorical.setEnabled(false);
        GridBagConstraints gbc_chckbxNewCheckBox = new GridBagConstraints();
        gbc_chckbxNewCheckBox.anchor = 17;
        gbc_chckbxNewCheckBox.gridwidth = 2;
        gbc_chckbxNewCheckBox.insets = new Insets(0, 0, 5, 5);
        gbc_chckbxNewCheckBox.gridx = 0;
        gbc_chckbxNewCheckBox.gridy = 3;
        this.add((Component)this.chckbxCategorical, gbc_chckbxNewCheckBox);
        JLabel lblPattern = new JLabel("pattern:");
        GridBagConstraints gbc_lblPattern = new GridBagConstraints();
        gbc_lblPattern.anchor = 13;
        gbc_lblPattern.insets = new Insets(0, 0, 5, 5);
        gbc_lblPattern.gridx = 0;
        gbc_lblPattern.gridy = 4;
        this.add((Component)lblPattern, gbc_lblPattern);
        GridBagConstraints gbc_txtPattern = new GridBagConstraints();
        gbc_txtPattern.gridwidth = 2;
        gbc_txtPattern.insets = new Insets(0, 0, 5, 5);
        gbc_txtPattern.fill = 2;
        gbc_txtPattern.gridx = 0;
        gbc_txtPattern.gridy = 5;
        this.add((Component)this.txtPattern, gbc_txtPattern);
        this.txtPattern.setColumns(10);
        this.txtPattern.setEnabled(false);
        this.btnLineColors = new RoundedButton("Line colors");
        this.btnLineColors.addActionListener(e -> new ColorDialog(this.m_dt));
        GridBagConstraints gbc_btnLineColors = new GridBagConstraints();
        gbc_btnLineColors.gridwidth = 2;
        gbc_btnLineColors.fill = 2;
        gbc_btnLineColors.insets = new Insets(0, 0, 0, 5);
        gbc_btnLineColors.gridx = 0;
        gbc_btnLineColors.gridy = 6;
        this.add((Component)this.btnLineColors, gbc_btnLineColors);
        this.comboBox.setToolTipText(Util.formatToolTipAsHtml(HELP_LINE_COLOR));
        this.txtPattern.setToolTipText(Util.formatToolTipAsHtml(HELP_PATTERN));
        this.btnLineColors.setToolTipText(Util.formatToolTipAsHtml(HELP_LINE_COLORS));
        this.chckbxShowLegend.setToolTipText(Util.formatToolTipAsHtml(HELP_SHOW_LEGEND));
        this.chckbxCategorical.setToolTipText(Util.formatToolTipAsHtml(HELP_CATEGORICAL));
        chckbxMultiColorConsensus.setToolTipText(Util.formatToolTipAsHtml(HELP_MULTI_COLOR_CONSENSUS_TREES));
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        ArrayList<String> selection = new ArrayList<String>();
        selection.add(DensiTree.LineColorMode.DEFAULT.toString());
        if (this.m_dt.m_bMetaDataReady) {
            selection.add(DensiTree.LineColorMode.COLOR_BY_CLADE.toString());
            selection.add(DensiTree.LineColorMode.BY_METADATA_PATTERN.toString());
            int i = 0;
            while (i < this.m_dt.m_metaDataTags.size()) {
                if (!this.m_dt.m_metaDataTypes.get(i).equals((Object)DensiTree.MetaDataType.SET)) {
                    selection.add(this.m_dt.m_metaDataTags.get(i));
                }
                ++i;
            }
        }
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>(selection.toArray(new String[0]));
        this.comboBox.setModel(model);
        if (this.m_dt.m_lineColorMode == DensiTree.LineColorMode.DEFAULT) {
            this.comboBox.setSelectedItem(DensiTree.LineColorMode.DEFAULT.toString());
        } else if (this.m_dt.m_lineColorMode == DensiTree.LineColorMode.BY_METADATA_PATTERN) {
            this.comboBox.setSelectedItem(DensiTree.LineColorMode.BY_METADATA_PATTERN.toString());
        } else if (this.m_dt.m_lineColorMode == DensiTree.LineColorMode.COLOR_BY_CLADE) {
            this.comboBox.setSelectedItem(DensiTree.LineColorMode.COLOR_BY_CLADE.toString());
        } else {
            this.comboBox.setSelectedItem(this.m_dt.m_lineColorTag);
        }
    }

    public class ColorDialog
    extends JDialog {
        private static final long serialVersionUID = 1L;
        DensiTree m_dt;

        public ColorDialog(DensiTree dt) {
            this.m_dt = dt;
            this.getContentPane().setLayout(new GridLayout(0, 3, 0, 0));
            this.addColorAction("Color 1", "Color of most popular topolgy", 0);
            this.addColorAction("Color 2", "Color of second most popular topolgy", 1);
            this.addColorAction("Color 3", "Color of third most popular topolgy", 2);
            this.addColorAction("Default", "Default color ", 3);
            this.addColorAction("Consensus", "Consensus tree color ", DensiTree.CONSCOLOR);
            this.addColorAction("Background", "Background color ", DensiTree.BGCOLOR);
            this.addColorAction("Root canal", "Root canal color ", DensiTree.ROOTCANALCOLOR);
            int k = 9;
            while (k < this.m_dt.m_color.length) {
                this.addColorAction("Color " + k, "Custom line color " + k, k);
                ++k;
            }
            RoundedButton button = new RoundedButton("Close");
            button.addActionListener(e -> this.dispose());
            this.add(button);
            this.setPreferredSize(new Dimension(300, 600));
            this.setSize(new Dimension(300, 600));
            this.setLocation(300, 600);
            this.setModal(true);
            this.setVisible(true);
        }

        private void addColorAction(String label, String tiptext, int colorID) {
            ColorButton button = new ColorButton(label, this.m_dt.m_color[colorID]);
            button.setToolTipText(tiptext);
            button.addActionListener(new ColorActionListener(colorID, tiptext));
            JButton btnColors = new JButton("colors");
            btnColors.addActionListener(e -> new ColorDialog(this.m_dt));
            this.add(button);
        }

        class ColorActionListener
        implements ActionListener {
            int m_colorID;
            String m_sName;

            public ColorActionListener(int colorID, String name) {
                this.m_colorID = colorID;
                this.m_sName = name;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                Color newColor = JColorChooser.showDialog(ColorDialog.this.m_dt.m_Panel, this.m_sName, ColorDialog.this.m_dt.m_color[this.m_colorID]);
                if (newColor != null && ColorDialog.this.m_dt.m_color[this.m_colorID] != newColor) {
                    ColorButton button = (ColorButton)e.getSource();
                    button.m_color = newColor;
                    button.repaint();
                    ColorDialog.this.m_dt.m_color[this.m_colorID] = newColor;
                    ColorDialog.this.m_dt.calcColors(true);
                    ColorDialog.this.m_dt.makeDirty();
                }
                ColorDialog.this.m_dt.repaint();
            }
        }

        class ColorButton
        extends RoundedButton {
            private static final long serialVersionUID = 1L;
            Color m_color;

            ColorButton(String label, Color color) {
                super(label);
                this.m_color = color;
            }

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.setColor(this.m_color);
                g.fillRect(3, 3, 10, this.getHeight() - 6);
            }
        }
    }
}

