"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const exposes = __importStar(require("../lib/exposes"));
const fromZigbee_1 = __importDefault(require("../converters/fromZigbee"));
const extend_1 = __importDefault(require("../lib/extend"));
const e = exposes.presets;
const definitions = [
    {
        zigbeeModel: ['NLG-remote', 'Neuhaus remote'],
        model: '100.462.31',
        vendor: 'Paul Neuhaus',
        description: 'Q-REMOTE',
        fromZigbee: [fromZigbee_1.default.command_on, fromZigbee_1.default.command_off, fromZigbee_1.default.command_toggle, fromZigbee_1.default.command_step, fromZigbee_1.default.command_move_to_color_temp, fromZigbee_1.default.command_stop,
            fromZigbee_1.default.command_move_to_color, fromZigbee_1.default.command_move, fromZigbee_1.default.command_color_loop_set, fromZigbee_1.default.command_ehanced_move_to_hue_and_saturation,
            fromZigbee_1.default.tint_scene, fromZigbee_1.default.command_recall],
        exposes: [e.action(['on', 'off', 'toggle', 'brightness_step_up', 'brightness_step_down', 'color_temperature_move', 'color_move',
                'brightness_stop', 'brightness_move_up', 'brightness_move_down', 'color_loop_set', 'enhanced_move_to_hue_and_saturation',
                'recall_*', 'scene_*'])],
        toZigbee: [],
    },
    {
        zigbeeModel: ['NLG-CCT light'],
        model: 'NLG-CCT light',
        vendor: 'Paul Neuhaus',
        description: 'Various color temperature lights (e.g. 100.424.11)',
        extend: extend_1.default.light_onoff_brightness_colortemp(),
    },
    {
        zigbeeModel: ['Neuhaus NLG-TW light', 'NLG-TW light'],
        model: 'NLG-TW light',
        vendor: 'Paul Neuhaus',
        description: 'Various tunable white lights (e.g. 8195-55)',
        extend: extend_1.default.light_onoff_brightness_colortemp({ colorTempRange: [153, 370] }),
    },
    {
        zigbeeModel: ['NLG-RGBW light '],
        model: 'NLG-RGBW_light',
        vendor: 'Paul Neuhaus',
        description: 'Various RGBW lights (e.g. 100.110.39)',
        extend: extend_1.default.light_onoff_brightness_colortemp_color(),
        endpoint: (device) => {
            return { 'default': 2 };
        },
    },
    {
        zigbeeModel: ['NLG-RGBW light'],
        model: 'NLG-RGBW__light',
        vendor: 'Paul Neuhaus',
        description: 'Various RGBW lights (e.g. 100.111.57)',
        extend: extend_1.default.light_onoff_brightness_colortemp_color(),
    },
    {
        zigbeeModel: ['NLG-RGB-TW light'],
        model: 'NLG-RGB-TW light',
        vendor: 'Paul Neuhaus',
        description: 'Various RGB + tunable white lights (e.g. 100.470.92)',
        extend: extend_1.default.light_onoff_brightness_colortemp_color(),
    },
    {
        zigbeeModel: ['NLG-plug'],
        model: '100.425.90',
        vendor: 'Paul Neuhaus',
        description: 'Q-PLUG adapter plug with night orientation light',
        extend: extend_1.default.switch(),
    },
    {
        zigbeeModel: ['JZ-CT-Z01'],
        model: '100.110.51',
        vendor: 'Paul Neuhaus',
        description: 'Q-FLAG LED panel, Smart-Home CCT',
        extend: extend_1.default.light_onoff_brightness_colortemp(),
    },
    {
        zigbeeModel: ['JZ-RC-J4R'],
        model: 'E0040006',
        vendor: 'Paul Neuhaus',
        description: 'Q RGBW remote controller',
        fromZigbee: [fromZigbee_1.default.command_step, fromZigbee_1.default.command_ehanced_move_to_hue_and_saturation, fromZigbee_1.default.command_move_to_color_temp,
            fromZigbee_1.default.command_on, fromZigbee_1.default.command_off, fromZigbee_1.default.command_color_loop_set],
        toZigbee: [],
        exposes: [e.action(['on', 'off', 'brightness_step_up', 'brightness_step_down', 'color_move',
                'color_temperature_move', 'brightness_stop', 'brightness_move_up', 'brightness_move_down',
                'color_loop_set', 'enhanced_move_to_hue_and_saturation']), e.action_group()],
    },
    {
        zigbeeModel: ['JZ-RGBW-Z01'],
        model: '100.075.74',
        vendor: 'Paul Neuhaus',
        description: 'Q-VIDAL RGBW ceiling lamp, 6032-55',
        endpoint: (device) => {
            return { 'default': 2 };
        },
        extend: extend_1.default.light_onoff_brightness_colortemp_color(),
    },
    {
        zigbeeModel: ['JZD60-J4R150'],
        model: '100.001.96',
        vendor: 'Paul Neuhaus',
        description: 'Q-LED Lamp RGBW E27 socket',
        extend: extend_1.default.light_onoff_brightness_colortemp_color(),
    },
    {
        zigbeeModel: ['Neuhaus RGB+CCT light'],
        model: '100.491.61',
        vendor: 'Paul Neuhaus',
        description: 'Q-MIA LED RGBW wall lamp, 9185-13',
        extend: extend_1.default.light_onoff_brightness_colortemp_color(),
    },
];
module.exports = definitions;
//# sourceMappingURL=paul_neuhaus.js.map