/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.plugin;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.cluster.ClusterStateListener;
import org.opensearch.cluster.NamedDiff;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.node.DiscoveryNodes;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.IndexScopedSettings;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.settings.SettingsFilter;
import org.opensearch.core.ParseField;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.core.common.settings.SecureString;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.env.Environment;
import org.opensearch.env.NodeEnvironment;
import org.opensearch.index.IndexModule;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.codec.CodecServiceFactory;
import org.opensearch.index.engine.EngineFactory;
import org.opensearch.index.mapper.Mapper;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.shard.IndexSettingProvider;
import org.opensearch.index.shard.IndexingOperationListener;
import org.opensearch.indices.SystemIndexDescriptor;
import org.opensearch.knn.grpc.proto.request.search.query.KNNQueryBuilderProtoConverter;
import org.opensearch.knn.index.KNNCircuitBreaker;
import org.opensearch.knn.index.KNNSettings;
import org.opensearch.knn.index.codec.KNNCodecService;
import org.opensearch.knn.index.codec.derivedsource.DerivedSourceIndexOperationListener;
import org.opensearch.knn.index.codec.nativeindex.NativeIndexBuildStrategyFactory;
import org.opensearch.knn.index.mapper.KNNVectorFieldMapper;
import org.opensearch.knn.index.memory.NativeMemoryCacheManager;
import org.opensearch.knn.index.memory.NativeMemoryLoadStrategy;
import org.opensearch.knn.index.query.KNNQuery;
import org.opensearch.knn.index.query.KNNQueryBuilder;
import org.opensearch.knn.index.query.KNNWeight;
import org.opensearch.knn.index.query.RescoreKNNVectorQuery;
import org.opensearch.knn.index.query.nativelib.NativeEngineKnnVectorQuery;
import org.opensearch.knn.index.query.parser.KNNQueryBuilderParser;
import org.opensearch.knn.index.util.KNNClusterUtil;
import org.opensearch.knn.indices.ModelCache;
import org.opensearch.knn.indices.ModelDao;
import org.opensearch.knn.indices.ModelGraveyard;
import org.opensearch.knn.jni.PlatformUtils;
import org.opensearch.knn.plugin.rest.RestClearCacheHandler;
import org.opensearch.knn.plugin.rest.RestDeleteModelHandler;
import org.opensearch.knn.plugin.rest.RestGetModelHandler;
import org.opensearch.knn.plugin.rest.RestKNNStatsHandler;
import org.opensearch.knn.plugin.rest.RestKNNWarmupHandler;
import org.opensearch.knn.plugin.rest.RestSearchModelHandler;
import org.opensearch.knn.plugin.rest.RestTrainModelHandler;
import org.opensearch.knn.plugin.script.KNNScoringScriptEngine;
import org.opensearch.knn.plugin.search.KNNConcurrentSearchRequestDecider;
import org.opensearch.knn.plugin.stats.KNNStats;
import org.opensearch.knn.plugin.transport.ClearCacheAction;
import org.opensearch.knn.plugin.transport.ClearCacheTransportAction;
import org.opensearch.knn.plugin.transport.DeleteModelAction;
import org.opensearch.knn.plugin.transport.DeleteModelTransportAction;
import org.opensearch.knn.plugin.transport.GetModelAction;
import org.opensearch.knn.plugin.transport.GetModelTransportAction;
import org.opensearch.knn.plugin.transport.KNNStatsAction;
import org.opensearch.knn.plugin.transport.KNNStatsTransportAction;
import org.opensearch.knn.plugin.transport.KNNWarmupAction;
import org.opensearch.knn.plugin.transport.KNNWarmupTransportAction;
import org.opensearch.knn.plugin.transport.RemoveModelFromCacheAction;
import org.opensearch.knn.plugin.transport.RemoveModelFromCacheTransportAction;
import org.opensearch.knn.plugin.transport.SearchModelAction;
import org.opensearch.knn.plugin.transport.SearchModelTransportAction;
import org.opensearch.knn.plugin.transport.TrainingJobRouteDecisionInfoAction;
import org.opensearch.knn.plugin.transport.TrainingJobRouteDecisionInfoTransportAction;
import org.opensearch.knn.plugin.transport.TrainingJobRouterAction;
import org.opensearch.knn.plugin.transport.TrainingJobRouterTransportAction;
import org.opensearch.knn.plugin.transport.TrainingModelAction;
import org.opensearch.knn.plugin.transport.TrainingModelRequest;
import org.opensearch.knn.plugin.transport.TrainingModelTransportAction;
import org.opensearch.knn.plugin.transport.UpdateModelGraveyardAction;
import org.opensearch.knn.plugin.transport.UpdateModelGraveyardTransportAction;
import org.opensearch.knn.plugin.transport.UpdateModelMetadataAction;
import org.opensearch.knn.plugin.transport.UpdateModelMetadataTransportAction;
import org.opensearch.knn.profile.query.KNNMetrics;
import org.opensearch.knn.quantization.models.quantizationState.QuantizationStateCache;
import org.opensearch.knn.search.extension.MMRSearchExtBuilder;
import org.opensearch.knn.search.processor.mmr.MMRKnnQueryTransformer;
import org.opensearch.knn.search.processor.mmr.MMROverSampleProcessor;
import org.opensearch.knn.search.processor.mmr.MMRQueryTransformer;
import org.opensearch.knn.search.processor.mmr.MMRRerankProcessor;
import org.opensearch.knn.training.TrainingJobClusterStateListener;
import org.opensearch.knn.training.TrainingJobRunner;
import org.opensearch.knn.training.VectorReader;
import org.opensearch.plugins.ActionPlugin;
import org.opensearch.plugins.ClusterPlugin;
import org.opensearch.plugins.EnginePlugin;
import org.opensearch.plugins.ExtensiblePlugin;
import org.opensearch.plugins.MapperPlugin;
import org.opensearch.plugins.Plugin;
import org.opensearch.plugins.ReloadablePlugin;
import org.opensearch.plugins.ScriptPlugin;
import org.opensearch.plugins.SearchPipelinePlugin;
import org.opensearch.plugins.SearchPlugin;
import org.opensearch.plugins.SystemIndexPlugin;
import org.opensearch.remoteindexbuild.client.RemoteIndexHTTPClient;
import org.opensearch.repositories.RepositoriesService;
import org.opensearch.rest.RestController;
import org.opensearch.rest.RestHandler;
import org.opensearch.script.ScriptContext;
import org.opensearch.script.ScriptEngine;
import org.opensearch.script.ScriptService;
import org.opensearch.search.deciders.ConcurrentSearchRequestDecider;
import org.opensearch.search.pipeline.SearchRequestProcessor;
import org.opensearch.search.pipeline.SearchResponseProcessor;
import org.opensearch.search.pipeline.SystemGeneratedProcessor;
import org.opensearch.threadpool.ExecutorBuilder;
import org.opensearch.threadpool.FixedExecutorBuilder;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.client.Client;
import org.opensearch.watcher.ResourceWatcherService;

public class KNNPlugin
extends Plugin
implements MapperPlugin,
SearchPlugin,
ActionPlugin,
EnginePlugin,
ClusterPlugin,
ScriptPlugin,
ExtensiblePlugin,
SystemIndexPlugin,
ReloadablePlugin,
SearchPipelinePlugin {
    public static final String LEGACY_KNN_BASE_URI = "/_opendistro/_knn";
    public static final String KNN_BASE_URI = "/_plugins/_knn";
    private KNNStats knnStats;
    private ClusterService clusterService;
    private Supplier<RepositoriesService> repositoriesServiceSupplier;
    private final Map<String, MMRQueryTransformer<? extends QueryBuilder>> mmrQueryTransformers = new HashMap<String, MMRQueryTransformer<? extends QueryBuilder>>();

    public Optional<SearchPlugin.ProfileMetricsProvider> getQueryProfileMetricsProvider() {
        return Optional.of((searchContext, query) -> {
            if (query instanceof KNNQuery || query instanceof RescoreKNNVectorQuery) {
                return KNNMetrics.getKNNQueryMetrics();
            }
            if (query instanceof NativeEngineKnnVectorQuery) {
                return KNNMetrics.getNativeMetrics();
            }
            return List.of();
        });
    }

    public Map<String, Mapper.TypeParser> getMappers() {
        return Collections.singletonMap("knn_vector", new KNNVectorFieldMapper.TypeParser(ModelDao.OpenSearchKNNModelDao::getInstance));
    }

    public List<SearchPlugin.QuerySpec<?>> getQueries() {
        return Collections.singletonList(new SearchPlugin.QuerySpec("knn", KNNQueryBuilder::new, KNNQueryBuilderParser::fromXContent));
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<RepositoriesService> repositoriesServiceSupplier) {
        this.clusterService = clusterService;
        this.repositoriesServiceSupplier = repositoriesServiceSupplier;
        VectorReader vectorReader = new VectorReader(client);
        NativeMemoryLoadStrategy.TrainingLoadStrategy.initialize(vectorReader);
        KNNSettings.state().initialize(client, clusterService);
        KNNClusterUtil.instance().initialize(clusterService, indexNameExpressionResolver);
        ModelDao.OpenSearchKNNModelDao.initialize(client, clusterService, environment.settings());
        ModelCache.initialize(ModelDao.OpenSearchKNNModelDao.getInstance(), clusterService);
        TrainingJobRunner.initialize(threadPool, ModelDao.OpenSearchKNNModelDao.getInstance());
        TrainingJobClusterStateListener.initialize(threadPool, ModelDao.OpenSearchKNNModelDao.getInstance(), clusterService);
        QuantizationStateCache.setThreadPool(threadPool);
        NativeMemoryCacheManager.setThreadPool(threadPool);
        KNNCircuitBreaker.getInstance().initialize(threadPool, clusterService, client);
        KNNQueryBuilder.initialize(ModelDao.OpenSearchKNNModelDao.getInstance());
        KNNWeight.initialize(ModelDao.OpenSearchKNNModelDao.getInstance());
        TrainingModelRequest.initialize(ModelDao.OpenSearchKNNModelDao.getInstance(), clusterService);
        clusterService.addListener((ClusterStateListener)TrainingJobClusterStateListener.getInstance());
        this.knnStats = new KNNStats();
        KNNQueryBuilderProtoConverter knnQueryConverter = new KNNQueryBuilderProtoConverter();
        return ImmutableList.of((Object)this.knnStats, (Object)knnQueryConverter);
    }

    public List<Setting<?>> getSettings() {
        return KNNSettings.state().getSettings();
    }

    public Collection<IndexSettingProvider> getAdditionalIndexSettingProviders() {
        return ImmutableList.of((Object)new IndexSettingProvider(this){

            public Settings getAdditionalIndexSettings(String indexName, boolean isDataStreamIndex, Settings templateAndRequestSettings) {
                if (templateAndRequestSettings.getAsBoolean("index.knn", Boolean.valueOf(false)).booleanValue()) {
                    return Settings.builder().put("index.knn.derived_source.enabled", true).build();
                }
                return Settings.EMPTY;
            }
        });
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        RestKNNStatsHandler restKNNStatsHandler = new RestKNNStatsHandler();
        RestKNNWarmupHandler restKNNWarmupHandler = new RestKNNWarmupHandler(settings, restController, this.clusterService, indexNameExpressionResolver);
        RestGetModelHandler restGetModelHandler = new RestGetModelHandler();
        RestDeleteModelHandler restDeleteModelHandler = new RestDeleteModelHandler();
        RestTrainModelHandler restTrainModelHandler = new RestTrainModelHandler();
        RestSearchModelHandler restSearchModelHandler = new RestSearchModelHandler();
        RestClearCacheHandler restClearCacheHandler = new RestClearCacheHandler(this.clusterService, indexNameExpressionResolver);
        return ImmutableList.of((Object)((Object)restKNNStatsHandler), (Object)((Object)restKNNWarmupHandler), (Object)((Object)restGetModelHandler), (Object)((Object)restDeleteModelHandler), (Object)((Object)restTrainModelHandler), (Object)((Object)restSearchModelHandler), (Object)((Object)restClearCacheHandler));
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        return Arrays.asList(new ActionPlugin.ActionHandler((ActionType)KNNStatsAction.INSTANCE, KNNStatsTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)KNNWarmupAction.INSTANCE, KNNWarmupTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)UpdateModelMetadataAction.INSTANCE, UpdateModelMetadataTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)TrainingJobRouteDecisionInfoAction.INSTANCE, TrainingJobRouteDecisionInfoTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetModelAction.INSTANCE, GetModelTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)DeleteModelAction.INSTANCE, DeleteModelTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)TrainingJobRouterAction.INSTANCE, TrainingJobRouterTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)TrainingModelAction.INSTANCE, TrainingModelTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)RemoveModelFromCacheAction.INSTANCE, RemoveModelFromCacheTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)SearchModelAction.INSTANCE, SearchModelTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)UpdateModelGraveyardAction.INSTANCE, UpdateModelGraveyardTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ClearCacheAction.INSTANCE, ClearCacheTransportAction.class, new Class[0]));
    }

    public Optional<EngineFactory> getEngineFactory(IndexSettings indexSettings) {
        return Optional.empty();
    }

    public Optional<CodecServiceFactory> getCustomCodecServiceFactory(IndexSettings indexSettings) {
        if (((Boolean)indexSettings.getValue(KNNSettings.IS_KNN_INDEX_SETTING)).booleanValue()) {
            return Optional.of(config -> new KNNCodecService(config, new NativeIndexBuildStrategyFactory(this.repositoriesServiceSupplier, indexSettings)));
        }
        return Optional.empty();
    }

    public void onIndexModule(IndexModule indexModule) {
        KNNSettings.state().onIndexModule(indexModule);
        if (KNNSettings.isKNNDerivedSourceEnabled(indexModule.getSettings())) {
            indexModule.addIndexOperationListener((IndexingOperationListener)new DerivedSourceIndexOperationListener());
        }
    }

    public void loadExtensions(ExtensiblePlugin.ExtensionLoader loader) {
        this.mmrQueryTransformers.put("knn", new MMRKnnQueryTransformer());
        for (MMRQueryTransformer transformer : loader.loadExtensions(MMRQueryTransformer.class)) {
            String queryName = transformer.getQueryName();
            if (this.mmrQueryTransformers.containsKey(queryName)) {
                throw new IllegalStateException(String.format(Locale.ROOT, "Already load the MMR query transformer %s for %s query. Cannot load another transformer %s for it.", this.mmrQueryTransformers.get(queryName).getClass().getName(), queryName, transformer.getClass().getName()));
            }
            this.mmrQueryTransformers.put(queryName, transformer);
        }
    }

    public ScriptEngine getScriptEngine(Settings settings, Collection<ScriptContext<?>> contexts) {
        return new KNNScoringScriptEngine();
    }

    public List<ExecutorBuilder<?>> getExecutorBuilders(Settings settings) {
        return ImmutableList.of((Object)new FixedExecutorBuilder(settings, "training", 1, 1, "knn", false));
    }

    public List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        ArrayList<NamedWriteableRegistry.Entry> entries = new ArrayList<NamedWriteableRegistry.Entry>();
        entries.add(new NamedWriteableRegistry.Entry(Metadata.Custom.class, "opensearch-knn-blocked-models", ModelGraveyard::new));
        entries.add(new NamedWriteableRegistry.Entry(NamedDiff.class, "opensearch-knn-blocked-models", ModelGraveyard::readDiffFrom));
        return entries;
    }

    public List<NamedXContentRegistry.Entry> getNamedXContent() {
        ArrayList<NamedXContentRegistry.Entry> entries = new ArrayList<NamedXContentRegistry.Entry>();
        entries.add(new NamedXContentRegistry.Entry(Metadata.Custom.class, new ParseField("opensearch-knn-blocked-models", new String[0]), ModelGraveyard::fromXContent));
        return entries;
    }

    public Collection<SystemIndexDescriptor> getSystemIndexDescriptors(Settings settings) {
        return ImmutableList.of((Object)new SystemIndexDescriptor(".opensearch-knn-models", "Index for storing models used for k-NN indices"));
    }

    public Optional<ConcurrentSearchRequestDecider.Factory> getConcurrentSearchRequestDeciderFactory() {
        return Optional.of(new KNNConcurrentSearchRequestDecider.Factory());
    }

    public void onNodeStarted(DiscoveryNode localNode) {
        Optional<String> tierAttribute = Optional.ofNullable((String)localNode.getAttributes().get("knn_cb_tier"));
        if (tierAttribute.isPresent()) {
            KNNSettings.state().setNodeCbAttribute(tierAttribute);
            if (KNNSettings.state().getCircuitBreakerLimit().getKb() != NativeMemoryCacheManager.getInstance().getMaxCacheSizeInKilobytes()) {
                NativeMemoryCacheManager.getInstance().rebuildCache();
            }
        }
    }

    public void reload(Settings settings) {
        SecureString username = (SecureString)KNNSettings.KNN_REMOTE_BUILD_SERVER_USERNAME_SETTING.get(settings);
        SecureString password = (SecureString)KNNSettings.KNN_REMOTE_BUILD_SERVER_PASSWORD_SETTING.get(settings);
        RemoteIndexHTTPClient.reloadAuthHeader((SecureString)username, (SecureString)password);
    }

    public List<SearchPlugin.SearchExtSpec<?>> getSearchExts() {
        return List.of(new SearchPlugin.SearchExtSpec("mmr", MMRSearchExtBuilder::new, MMRSearchExtBuilder::parse));
    }

    public Map<String, SystemGeneratedProcessor.SystemGeneratedFactory<SearchRequestProcessor>> getSystemGeneratedRequestProcessors(SearchPipelinePlugin.Parameters parameters) {
        KNNClusterUtil.instance().setSearchPipelineService(parameters.searchPipelineService);
        return Map.of("mmr_over_sample_factory", new MMROverSampleProcessor.MMROverSampleProcessorFactory(parameters.client, this.mmrQueryTransformers));
    }

    public Map<String, SystemGeneratedProcessor.SystemGeneratedFactory<SearchResponseProcessor>> getSystemGeneratedResponseProcessors(SearchPipelinePlugin.Parameters parameters) {
        return Map.of("mmr_rerank_factory", new MMRRerankProcessor.MMRRerankProcessorFactory());
    }

    static {
        PlatformUtils.isAVX2SupportedBySystem();
        PlatformUtils.isAVX512SupportedBySystem();
        PlatformUtils.isAVX512SPRSupportedBySystem();
    }
}

