// This file is part of libigl, a simple c++ geometry processing library.
// 
// Copyright (C) 2013 Alec Jacobson <alecjacobson@gmail.com>
// 
// This Source Code Form is subject to the terms of the Mozilla Public License 
// v. 2.0. If a copy of the MPL was not distributed with this file, You can 
// obtain one at http://mozilla.org/MPL/2.0/.
#include "quat_to_mat.h"

template <typename Q_type>
IGL_INLINE void igl::quat_to_mat(const Q_type * quat, Q_type * mat)
{
  Q_type yy2 = 2.0f * quat[1] * quat[1];
  Q_type xy2 = 2.0f * quat[0] * quat[1];
  Q_type xz2 = 2.0f * quat[0] * quat[2];
  Q_type yz2 = 2.0f * quat[1] * quat[2];
  Q_type zz2 = 2.0f * quat[2] * quat[2];
  Q_type wz2 = 2.0f * quat[3] * quat[2];
  Q_type wy2 = 2.0f * quat[3] * quat[1];
  Q_type wx2 = 2.0f * quat[3] * quat[0];
  Q_type xx2 = 2.0f * quat[0] * quat[0];
  mat[0*4+0] = - yy2 - zz2 + 1.0f;
  mat[0*4+1] = xy2 + wz2;
  mat[0*4+2] = xz2 - wy2;
  mat[0*4+3] = 0;
  mat[1*4+0] = xy2 - wz2;
  mat[1*4+1] = - xx2 - zz2 + 1.0f;
  mat[1*4+2] = yz2 + wx2;
  mat[1*4+3] = 0;
  mat[2*4+0] = xz2 + wy2;
  mat[2*4+1] = yz2 - wx2;
  mat[2*4+2] = - xx2 - yy2 + 1.0f;
  mat[2*4+3] = 0;
  mat[3*4+0] = mat[3*4+1] = mat[3*4+2] = 0;
  mat[3*4+3] = 1;
}

#ifdef IGL_STATIC_LIBRARY
// Explicit template instantiation
// generated by autoexplicit.sh
template void igl::quat_to_mat<double>(double const*, double*);
// generated by autoexplicit.sh
template void igl::quat_to_mat<float>(float const*, float*);
#endif
