/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bibgls.bib2gls;

import com.dickimawbooks.bibgls.bib2gls.Bib2Gls;
import com.dickimawbooks.bibgls.bib2gls.Bib2GlsIndex;
import com.dickimawbooks.bibgls.bib2gls.CompoundEntry;
import com.dickimawbooks.bibgls.bib2gls.FieldAssignment;
import com.dickimawbooks.bibgls.bib2gls.GlsLike;
import com.dickimawbooks.bibgls.bib2gls.GlsRecord;
import com.dickimawbooks.bibgls.bib2gls.GlsResource;
import com.dickimawbooks.bibgls.bib2gls.GlsSeeRecord;
import com.dickimawbooks.bibgls.bib2gls.MissingFieldAction;
import com.dickimawbooks.bibgls.bib2gls.SortSettings;
import com.dickimawbooks.bibgls.bib2gls.SupplementalRecord;
import com.dickimawbooks.bibgls.common.Bib2GlsException;
import com.dickimawbooks.texparserlib.BgChar;
import com.dickimawbooks.texparserlib.CharObject;
import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.EgChar;
import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.Ignoreable;
import com.dickimawbooks.texparserlib.MathGroup;
import com.dickimawbooks.texparserlib.TeXApp;
import com.dickimawbooks.texparserlib.TeXCsRef;
import com.dickimawbooks.texparserlib.TeXNumber;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserListener;
import com.dickimawbooks.texparserlib.TeXPath;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.UserNumber;
import com.dickimawbooks.texparserlib.bib.BibEntry;
import com.dickimawbooks.texparserlib.bib.BibNumber;
import com.dickimawbooks.texparserlib.bib.BibTeXSyntaxException;
import com.dickimawbooks.texparserlib.bib.BibUserString;
import com.dickimawbooks.texparserlib.bib.BibValue;
import com.dickimawbooks.texparserlib.bib.BibValueList;
import com.dickimawbooks.texparserlib.bib.Contributor;
import com.dickimawbooks.texparserlib.latex.CsvList;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.CollationKey;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Bib2GlsEntry
extends BibEntry {
    private Vector<GlsRecord> records;
    private HashMap<String, Vector<GlsRecord>> recordMap;
    private Vector<GlsRecord> ignoredRecords;
    private Vector<GlsRecord> supplementalRecords;
    private HashMap<TeXPath, Vector<GlsRecord>> supplementalRecordMap;
    private Vector<GlsRecord> primaryRecords = null;
    private HashMap<String, Vector<GlsRecord>> primaryRecordMap = null;
    private Vector<String> primaryCounters = null;
    private boolean selected = false;
    private boolean nonumberlist = false;
    private String base = "";
    private File baseFile = null;
    private String originalEntryType;
    private Vector<Bib2GlsEntry> children;
    private HashMap<String, String> fieldValues;
    private Vector<String> deps;
    private Vector<Bib2GlsEntry> hierarchy;
    private Vector<Bib2GlsEntry> crossRefdBy;
    private BibValueList orgParentValue = null;
    private String crossRefTag = null;
    private String[] crossRefs = null;
    private String[] alsocrossRefs = null;
    private String orgCrossRefTag = null;
    private String[] orgCrossRefs = null;
    private String[] orgAlsoCrossRefs = null;
    public static final int NO_SEE = 0;
    public static final int PRE_SEE = 1;
    public static final int POST_SEE = 2;
    protected Bib2Gls bib2gls;
    protected GlsResource resource;
    private CollationKey collationKey;
    private String groupId = null;
    private String labelPrefix = null;
    private String labelSuffix;
    private Bib2GlsEntry dual = null;
    private Number numericSort = null;
    private Object sortObject = null;
    private int sortLevel = -1;
    private boolean fieldsParsed = false;
    private boolean triggerRecordFound = false;
    private Vector<String> locationList = null;
    private GlsRecord indexCounterRecord = null;
    private long defIndex = 0L;
    private long recordIndex = -1L;
    private String crossRefTail = null;
    private static long defIndexCount = 0L;
    private static final Pattern EXT_PREFIX_PATTERN = Pattern.compile("ext(\\d+)\\.(.*)");
    private static final Pattern RANGE_PATTERN = Pattern.compile("(\\(|\\))(.*)");

    public Bib2GlsEntry(Bib2Gls bib2Gls) {
        this(bib2Gls, "entry");
    }

    private Bib2GlsEntry(Bib2Gls bib2Gls, long l) {
        this(bib2Gls, "entry", l);
    }

    public Bib2GlsEntry(Bib2Gls bib2Gls, String string) {
        this(bib2Gls, string, defIndexCount++);
    }

    private Bib2GlsEntry(Bib2Gls bib2Gls, String string, long l) {
        super(string.toLowerCase());
        this.bib2gls = bib2Gls;
        this.originalEntryType = string;
        this.defIndex = l;
        this.resource = bib2Gls.getCurrentResource();
        this.labelPrefix = this.resource.getLabelPrefix();
        this.fieldValues = new HashMap();
        this.deps = new Vector();
        String[] stringArray = this.resource.getLocationCounters();
        if (stringArray == null) {
            this.records = new Vector();
        } else {
            this.recordMap = new HashMap(stringArray.length);
            for (String string2 : stringArray) {
                this.recordMap.put(string2, new Vector());
            }
        }
        String string3 = this.resource.getDefinitionIndexField();
        if (string3 != null) {
            BibValueList bibValueList = new BibValueList();
            bibValueList.add((Object)new BibNumber((TeXNumber)new UserNumber((int)l)));
            this.putField(string3, bibValueList);
            this.putField(string3, "" + l);
        }
    }

    public String getBase() {
        return this.base;
    }

    public File getBaseFile() {
        return this.baseFile;
    }

    public void setBase(File file) {
        this.baseFile = file;
        String string = file.getName();
        this.base = string != null && string.endsWith(".bib") ? string.substring(0, string.length() - 4) : string;
    }

    @Deprecated
    public void setBase(String string) {
        this.base = string != null && string.endsWith(".bib") ? string.substring(0, string.length() - 4) : string;
    }

    public void setDual(Bib2GlsEntry bib2GlsEntry) {
        this.dual = bib2GlsEntry;
    }

    public Bib2GlsEntry getDual() {
        return this.dual;
    }

    public GlsResource getResource() {
        return this.resource;
    }

    public Bib2Gls getBib2Gls() {
        return this.bib2gls;
    }

    public String getPrefix() {
        return this.labelPrefix;
    }

    public String getSuffix() {
        return this.labelSuffix;
    }

    public void setSuffix(String string) {
        this.labelSuffix = string;
    }

    public String getId() {
        String string = super.getId();
        if (string == null) {
            return this.bib2gls.getMessage("message.missing.id");
        }
        if (this.labelPrefix == null && this.labelSuffix == null) {
            return string;
        }
        if (this.labelPrefix == null) {
            return string + this.labelSuffix;
        }
        if (this.labelSuffix == null) {
            return this.labelPrefix + string;
        }
        return this.labelPrefix + string + this.labelSuffix;
    }

    public String getOriginalId() {
        return super.getId();
    }

    private void setOriginalId(String string) {
        super.setId(string);
    }

    public void setId(String string, String string2) {
        this.labelPrefix = string;
        this.setId(string2);
    }

    public void setOriginalEntryType(String string) {
        this.originalEntryType = string;
    }

    public String getOriginalEntryType() {
        return this.originalEntryType;
    }

    public String processLabel(String string) {
        return this.processLabel(string, false);
    }

    public String processLabel(String string, boolean bl) {
        Object object;
        String string2;
        block20: {
            string2 = string;
            if (string2.startsWith("dual.")) {
                object = this.resource.getDualPrefix();
                if (object == null) {
                    string2 = string2.substring(5);
                } else if (!((String)object).equals("dual.")) {
                    string2 = String.format("%s%s", object, string2.substring(5));
                }
            } else if (string2.startsWith("tertiary.")) {
                object = this.resource.getTertiaryPrefix();
                if (object == null) {
                    string2 = string2.substring(9);
                } else if (!((String)object).equals("tertiary.")) {
                    string2 = String.format("%s%s", object, string2.substring(5));
                }
            } else {
                object = EXT_PREFIX_PATTERN.matcher(string2);
                if (((Matcher)object).matches()) {
                    try {
                        String string3 = this.resource.getExternalPrefix(Integer.parseInt(((Matcher)object).group(1)));
                        if (string3 == null) {
                            string2 = ((Matcher)object).group(2);
                            break block20;
                        }
                        string2 = String.format("%s%s", string3, ((Matcher)object).group(2));
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.bib2gls.debug(numberFormatException);
                    }
                } else if (bl) {
                    String string4 = this.resource.getCsLabelPrefix();
                    if (string4 != null) {
                        string2 = String.format("%s%s", this.resource.getCsLabelPrefix(), string2);
                    }
                } else if (this.labelPrefix != null) {
                    string2 = String.format("%s%s", this.labelPrefix, string2);
                }
            }
        }
        if (this.resource.isInsertPrefixOnlyExists() && (object = this.resource.getEntry(string2)) == null) {
            return string;
        }
        return string2;
    }

    private boolean isGlsCsOptLabel(String string) {
        block9: {
            block8: {
                if (string.equals("gls") || string.equals("glspl") || string.equals("acrfull") || string.equals("acrlong") || string.equals("acrshort") || string.equals("acrfullpl") || string.equals("acrlongpl") || string.equals("acrshortpl") || string.equals("cgls") || string.equals("cglspl") || string.equals("pgls") || string.equals("pglspl") || string.equals("glsadd") || string.equals("glsdisp") || string.equals("glslink") || string.equals("glsxtrfull") || string.equals("glsxtrfullpl") || string.equals("glsxtrshort") || string.equals("glsxtrshortpl") || string.equals("glsxtrlong") || string.equals("glsxtrlongpl") || string.equals("glsps") || string.equals("glspt") || string.equals("glshyperlink")) {
                    if (string.startsWith("acr")) {
                        this.bib2gls.warningMessage("warning.deprecated.cs", string, "glsxtr" + string.substring(3));
                    }
                    return true;
                }
                if (this.bib2gls.checkAcroShortcuts() && (string.equals("ac") || string.equals("acs") || string.equals("acsp") || string.equals("acl") || string.equals("aclp") || string.equals("acf") || string.equals("acfp"))) {
                    return true;
                }
                if (this.bib2gls.checkAbbrvShortcuts() && (string.equals("ab") || string.equals("abp") || string.equals("as") || string.equals("asp") || string.equals("al") || string.equals("alp") || string.equals("af") || string.equals("afp"))) {
                    return true;
                }
                if (!string.startsWith("glsxtr")) break block8;
                Vector<String> vector = this.bib2gls.getFields();
                HashMap<String, String> hashMap = this.bib2gls.getFieldMap();
                for (String string2 : vector) {
                    if (string.equals("glsxtr" + string2)) {
                        return true;
                    }
                    String string3 = hashMap.get(string2);
                    if (string3 == null || !string.equals("glsxtr" + string3)) continue;
                    return true;
                }
                break block9;
            }
            if (!string.startsWith("gls")) break block9;
            Vector<String> vector = this.bib2gls.getFields();
            HashMap<String, String> hashMap = this.bib2gls.getFieldMap();
            for (String string4 : vector) {
                if (string.equals("gls" + string4)) {
                    return true;
                }
                String string5 = hashMap.get(string4);
                if (string5 == null || !string.equals("gls" + string5)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isCsProblematic(String string) {
        return string.equals("foreignlanguage") || string.equals("textcolor") || string.equals("ensuremath") || string.equals("cite") || string.equals("citep") || string.equals("citet") || string.equals("autoref") || string.equals("cref") || string.equals("ref");
    }

    private void checkGlsCs(TeXObjectList teXObjectList, boolean bl, String string) throws IOException {
        TeXParser teXParser = this.resource.getBibParser();
        for (int i = 0; i < teXObjectList.size(); ++i) {
            TeXObject teXObject = (TeXObject)teXObjectList.get(i);
            if (teXObject.isPar() || teXObject instanceof TeXCsRef && ((TeXCsRef)teXObject).getName().equals("par")) {
                teXObjectList.set(i, (Object)new TeXCsRef("glspar"));
                continue;
            }
            if (teXObject instanceof TeXCsRef) {
                String string2 = ((TeXCsRef)teXObject).getName();
                GlsLike glsLike = this.bib2gls.getGlsLike(string2);
                boolean bl2 = glsLike != null;
                String string3 = glsLike == null ? null : glsLike.getPrefix();
                boolean bl3 = false;
                boolean bl4 = false;
                if (!bl2) {
                    bl4 = this.bib2gls.isMglsCs(string2);
                }
                String string4 = string2.toLowerCase();
                try {
                    Object object;
                    String string5;
                    String string6;
                    TeXObject teXObject2;
                    if (string4.equals("glssee") || string4.equals("glsxtrindexseealso")) {
                        int n;
                        bl3 = i == 0;
                        teXObject2 = (TeXObject)teXObjectList.get(++i);
                        while (teXObject2 instanceof Ignoreable) {
                            teXObject2 = (TeXObject)teXObjectList.get(++i);
                        }
                        if (teXObject2 instanceof CharObject && (n = ((CharObject)teXObject2).getCharCode()) == 91) {
                            while (i < teXObjectList.size()) {
                                teXObject2 = (TeXObject)teXObjectList.get(i);
                                if (teXObject2 instanceof CharObject && ((CharObject)teXObject2).getCharCode() == 93) {
                                    teXObject2 = (TeXObject)teXObjectList.get(++i);
                                    break;
                                }
                                ++i;
                            }
                            while (teXObject2 instanceof Ignoreable) {
                                teXObject2 = (TeXObject)teXObjectList.get(++i);
                            }
                        }
                        if (teXObject2 instanceof Group) {
                            teXObject2 = ((Group)teXObject2).toList();
                        }
                        if (!(string6 = this.processLabel(string5 = teXObject2.toString(teXParser), true)).equals(string5)) {
                            string5 = string6;
                            teXObjectList.set(i, (Object)teXParser.getListener().createGroup(string5));
                        }
                        if (this.bib2gls.isVerbose()) {
                            this.bib2gls.logMessage(this.bib2gls.getMessage("message.crossref.found", this.getId(), teXObject.toString(teXParser), string5));
                        }
                        this.addParsedDependency(string5, string2, glsLike, bl4);
                        teXObject2 = (TeXObject)teXObjectList.get(++i);
                        while (teXObject2 instanceof Ignoreable) {
                            teXObject2 = (TeXObject)teXObjectList.get(++i);
                        }
                        object = teXParser.getListener().createGroup();
                        CsvList csvList = CsvList.getList((TeXParser)teXParser, (TeXObject)teXObject2);
                        int n2 = csvList.size() - 1;
                        for (int j = 0; j <= n2; ++j) {
                            TeXObject teXObject3 = (TeXObject)csvList.get(j);
                            string5 = this.processLabel(teXObject3.toString(teXParser), true);
                            object.add((TeXObject)teXParser.getListener().createString(string5));
                            if (j < n2) {
                                object.add((TeXObject)teXParser.getListener().getOther(44));
                            }
                            if (this.bib2gls.isVerbose()) {
                                this.bib2gls.logMessage(this.bib2gls.getMessage("message.crossref.found", this.getId(), teXObject.toString(teXParser), string5));
                            }
                            this.addParsedDependency(string5, string2, glsLike, bl4);
                        }
                        teXObjectList.set(i, object);
                    } else if (string4.equals("glsxtrp")) {
                        bl3 = i == 0;
                        teXObject2 = (TeXObject)teXObjectList.get(++i);
                        while (teXObject2 instanceof Ignoreable) {
                            teXObject2 = (TeXObject)teXObjectList.get(++i);
                        }
                        teXObject2 = (TeXObject)teXObjectList.get(++i);
                        while (teXObject2 instanceof Ignoreable) {
                            teXObject2 = (TeXObject)teXObjectList.get(++i);
                        }
                        if (teXObject2 instanceof Group) {
                            teXObject2 = ((Group)teXObject2).toList();
                        }
                        if (!(string5 = teXObject2.toString(teXParser)).equals(string6 = this.processLabel(string5, true))) {
                            string5 = string6;
                            teXObjectList.set(i, (Object)teXParser.getListener().createGroup(string5));
                        }
                        if (this.bib2gls.isVerbose()) {
                            this.bib2gls.logMessage(this.bib2gls.getMessage("message.crossref.found", this.getId(), teXObject.toString(teXParser), string5));
                        }
                        this.addParsedDependency(string5, string2, glsLike, bl4);
                    } else if (bl2 || bl4 || this.isGlsCsOptLabel(string4)) {
                        Object object2;
                        bl3 = i == 0;
                        teXObject2 = (TeXObject)teXObjectList.get(++i);
                        while (teXObject2 instanceof Ignoreable) {
                            teXObject2 = (TeXObject)teXObjectList.get(++i);
                        }
                        string5 = "";
                        string6 = "";
                        if (teXObject2 instanceof CharObject) {
                            int n = ((CharObject)teXObject2).getCharCode();
                            if (n == 42 || n == 43 || n == this.bib2gls.getAltModifier()) {
                                string5 = teXObject2.toString(teXParser);
                                teXObject2 = (TeXObject)teXObjectList.get(++i);
                                while (teXObject2 instanceof Ignoreable) {
                                    teXObject2 = (TeXObject)teXObjectList.get(++i);
                                }
                                if (teXObject2 instanceof CharObject) {
                                    n = ((CharObject)teXObject2).getCharCode();
                                }
                            }
                            if (n == 91) {
                                string6 = "[";
                                while (i < teXObjectList.size()) {
                                    teXObject2 = (TeXObject)teXObjectList.get(i);
                                    string6 = string6 + teXObject2.toString(teXParser);
                                    if (teXObject2 instanceof CharObject && ((CharObject)teXObject2).getCharCode() == 93) {
                                        teXObject2 = (TeXObject)teXObjectList.get(++i);
                                        break;
                                    }
                                    ++i;
                                }
                                while (teXObject2 instanceof Ignoreable) {
                                    teXObject2 = (TeXObject)teXObjectList.get(++i);
                                }
                            }
                        }
                        int n = i;
                        if (teXObject2 instanceof BgChar) {
                            object = "";
                            while (!((teXObject2 = (TeXObject)teXObjectList.get(++i)) instanceof EgChar)) {
                                object = (String)object + teXObject2.toString(teXParser);
                            }
                        } else {
                            object = teXObject2 instanceof Group ? ((Group)teXObject2).toList().toString(teXParser) : teXObject2.toString(teXParser);
                        }
                        if (bl4) {
                            if (this.bib2gls.isVerbose()) {
                                this.bib2gls.logMessage(this.bib2gls.getMessage("message.compoundcrossref.found", this.getId(), teXObject.toString(teXParser), object));
                            }
                            if ((object2 = this.bib2gls.getCompoundEntry((String)object)) == null) {
                                this.bib2gls.warningMessage("warning.unknown_compound_label.in_entry", this.getId());
                            } else {
                                for (String string7 : ((CompoundEntry)object2).getElements()) {
                                    this.addParsedDependency(string7, string2, glsLike, bl4);
                                }
                            }
                            this.bib2gls.addMglsRef((String)object);
                        } else {
                            if (string3 != null && !string3.isEmpty()) {
                                object2 = object;
                                String string8 = this.resource.getLabelPrefix();
                                if (string8 == null || string8.isEmpty() || !string3.startsWith(string8)) {
                                    object2 = this.processLabel((String)object, true);
                                    if (((String)object2).startsWith(string3)) {
                                        object2 = ((String)object2).substring(string3.length());
                                    }
                                    if (!((String)object).equals(object2)) {
                                        while (i > n) {
                                            teXObjectList.remove(i);
                                            --i;
                                        }
                                        teXObjectList.set(i, (Object)teXParser.getListener().createGroup((String)object2));
                                    }
                                }
                                object = string3 + (String)object2;
                            } else {
                                object2 = this.processLabel((String)object, true);
                                if (!((String)object).equals(object2)) {
                                    object = object2;
                                    while (i > n) {
                                        teXObjectList.remove(i);
                                        --i;
                                    }
                                    teXObjectList.set(i, (Object)teXParser.getListener().createGroup((String)object));
                                }
                            }
                            if (this.bib2gls.isVerbose()) {
                                this.bib2gls.logMessage(this.bib2gls.getMessage("message.crossref.found", this.getId(), teXObject.toString(teXParser), object));
                            }
                            this.addParsedDependency((String)object, string2, glsLike, bl4);
                        }
                        if (this.bib2gls.checkNestedLinkTextField(string) && !string4.equals("glsps") && !string4.equals("glspt")) {
                            if (string4.equals("glsadd")) {
                                this.bib2gls.warning(teXParser, this.bib2gls.getMessage("warning.glsadd.in.field", this.getId(), string, object));
                            } else {
                                this.bib2gls.warning(teXParser, this.bib2gls.getMessage("warning.potential.nested.link", this.getId(), string, String.format("\\%s%s%s", ((TeXCsRef)teXObject).getName(), string5, string6), object));
                            }
                        }
                    } else if (this.isCsProblematic(string4)) {
                        bl3 = i == 0;
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    this.bib2gls.warning(teXParser, this.bib2gls.getMessage("warning.can.find.arg", string4));
                }
                if (!bl3 || !bl) continue;
                this.bib2gls.verbose(teXParser, this.bib2gls.getMessage("message.uc.protecting", teXObject.toString(teXParser)));
                teXObjectList.add(0, (TeXObject)teXParser.getListener().createGroup());
                ++i;
                continue;
            }
            if (!(teXObject instanceof TeXObjectList)) continue;
            if (teXObject instanceof MathGroup && i == 0 && bl && this.bib2gls.mfirstucMathShiftProtection()) {
                this.bib2gls.verbose(teXParser, this.bib2gls.getMessage("message.uc.protecting", teXObject.toString(teXParser)));
                teXObjectList.add(0, (TeXObject)teXParser.getListener().createGroup());
                ++i;
            }
            this.checkGlsCs((TeXObjectList)teXObject, false, string);
        }
    }

    protected boolean fieldsParsed() {
        return this.fieldsParsed;
    }

    public boolean checkField(String string) throws BibTeXSyntaxException {
        if (this.bib2gls.isCheckNonBibFieldsOn() && this.bib2gls.isNonBibField(string)) {
            this.bib2gls.warningMessage("warning.non_bib_field", string, this.base == null ? "" : this.base, this.getOriginalId());
        }
        return true;
    }

    public void parseFields() throws Bib2GlsException, IOException {
        BibValueList bibValueList;
        Object object;
        Object object2;
        BibValueList bibValueList2;
        Object object3;
        BibValueList bibValueList3;
        String string7;
        BibValueList bibValueList4;
        BibValueList bibValueList5;
        BibValueList bibValueList6;
        BibValueList bibValueList7;
        BibValueList bibValueList8;
        Object object42;
        int n;
        String string2;
        int n2;
        BibValueList bibValueList9;
        BibValueList bibValueList10;
        String string3;
        Object object5;
        TeXParser teXParser = this.resource.getBibParser();
        if (this.fieldsParsed) {
            return;
        }
        if (this.bib2gls.isDebuggingOn()) {
            this.bib2gls.logMessage(this.bib2gls.getMessage("message.parsing.fields", this.getId()));
        }
        this.fieldsParsed = true;
        if (this.resource.hasFieldAliases()) {
            if (this.bib2gls.isVerbose()) {
                this.bib2gls.logMessage(this.bib2gls.getMessage("message.field.alias.check", this.getOriginalId()));
            }
            object5 = this.resource.getFieldAliasesIterator();
            while (object5.hasNext()) {
                String string4 = (String)object5.next();
                string3 = this.resource.getFieldAlias(string4);
                bibValueList10 = this.removeField(string4);
                if (bibValueList10 == null) continue;
                bibValueList9 = bibValueList10.expand(teXParser);
                BibUserString bibUserString = new BibUserString((TeXObject)bibValueList9);
                bibValueList10.clear();
                bibValueList10.add((Object)bibUserString);
                this.putField(string3, bibValueList10);
                if (!this.bib2gls.isVerbose()) continue;
                this.bib2gls.logMessage(string4 + "=>" + string3 + "={" + bibValueList9.toString(teXParser) + "}");
            }
        }
        if ((object5 = this.resource.getSaveOriginalIdField()) != null && this.bib2gls.isKnownField((String)object5) && ((n2 = this.resource.getSaveOriginalIdAction()) == 0 || n2 == 1 && this.getField((String)object5) == null || !this.getId().equals(this.getOriginalId()) && (n2 == 2 || n2 == 3 && this.getField((String)object5) == null))) {
            string3 = new BibUserString((TeXObject)teXParser.getListener().createString(this.getOriginalId()));
            bibValueList10 = new BibValueList();
            bibValueList10.add((Object)string3);
            this.putField((String)object5, bibValueList10);
            this.putField((String)object5, this.getOriginalId());
        }
        if ((string2 = this.resource.getSaveOriginalEntryTypeField()) != null && this.bib2gls.isKnownField(string2) && ((n = this.resource.getSaveOriginalEntryTypeAction()) == 0 || n == 1 && this.getField(string2) == null || !this.getEntryType().equals(this.getOriginalEntryType()) && (n == 2 || n == 3 && this.getField(string2) == null))) {
            bibValueList10 = new BibUserString((TeXObject)teXParser.getListener().createString(this.getOriginalEntryType()));
            bibValueList9 = new BibValueList();
            bibValueList9.add((Object)bibValueList10);
            this.putField(string2, bibValueList9);
            this.putField(string2, this.getOriginalEntryType());
        }
        Vector<String> vector = this.bib2gls.getFields();
        if (this.resource.hasSkippedFields()) {
            for (Object object42 : bibValueList10 = this.resource.getSkipFields()) {
                this.removeField((String)object42);
            }
        }
        if (this.resource.isCreateMissingParentsEnabled()) {
            this.orgParentValue = this.getField("parent");
            if (this.orgParentValue != null) {
                bibValueList10 = this.orgParentValue.expand(teXParser);
                this.orgParentValue = new BibValueList();
                this.orgParentValue.add((Object)new BibUserString((TeXObject)((TeXObjectList)bibValueList10.clone())));
            }
        }
        boolean bl = this.bib2gls.mfirstucProtection();
        bibValueList9 = this.bib2gls.mfirstucProtectionFields();
        if (this.resource.changeShortCase() && (bibValueList8 = this.getField("short")) != null) {
            TeXObjectList teXObjectList = bibValueList8.expand(teXParser);
            this.putField("short", this.resource.applyShortCaseChange(bibValueList8));
        }
        if (this.resource.changeLongCase() && (bibValueList7 = this.getField("long")) != null) {
            TeXObjectList teXObjectList = bibValueList7.expand(teXParser);
            this.putField("long", this.resource.applyLongCaseChange(bibValueList7));
        }
        if (this.resource.changeDescriptionCase() && (bibValueList6 = this.getField("description")) != null) {
            this.putField("description", this.resource.applyDescriptionCaseChange(bibValueList6));
        }
        if (this.resource.changeDualShortCase() && (bibValueList5 = this.getField("dualshort")) != null) {
            this.putField("dualshort", this.resource.applyShortCaseChange(bibValueList5));
        }
        if (this.resource.changeDualLongCase() && (bibValueList4 = this.getField("duallong")) != null) {
            this.putField("duallong", this.resource.applyLongCaseChange(bibValueList4));
        }
        String string5 = this.resource.getShortPluralSuffix();
        String string6 = this.resource.getDualShortPluralSuffix();
        this.appendShortPluralSuffix("short", "shortplural", string5);
        this.appendShortPluralSuffix("dualshort", "dualshortplural", string6);
        this.applyFieldReplication();
        object42 = this.resource.getGroupField();
        if (object42 != null) {
            this.putField("group", (String)object42);
        }
        Vector<String> vector2 = null;
        for (String string7 : vector) {
            vector2 = this.processField(string7, bl, (String[])bibValueList9, (String)object5, vector2);
        }
        vector2 = this.processSpecialFields(bl, (String[])bibValueList9, (String)object5, vector2);
        vector2 = this.applyFieldAssignments(bl, (String[])bibValueList9, (String)object5, vector2);
        CompoundEntry compoundEntry = this.resource.getCompoundAdjustName(this.getId());
        if (compoundEntry != null) {
            this.compoundAdjustName(compoundEntry);
        }
        if (this.resource.changeNameCase()) {
            this.changeNameCase();
        }
        if (this.resource.isCopyAliasToSeeEnabled() && (string7 = this.getField("alias")) != null) {
            bibValueList3 = this.getField("see");
            if (bibValueList3 == null) {
                this.putField("see", (BibValueList)string7);
            } else {
                object3 = bibValueList3.expand(teXParser);
                object3.add((TeXObject)teXParser.getListener().getOther(44));
                object3.addAll((Collection)string7.expand(teXParser));
            }
        }
        this.changeFieldCase();
        if (vector2 != null) {
            byte by = this.resource.getInterpretFieldAction();
            bibValueList3 = vector2.iterator();
            while (bibValueList3.hasNext()) {
                object3 = (String)bibValueList3.next();
                BibValueList bibValueList11 = this.getField((String)object3);
                bibValueList2 = bibValueList11.expand(teXParser);
                object2 = bibValueList2.toString(teXParser);
                if (((String)object2).equals(object = this.bib2gls.replaceSpecialChars(this.bib2gls.interpret((String)object2, bibValueList11, this.bib2gls.isTrimFieldOn((String)object3)))) || ((String)object).isEmpty() && by != 0) continue;
                bibValueList2.clear();
                bibValueList2.addAll((Collection)teXParser.getListener().createString((String)object));
                bibValueList11.clear();
                bibValueList11.add((Object)new BibUserString((TeXObject)bibValueList2));
                this.putField((String)object3, (String)object);
            }
        }
        if ((bibValueList = this.resource.getHexUnicodeFields()) != null) {
            bibValueList3 = bibValueList;
            int n3 = ((String[])bibValueList3).length;
            for (int i = 0; i < n3; ++i) {
                bibValueList2 = bibValueList3[i];
                object2 = this.getField((String)bibValueList2);
                if (object2 == null || !this.convertUnicodeCharToHex((TeXObjectList)(object = object2.expand(teXParser)))) continue;
                this.putField((String)bibValueList2, object.toString(teXParser));
            }
        }
        if ((bibValueList3 = this.getField("nonumberlist")) != null) {
            object3 = bibValueList3.expand(teXParser);
            String string8 = object3.toString(teXParser);
            if (string8.equals("true")) {
                this.nonumberlist = true;
            } else if (string8.equals("false")) {
                this.nonumberlist = false;
            } else {
                throw new TeXSyntaxException(teXParser, "error.invalid.choice.value", new Object[]{string8, "true, false"});
            }
        }
    }

    private void applyFieldReplication() throws IOException {
        String string = this.resource.getShortPluralSuffix();
        String string2 = this.resource.getDualShortPluralSuffix();
        if (this.resource.hasFieldCopies()) {
            boolean bl = this.resource.isReplicateOverrideOn();
            MissingFieldAction missingFieldAction = this.resource.getFallbackOnMissingReplicateAction();
            boolean bl2 = false;
            boolean bl3 = false;
            Iterator<String> iterator = this.resource.getFieldCopiesIterator();
            while (iterator.hasNext()) {
                String string3 = iterator.next();
                BibValueList bibValueList = this.getField(string3);
                if (bibValueList == null) {
                    if (missingFieldAction == MissingFieldAction.FALLBACK) {
                        bibValueList = this.getFallbackContents(string3);
                    } else if (missingFieldAction == MissingFieldAction.EMPTY) {
                        bibValueList = new BibValueList();
                    }
                }
                if (bibValueList == null) continue;
                Vector<String> vector = this.resource.getFieldCopy(string3);
                for (String string4 : vector) {
                    if (!bl && this.getField(string4) != null) continue;
                    BibValueList bibValueList2 = (BibValueList)bibValueList.clone();
                    if (string4.equals("description") && this.resource.changeDescriptionCase()) {
                        bibValueList2 = this.resource.applyDescriptionCaseChange(bibValueList2);
                    } else if (string4.equals("short")) {
                        if (this.resource.changeShortCase()) {
                            bibValueList2 = this.resource.applyShortCaseChange(bibValueList2);
                        }
                        if (string != null) {
                            bl2 = true;
                        }
                    } else if (string4.equals("long")) {
                        if (this.resource.changeLongCase()) {
                            bibValueList2 = this.resource.applyLongCaseChange(bibValueList2);
                        }
                    } else if (string4.equals("dualshort")) {
                        if (this.resource.changeDualShortCase()) {
                            bibValueList2 = this.resource.applyShortCaseChange(bibValueList2);
                        }
                        if (string2 != null) {
                            bl3 = true;
                        }
                    } else if (string4.equals("duallong") && this.resource.changeDualLongCase()) {
                        bibValueList2 = this.resource.applyLongCaseChange(bibValueList2);
                    }
                    this.putField(string4, bibValueList2);
                }
            }
            if (bl2) {
                this.appendShortPluralSuffix("short", "shortplural", string);
            }
            if (bl3) {
                this.appendShortPluralSuffix("dualshort", "dualshortplural", string2);
            }
        }
    }

    private Vector<String> applyFieldAssignments(boolean bl, String[] stringArray, String string, Vector<String> vector) throws Bib2GlsException, IOException {
        String string2 = this.resource.getShortPluralSuffix();
        String string3 = this.resource.getDualShortPluralSuffix();
        Vector<FieldAssignment> vector2 = this.resource.getFieldAssignments();
        if (vector2 != null) {
            boolean bl2 = false;
            boolean bl3 = false;
            for (FieldAssignment fieldAssignment : vector2) {
                BibValue bibValue;
                boolean bl4 = fieldAssignment.isFieldOverrideOn(this.resource);
                String string4 = fieldAssignment.getDestinationField();
                if (!bl4 && this.getField(string4) != null) continue;
                if (this.bib2gls.isDebuggingOn()) {
                    this.bib2gls.logAndPrintMessage("Entry " + this.getId() + " evaluating assignment " + fieldAssignment);
                }
                if ((bibValue = fieldAssignment.getValue(this)) != null) {
                    BibValueList bibValueList;
                    BibValue bibValue2;
                    if (this.bib2gls.isDebuggingOn()) {
                        this.bib2gls.logAndPrintMessage("Value: " + bibValue);
                    }
                    if ((bibValue2 = (BibValue)bibValue.clone()) instanceof BibValueList) {
                        bibValueList = (BibValueList)bibValue2;
                    } else {
                        bibValueList = new BibValueList();
                        bibValueList.add((Object)bibValue2);
                    }
                    if (string4.equals("description") && this.resource.changeDescriptionCase()) {
                        bibValueList = this.resource.applyDescriptionCaseChange(bibValueList);
                    } else if (string4.equals("short")) {
                        if (this.resource.changeShortCase()) {
                            bibValueList = this.resource.applyShortCaseChange(bibValueList);
                        }
                        if (string2 != null) {
                            bl2 = true;
                        }
                    } else if (string4.equals("long")) {
                        if (this.resource.changeLongCase()) {
                            bibValueList = this.resource.applyLongCaseChange(bibValueList);
                        }
                    } else if (string4.equals("dualshort")) {
                        if (this.resource.changeDualShortCase()) {
                            bibValueList = this.resource.applyShortCaseChange(bibValueList);
                        }
                        if (string3 != null) {
                            bl3 = true;
                        }
                    } else if (string4.equals("duallong") && this.resource.changeDualLongCase()) {
                        bibValueList = this.resource.applyLongCaseChange(bibValueList);
                    }
                    this.putField(string4, bibValueList);
                    if (this.bib2gls.isDebuggingOn()) {
                        TeXParser teXParser = this.resource.getBibParser();
                        this.bib2gls.logAndPrintMessage("Setting " + string4 + "=" + bibValueList.expand(teXParser).toString(teXParser));
                    }
                    vector = this.processField(string4, bl, stringArray, string, vector);
                    continue;
                }
                if (!this.bib2gls.isDebuggingOn()) continue;
                this.bib2gls.logAndPrintMessage(String.format("Value for field '%s' can't be obtained", string4));
            }
        }
        return vector;
    }

    private boolean convertUnicodeCharToHex(TeXObjectList teXObjectList) {
        TeXParser teXParser = this.resource.getBibParser();
        boolean bl = false;
        for (int i = 0; i < teXObjectList.size(); ++i) {
            TeXObject teXObject = (TeXObject)teXObjectList.get(i);
            if (teXObject instanceof TeXObjectList) {
                if (!this.convertUnicodeCharToHex((TeXObjectList)teXObject)) continue;
                bl = true;
                continue;
            }
            if (!(teXObject instanceof CharObject)) continue;
            TeXObjectList teXObjectList2 = new TeXObjectList();
            teXObjectList2.add((TeXObject)new TeXCsRef("bibglshexunicodechar"));
            teXObjectList2.add((TeXObject)teXParser.getListener().createGroup(String.format("%X", ((CharObject)teXObject).getCharCode())));
            teXObjectList.set(i, (Object)teXObjectList2);
            bl = true;
        }
        return bl;
    }

    protected Vector<String> processSpecialFields(boolean bl, String[] stringArray, String string, Vector<String> vector) throws IOException {
        String string2 = this.resource.getDefinitionIndexField();
        if (string2 != null) {
            vector = this.processField(string2, bl, stringArray, string, vector);
        }
        return vector;
    }

    /*
     * WARNING - void declaration
     */
    protected Vector<String> processField(String string, boolean bl, String[] stringArray, String string2, Vector<String> vector) throws IOException {
        boolean bl2;
        String string3;
        BibUserString bibUserString;
        TeXParser teXParser = this.resource.getBibParser();
        BibValueList bibValueList = this.getField(string);
        if (bibValueList == null || string.equals(string2)) {
            return vector;
        }
        TeXObjectList teXObjectList = bibValueList.expand(teXParser);
        if (this.bib2gls.isDebuggingOn()) {
            this.bib2gls.debug(String.format(">> %s={%s}", string, teXObjectList.toString(teXParser)));
        }
        if (bibValueList.size() > 1 || !(bibValueList.firstElement() instanceof BibUserString)) {
            bibUserString = new BibUserString((TeXObject)teXObjectList);
            bibValueList.clear();
            bibValueList.add((Object)bibUserString);
        }
        if (this.resource.isBibTeXAuthorField(string)) {
            teXObjectList = this.convertBibTeXAuthorField(string, bibValueList);
            bibValueList.clear();
            bibValueList.add((Object)new BibUserString((TeXObject)teXObjectList));
        }
        if ((bibUserString = this.resource.getAppendPrefixFieldObject(string, teXObjectList)) != null) {
            teXObjectList.add((TeXObject)bibUserString);
            bibValueList.clear();
            bibValueList.add((Object)new BibUserString((TeXObject)teXObjectList));
        }
        String string4 = this.resource.getIntegerFieldFormat(string);
        String string5 = this.resource.getDecimalFieldFormat(string);
        if (string4 != null) {
            block45: {
                string3 = null;
                if (teXObjectList.size() == 1 && teXObjectList.firstElement() instanceof TeXNumber) {
                    int bl3 = ((TeXNumber)teXObjectList.firstElement()).getValue();
                    string3 = String.format(string4, bl3);
                } else {
                    String string6 = teXObjectList.toString(teXParser);
                    try {
                        int numberFormatException = Integer.parseInt(string6);
                        string3 = String.format(string4, numberFormatException);
                    }
                    catch (NumberFormatException d) {
                        if (string5 == null) break block45;
                        try {
                            double d2 = Double.parseDouble(string6);
                            string3 = String.format(string5, d2);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                }
            }
            if (string3 != null) {
                teXObjectList = teXParser.getListener().createString(string3);
                bibValueList.clear();
                bibValueList.add((Object)new BibUserString((TeXObject)teXObjectList));
            }
        } else if (string5 != null) {
            string3 = null;
            if (teXObjectList.size() == 1 && teXObjectList.firstElement() instanceof TeXNumber) {
                double d = ((TeXNumber)teXObjectList.firstElement()).getValue();
                string3 = String.format(string5, d);
            } else {
                String string7 = teXObjectList.toString(teXParser);
                try {
                    double numberFormatException = Double.parseDouble(string7);
                    string3 = String.format(string5, numberFormatException);
                }
                catch (NumberFormatException string8) {
                    // empty catch block
                }
            }
            if (string3 != null) {
                teXObjectList = teXParser.getListener().createString(string3);
                bibValueList.clear();
                bibValueList.add((Object)new BibUserString((TeXObject)teXObjectList));
            }
        }
        string3 = this.resource.getFieldEncap(string);
        if (string3 != null) {
            Group group = teXParser.getListener().createGroup();
            group.addAll((Collection)teXObjectList);
            teXObjectList.clear();
            teXObjectList.add((TeXObject)new TeXCsRef(string3));
            teXObjectList.add((TeXObject)group);
            bibValueList.clear();
            bibValueList.add((Object)new BibUserString((TeXObject)teXObjectList));
        }
        if ((string3 = this.resource.getFieldEncapIncLabel(string)) != null) {
            Group group = teXParser.getListener().createGroup();
            group.addAll((Collection)teXObjectList);
            teXObjectList.clear();
            teXObjectList.add((TeXObject)new TeXCsRef(string3));
            teXObjectList.add((TeXObject)group);
            teXObjectList.add((TeXObject)teXParser.getListener().createGroup(this.getId()));
            bibValueList.clear();
            bibValueList.add((Object)new BibUserString((TeXObject)teXObjectList));
        }
        if (this.resource.isInterpretField(string)) {
            if (vector == null) {
                vector = new Vector();
            }
            vector.add(string);
        }
        if ((bl2 = this.resource.isLabelifyListField(string)) || this.resource.isLabelifyField(string)) {
            String string9 = this.bib2gls.convertToLabel(teXParser, bibValueList, this.resource, bl2);
            teXObjectList = teXParser.getListener().createString(string9);
            bibValueList.clear();
            bibValueList.add((Object)new BibUserString((TeXObject)teXObjectList));
            this.putField(string, string9);
        }
        if (this.resource.isDependencyListField(string)) {
            this.parseCustomDependencyList(teXObjectList, string);
        }
        if (string.equals("parent") || string.equals("category") || string.equals("type") || string.equals("group") || string.equals("seealso") || string.equals("alias")) {
            void var14_27;
            String string6 = teXObjectList.toString(teXParser);
            if (this.resource.isInterpretLabelFieldsEnabled() && string6.matches("(?s).*[\\\\\\{\\}].*")) {
                String string7 = this.bib2gls.interpret(string6, bibValueList, true);
            }
            if (string.equals("parent")) {
                this.putField(string, this.processLabel((String)var14_27));
            } else {
                this.putField(string, (String)var14_27);
            }
        } else {
            CharObject charObject;
            boolean bl3;
            String string8;
            int n;
            boolean bl4 = bl;
            if (bl4 && stringArray != null) {
                boolean bl5 = false;
                String[] stringArray2 = stringArray;
                n = stringArray2.length;
                for (int i = 0; i < n; ++i) {
                    string8 = stringArray2[i];
                    if (!string8.equals(string)) continue;
                    bl3 = true;
                    break;
                }
            }
            this.checkGlsCs(teXObjectList, bl3, string);
            if (string.equals("description")) {
                if (this.resource.isStripTrailingNoPostOn()) {
                    int n2 = teXObjectList.size();
                    for (n = n2 - 1; n >= 0; --n) {
                        TeXObject teXObject = (TeXObject)teXObjectList.get(n);
                        if (!(teXObject instanceof Ignoreable)) {
                            if (!(teXObject instanceof ControlSequence) || !(string8 = ((ControlSequence)teXObject).getName()).equals("nopostdesc") && !string8.equals("glsxtrnopostpunc")) break;
                            teXObjectList.remove(n);
                            break;
                        }
                        teXObjectList.remove(n);
                    }
                }
                block3 : switch (this.resource.getPostDescDot()) {
                    case 1: {
                        teXObjectList.add((TeXObject)teXParser.getListener().getOther(46));
                        break;
                    }
                    case 2: {
                        int n3 = teXObjectList.size();
                        for (n = n3 - 1; n >= 0; --n) {
                            TeXObject teXObject = (TeXObject)teXObjectList.get(n);
                            if (teXObject instanceof CharObject) {
                                int n4 = ((CharObject)teXObject).getCharCode();
                                int n5 = Character.getType(n4);
                                if (n5 == 22 || n5 == 30) continue;
                                if (n5 == 24) break block3;
                                teXObjectList.add((TeXObject)teXParser.getListener().getOther(46));
                                break block3;
                            }
                            if (teXObject instanceof ControlSequence && (((ControlSequence)teXObject).getName().equals("nopostdesc") || ((ControlSequence)teXObject).getName().equals("glsxtrnopostpunc"))) break block3;
                            if (teXObject instanceof Ignoreable) continue;
                            teXObjectList.add((TeXObject)teXParser.getListener().getOther(46));
                            break block3;
                        }
                        break;
                    }
                }
            }
            if (this.resource.isCheckEndPuncOn(string) && (charObject = this.getEndPunc(teXObjectList)) != null) {
                this.putField(string + "endpunc", charObject.toString(teXParser));
            }
            this.putField(string, teXObjectList.toString(teXParser));
        }
        if (this.bib2gls.isDebuggingOn()) {
            this.bib2gls.debug(String.format("=>> %s={%s}", string, this.getFieldValue(string)));
        }
        return vector;
    }

    protected void appendShortPluralSuffix(String string, String string2, String string3) throws IOException {
        TeXParser teXParser = this.resource.getBibParser();
        if (string3 == null || string3.isEmpty()) {
            return;
        }
        BibValueList bibValueList = this.getField(string2);
        if (bibValueList != null) {
            return;
        }
        bibValueList = this.getField(string);
        if (bibValueList == null) {
            return;
        }
        TeXObjectList teXObjectList = (TeXObjectList)bibValueList.getContents(true);
        BibValueList bibValueList2 = new BibValueList();
        if (teXObjectList != null) {
            bibValueList2.add((Object)new BibUserString((TeXObject)teXObjectList));
        }
        bibValueList2.add((Object)new BibUserString((TeXObject)teXParser.getListener().createString(string3)));
        this.putField(string2, bibValueList2);
    }

    protected boolean changeNameAlsoCopyToText(boolean bl) {
        return true;
    }

    protected void changeNameCase() throws IOException {
        BibValueList bibValueList;
        TeXParser teXParser = this.resource.getBibParser();
        BibValueList bibValueList2 = this.getField("name");
        boolean bl = true;
        if (bibValueList2 == null) {
            bl = false;
            bibValueList2 = this.getFallbackContents("name");
            if (bibValueList2 == null) {
                return;
            }
            bibValueList2 = (BibValueList)bibValueList2.clone();
        }
        if (this.changeNameAlsoCopyToText(bl) && (bibValueList = this.getField("text")) == null) {
            this.putField("text", bibValueList2);
            this.putField("text", bibValueList2.expand(teXParser).toString(teXParser));
        }
        bibValueList2 = this.resource.applyNameCaseChange(bibValueList2);
        bibValueList = BibValueList.stripDelim((TeXObjectList)bibValueList2.expand(teXParser));
        this.putField("name", bibValueList2);
        this.putField("name", bibValueList.toString(teXParser));
    }

    protected void compoundAdjustName(CompoundEntry compoundEntry) throws IOException {
        BibValueList bibValueList;
        TeXParser teXParser = this.resource.getBibParser();
        TeXParserListener teXParserListener = teXParser.getListener();
        BibValueList bibValueList2 = this.getField("name");
        boolean bl = true;
        if (bibValueList2 == null) {
            bl = false;
            bibValueList2 = this.getFallbackContents("name");
            if (bibValueList2 == null) {
                return;
            }
            bibValueList2 = (BibValueList)bibValueList2.clone();
        }
        if (this.changeNameAlsoCopyToText(bl) && (bibValueList = this.getField("text")) == null) {
            this.putField("text", bibValueList2);
            this.putField("text", bibValueList2.expand(teXParser).toString(teXParser));
        }
        bibValueList = new BibValueList();
        TeXObjectList teXObjectList = new TeXObjectList();
        Group group = teXParserListener.createGroup();
        Group group2 = teXParserListener.createGroup();
        Group group3 = teXParserListener.createGroup();
        teXObjectList.add((TeXObject)new TeXCsRef("glsxtrmultientryadjustedname"));
        teXObjectList.add((TeXObject)group);
        teXObjectList.add((TeXObject)group2);
        teXObjectList.add((TeXObject)group3);
        teXObjectList.add((TeXObject)teXParserListener.createGroup(compoundEntry.getLabel()));
        TeXObjectList teXObjectList2 = BibValueList.stripDelim((TeXObjectList)bibValueList2.expand(teXParser));
        group2.addAll((Collection)teXObjectList2);
        Group group4 = group;
        String string = this.getId();
        String string2 = "";
        for (String string3 : compoundEntry.getElements()) {
            if (compoundEntry.getMainLabel().equals(string3)) {
                group4 = group3;
                string2 = "";
                continue;
            }
            group4.addAll((Collection)teXParserListener.createString(string2 + string3));
            string2 = ",";
        }
        BibUserString bibUserString = new BibUserString((TeXObject)teXObjectList);
        bibValueList.add((Object)bibUserString);
        this.putField("name", bibValueList);
        this.putField("name", teXObjectList.toString(teXParser));
    }

    protected void changeFieldCase() throws IOException {
        HashMap<String, String> hashMap = this.resource.getFieldCaseOptions();
        if (hashMap == null) {
            return;
        }
        for (String string : hashMap.keySet()) {
            String string2 = hashMap.get(string);
            if (string2.equals("none")) continue;
            this.changeFieldCase(string, string2);
        }
    }

    protected void changeFieldCase(String string, String string2) throws IOException {
        TeXParser teXParser = this.resource.getBibParser();
        BibValueList bibValueList = this.getField(string);
        if (bibValueList == null) {
            bibValueList = this.getFallbackContents(string);
            if (bibValueList == null) {
                return;
            }
            bibValueList = (BibValueList)bibValueList.clone();
        }
        bibValueList = this.resource.applyCaseChange(bibValueList, string2);
        TeXObjectList teXObjectList = BibValueList.stripDelim((TeXObjectList)bibValueList.expand(teXParser));
        this.putField(string, bibValueList);
        this.putField(string, teXObjectList.toString(teXParser));
    }

    public void convertFieldToDateTime(String string, String string2, Locale locale, boolean bl, boolean bl2) throws IOException {
        Group group;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        Date date;
        TeXParser teXParser = this.resource.getBibParser();
        String string3 = this.getId();
        this.bib2gls.debugMessage("message.datetime.field.check", string3, string, bl, bl2);
        BibValueList bibValueList = this.getField(string);
        if (bibValueList == null) {
            this.bib2gls.debugMessage("message.field.notset", string, string3);
            return;
        }
        String string4 = this.getFieldValue(string);
        TeXObjectList teXObjectList = (TeXObjectList)bibValueList.expand(teXParser).clone();
        String string5 = string4;
        if (this.bib2gls.useInterpreter() && string4.matches("(?s).*[\\\\\\$\\{\\}\\~].*")) {
            string4 = this.bib2gls.interpret(string4, bibValueList, true);
        }
        DateFormat dateFormat = SortSettings.getDateFormat(locale, string2, bl, bl2);
        try {
            date = dateFormat.parse(string4);
        }
        catch (ParseException parseException) {
            if (dateFormat instanceof SimpleDateFormat) {
                this.bib2gls.warningMessage("warning.cant.parse.datetime.pattern", string, string3, ((SimpleDateFormat)dateFormat).toPattern());
            } else {
                this.bib2gls.warningMessage("warning.cant.parse.datetime.pattern", string, string3, string2);
            }
            this.bib2gls.debug(parseException);
            return;
        }
        Calendar calendar = locale == null ? Calendar.getInstance() : Calendar.getInstance(locale);
        calendar.setTime(date);
        TeXObjectList teXObjectList2 = new TeXObjectList();
        TeXParserListener teXParserListener = teXParser.getListener();
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            if (bl2) {
                teXObjectList2.add((TeXObject)new TeXCsRef("bibglsdatetime"));
                stringBuilder.append("\\bibglsdatetime");
            } else {
                teXObjectList2.add((TeXObject)new TeXCsRef("bibglsdate"));
                stringBuilder.append("\\bibglsdate");
            }
            n6 = calendar.get(1);
            n5 = calendar.get(2) + 1;
            n4 = calendar.get(5);
            n3 = calendar.get(7);
            n2 = calendar.get(6);
            n = calendar.get(0);
            switch (n3) {
                case 2: {
                    n3 = 0;
                    break;
                }
                case 3: {
                    n3 = 1;
                    break;
                }
                case 4: {
                    n3 = 2;
                    break;
                }
                case 5: {
                    n3 = 3;
                    break;
                }
                case 6: {
                    n3 = 4;
                    break;
                }
                case 7: {
                    n3 = 5;
                    break;
                }
                case 1: {
                    n3 = 6;
                }
            }
            group = teXParserListener.createGroup();
            teXObjectList2.add((TeXObject)group);
            group.add((TeXObject)new UserNumber(n6));
            group = teXParserListener.createGroup();
            teXObjectList2.add((TeXObject)group);
            group.add((TeXObject)new UserNumber(n5));
            group = teXParserListener.createGroup();
            teXObjectList2.add((TeXObject)group);
            group.add((TeXObject)new UserNumber(n4));
            group = teXParserListener.createGroup();
            teXObjectList2.add((TeXObject)group);
            group.add((TeXObject)new UserNumber(n3));
            group = teXParserListener.createGroup();
            teXObjectList2.add((TeXObject)group);
            group.add((TeXObject)new UserNumber(n2));
            group = teXParserListener.createGroup();
            teXObjectList2.add((TeXObject)group);
            group.add((TeXObject)new UserNumber(n));
            stringBuilder.append(String.format("{%d}{%d}{%d}{%d}{%d}{%d}", n6, n5, n4, n3, n2, n));
        } else {
            teXObjectList2.add((TeXObject)new TeXCsRef("bibglstime"));
            stringBuilder.append("\\bibglstime");
        }
        if (bl2) {
            n6 = calendar.get(11);
            n5 = calendar.get(12);
            n4 = calendar.get(13);
            n3 = calendar.get(14);
            n2 = calendar.get(16);
            n = calendar.get(15);
            group = teXParserListener.createGroup();
            teXObjectList2.add((TeXObject)group);
            group.add((TeXObject)new UserNumber(n6));
            group = teXParserListener.createGroup();
            teXObjectList2.add((TeXObject)group);
            group.add((TeXObject)new UserNumber(n5));
            group = teXParserListener.createGroup();
            teXObjectList2.add((TeXObject)group);
            group.add((TeXObject)new UserNumber(n4));
            group = teXParserListener.createGroup();
            teXObjectList2.add((TeXObject)group);
            group.add((TeXObject)new UserNumber(n3));
            group = teXParserListener.createGroup();
            teXObjectList2.add((TeXObject)group);
            group.add((TeXObject)new UserNumber(n2));
            group = teXParserListener.createGroup();
            teXObjectList2.add((TeXObject)group);
            group.add((TeXObject)new UserNumber(n));
            stringBuilder.append(String.format("{%d}{%d}{%d}{%d}{%d}{%d}", n6, n5, n4, n3, n2, n));
        }
        group = teXParserListener.createGroup();
        group.addAll((Collection)teXObjectList);
        stringBuilder.append(String.format("{%s}", string5));
        bibValueList.clear();
        bibValueList.add((Object)new BibUserString((TeXObject)teXObjectList2));
        this.putField(string, bibValueList);
        this.putField(string, stringBuilder.toString());
    }

    protected TeXObjectList convertBibTeXAuthorField(String string, BibValueList bibValueList) throws IOException {
        TeXParser teXParser = this.resource.getBibParser();
        Vector vector = Bib2GlsEntry.parseContributors((TeXParser)teXParser, (BibValueList)bibValueList);
        int n = vector.size();
        TeXParserListener teXParserListener = teXParser.getListener();
        TeXObjectList teXObjectList = new TeXObjectList();
        teXObjectList.add((TeXObject)new TeXCsRef("bibglscontributorlist"));
        Group group = teXParserListener.createGroup();
        teXObjectList.add((TeXObject)group);
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                group.add((TeXObject)teXParserListener.getOther(44));
            }
            Contributor contributor = (Contributor)vector.get(i);
            String string2 = contributor.getForenames();
            String string3 = contributor.getVonPart();
            String string4 = contributor.getSurname();
            String string5 = contributor.getSuffix();
            group.add((TeXObject)new TeXCsRef("bibglscontributor"));
            if (string2 == null) {
                group.add((TeXObject)teXParserListener.createGroup());
            } else {
                group.add((TeXObject)teXParserListener.createGroup(string2.trim()));
            }
            if (string3 == null) {
                group.add((TeXObject)teXParserListener.createGroup());
            } else {
                group.add((TeXObject)teXParserListener.createGroup(string3.trim()));
            }
            if (string4 == null) {
                group.add((TeXObject)teXParserListener.createGroup());
            } else {
                group.add((TeXObject)teXParserListener.createGroup(string4.trim()));
            }
            if (string5 == null) {
                group.add((TeXObject)teXParserListener.createGroup());
                continue;
            }
            group.add((TeXObject)teXParserListener.createGroup(string5.trim()));
        }
        teXObjectList.add((TeXObject)teXParserListener.createGroup(String.format("%d", n)));
        return teXObjectList;
    }

    protected boolean isSentenceTerminator(int n) {
        int n2;
        String string = this.resource.getLocalisationText("sentence", "terminators");
        for (int i = 0; i < string.length(); i += Character.charCount(n2)) {
            n2 = string.codePointAt(i);
            if (n2 != n) continue;
            return true;
        }
        return false;
    }

    protected CharObject getEndPunc(TeXObjectList teXObjectList) {
        int n = teXObjectList.size();
        for (int i = n - 1; i >= 0; --i) {
            TeXObject teXObject = (TeXObject)teXObjectList.get(i);
            if (teXObject instanceof CharObject) {
                CharObject charObject = (CharObject)teXObject;
                int n2 = charObject.getCharCode();
                int n3 = Character.getType(n2);
                if (n3 == 24) {
                    if (this.isSentenceTerminator(n2)) {
                        return charObject;
                    }
                    return null;
                }
                if (n3 == 30 || n3 == 22) continue;
                return null;
            }
            if (teXObject instanceof TeXObjectList) {
                return this.getEndPunc((TeXObjectList)teXObject);
            }
            if (teXObject instanceof Ignoreable) continue;
            return null;
        }
        return null;
    }

    public String getSortFallbackField() {
        String string = this.resource.getCustomEntryDefaultSortField(this.originalEntryType);
        if (string != null) {
            return string;
        }
        return this.resource.getEntryDefaultSortField();
    }

    public String getPluralFallbackValue() {
        Object object;
        String string = this.fieldValues.get("parent");
        String string2 = null;
        if (string != null && (object = this.resource.getEntry(string)) != null) {
            String string3 = this.getFieldValue("name");
            String string4 = ((Bib2GlsEntry)((Object)object)).getFieldValue("name");
            if (string3 == null || string3.equals(string4)) {
                string2 = ((Bib2GlsEntry)((Object)object)).getFieldValue("plural");
                if (string2 == null) {
                    string2 = ((Bib2GlsEntry)((Object)object)).getFallbackValue("plural");
                    if (string2 != null) {
                        return string2;
                    }
                } else {
                    return string2;
                }
            }
        }
        if ((string2 = this.getFieldValue("text")) == null) {
            string2 = this.getFallbackValue("text");
        }
        if (string2 != null) {
            object = this.resource.getPluralSuffix();
            return object == null ? string2 : string2 + (String)object;
        }
        return null;
    }

    public String getSortFallbackValue() {
        String string = this.getSortFallbackField();
        String string2 = this.resource.getFieldConcatenationSeparator();
        String[] stringArray = string.split("\\s*\\+\\s*");
        String string3 = null;
        for (String string4 : stringArray) {
            if (string3 != null) {
                string3 = string3 + string2;
            }
            if (string4.equals("id")) {
                if (string3 == null) {
                    string3 = this.getId();
                    continue;
                }
                string3 = string3 + this.getId();
                continue;
            }
            if (string4.equals("original id")) {
                if (string3 == null) {
                    string3 = this.getOriginalId();
                    continue;
                }
                string3 = string3 + this.getOriginalId();
                continue;
            }
            String string5 = this.fieldValues.get(string4);
            if (string5 == null) {
                string5 = this.getFallbackValue(string4);
            }
            if (string5 == null) continue;
            string3 = string3 == null ? string5 : string3 + string5;
        }
        return string3;
    }

    public String getFallbackValue(String string) {
        if (string.equals("text")) {
            return this.fieldValues.get("name");
        }
        if (string.equals("name")) {
            String string2 = this.fieldValues.get("parent");
            if (string2 == null) {
                return null;
            }
            Bib2GlsEntry bib2GlsEntry = this.resource.getEntry(string2);
            if (bib2GlsEntry == null) {
                return null;
            }
            String string3 = bib2GlsEntry.getFieldValue("name");
            if (string3 != null) {
                return string3;
            }
            return bib2GlsEntry.getFallbackValue("name");
        }
        if (string.equals("plural")) {
            return this.getPluralFallbackValue();
        }
        if (string.equals("sort")) {
            return this.getSortFallbackValue();
        }
        if (string.equals("first")) {
            String string4 = this.getFieldValue("text");
            if (string4 != null) {
                return string4;
            }
            return this.getFallbackValue("text");
        }
        if (string.equals("firstplural")) {
            String string5 = this.getFieldValue("first");
            if (string5 == null) {
                string5 = this.fieldValues.get("first");
            }
            if (string5 != null) {
                String string6 = this.resource.getPluralSuffix();
                return string6 == null ? string5 : string5 + string6;
            }
            string5 = this.getFieldValue("plural");
            return string5 == null ? this.getFallbackValue("plural") : string5;
        }
        if (string.equals("shortplural")) {
            String string7 = this.getFieldValue("short");
            if (string7 != null) {
                String string8 = this.resource.getShortPluralSuffix();
                return string8 == null ? string7 : string7 + string8;
            }
        } else if (string.equals("longplural")) {
            String string9 = this.getFieldValue("long");
            if (string9 != null) {
                String string10 = this.resource.getPluralSuffix();
                return string10 == null ? string9 : string9 + string10;
            }
        } else {
            if (string.equals("prefixfirst")) {
                String string11 = this.getFieldValue("prefix");
                if (string11 != null) {
                    return string11;
                }
                return this.getFallbackValue("prefix");
            }
            if (string.equals("prefixfirstplural")) {
                String string12 = this.getFieldValue("prefixplural");
                if (string12 != null) {
                    return string12;
                }
                return this.getFallbackValue("prefixplural");
            }
            if (string.equals("dualprefixfirst")) {
                String string13 = this.getFieldValue("dualprefix");
                if (string13 != null) {
                    return string13;
                }
                return this.getFallbackValue("dualprefix");
            }
            if (string.equals("dualprefixfirstplural")) {
                String string14 = this.getFieldValue("dualprefixplural");
                if (string14 != null) {
                    return string14;
                }
                return this.getFallbackValue("dualprefixplural");
            }
        }
        return null;
    }

    public BibValueList getPluralFallbackContents() {
        Bib2GlsEntry bib2GlsEntry;
        String string = this.fieldValues.get("parent");
        BibValueList bibValueList = null;
        if (string != null && (bib2GlsEntry = this.resource.getEntry(string)) != null) {
            BibValueList bibValueList2 = this.getField("name");
            BibValueList bibValueList3 = this.getField("name");
            if (bibValueList2 == null || bibValueList2.equals((Object)bibValueList3)) {
                bibValueList = bib2GlsEntry.getField("plural");
                if (bibValueList == null && (bibValueList = bib2GlsEntry.getFallbackContents("plural")) != null) {
                    return bibValueList;
                }
            } else {
                return bibValueList;
            }
        }
        if ((bibValueList = this.getField("text")) == null) {
            bibValueList = this.getFallbackContents("text");
        }
        return this.plural(bibValueList, "glspluralsuffix");
    }

    public BibValueList getSortFallbackContents() {
        BibValueList bibValueList;
        String string = this.getSortFallbackField();
        TeXObjectList teXObjectList = null;
        String string2 = this.resource.getFieldConcatenationSeparator();
        for (String string3 : bibValueList = string.split("\\+")) {
            BibValueList bibValueList2 = null;
            if (string.equals("original id") || string.equals("id") && this.labelPrefix == null && this.labelSuffix == null) {
                bibValueList2 = this.getIdField();
            } else if (string.equals("id")) {
                bibValueList2 = new BibValueList();
                bibValueList2.add((Object)new BibUserString((TeXObject)this.resource.getBibParserListener().createString(this.getId())));
            } else {
                bibValueList2 = this.getField(string3);
                if (bibValueList2 == null) {
                    bibValueList2 = this.getFallbackContents(string3);
                }
            }
            if (((BibValueList)bibValueList).length == 1) {
                return bibValueList2;
            }
            if (bibValueList2 == null) continue;
            try {
                TeXObjectList teXObjectList2 = ((BibValueList)bibValueList2.clone()).expand(this.resource.getBibParserListener().getParser());
                if (teXObjectList == null) {
                    teXObjectList = teXObjectList2;
                    continue;
                }
                teXObjectList.add((TeXObject)this.resource.getBibParserListener().createString(string2));
                teXObjectList.addAll((Collection)teXObjectList2);
            }
            catch (IOException iOException) {
                this.bib2gls.debug(iOException);
                return bibValueList2;
            }
        }
        if (teXObjectList == null) {
            return null;
        }
        BibValueList bibValueList3 = new BibValueList();
        bibValueList3.add((Object)new BibUserString(teXObjectList));
        return bibValueList3;
    }

    public BibValueList getFallbackContents(String string) {
        if (string.equals("text")) {
            return this.getField("name");
        }
        if (string.equals("name")) {
            String string2 = this.fieldValues.get("parent");
            if (string2 == null) {
                return null;
            }
            Bib2GlsEntry bib2GlsEntry = this.resource.getEntry(string2);
            if (bib2GlsEntry == null) {
                return null;
            }
            BibValueList bibValueList = bib2GlsEntry.getField("name");
            if (bibValueList != null) {
                return bibValueList;
            }
            return bib2GlsEntry.getFallbackContents("name");
        }
        if (string.equals("plural")) {
            return this.getPluralFallbackContents();
        }
        if (string.equals("sort")) {
            return this.getSortFallbackContents();
        }
        if (string.equals("first")) {
            BibValueList bibValueList = this.getField("text");
            return bibValueList == null ? this.getFallbackContents("text") : bibValueList;
        }
        if (string.equals("firstplural")) {
            BibValueList bibValueList = this.getField("first");
            if (bibValueList == null) {
                bibValueList = this.getField("plural");
                return bibValueList == null ? this.getFallbackContents("plural") : bibValueList;
            }
            return this.plural(bibValueList, "glspluralsuffix");
        }
        if (string.equals("longplural")) {
            return this.plural(this.getField("long"), "glspluralsuffix");
        }
        if (string.equals("shortplural")) {
            return this.plural(this.getField("short"), "abbrvpluralsuffix");
        }
        if (string.equals("duallongplural")) {
            return this.plural(this.getField("duallong"), "glspluralsuffix");
        }
        if (string.equals("dualshortplural")) {
            return this.plural(this.getField("dualshort"), "abbrvpluralsuffix");
        }
        if (string.equals("prefixfirst")) {
            BibValueList bibValueList = this.getField("prefix");
            return bibValueList == null ? this.getFallbackContents("prefix") : bibValueList;
        }
        if (string.equals("prefixfirstplural")) {
            BibValueList bibValueList = this.getField("prefixplural");
            return bibValueList == null ? this.getFallbackContents("prefixplural") : bibValueList;
        }
        if (string.equals("dualprefixfirst")) {
            BibValueList bibValueList = this.getField("dualprefix");
            return bibValueList == null ? this.getFallbackContents("dualprefix") : bibValueList;
        }
        if (string.equals("dualprefixfirstplural")) {
            BibValueList bibValueList = this.getField("dualprefixplural");
            return bibValueList == null ? this.getFallbackContents("dualprefixplural") : bibValueList;
        }
        return null;
    }

    protected BibValueList plural(BibValueList bibValueList, String string) {
        if (bibValueList == null) {
            return null;
        }
        bibValueList = (BibValueList)bibValueList.clone();
        bibValueList.add((Object)new BibUserString((TeXObject)new TeXCsRef(string)));
        return bibValueList;
    }

    public void parseContents(TeXParser teXParser, TeXObjectList teXObjectList, TeXObject teXObject) throws IOException {
        super.parseContents(teXParser, teXObjectList, teXObject);
        this.initMissingFields();
    }

    protected void initMissingFields() {
    }

    public void checkRequiredFields() {
        if (this.getField("name") == null && this.getField("parent") == null) {
            this.missingFieldWarning("name");
        }
        if (this.getField("description") == null) {
            this.missingFieldWarning("description");
        }
    }

    protected void missingFieldWarning(String string) {
        this.bib2gls.warningMessage("warning.missing.field", this.getId(), string);
    }

    public String getCsName() {
        return String.format("bibglsnew%s", this.getEntryType());
    }

    public void writeCsDefinition(PrintWriter printWriter) throws IOException {
        printWriter.format("\\providecommand{\\%s}[4]{%%%n", this.getCsName());
        printWriter.print(" \\longnewglossaryentry*{#1}");
        printWriter.println("{name={#3},#2}{#4}%");
        printWriter.println("}");
    }

    public void writeBibEntry(PrintWriter printWriter) throws IOException {
        printWriter.format("\\%s{%s}%%%n{", this.getCsName(), this.getId());
        String string = "";
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = "";
        Set<String> set = this.getFieldSet();
        Vector<String> vector = this.resource.getOmitFieldList(this);
        for (String string6 : set) {
            if (vector != null && vector.contains(string6)) {
                this.bib2gls.verboseMessage("message.omitting.field", string6, this.getId());
                continue;
            }
            String string7 = this.fieldValues.get(string6);
            if (string7 == null) continue;
            if (string6.equals("description")) {
                string = string7;
                continue;
            }
            if (string6.equals("name")) {
                string2 = string7;
                continue;
            }
            if (this.bib2gls.isKnownField(string6)) {
                if (string6.equals("parent")) {
                    string3 = string7;
                } else if (string6.equals("plural")) {
                    string4 = string7;
                }
                printWriter.format("%s", string5);
                string5 = String.format(",%n", new Object[0]);
                printWriter.format("%s={%s}", string6, string7);
                continue;
            }
            if (!this.bib2gls.isDebuggingOn() || this.bib2gls.isInternalField(string6) || this.bib2gls.isKnownSpecialField(string6)) continue;
            this.bib2gls.debugMessage("warning.ignoring.unknown.field", string6);
        }
        if (string2 == null) {
            string2 = this.getFallbackValue("name");
            if (string2 == null) {
                string2 = "";
            }
            this.writePluralIfInherited(printWriter, string2, string3, string4, string5);
        }
        if (string == null) {
            string = "";
        }
        printWriter.println("}%");
        printWriter.println(String.format("{%s}%%", string2));
        printWriter.println(String.format("{%s}", string));
        this.writeInternalFields(printWriter);
    }

    protected void writePluralIfInherited(PrintWriter printWriter, String string, String string2, String string3, String string4) throws IOException {
        Bib2GlsEntry bib2GlsEntry;
        if (string2 != null && string3 == null && (bib2GlsEntry = this.resource.getEntry(string2)) != null) {
            String string5 = bib2GlsEntry.getFieldValue("name");
            if (string5 == null) {
                string5 = bib2GlsEntry.getFallbackValue("name");
            }
            if (string.equals(string5)) {
                string3 = bib2GlsEntry.getFieldValue("plural");
                if (string3 == null) {
                    string3 = bib2GlsEntry.getFallbackValue("plural");
                }
                if (string3 != null) {
                    printWriter.format("%splural={%s}", string4, string3);
                }
            }
        }
    }

    public void writeInternalFields(PrintWriter printWriter) throws IOException {
    }

    public void writeLocList(PrintWriter printWriter) throws IOException {
        if (this.locationList == null || this.nonumberlist) {
            return;
        }
        for (String string : this.locationList) {
            printWriter.println(String.format("\\glsxtrfieldlistadd{%s}{loclist}{%s}", this.getId(), string));
        }
    }

    public void writeExtraFields(PrintWriter printWriter) throws IOException {
        String string;
        if (this.getEntryType().startsWith("spawned") && (string = this.getFieldValue("progenitor")) != null) {
            printWriter.format("\\GlsXtrSetField{%s}{progenitor}{%s}%n", this.getId(), string);
        }
    }

    public void writeIndexCounterField(PrintWriter printWriter) throws IOException {
        if (this.indexCounterRecord == null) {
            return;
        }
        printWriter.format("\\GlsXtrSetField{%s}{%s}{%s}%n", this.getId(), "indexcounter", this.indexCounterRecord.getLocation());
    }

    public Set<String> getFieldSet() {
        return this.fieldValues.keySet();
    }

    public String getFieldValue(String string) {
        return this.fieldValues.get(string);
    }

    public String putField(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("null label not permitted");
        }
        if (string2 == null) {
            throw new NullPointerException("null value not permitted for field " + string);
        }
        if (this.bib2gls.isTrimFieldOn(string)) {
            string2 = string2.trim();
        }
        return this.fieldValues.put(string, string2);
    }

    public String removeFieldValue(String string) {
        return this.fieldValues.remove(string);
    }

    public String getParent() {
        return this.fieldValues.get("parent");
    }

    public boolean hasParent() {
        return this.getParent() != null;
    }

    public void setParent(String string) {
        this.fieldValues.put("parent", string);
        this.sortLevel = -1;
    }

    public String getAlias() {
        return this.getFieldValue("alias");
    }

    public boolean hasAlias() {
        return this.getAlias() != null;
    }

    public boolean hasCrossRefs() {
        return this.crossRefs != null && this.crossRefs.length > 0 || this.alsocrossRefs != null && this.alsocrossRefs.length > 0 || this.hasAlias();
    }

    public String[] getCrossRefs() {
        return this.crossRefs;
    }

    public boolean isSeeLabel(String string) {
        if (this.crossRefs == null) {
            return false;
        }
        for (int i = 0; i < this.crossRefs.length; ++i) {
            if (!this.crossRefs[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public String[] getAlsoCrossRefs() {
        return this.alsocrossRefs;
    }

    public boolean isSeeAlsoLabel(String string) {
        if (this.alsocrossRefs == null) {
            return false;
        }
        for (int i = 0; i < this.alsocrossRefs.length; ++i) {
            if (!this.alsocrossRefs[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public void addCrossRefdBy(Bib2GlsEntry bib2GlsEntry) {
        if (this.crossRefdBy == null) {
            this.crossRefdBy = new Vector();
        }
        if (!this.crossRefdBy.contains((Object)bib2GlsEntry)) {
            this.crossRefdBy.add(bib2GlsEntry);
        }
    }

    public Iterator<Bib2GlsEntry> getCrossRefdByIterator() {
        return this.crossRefdBy.iterator();
    }

    public String getCrossRefTail() {
        if (this.crossRefTail != null) {
            if (this.crossRefTail.isEmpty()) {
                return null;
            }
            if (this.bib2gls.isDebuggingOn()) {
                this.bib2gls.logAndPrintMessage(this.bib2gls.getMessage("message.crossref.tail", this.getId(), this.crossRefTail));
                this.bib2gls.logAndPrintMessage("[ " + this.getId() + " > " + this.crossRefTail + " ]");
            }
            return this.crossRefTail;
        }
        Vector<String> vector = new Vector<String>();
        String string = this.getCrossRefTail(vector);
        if (string != null && this.bib2gls.isDebuggingOn()) {
            this.bib2gls.logAndPrintMessage(this.bib2gls.getMessage("message.crossref.tail", this.getId(), string));
            this.bib2gls.logAndPrintMessageNoLn("[");
            String string2 = " ";
            for (String string3 : vector) {
                this.bib2gls.logAndPrintMessageNoLn(string2 + string3);
                string2 = ", ";
            }
            this.bib2gls.logAndPrintMessage(" ]");
        }
        return string;
    }

    private String getCrossRefTail(Vector<String> vector) {
        if (this.crossRefTail != null) {
            if (this.crossRefTail.isEmpty()) {
                return null;
            }
            if (this.bib2gls.isDebuggingOn()) {
                vector.add(this.getId());
            }
            return this.crossRefTail;
        }
        String string = this.getFieldValue("alias");
        if (string == null) {
            if (this.crossRefs != null && this.crossRefs.length == 1) {
                string = this.crossRefs[0];
            }
        } else if (this.crossRefs != null && this.crossRefs.length > 0) {
            this.crossRefTail = "";
            return null;
        }
        if (string == null) {
            if (this.alsocrossRefs != null && this.alsocrossRefs.length == 1) {
                string = this.alsocrossRefs[0];
            }
        } else if (this.alsocrossRefs != null && this.alsocrossRefs.length > 0) {
            this.crossRefTail = "";
            return null;
        }
        if (string != null) {
            Bib2GlsEntry bib2GlsEntry;
            String string2 = this.getId();
            String string3 = null;
            if (!vector.isEmpty()) {
                string3 = vector.lastElement();
                if (vector.contains(string)) {
                    this.crossRefTail = string3;
                    return string3;
                }
            }
            if ((bib2GlsEntry = this.resource.getEntry(string)) == null) {
                this.crossRefTail = string3 == null ? "" : string3;
                return string3;
            }
            vector.add(string2);
            String string4 = bib2GlsEntry.getCrossRefTail(vector);
            if (string4 != null && !string2.equals(string4)) {
                string = string4;
            }
            if (string2.equals(string)) {
                string = null;
            }
        }
        this.crossRefTail = string == null ? "" : string;
        return string;
    }

    public boolean hasDependent(String string) {
        return this.deps.contains(string);
    }

    public void addDependency(String string) {
        if (!this.deps.contains(string) && !string.equals(this.getId())) {
            this.deps.add(string);
        }
    }

    protected void addParsedDependency(String string, String string2, GlsLike glsLike, boolean bl) throws IOException {
        TeXParser teXParser = this.resource.getBibParser();
        if (!string.equals(this.getId())) {
            String string3;
            if (!this.deps.contains(string)) {
                this.deps.add(string);
            }
            if ((string3 = this.resource.getGatherParsedDependenciesField()) != null) {
                String string4 = this.getFieldValue(string3);
                BibValueList bibValueList = null;
                TeXObjectList teXObjectList = null;
                boolean bl2 = true;
                if (string4 == null && (bibValueList = this.getField(string3)) != null) {
                    teXObjectList = bibValueList.expand(teXParser);
                    string4 = teXObjectList.toString(teXParser);
                }
                if (string4 == null || string4.isEmpty()) {
                    string4 = string;
                    teXObjectList = teXParser.getListener().createString(string);
                } else {
                    String[] stringArray;
                    TeXObject teXObject = null;
                    String string5 = string4;
                    if (string4.startsWith("[")) {
                        if (teXObjectList == null) {
                            if (bibValueList == null) {
                                bibValueList = this.getField(string3);
                            }
                            if (bibValueList != null) {
                                teXObjectList = bibValueList.expand(teXParser);
                            }
                        }
                        if (teXObjectList == null) {
                            int n = string4.lastIndexOf(93);
                            if (n > 0) {
                                string5 = string4.substring(n + 1);
                                teXObject = teXParser.getListener().createString(string4.substring(1, n - 1));
                            }
                        } else {
                            teXObject = teXObjectList.popArg(teXParser, 91, 93);
                            string4 = teXObjectList.toString(teXParser);
                        }
                    }
                    for (String string6 : stringArray = string5.split(" *, *")) {
                        if (!string6.equals(string)) continue;
                        bl2 = false;
                        break;
                    }
                    if (bl2) {
                        if (teXObject == null) {
                            string4 = string4 + "," + string;
                            teXObjectList = teXParser.getListener().createString(string4);
                        } else {
                            teXObjectList = teXParser.getListener().createStack();
                            teXObjectList.add((TeXObject)teXParser.getListener().getOther(91));
                            teXObjectList.add(teXObject, true);
                            teXObjectList.add((TeXObject)teXParser.getListener().getOther(93));
                            teXObjectList.addAll((Collection)teXParser.getListener().createString(string4 + "," + string));
                            string4 = "[" + teXObject + "]" + string4 + "," + string;
                        }
                    }
                }
                if (bl2) {
                    bibValueList = new BibValueList();
                    bibValueList.add((Object)new BibUserString((TeXObject)teXObjectList));
                    this.putField(string3, string4);
                    this.putField(string3, bibValueList);
                }
            }
        }
    }

    public void removeDependency(String string) {
        this.deps.remove(string);
    }

    public Iterator<String> getDependencyIterator() {
        return this.deps.iterator();
    }

    public boolean hasDependencies() {
        return this.deps.size() > 0;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Bib2GlsEntry)) {
            return false;
        }
        return this.getId().equals(((Bib2GlsEntry)((Object)object)).getId());
    }

    public Vector<GlsRecord> getRecords() {
        if (this.records == null) {
            Vector<GlsRecord> vector = new Vector<GlsRecord>();
            for (String string : this.recordMap.keySet()) {
                vector.addAll((Collection<GlsRecord>)this.recordMap.get(string));
            }
            return vector;
        }
        return this.records;
    }

    public int recordCount() {
        int n = 0;
        if (this.supplementalRecords != null) {
            n = this.supplementalRecords.size();
        }
        if (this.ignoredRecords != null) {
            n = this.ignoredRecords.size();
        }
        if (this.records != null) {
            return n + this.records.size();
        }
        for (String string : this.resource.getLocationCounters()) {
            n += this.recordMap.get(string).size();
        }
        if (this.resource.getSavePrimaryLocationSetting() == 1) {
            n += this.getPrimaryRecordCount();
        }
        return n;
    }

    public boolean isIgnoredEntry() {
        if (this.ignoredRecords == null || this.records != null && !this.records.isEmpty() || this.supplementalRecords != null && !this.supplementalRecords.isEmpty() || this.primaryRecords != null && !this.primaryRecords.isEmpty() || this.recordMap != null && !this.recordMap.isEmpty() || !this.deps.isEmpty() || this.crossRefdBy != null && !this.crossRefdBy.isEmpty() || this.resource.hasEntryMglsRecords(this.getId())) {
            return false;
        }
        return !this.ignoredRecords.isEmpty();
    }

    public int mainRecordCount() {
        int n = 0;
        if (this.records != null) {
            n = this.records.size();
        } else {
            for (String string : this.resource.getLocationCounters()) {
                n += this.recordMap.get(string).size();
            }
        }
        return n;
    }

    public int getPrimaryRecordCount() {
        int n = 0;
        if (this.primaryRecords != null) {
            n = this.primaryRecords.size();
        } else if (this.primaryRecordMap != null) {
            for (String string : this.primaryRecordMap.keySet()) {
                n += this.primaryRecordMap.get(string).size();
            }
        }
        return n;
    }

    public int supplementalRecordCount() {
        return this.supplementalRecords == null ? 0 : this.supplementalRecords.size();
    }

    public int ignoredRecordCount() {
        return this.ignoredRecords == null ? 0 : this.ignoredRecords.size();
    }

    public boolean hasRecords() {
        if (this.recordCount() > 0) {
            return true;
        }
        return this.resource.hasEntryMglsRecords(this.getId());
    }

    public void addRecord(GlsSeeRecord glsSeeRecord) {
        this.addIgnoredRecord(new GlsRecord(this.bib2gls, glsSeeRecord.getLabel(), "", "page", "glsignore", ""));
        StringBuilder stringBuilder = new StringBuilder();
        if (this.crossRefTag == null) {
            this.crossRefTag = glsSeeRecord.getTag();
        }
        if (this.crossRefTag != null) {
            stringBuilder.append(String.format("[%s]", this.crossRefTag));
        }
        if (this.crossRefs == null) {
            this.crossRefs = glsSeeRecord.getXrLabels();
            for (int i = 0; i < this.crossRefs.length; ++i) {
                if (this.bib2gls.isVerbose()) {
                    this.bib2gls.logMessage(this.bib2gls.getMessage("message.crossref.found", this.getId(), "\\glssee", this.crossRefs[i]));
                }
                this.addDependency(this.crossRefs[i]);
                if (i > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(this.crossRefs[i]);
            }
        } else {
            int n;
            Vector<String> vector = new Vector<String>();
            String[] stringArray = glsSeeRecord.getXrLabels();
            char c = '\u0000';
            for (n = 0; n < this.crossRefs.length; ++n) {
                if (vector.contains(this.crossRefs[n])) continue;
                if (c == '\u0000') {
                    c = ',';
                } else {
                    stringBuilder.append(c);
                }
                vector.add(this.crossRefs[n]);
                stringBuilder.append(this.crossRefs[n]);
            }
            for (n = 0; n < stringArray.length; ++n) {
                if (vector.contains(stringArray[n])) continue;
                if (c == '\u0000') {
                    c = ',';
                } else {
                    stringBuilder.append(c);
                }
                vector.add(stringArray[n]);
                if (this.bib2gls.isVerbose()) {
                    this.bib2gls.logMessage(this.bib2gls.getMessage("message.crossref.found", this.getId(), "\\glssee", stringArray[n]));
                }
                this.addDependency(stringArray[n]);
                stringBuilder.append(stringArray[n]);
            }
            this.crossRefs = new String[vector.size()];
            vector.toArray(this.crossRefs);
        }
        this.putField("see", stringBuilder.toString());
    }

    public boolean hasTriggerRecord() {
        return this.triggerRecordFound;
    }

    public void addRecord(GlsRecord glsRecord) {
        this.addRecord(glsRecord, false);
    }

    public void addRecord(GlsRecord glsRecord, boolean bl) {
        String string;
        Object object;
        boolean bl2;
        Object object2;
        if (glsRecord.getFormat().equals("glsignore")) {
            this.bib2gls.debugMessage("message.ignored.record", glsRecord);
            this.addIgnoredRecord(glsRecord);
            return;
        }
        if (this.recordIndex == -1L) {
            this.setRecordIndex(glsRecord.getIndex());
        }
        if (glsRecord.getFormat().equals("glstriggerrecordformat")) {
            this.triggerRecordFound = true;
            this.bib2gls.debugMessage("message.ignored.record", glsRecord);
            this.addIgnoredRecord(glsRecord);
            return;
        }
        if (this.indexCounterRecord == null && (object2 = this.resource.getSaveIndexCounter()) != null && glsRecord.getCounter().equals("wrglossary")) {
            if (((String)object2).equals("true")) {
                this.indexCounterRecord = glsRecord;
            } else if (glsRecord.getFormat().equals(object2)) {
                this.indexCounterRecord = glsRecord;
            }
        }
        object2 = null;
        int n = 0;
        boolean bl3 = bl2 = !bl;
        if (this.resource.isPrimaryLocation(glsRecord.getFormat())) {
            object2 = glsRecord;
            int n2 = this.resource.getPrimaryLocationCountersSetting();
            if (this.records != null || n2 == 0) {
                if (this.primaryRecords == null) {
                    this.primaryRecords = new Vector();
                }
                this.bib2gls.debugMessage("message.adding.primary.record", object2, this.getId());
                this.primaryRecords.add((GlsRecord)object2);
            } else {
                if (this.primaryRecordMap == null) {
                    this.primaryRecordMap = new HashMap();
                    if (n2 != 1) {
                        this.primaryCounters = new Vector();
                    }
                }
                if (this.resource.isPrimaryLocationCounterAllowed((String)(object = ((GlsRecord)object2).getCounter()))) {
                    Vector<GlsRecord> vector = this.primaryRecordMap.get(object);
                    if (vector == null) {
                        vector = new Vector();
                        this.primaryRecordMap.put((String)object, vector);
                        if (this.primaryCounters != null) {
                            this.primaryCounters.add((String)object);
                        }
                    }
                    if (!vector.contains(object2)) {
                        this.bib2gls.debugMessage("message.adding.counter.primary.record", object2, this.getId(), object);
                        vector.add((GlsRecord)object2);
                    }
                }
            }
            n = this.resource.getSavePrimaryLocationSetting();
            if (bl) {
                bl2 = true;
            }
        }
        if (!bl2) {
            return;
        }
        if (this.records != null) {
            if (!this.records.contains(glsRecord)) {
                this.bib2gls.debugMessage("message.adding.record", glsRecord, this.getId());
                if (object2 != null && n == 4) {
                    this.bib2gls.debugMessage("message.changing.primary_record.format", glsRecord, "glsnumberformat", n);
                    glsRecord = (GlsRecord)glsRecord.clone();
                    glsRecord.setFormat("glsnumberformat");
                    this.records.add(glsRecord);
                } else if (object2 == null || n == 2) {
                    this.records.add(glsRecord);
                } else if (n == 3) {
                    this.records.add(this.primaryRecords.size() - 1, glsRecord);
                }
            }
        } else if (!(object2 != null && n == 1 || (object = this.recordMap.get(string = glsRecord.getCounter())) == null || ((Vector)object).contains(glsRecord))) {
            this.bib2gls.debugMessage("message.adding.counter.record", glsRecord, this.getId(), string);
            if (object2 != null && n == 4) {
                this.bib2gls.debugMessage("message.changing.primary_record.format", glsRecord, "glsnumberformat", n);
                glsRecord = (GlsRecord)glsRecord.clone();
                glsRecord.setFormat("glsnumberformat");
                ((Vector)object).add(glsRecord);
            } else if (object2 == null || n == 2) {
                ((Vector)object).add(glsRecord);
            } else if (this.resource.getSavePrimaryLocationSetting() == 3) {
                boolean bl4 = false;
                for (int i = 0; i < ((Vector)object).size(); ++i) {
                    if (this.resource.isPrimaryLocation(((GlsRecord)((Vector)object).get(i)).getFormat())) continue;
                    ((Vector)object).add(i, glsRecord);
                    bl4 = true;
                    break;
                }
                if (!bl4) {
                    ((Vector)object).add(glsRecord);
                }
            }
        }
    }

    public void clearRecords() {
        this.bib2gls.debugMessage("message.clearing.records", this.getId());
        if (this.records == null) {
            for (String string : this.recordMap.keySet()) {
                Vector<GlsRecord> vector = this.recordMap.get(string);
                vector.clear();
            }
        } else {
            this.records.clear();
        }
    }

    public void addSupplementalRecord(GlsRecord glsRecord) {
        if (this.supplementalRecords == null) {
            this.supplementalRecords = new Vector();
        }
        if (!this.bib2gls.isMultipleSupplementarySupported()) {
            String string = glsRecord.getFormat();
            string = string.startsWith("(") ? "(glsxtrsupphypernumber" : (string.startsWith(")") ? ")glsxtrsupphypernumber" : "glsxtrsupphypernumber");
            glsRecord.setFormat(string);
        } else if (glsRecord instanceof SupplementalRecord) {
            TeXPath teXPath;
            Vector<GlsRecord> vector;
            if (this.supplementalRecordMap == null) {
                this.supplementalRecordMap = new HashMap();
            }
            if ((vector = this.supplementalRecordMap.get(teXPath = ((SupplementalRecord)((Object)glsRecord)).getSource())) == null) {
                vector = new Vector();
                this.supplementalRecordMap.put(teXPath, vector);
            }
            if (!vector.contains(glsRecord)) {
                vector.add(glsRecord);
            }
        }
        if (!this.supplementalRecords.contains(glsRecord)) {
            this.bib2gls.debugMessage("message.adding.supplemental.record", this.getId());
            this.supplementalRecords.add(glsRecord);
        }
    }

    public void addIgnoredRecord(GlsRecord glsRecord) {
        if (this.ignoredRecords == null) {
            this.ignoredRecords = new Vector();
        }
        if (!this.ignoredRecords.contains(glsRecord)) {
            this.ignoredRecords.add(glsRecord);
        }
    }

    public static void insertRecord(GlsRecord glsRecord, Vector<GlsRecord> vector) {
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            GlsRecord glsRecord2 = vector.get(i);
            if (glsRecord2.locationMatch(glsRecord)) {
                return;
            }
            if (glsRecord2.partialMatch(glsRecord)) {
                if (!glsRecord2.resolveConflict(glsRecord)) {
                    vector.add(i, glsRecord);
                }
                return;
            }
            int n2 = glsRecord.compareTo(glsRecord2);
            if (n2 > 0) continue;
            vector.add(i, glsRecord);
            return;
        }
        vector.add(glsRecord);
    }

    public void copyRecordsFrom(Bib2GlsEntry bib2GlsEntry) {
        Vector<GlsRecord> vector;
        Vector<GlsRecord> vector2;
        if (this.getId().equals(bib2GlsEntry.getId())) {
            this.bib2gls.debugMessage("message.copying.self_record", this.getId());
            return;
        }
        if (bib2GlsEntry.records != null) {
            for (GlsRecord object : bib2GlsEntry.records) {
                this.bib2gls.debugMessage("message.copying.record", object, bib2GlsEntry.getId(), this.getId());
                if (object.getFormat().equals("glsignore") || object.getFormat().equals("glstriggerrecordformat")) {
                    this.addIgnoredRecord(object.copy(this.getId()));
                    continue;
                }
                Bib2GlsEntry.insertRecord(object.copy(this.getId()), this.records);
            }
        } else if (bib2GlsEntry.recordMap != null) {
            for (String string : bib2GlsEntry.recordMap.keySet()) {
                vector2 = bib2GlsEntry.recordMap.get(string);
                if (vector2 == null) continue;
                vector = this.recordMap.get(string);
                if (vector == null) {
                    vector = new Vector();
                    this.recordMap.put(string, vector);
                }
                for (GlsRecord glsRecord : vector2) {
                    this.bib2gls.debugMessage("message.copying.record", glsRecord, bib2GlsEntry.getId(), this.getId());
                    if (glsRecord.getFormat().equals("glsignore") || glsRecord.getFormat().equals("glstriggerrecordformat")) {
                        this.addIgnoredRecord(glsRecord.copy(this.getId()));
                        continue;
                    }
                    Bib2GlsEntry.insertRecord(glsRecord.copy(this.getId()), vector);
                }
            }
        }
        if (bib2GlsEntry.primaryRecords != null) {
            if (this.primaryRecords == null) {
                this.primaryRecords = new Vector();
            }
            for (GlsRecord glsRecord : bib2GlsEntry.primaryRecords) {
                this.bib2gls.debugMessage("message.copying.primary.record", glsRecord, bib2GlsEntry.getId(), this.getId());
                this.primaryRecords.add(glsRecord);
            }
        } else if (bib2GlsEntry.primaryRecordMap != null) {
            if (this.primaryRecordMap == null) {
                this.primaryRecordMap = new HashMap();
            }
            for (String string : bib2GlsEntry.primaryRecordMap.keySet()) {
                vector2 = this.primaryRecordMap.get(string);
                if (vector2 == null) {
                    vector2 = new Vector();
                    this.primaryRecordMap.put(string, vector2);
                }
                vector = bib2GlsEntry.primaryRecordMap.get(string);
                for (GlsRecord glsRecord : vector) {
                    this.bib2gls.debugMessage("message.copying.primary.record", glsRecord, bib2GlsEntry.getId(), this.getId());
                    vector2.add(glsRecord);
                }
            }
        }
        if (bib2GlsEntry.supplementalRecords != null) {
            for (GlsRecord glsRecord : bib2GlsEntry.supplementalRecords) {
                this.bib2gls.debugMessage("message.copying.record", glsRecord, bib2GlsEntry.getId(), this.getId());
                this.addSupplementalRecord(glsRecord.copy(this.getId()));
            }
        }
    }

    private StringBuilder updateLocationList(int n, String string, String string2, int n2, Vector<GlsRecord> vector, StringBuilder stringBuilder) throws Bib2GlsException {
        GlsRecord glsRecord = null;
        int n3 = 0;
        StringBuilder stringBuilder2 = new StringBuilder();
        GlsRecord glsRecord2 = null;
        GlsRecord glsRecord3 = null;
        GlsRecord glsRecord4 = null;
        int[] nArray = new int[]{0};
        boolean bl = true;
        int n4 = this.resource.getCompactRanges();
        GlsRecord glsRecord5 = null;
        String string3 = null;
        int n5 = 0;
        int n6 = vector.size();
        for (int i = 0; i < n6; ++i) {
            GlsRecord glsRecord6 = vector.get(i);
            String string4 = i == n6 - 1 ? "\\bibglslastDelimN " : "\\bibglsdelimN ";
            this.locationList.add(glsRecord6.getListTeXCode());
            Matcher matcher = RANGE_PATTERN.matcher(glsRecord6.getFormat());
            if (matcher.matches()) {
                char c = matcher.group(1).charAt(0);
                if (c == '(') {
                    if (glsRecord5 != null) {
                        throw new Bib2GlsException(this.bib2gls.getMessage("error.nested.range", glsRecord6, glsRecord5));
                    }
                    glsRecord5 = glsRecord6;
                    string3 = matcher.group(2);
                    if (this.resource.isMergeRangesOn()) {
                        glsRecord3 = (GlsRecord)glsRecord6.clone();
                        glsRecord3.setFormat(string3);
                        if (glsRecord != null && glsRecord3.follows(glsRecord, n2, nArray)) {
                            stringBuilder2.setLength(0);
                        } else if (glsRecord2 == null) {
                            glsRecord2 = glsRecord5;
                            if (stringBuilder == null) {
                                stringBuilder = new StringBuilder();
                            } else if (!bl) {
                                stringBuilder.append(string4);
                                n5 = stringBuilder.length();
                            }
                            stringBuilder.append(glsRecord6.getFmtTeXCode());
                        } else {
                            if (stringBuilder == null) {
                                stringBuilder = new StringBuilder();
                            }
                            stringBuilder.append((CharSequence)stringBuilder2);
                            stringBuilder2.setLength(0);
                            glsRecord2 = glsRecord5;
                            stringBuilder.append(string4);
                            n5 = stringBuilder.length();
                            stringBuilder.append(glsRecord6.getFmtTeXCode());
                        }
                        n3 = n;
                        glsRecord = glsRecord3;
                    } else {
                        glsRecord2 = null;
                        n3 = 0;
                        stringBuilder2.setLength(0);
                        if (stringBuilder == null) {
                            stringBuilder = new StringBuilder();
                        } else if (!bl) {
                            stringBuilder.append(string4);
                        }
                        n5 = stringBuilder.length();
                        stringBuilder.append("\\bibglsrange{");
                        stringBuilder.append(glsRecord6.getFmtTeXCode());
                    }
                    glsRecord4 = null;
                } else {
                    if (glsRecord5 == null) {
                        throw new Bib2GlsException(this.bib2gls.getMessage("error.range.missing.start", glsRecord6));
                    }
                    if (this.resource.isMergeRangesOn()) {
                        glsRecord4 = (GlsRecord)glsRecord6.clone();
                        glsRecord4.setFormat(string3);
                        glsRecord = glsRecord4;
                        glsRecord3 = null;
                    } else {
                        glsRecord2 = null;
                        n3 = 0;
                        stringBuilder2.setLength(0);
                        stringBuilder.append("\\delimR ");
                        stringBuilder.append(glsRecord6.getFmtTeXCode(glsRecord5, n4));
                        stringBuilder.append("}");
                    }
                    glsRecord5 = null;
                    string3 = null;
                }
            } else if (glsRecord5 != null) {
                String string5;
                String string6 = glsRecord6.getFormat();
                if (!glsRecord5.getPrefix().equals(glsRecord6.getPrefix()) || !glsRecord5.getCounter().equals(glsRecord6.getCounter())) {
                    this.bib2gls.warningMessage("error.inconsistent.range", glsRecord6, glsRecord5);
                    string5 = String.format("\\bibglsinterloper{%s}", glsRecord6.getFmtTeXCode());
                    stringBuilder.insert(n5, string5);
                    n5 += string5.length();
                } else if ((string3.isEmpty() || string3.equals("glsnumberformat")) && (string6.isEmpty() || string6.equals("glsnumberformat")) || string3.equals(string6)) {
                    this.bib2gls.debugMessage("message.merge.range", glsRecord6, glsRecord5);
                } else {
                    if (glsRecord6.getFormat().equals("glsnumberformat") || string3.isEmpty()) {
                        this.bib2gls.verboseMessage("message.inconsistent.range", glsRecord6, glsRecord5);
                    } else {
                        this.bib2gls.warningMessage("error.inconsistent.range", glsRecord6, glsRecord5);
                    }
                    string5 = String.format("\\bibglsinterloper{%s}", glsRecord6.getFmtTeXCode());
                    stringBuilder.insert(n5, string5);
                    n5 += string5.length();
                }
            } else if (glsRecord4 != null) {
                if (!glsRecord6.follows(glsRecord4, n2, nArray)) {
                    stringBuilder.append((CharSequence)stringBuilder2);
                    stringBuilder.append("\\delimR ");
                    stringBuilder.append(glsRecord4.getFmtTeXCode());
                    if (nArray[0] > 1) {
                        stringBuilder.append("\\bibglspassim ");
                    }
                    nArray[0] = 0;
                    stringBuilder.append(string4);
                    stringBuilder.append(glsRecord6.getFmtTeXCode());
                    stringBuilder2.setLength(0);
                    n3 = 1;
                    nArray[0] = 0;
                    glsRecord2 = null;
                } else {
                    stringBuilder2.append(string4);
                    stringBuilder2.append(glsRecord6.getFmtTeXCode());
                }
                glsRecord = glsRecord6;
                glsRecord4 = null;
            } else if (glsRecord == null) {
                n3 = 1;
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder();
                } else if (!bl) {
                    stringBuilder.append(string4);
                }
                stringBuilder.append(glsRecord6.getFmtTeXCode());
            } else if (n < Integer.MAX_VALUE && glsRecord6.follows(glsRecord, n2, nArray)) {
                if (n3 == 1) {
                    glsRecord2 = glsRecord;
                }
                ++n3;
                stringBuilder2.append(string4);
                stringBuilder2.append(glsRecord6.getFmtTeXCode());
            } else if (n3 == 2 && string != null) {
                stringBuilder.append(string);
                stringBuilder.append(string4);
                stringBuilder.append(glsRecord6.getFmtTeXCode());
                stringBuilder2.setLength(0);
                n3 = 1;
                nArray[0] = 0;
                glsRecord2 = null;
            } else if (n3 > 2 && string2 != null) {
                stringBuilder.append(string2);
                stringBuilder.append(string4);
                stringBuilder.append(glsRecord6.getFmtTeXCode());
                stringBuilder2.setLength(0);
                n3 = 1;
                nArray[0] = 0;
                glsRecord2 = null;
            } else if (n3 >= n) {
                stringBuilder.append("\\delimR ");
                stringBuilder.append(glsRecord.getFmtTeXCode(glsRecord2, n4));
                if (nArray[0] > 1) {
                    stringBuilder.append("\\bibglspassim ");
                }
                nArray[0] = 0;
                stringBuilder.append(string4);
                stringBuilder.append(glsRecord6.getFmtTeXCode());
                stringBuilder2.setLength(0);
                n3 = 1;
                glsRecord2 = null;
            } else {
                stringBuilder.append((CharSequence)stringBuilder2);
                stringBuilder.append(string4);
                stringBuilder.append(glsRecord6.getFmtTeXCode());
                stringBuilder2.setLength(0);
                n3 = 1;
                nArray[0] = 0;
                glsRecord2 = null;
            }
            glsRecord = glsRecord6;
            bl = false;
        }
        if (glsRecord4 != null) {
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            }
            stringBuilder.append((CharSequence)stringBuilder2);
            stringBuilder.append("\\delimR ");
            stringBuilder.append(glsRecord4.getFmtTeXCode());
        } else {
            if (glsRecord5 != null) {
                throw new Bib2GlsException(this.bib2gls.getMessage("error.range.missing.end", glsRecord5));
            }
            if (glsRecord != null && stringBuilder2.length() > 0) {
                if (n3 >= n) {
                    stringBuilder.append("\\delimR ");
                    stringBuilder.append(glsRecord.getFmtTeXCode(glsRecord2, n4));
                    if (nArray[0] > 1) {
                        stringBuilder.append("\\bibglspassim ");
                    }
                } else {
                    stringBuilder.append((CharSequence)stringBuilder2);
                }
            }
        }
        return stringBuilder;
    }

    /*
     * WARNING - void declaration
     */
    public void updateLocationList() throws Bib2GlsException {
        int n;
        CharSequence charSequence;
        if (this.nonumberlist || this.resource.isSaveLocationsOff()) {
            return;
        }
        int n2 = this.resource.getMinLocationRange();
        String string = this.resource.getSuffixF();
        String string2 = this.resource.getSuffixFF();
        int n3 = this.resource.getSeeLocation();
        int n4 = this.resource.getSeeAlsoLocation();
        int n5 = this.resource.getAliasLocation();
        boolean bl = this.resource.showLocationPrefix();
        boolean bl2 = this.resource.showLocationSuffix();
        int n6 = this.resource.getLocationGap();
        StringBuilder stringBuilder = null;
        this.locationList = new Vector();
        int n7 = this.mainRecordCount() + this.supplementalRecordCount();
        boolean bl3 = this.resource.isSaveAliasLocationsOn();
        boolean bl4 = this.resource.isSaveSeeLocationsOn();
        boolean bl5 = this.resource.isSaveSeeAlsoLocationsOn();
        boolean bl6 = n7 > 0 && this.resource.isSaveAnyNonIgnoredLocationsOn();
        String string3 = this.getAlias();
        if (n5 == 1 && string3 != null && bl3) {
            stringBuilder = new StringBuilder();
            stringBuilder.append("\\bibglsusealias{");
            stringBuilder.append(this.getId());
            stringBuilder.append("}");
            if (bl6) {
                stringBuilder.append("\\bibglsaliassep ");
            }
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("\\glsseeformat");
            ((StringBuilder)charSequence).append("{");
            ((StringBuilder)charSequence).append(string3);
            ((StringBuilder)charSequence).append("}{}");
            this.locationList.add(((StringBuilder)charSequence).toString());
        } else if (n3 == 1 && this.crossRefs != null && bl4) {
            stringBuilder = new StringBuilder();
            stringBuilder.append("\\bibglsusesee{");
            stringBuilder.append(this.getId());
            stringBuilder.append("}");
            if (bl6) {
                stringBuilder.append("\\bibglsseesep ");
            }
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("\\glsseeformat");
            if (this.crossRefTag != null) {
                ((StringBuilder)charSequence).append('[');
                ((StringBuilder)charSequence).append(this.crossRefTag);
                ((StringBuilder)charSequence).append(']');
            }
            ((StringBuilder)charSequence).append("{");
            for (n = 0; n < this.crossRefs.length; ++n) {
                if (n > 0) {
                    ((StringBuilder)charSequence).append(",");
                }
                ((StringBuilder)charSequence).append(this.crossRefs[n]);
            }
            ((StringBuilder)charSequence).append("}{}");
            this.locationList.add(((StringBuilder)charSequence).toString());
        } else if (n4 == 1 && this.alsocrossRefs != null && bl5) {
            stringBuilder = new StringBuilder();
            stringBuilder.append("\\bibglsuseseealso{");
            stringBuilder.append(this.getId());
            stringBuilder.append("}");
            if (bl6) {
                stringBuilder.append("\\bibglsseealsosep ");
            }
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("\\glsxtruseseealsoformat");
            ((StringBuilder)charSequence).append("{");
            for (n = 0; n < this.alsocrossRefs.length; ++n) {
                if (n > 0) {
                    ((StringBuilder)charSequence).append(",");
                }
                ((StringBuilder)charSequence).append(this.processLabel(this.alsocrossRefs[n]));
            }
            ((StringBuilder)charSequence).append("}");
            this.locationList.add(((StringBuilder)charSequence).toString());
        }
        if (string3 != null && this.resource.aliasLocations() != 2) {
            bl6 = false;
        }
        if (bl6) {
            if (bl) {
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder();
                }
                stringBuilder.append(String.format("\\bibglslocprefix{%d}", n7));
            }
            charSequence = "";
            if (this.records == null) {
                String string4 = "";
                for (String string5 : this.resource.getLocationCounters()) {
                    Vector<GlsRecord> vector = this.recordMap.get(string5);
                    if (vector.size() <= 0) continue;
                    if (stringBuilder == null) {
                        stringBuilder = new StringBuilder();
                    }
                    stringBuilder.append(String.format("%s\\bibglslocationgroup{%s}{%s}{", string4, vector.size(), string5));
                    stringBuilder = this.updateLocationList(n2, string, string2, n6, vector, stringBuilder);
                    stringBuilder.append("}");
                    string4 = "\\bibglslocationgroupsep ";
                    charSequence = "\\bibglssupplementalsep ";
                }
            } else if (this.records.size() > 0) {
                stringBuilder = this.updateLocationList(n2, string, string2, n6, this.records, stringBuilder);
                charSequence = "\\bibglssupplementalsep ";
            }
            if (this.supplementalRecords != null && this.supplementalRecords.size() > 0) {
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder();
                }
                stringBuilder.append(String.format("%s\\bibglssupplemental{%d}{", charSequence, this.supplementalRecords.size()));
                if (this.bib2gls.isMultipleSupplementarySupported()) {
                    Vector<TeXPath> vector = this.resource.getSupplementalPaths();
                    String string6 = "";
                    for (TeXPath teXPath : vector) {
                        void var19_25;
                        Vector<GlsRecord> vector2 = this.supplementalRecordMap.get(teXPath);
                        if (vector2 == null) continue;
                        stringBuilder.append(String.format("%s\\bibglssupplementalsublist{%d}{%s}{", var19_25, vector2.size(), this.bib2gls.getTeXPathHref(teXPath)));
                        String string7 = "\\bibglssupplementalsubsep ";
                        stringBuilder = this.updateLocationList(n2, string, string2, n6, vector2, stringBuilder);
                        stringBuilder.append("}");
                    }
                } else {
                    stringBuilder = this.updateLocationList(n2, string, string2, n6, this.supplementalRecords, stringBuilder);
                }
                stringBuilder.append("}");
            }
        }
        if (n5 == 2 && string3 != null && bl3) {
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            }
            if (bl6) {
                stringBuilder.append("\\bibglsaliassep ");
            }
            stringBuilder.append("\\bibglsusealias{");
            stringBuilder.append(this.getId());
            stringBuilder.append("}");
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("\\glsseeformat");
            ((StringBuilder)charSequence).append("{");
            ((StringBuilder)charSequence).append(string3);
            ((StringBuilder)charSequence).append("}{}");
            this.locationList.add(((StringBuilder)charSequence).toString());
        } else if (n3 == 2 && this.crossRefs != null && bl4) {
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            }
            if (bl6) {
                stringBuilder.append("\\bibglsseesep ");
            }
            stringBuilder.append("\\bibglsusesee{");
            stringBuilder.append(this.getId());
            stringBuilder.append("}");
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("\\glsseeformat");
            if (this.crossRefTag != null) {
                ((StringBuilder)charSequence).append('[');
                ((StringBuilder)charSequence).append(this.crossRefTag);
                ((StringBuilder)charSequence).append(']');
            }
            ((StringBuilder)charSequence).append("{");
            for (int i = 0; i < this.crossRefs.length; ++i) {
                if (i > 0) {
                    ((StringBuilder)charSequence).append(",");
                }
                ((StringBuilder)charSequence).append(this.crossRefs[i]);
            }
            ((StringBuilder)charSequence).append("}{}");
            this.locationList.add(((StringBuilder)charSequence).toString());
        } else if (n4 == 2 && this.alsocrossRefs != null && bl5) {
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            }
            if (bl6) {
                stringBuilder.append("\\bibglsseealsosep ");
            }
            stringBuilder.append("\\bibglsuseseealso{");
            stringBuilder.append(this.getId());
            stringBuilder.append("}");
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("\\glsxtruseseealsoformat");
            ((StringBuilder)charSequence).append("{");
            for (int i = 0; i < this.alsocrossRefs.length; ++i) {
                if (i > 0) {
                    ((StringBuilder)charSequence).append(",");
                }
                ((StringBuilder)charSequence).append(this.processLabel(this.alsocrossRefs[i]));
            }
            ((StringBuilder)charSequence).append("}");
            this.locationList.add(((StringBuilder)charSequence).toString());
        }
        if (stringBuilder != null) {
            if (bl2 && (n7 > 0 || this.crossRefs != null || this.alsocrossRefs != null)) {
                stringBuilder.append(String.format("\\bibglslocsuffix{%d}", n7));
            }
            this.putField("location", stringBuilder.toString());
        }
    }

    public String getPrimaryRecordList() throws Bib2GlsException {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.locationList == null) {
            this.locationList = new Vector();
        }
        int n = this.resource.getMinLocationRange();
        String string = this.resource.getSuffixF();
        String string2 = this.resource.getSuffixFF();
        int n2 = this.resource.getLocationGap();
        if (this.primaryRecords != null) {
            stringBuilder.append(String.format("\\bibglsprimary{%d}{", this.primaryRecords.size()));
            stringBuilder = this.updateLocationList(n, string, string2, n2, this.primaryRecords, stringBuilder);
            stringBuilder.append("}");
        } else if (this.primaryRecordMap != null) {
            String string3 = "";
            if (this.primaryCounters == null) {
                for (String string4 : this.resource.getLocationCounters()) {
                    Vector<GlsRecord> vector = this.primaryRecordMap.get(string4);
                    if (vector == null) continue;
                    stringBuilder.append(String.format("%s\\bibglsprimarylocationgroup{%s}{%s}{", string3, vector.size(), string4));
                    stringBuilder = this.updateLocationList(n, string, string2, n2, vector, stringBuilder);
                    stringBuilder.append("}");
                    string3 = "\\bibglsprimarylocationgroupsep ";
                }
            } else {
                for (String string5 : this.primaryCounters) {
                    Vector<GlsRecord> vector = this.primaryRecordMap.get(string5);
                    stringBuilder.append(String.format("%s\\bibglsprimarylocationgroup{%s}{%s}{", string3, vector.size(), string5));
                    stringBuilder = this.updateLocationList(n, string, string2, n2, vector, stringBuilder);
                    stringBuilder.append("}");
                    string3 = "\\bibglsprimarylocationgroupsep ";
                }
            }
        }
        if (stringBuilder.length() > 0) {
            return stringBuilder.toString();
        }
        return null;
    }

    public void initAlias() throws IOException {
        TeXParser teXParser = this.resource.getBibParser();
        String string = this.getFieldValue("alias");
        BibValueList bibValueList = this.getField("alias");
        if (string == null && bibValueList != null) {
            string = bibValueList.expand(teXParser).toString(teXParser);
        }
        if (string == null) {
            if (this.bib2gls.isVerbose()) {
                this.bib2gls.logMessage(this.bib2gls.getMessage("message.field.not.set", "alias"));
            }
        } else {
            CompoundEntry compoundEntry = this.bib2gls.getCompoundEntry(string);
            if (compoundEntry == null) {
                string = this.processLabel(string);
                if (this.bib2gls.isVerbose()) {
                    this.bib2gls.logMessage(this.bib2gls.getMessage("message.crossref.found", this.getId(), "alias", string));
                }
                this.addDependency(string);
            } else {
                String[] stringArray;
                if (this.bib2gls.isVerbose()) {
                    this.bib2gls.logMessage(this.bib2gls.getMessage("message.compoundcrossref.found", this.getId(), "alias", string));
                }
                for (String string2 : stringArray = compoundEntry.getElements()) {
                    this.addDependency(string2);
                }
            }
            this.putField("alias", string);
            this.resource.setAliases(true);
        }
    }

    public void initCrossRefs() throws IOException {
        if (this.bib2gls.isVerbose()) {
            this.bib2gls.logMessage(this.bib2gls.getMessage("message.checking.crossrefs", this.getId()));
        }
        this.initAlias();
        BibValueList bibValueList = this.getField("see");
        BibValueList bibValueList2 = this.getField("seealso");
        if (bibValueList == null) {
            if (this.bib2gls.isVerbose()) {
                this.bib2gls.logMessage(this.bib2gls.getMessage("message.field.not.set", "see"));
            }
            if (bibValueList2 != null) {
                this.initAlsoCrossRefs(bibValueList2, this.getFieldValue("seealso"));
                return;
            }
            if (this.bib2gls.isVerbose()) {
                this.bib2gls.logMessage(this.bib2gls.getMessage("message.field.not.set", "seealso"));
            }
        }
        if (bibValueList2 != null) {
            this.bib2gls.warningMessage("warning.field.clash", "see", "seealso");
        }
        if (bibValueList == null) {
            return;
        }
        TeXParser teXParser = this.resource.getBibParser();
        TeXObjectList teXObjectList = bibValueList.expand(teXParser);
        StringBuilder stringBuilder = new StringBuilder();
        this.initSeeRef(teXObjectList, stringBuilder);
    }

    private void initSeeRef(TeXObjectList teXObjectList, StringBuilder stringBuilder) throws IOException {
        String[] stringArray;
        TeXObject teXObject;
        CsvList csvList;
        int n;
        TeXObject teXObject2;
        TeXParser teXParser = this.resource.getBibParser();
        boolean bl = this.resource.isPruneSeeDeadEndsOn();
        if (teXObjectList instanceof Group) {
            teXObjectList = ((Group)teXObjectList).toList();
        }
        if ((teXObject2 = teXObjectList.popArg(teXParser, 91, 93)) != null) {
            this.orgCrossRefTag = this.crossRefTag = teXObject2.toString(teXParser);
            stringBuilder.append('[');
            stringBuilder.append(this.crossRefTag);
            stringBuilder.append(']');
        }
        if ((n = (csvList = CsvList.getList((TeXParser)teXParser, (TeXObject)teXObjectList)).size()) == 0) {
            return;
        }
        this.crossRefs = new String[n];
        int n2 = 0;
        if (bl) {
            this.orgCrossRefs = new String[n];
        }
        for (int i = 0; i < n; ++i) {
            CompoundEntry compoundEntry;
            boolean bl2 = true;
            teXObject = (TeXObject)csvList.get(i);
            if (teXObject instanceof TeXObjectList) {
                teXObject = ((TeXObjectList)teXObject).trim();
            }
            if ((compoundEntry = this.bib2gls.getCompoundEntry((String)(stringArray = teXObject.toString(teXParser)))) == null) {
                stringArray = this.processLabel((String)stringArray);
                if (bl && this.resource.isSeeDeadEnd((String)stringArray)) {
                    bl2 = false;
                    this.bib2gls.verboseMessage("message.crossref.pruned", this.getId(), "see", stringArray);
                    this.resource.prunedSee((String)stringArray, this);
                } else {
                    this.crossRefs[n2++] = stringArray;
                    if (this.bib2gls.isVerbose()) {
                        this.bib2gls.logMessage(this.bib2gls.getMessage("message.crossref.found", this.getId(), "see", stringArray));
                    }
                    this.addDependency((String)stringArray);
                }
            } else {
                String[] stringArray2;
                this.crossRefs[n2++] = stringArray;
                if (this.bib2gls.isVerbose()) {
                    this.bib2gls.logMessage(this.bib2gls.getMessage("message.compoundcrossref.found", this.getId(), "see", stringArray));
                }
                for (String string : stringArray2 = compoundEntry.getElements()) {
                    this.addDependency(string);
                }
            }
            if (bl) {
                this.orgCrossRefs[i] = stringArray;
            }
            if (!bl2) continue;
            if (n2 > 1) {
                stringBuilder.append(',');
            }
            stringBuilder.append((String)stringArray);
        }
        if (!bl) {
            this.orgCrossRefs = this.crossRefs;
        }
        if (n2 == 0) {
            this.removeField("see");
            this.fieldValues.remove("see");
            this.crossRefTag = null;
            this.crossRefs = null;
        } else if (n2 < n) {
            String string = stringBuilder.toString();
            TeXObjectList teXObjectList2 = new TeXObjectList();
            teXObjectList2.addAll((Collection)teXParser.getListener().createString(string));
            teXObject = new BibValueList();
            teXObject.add((Object)new BibUserString((TeXObject)teXObjectList2));
            this.putField("see", (BibValueList)teXObject);
            this.putField("see", string);
            stringArray = new String[n2];
            for (int i = 0; i < n2; ++i) {
                stringArray[i] = this.crossRefs[i];
            }
            this.crossRefs = stringArray;
        } else {
            this.putField("see", stringBuilder.toString());
        }
    }

    private void initAlsoCrossRefs(BibValueList bibValueList, String string) throws IOException {
        block10: {
            block9: {
                if (string != null && !string.isEmpty() && this.bib2gls.isKnownField("seealso")) break block9;
                this.initAlsoCrossRefs(bibValueList);
                break block10;
            }
            TeXParser teXParser = this.resource.getBibParser();
            boolean bl = this.resource.isPruneSeeAlsoDeadEndsOn();
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = "";
            this.alsocrossRefs = string.trim().split("\\s*,\\s*");
            this.orgAlsoCrossRefs = this.alsocrossRefs;
            Vector<String> vector = null;
            if (bl) {
                vector = new Vector<String>();
            }
            for (String string3 : this.alsocrossRefs) {
                boolean bl2;
                block13: {
                    String[] stringArray;
                    CompoundEntry compoundEntry;
                    block11: {
                        block12: {
                            bl2 = true;
                            compoundEntry = this.bib2gls.getCompoundEntry(string3);
                            if (compoundEntry != null) break block11;
                            string3 = this.processLabel(string3);
                            if (!bl || !this.resource.isSeeAlsoDeadEnd(string3)) break block12;
                            bl2 = false;
                            this.bib2gls.verboseMessage("message.crossref.pruned", this.getId(), "seealso", string3);
                            this.resource.prunedSeeAlso(string3, this);
                            break block13;
                        }
                        if (this.bib2gls.isVerbose()) {
                            this.bib2gls.logMessage(this.bib2gls.getMessage("message.crossref.found", this.getId(), "seealso", string3));
                        }
                        this.addDependency(string3);
                        if (vector == null) break block13;
                        vector.add(string3);
                        break block13;
                    }
                    if (this.bib2gls.isVerbose()) {
                        this.bib2gls.logMessage(this.bib2gls.getMessage("message.compoundcrossref.found", this.getId(), "seealso", string3));
                    }
                    for (String string4 : stringArray = compoundEntry.getElements()) {
                        this.addDependency(string4);
                    }
                }
                if (!bl2) continue;
                stringBuilder.append(string2);
                stringBuilder.append(string3);
                string2 = ",";
            }
            if (vector != null && vector.size() < this.alsocrossRefs.length) {
                if (vector.isEmpty()) {
                    this.removeField("seealso");
                    this.removeFieldValue("seealso");
                    this.alsocrossRefs = null;
                } else {
                    String string5 = stringBuilder.toString();
                    this.alsocrossRefs = vector.toArray(new String[vector.size()]);
                    TeXObjectList teXObjectList = new TeXObjectList();
                    teXObjectList.addAll((Collection)teXParser.getListener().createString(string5));
                    BibValueList bibValueList2 = new BibValueList();
                    bibValueList2.add((Object)new BibUserString((TeXObject)teXObjectList));
                    this.putField("seealso", bibValueList2);
                    this.putField("seealso", string5);
                }
            } else {
                this.putField("seealso", stringBuilder.toString());
            }
        }
    }

    private void initAlsoCrossRefs(BibValueList bibValueList) throws IOException {
        String[] stringArray;
        TeXObject teXObject;
        CsvList csvList;
        int n;
        TeXParser teXParser = this.resource.getBibParser();
        StringBuilder stringBuilder = new StringBuilder();
        TeXObjectList teXObjectList = bibValueList.expand(teXParser);
        if (!this.bib2gls.isKnownField("seealso")) {
            this.bib2gls.warningMessage("warning.field.unsupported", "seealso", "1.16");
            this.crossRefTag = "\\seealsoname ";
            stringBuilder.append("[\\seealsoname]");
            this.initSeeRef(teXObjectList, stringBuilder);
            return;
        }
        boolean bl = this.resource.isPruneSeeAlsoDeadEndsOn();
        if (teXObjectList instanceof Group) {
            teXObjectList = ((Group)teXObjectList).toList();
        }
        if ((n = (csvList = CsvList.getList((TeXParser)teXParser, (TeXObject)teXObjectList)).size()) == 0) {
            return;
        }
        this.alsocrossRefs = new String[n];
        int n2 = 0;
        if (bl) {
            this.orgAlsoCrossRefs = new String[n];
        }
        for (int i = 0; i < n; ++i) {
            boolean bl2 = true;
            teXObject = (TeXObject)csvList.get(i);
            if (teXObject instanceof TeXObjectList) {
                teXObject = ((TeXObjectList)teXObject).trim();
            }
            stringArray = teXObject.toString(teXParser);
            CompoundEntry compoundEntry = this.bib2gls.getCompoundEntry((String)stringArray);
            if (bl) {
                this.orgAlsoCrossRefs[i] = stringArray;
            }
            if (compoundEntry == null) {
                stringArray = this.processLabel(this.alsocrossRefs[i]);
                if (bl && this.resource.isSeeAlsoDeadEnd((String)stringArray)) {
                    bl2 = false;
                    this.bib2gls.verboseMessage("message.crossref.pruned", this.getId(), "seealso", stringArray);
                    this.resource.prunedSeeAlso((String)stringArray, this);
                } else {
                    if (this.bib2gls.isVerbose()) {
                        this.bib2gls.logMessage(this.bib2gls.getMessage("message.crossref.found", this.getId(), "seealso", stringArray));
                    }
                    this.addDependency((String)stringArray);
                }
            } else {
                String[] stringArray2;
                if (this.bib2gls.isVerbose()) {
                    this.bib2gls.logMessage(this.bib2gls.getMessage("message.compoundcrossref.found", this.getId(), "seealso", stringArray));
                }
                for (String string : stringArray2 = compoundEntry.getElements()) {
                    this.addDependency(string);
                }
            }
            if (!bl2) continue;
            this.alsocrossRefs[n2++] = stringArray;
            if (n2 > 1) {
                stringBuilder.append(',');
            }
            stringBuilder.append((String)stringArray);
        }
        if (!bl) {
            this.orgAlsoCrossRefs = this.alsocrossRefs;
        }
        if (n2 == 0) {
            this.removeField("seealso");
            this.removeFieldValue("seealso");
            this.alsocrossRefs = null;
        } else if (n2 < n) {
            String string = stringBuilder.toString();
            TeXObjectList teXObjectList2 = new TeXObjectList();
            teXObjectList2.addAll((Collection)teXParser.getListener().createString(string));
            teXObject = new BibValueList();
            teXObject.add((Object)new BibUserString((TeXObject)teXObjectList2));
            this.putField("seealso", (BibValueList)teXObject);
            this.putField("seealso", string);
            stringArray = new String[n2];
            for (int i = 0; i < n2; ++i) {
                stringArray[i] = this.alsocrossRefs[i];
            }
            this.alsocrossRefs = stringArray;
        } else {
            this.putField("seealso", stringBuilder.toString());
        }
    }

    public void reprune() {
        BibValueList bibValueList;
        TeXObjectList teXObjectList;
        Object object;
        int n;
        Vector<String> vector;
        TeXParser teXParser = this.resource.getBibParser();
        boolean bl = false;
        if (this.crossRefs != null) {
            vector = new Vector<String>();
            for (n = 0; n < this.crossRefs.length; ++n) {
                object = this.bib2gls.getCompoundEntry(this.crossRefs[n]);
                if (object == null && this.resource.isSeeDeadEnd(this.crossRefs[n])) {
                    bl = true;
                    this.removeDependency(this.crossRefs[n]);
                    this.bib2gls.verboseMessage("message.crossref.pruned", this.getId(), "see", this.crossRefs[n]);
                    this.resource.prunedSee(this.crossRefs[n], this);
                    continue;
                }
                vector.add(this.crossRefs[n]);
            }
            if (bl) {
                if (vector.isEmpty()) {
                    this.removeField("see");
                    this.removeFieldValue("see");
                    this.crossRefTag = null;
                    this.crossRefs = null;
                } else {
                    this.crossRefs = vector.toArray(new String[vector.size()]);
                    StringBuilder stringBuilder = new StringBuilder();
                    if (this.crossRefTag != null) {
                        stringBuilder.append('[');
                        stringBuilder.append(this.crossRefTag);
                        stringBuilder.append(']');
                    }
                    for (int i = 0; i < this.crossRefs.length; ++i) {
                        if (i > 0) {
                            stringBuilder.append(',');
                        }
                        stringBuilder.append(this.crossRefs[i]);
                    }
                    object = stringBuilder.toString();
                    teXObjectList = new TeXObjectList();
                    teXObjectList.addAll((Collection)teXParser.getListener().createString((String)object));
                    bibValueList = new BibValueList();
                    bibValueList.add((Object)new BibUserString((TeXObject)teXObjectList));
                    this.putField("see", bibValueList);
                    this.putField("see", (String)object);
                }
            }
            bl = false;
        }
        if (this.alsocrossRefs != null) {
            vector = new Vector();
            for (n = 0; n < this.alsocrossRefs.length; ++n) {
                object = this.bib2gls.getCompoundEntry(this.alsocrossRefs[n]);
                if (object == null && this.resource.isSeeAlsoDeadEnd(this.alsocrossRefs[n])) {
                    bl = true;
                    this.removeDependency(this.crossRefs[n]);
                    this.bib2gls.verboseMessage("message.crossref.pruned", this.getId(), "seealso", this.alsocrossRefs[n]);
                    this.resource.prunedSeeAlso(this.alsocrossRefs[n], this);
                    continue;
                }
                vector.add(this.alsocrossRefs[n]);
            }
            if (bl) {
                if (vector.isEmpty()) {
                    this.removeField("seealso");
                    this.removeFieldValue("seealso");
                    this.alsocrossRefs = null;
                } else {
                    this.alsocrossRefs = vector.toArray(new String[vector.size()]);
                    StringBuilder stringBuilder = new StringBuilder();
                    for (int i = 0; i < this.alsocrossRefs.length; ++i) {
                        if (i > 0) {
                            stringBuilder.append(',');
                        }
                        stringBuilder.append(this.alsocrossRefs[i]);
                    }
                    String string = stringBuilder.toString();
                    teXObjectList = new TeXObjectList();
                    teXObjectList.addAll((Collection)teXParser.getListener().createString(string));
                    bibValueList = new BibValueList();
                    bibValueList.add((Object)new BibUserString((TeXObject)teXObjectList));
                    this.putField("seealso", bibValueList);
                    this.putField("seealso", string);
                }
            }
        }
    }

    public void restorePrunedSee(String string) {
        int n;
        Object object;
        if (this.crossRefs == null) {
            this.crossRefTag = this.orgCrossRefTag;
            this.crossRefs = new String[1];
            this.crossRefs[0] = string;
        } else {
            object = new String[this.crossRefs.length + 1];
            n = 0;
            for (int i = 0; i < this.orgCrossRefs.length; ++i) {
                if (this.orgCrossRefs[i].equals(string)) {
                    object[n] = string;
                    break;
                }
                if (!this.isSeeLabel(this.orgCrossRefs[i])) continue;
                object[n++] = this.orgCrossRefs[i];
            }
            while (n < this.crossRefs.length) {
                object[n + 1] = this.crossRefs[n];
                ++n;
            }
            this.crossRefs = object;
        }
        object = new StringBuilder();
        if (this.crossRefTag != null) {
            ((StringBuilder)object).append('[');
            ((StringBuilder)object).append(this.crossRefTag);
            ((StringBuilder)object).append(']');
        }
        for (n = 0; n < this.crossRefs.length; ++n) {
            if (n > 0) {
                ((StringBuilder)object).append(',');
            }
            ((StringBuilder)object).append(this.crossRefs[n]);
        }
        TeXParser teXParser = this.resource.getBibParser();
        String string2 = ((StringBuilder)object).toString();
        TeXObjectList teXObjectList = new TeXObjectList();
        teXObjectList.addAll((Collection)teXParser.getListener().createString(string2));
        BibValueList bibValueList = new BibValueList();
        bibValueList.add((Object)new BibUserString((TeXObject)teXObjectList));
        this.putField("see", bibValueList);
        this.putField("see", string2);
    }

    public void restorePrunedSeeAlso(String string) {
        int n;
        Object object;
        if (this.alsocrossRefs == null) {
            this.alsocrossRefs = new String[1];
            this.alsocrossRefs[0] = string;
        } else {
            object = new String[this.alsocrossRefs.length + 1];
            n = 0;
            for (int i = 0; i < this.orgAlsoCrossRefs.length; ++i) {
                if (this.orgAlsoCrossRefs[i].equals(string)) {
                    object[n] = string;
                    break;
                }
                if (!this.isSeeAlsoLabel(this.orgAlsoCrossRefs[i])) continue;
                object[n++] = this.orgAlsoCrossRefs[i];
            }
            while (n < this.alsocrossRefs.length) {
                object[n + 1] = this.alsocrossRefs[n];
                ++n;
            }
            this.alsocrossRefs = object;
        }
        object = new StringBuilder();
        for (n = 0; n < this.alsocrossRefs.length; ++n) {
            if (n > 0) {
                ((StringBuilder)object).append(',');
            }
            ((StringBuilder)object).append(this.alsocrossRefs[n]);
        }
        TeXParser teXParser = this.resource.getBibParser();
        String string2 = ((StringBuilder)object).toString();
        TeXObjectList teXObjectList = new TeXObjectList();
        teXObjectList.addAll((Collection)teXParser.getListener().createString(string2));
        BibValueList bibValueList = new BibValueList();
        bibValueList.add((Object)new BibUserString((TeXObject)teXObjectList));
        this.putField("seealso", bibValueList);
        this.putField("seealso", string2);
    }

    private void parseCustomDependencyList(TeXObjectList teXObjectList, String string) throws IOException {
        int n;
        String string2;
        TeXParser teXParser = this.resource.getBibParser();
        if (teXObjectList instanceof Group) {
            teXObjectList = ((Group)teXObjectList).toList();
        }
        StringBuilder stringBuilder = new StringBuilder();
        TeXObject teXObject = teXObjectList.popArg(teXParser, 91, 93);
        if (teXObject != null) {
            string2 = teXObject.toString(teXParser);
            stringBuilder.append('[');
            stringBuilder.append(string2);
            stringBuilder.append(']');
        }
        if ((n = (string2 = CsvList.getList((TeXParser)teXParser, (TeXObject)teXObjectList)).size()) == 0) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            TeXObject teXObject2 = string2.getValue(i);
            if (teXObject2 instanceof TeXObjectList) {
                teXObject2 = ((TeXObjectList)teXObject2).trim();
            }
            String string3 = teXObject2.toString(teXParser);
            String string4 = this.processLabel(string3);
            if (this.bib2gls.isVerbose()) {
                this.bib2gls.logMessage(this.bib2gls.getMessage("message.custom.dep.found", string, this.getId(), string, string4));
            }
            this.addDependency(string4);
            stringBuilder.append(string4);
            if (i == n - 1) continue;
            stringBuilder.append(',');
        }
        if (teXObject != null) {
            teXObjectList.push((TeXObject)teXParser.getListener().getOther(93));
            teXObjectList.push(teXObject);
            teXObjectList.push((TeXObject)teXParser.getListener().getOther(91));
        }
        this.putField(string, stringBuilder.toString());
    }

    public void setCollationKey(CollationKey collationKey) {
        this.collationKey = collationKey;
    }

    public CollationKey getCollationKey() {
        return this.collationKey;
    }

    public void setGroupId(String string) {
        this.groupId = string;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public Bib2GlsEntry createParent() {
        String string;
        TeXParser teXParser = this.resource.getBibParser();
        if (this.orgParentValue == null) {
            return null;
        }
        String string2 = string = this.getParent();
        if (string == null) {
            return null;
        }
        Bib2GlsIndex bib2GlsIndex = new Bib2GlsIndex(this.bib2gls);
        if (this.labelPrefix != null && string.startsWith(this.labelPrefix)) {
            bib2GlsIndex.setId(this.labelPrefix, string.substring(this.labelPrefix.length()));
        } else {
            bib2GlsIndex.setId(null, string);
        }
        bib2GlsIndex.base = this.base;
        bib2GlsIndex.baseFile = this.baseFile;
        bib2GlsIndex.putField("name", this.orgParentValue);
        try {
            bib2GlsIndex.parseFields();
        }
        catch (TeXSyntaxException teXSyntaxException) {
            this.bib2gls.error(this.bib2gls.getMessage("error.create.missing.parent.failed", string2, this.getId(), teXSyntaxException.getMessage((TeXApp)this.bib2gls)));
            this.bib2gls.debug(teXSyntaxException);
        }
        catch (Exception exception) {
            this.bib2gls.error(this.bib2gls.getMessage("error.create.missing.parent.failed", string2, this.getId(), exception.getMessage()));
            this.bib2gls.debug(exception);
        }
        String string3 = this.getFieldValue("type");
        if (string3 != null) {
            bib2GlsIndex.putField("type", string3);
        }
        return bib2GlsIndex;
    }

    public static Bib2GlsEntry getEntry(String string, Vector<Bib2GlsEntry> vector) {
        for (Bib2GlsEntry bib2GlsEntry : vector) {
            if (!bib2GlsEntry.getId().equals(string)) continue;
            return bib2GlsEntry;
        }
        return null;
    }

    public Bib2GlsEntry getHierarchyRoot(Vector<Bib2GlsEntry> vector) {
        String string = this.getParent();
        if (string == null) {
            return this;
        }
        Bib2GlsEntry bib2GlsEntry = Bib2GlsEntry.getEntry(string, vector);
        if (bib2GlsEntry == null) {
            return this;
        }
        return bib2GlsEntry.getHierarchyRoot(vector);
    }

    public Bib2GlsEntry getHierarchyRoot() {
        String string = this.getParent();
        if (string == null) {
            return this;
        }
        Bib2GlsEntry bib2GlsEntry = this.resource.getEntry(string);
        if (bib2GlsEntry == null) {
            return this;
        }
        return bib2GlsEntry.getHierarchyRoot();
    }

    public int getLevel(Vector<Bib2GlsEntry> vector) {
        Bib2GlsEntry bib2GlsEntry;
        if (this.sortLevel != -1 || vector == null) {
            return this.sortLevel;
        }
        this.sortLevel = 0;
        String string = this.getParent();
        if (string != null && (bib2GlsEntry = Bib2GlsEntry.getEntry(string, vector)) != null) {
            this.sortLevel = bib2GlsEntry.getLevel(vector) + 1;
        }
        return this.sortLevel;
    }

    public void moveUpHierarchy(Vector<Bib2GlsEntry> vector) {
        String string = this.getParent();
        String string2 = this.getId();
        if (string == null) {
            return;
        }
        this.sortLevel = -1;
        Bib2GlsEntry bib2GlsEntry = Bib2GlsEntry.getEntry(string, vector);
        String string3 = null;
        if (bib2GlsEntry != null) {
            bib2GlsEntry.removeChild(string2);
            string3 = bib2GlsEntry.getParent();
        }
        if (string3 == null) {
            this.removeField("parent");
            this.removeFieldValue("parent");
            return;
        }
        Bib2GlsEntry bib2GlsEntry2 = Bib2GlsEntry.getEntry(string3, vector);
        if (bib2GlsEntry2 == null) {
            return;
        }
        bib2GlsEntry2.addChild(this);
        this.putField("parent", bib2GlsEntry.getField("parent"));
        this.putField("parent", string3);
    }

    private void addHierarchy(Bib2GlsEntry bib2GlsEntry, Vector<Bib2GlsEntry> vector) throws Bib2GlsException {
        bib2GlsEntry.sortLevel = -1;
        if (this.hierarchy.contains((Object)bib2GlsEntry)) {
            throw new Bib2GlsException(this.bib2gls.getMessage("error.cyclic.hierarchy", bib2GlsEntry.getId()));
        }
        this.hierarchy.add(0, bib2GlsEntry);
        String string = bib2GlsEntry.getParent();
        if (string == null) {
            return;
        }
        Bib2GlsEntry bib2GlsEntry2 = Bib2GlsEntry.getEntry(string, vector);
        if (bib2GlsEntry2 == null) {
            if (this.resource.isStripMissingParentsEnabled()) {
                this.bib2gls.verboseMessage("message.removing.missing.parent", string, bib2GlsEntry.getId());
                bib2GlsEntry.removeField("parent");
                bib2GlsEntry.fieldValues.remove("parent");
            } else {
                this.bib2gls.warningMessage("warning.cant.find.parent", string, bib2GlsEntry.getId());
            }
        } else {
            this.addHierarchy(bib2GlsEntry2, vector);
        }
    }

    public void updateHierarchy(Vector<Bib2GlsEntry> vector) throws Bib2GlsException {
        this.hierarchy = new Vector();
        this.addHierarchy(this, vector);
    }

    public int getHierarchyCount() {
        return this.hierarchy == null ? 0 : this.hierarchy.size();
    }

    public Bib2GlsEntry getHierarchyElement(int n) {
        return this.hierarchy.get(n);
    }

    public Number getNumericSort() {
        return this.numericSort;
    }

    public void setNumericSort(Number number) {
        this.numericSort = number;
    }

    public Object getSortObject() {
        return this.sortObject;
    }

    public void setSortObject(Object object) {
        this.sortObject = object;
    }

    public void addChild(Bib2GlsEntry bib2GlsEntry) {
        if (this.children == null) {
            this.children = new Vector();
        }
        if (!this.children.contains((Object)bib2GlsEntry)) {
            this.bib2gls.debugMessage("message.adding.child", this.getId(), bib2GlsEntry.getId());
            this.children.add(bib2GlsEntry);
        }
    }

    public int getChildCount() {
        if (this.children == null) {
            this.resource.updateChildLists();
        }
        return this.children == null ? 0 : this.children.size();
    }

    public Vector<Bib2GlsEntry> getChildren() {
        return this.children;
    }

    public Bib2GlsEntry getChild(int n) {
        return this.children.get(n);
    }

    public void clearChildren() {
        this.children = null;
    }

    private Bib2GlsEntry removeChild(String string) {
        if (this.children == null) {
            return null;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            if (!this.children.get(i).getId().equals(string)) continue;
            return this.children.remove(i);
        }
        return null;
    }

    public String toString() {
        return this.getId();
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public Bib2GlsEntry getMinimalCopy() {
        Bib2GlsEntry bib2GlsEntry = new Bib2GlsEntry(this.bib2gls, this.defIndex);
        bib2GlsEntry.originalEntryType = this.originalEntryType;
        bib2GlsEntry.records = this.records;
        bib2GlsEntry.recordMap = this.recordMap;
        bib2GlsEntry.base = this.base;
        bib2GlsEntry.baseFile = this.baseFile;
        bib2GlsEntry.labelPrefix = this.labelPrefix;
        bib2GlsEntry.labelSuffix = this.labelSuffix;
        bib2GlsEntry.setOriginalId(this.getOriginalId());
        bib2GlsEntry.setRecordIndex(this.recordIndex);
        return bib2GlsEntry;
    }

    private void setRecordIndex(long l) {
        String string;
        this.recordIndex = l;
        if (this.recordIndex != -1L && (string = this.resource.getUseIndexField()) != null) {
            BibValueList bibValueList = new BibValueList();
            bibValueList.add((Object)new BibNumber((TeXNumber)new UserNumber((int)this.recordIndex)));
            this.putField(string, bibValueList);
            this.putField(string, "" + this.recordIndex);
        }
    }

    public long getDefinitionIndex() {
        return this.defIndex;
    }

    public long getRecordIndex() {
        return this.recordIndex;
    }
}

