/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bibgls.bib2gls;

import com.dickimawbooks.bibgls.bib2gls.AtCompoundSet;
import com.dickimawbooks.bibgls.bib2gls.Bib2Gls;
import com.dickimawbooks.bibgls.bib2gls.Bib2GlsAbbrev;
import com.dickimawbooks.bibgls.bib2gls.Bib2GlsBibParser;
import com.dickimawbooks.bibgls.bib2gls.Bib2GlsBibTeXEntry;
import com.dickimawbooks.bibgls.bib2gls.Bib2GlsContributor;
import com.dickimawbooks.bibgls.bib2gls.Bib2GlsDualAbbrev;
import com.dickimawbooks.bibgls.bib2gls.Bib2GlsDualAbbrevEntry;
import com.dickimawbooks.bibgls.bib2gls.Bib2GlsDualEntry;
import com.dickimawbooks.bibgls.bib2gls.Bib2GlsDualEntryAbbrev;
import com.dickimawbooks.bibgls.bib2gls.Bib2GlsDualIndexAbbrev;
import com.dickimawbooks.bibgls.bib2gls.Bib2GlsDualIndexEntry;
import com.dickimawbooks.bibgls.bib2gls.Bib2GlsDualIndexSymbol;
import com.dickimawbooks.bibgls.bib2gls.Bib2GlsDualSymbol;
import com.dickimawbooks.bibgls.bib2gls.Bib2GlsEntry;
import com.dickimawbooks.bibgls.bib2gls.Bib2GlsIndex;
import com.dickimawbooks.bibgls.bib2gls.Bib2GlsIndexPlural;
import com.dickimawbooks.bibgls.bib2gls.Bib2GlsMultiEntry;
import com.dickimawbooks.bibgls.bib2gls.Bib2GlsProgenitor;
import com.dickimawbooks.bibgls.bib2gls.Bib2GlsSpawnAbbrev;
import com.dickimawbooks.bibgls.bib2gls.Bib2GlsSpawnDualIndexEntry;
import com.dickimawbooks.bibgls.bib2gls.Bib2GlsSpawnEntry;
import com.dickimawbooks.bibgls.bib2gls.Bib2GlsSpawnSymbol;
import com.dickimawbooks.bibgls.bib2gls.Bib2GlsSymbol;
import com.dickimawbooks.bibgls.bib2gls.Bib2GlsTertiaryIndexAbbrevEntry;
import com.dickimawbooks.bibgls.bib2gls.GlsResource;
import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.TeXApp;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.bib.At;
import com.dickimawbooks.texparserlib.bib.BibData;
import com.dickimawbooks.texparserlib.bib.BibEntry;
import com.dickimawbooks.texparserlib.bib.BibPreamble;
import com.dickimawbooks.texparserlib.bib.BibTeXSyntaxException;
import com.dickimawbooks.texparserlib.bib.BibValueList;
import java.io.IOException;

public class Bib2GlsAt
extends At {
    private GlsResource resource;

    public Bib2GlsAt(GlsResource glsResource) {
        this.resource = glsResource;
    }

    protected void process(TeXParser teXParser, TeXObjectList teXObjectList, TeXObject teXObject, TeXObject teXObject2) throws IOException {
        String string;
        BibEntry bibEntry;
        String string2;
        if (!(teXObject instanceof TeXObjectList)) {
            throw new BibTeXSyntaxException(teXParser, "bibtex.error.expecting_or", new Object[]{"{", "("});
        }
        Bib2GlsBibParser bib2GlsBibParser = (Bib2GlsBibParser)teXParser.getListener();
        Bib2Gls bib2Gls = (Bib2Gls)bib2GlsBibParser.getTeXApp();
        String string3 = string2 = teXObjectList.toString(teXParser).trim().toLowerCase();
        if ((string2 = this.resource.mapEntryType(string2)).startsWith("spawned")) {
            bib2Gls.warning(teXParser, bib2Gls.getMessage("warning.private.entry.type", string2, "spawn" + string2.substring(7)));
        }
        if ((bibEntry = string2.equals("compoundset") ? new AtCompoundSet(this.resource, string2) : Bib2GlsAt.createBib2GlsEntry(bib2Gls, string2)) == null) {
            string = this.resource.getUnknownEntryMap();
            if (!(string == null || string2.equals("preamble") || string2.equals("string") || string2.equals("comment"))) {
                string2 = string;
                bibEntry = Bib2GlsAt.createBib2GlsEntry(bib2Gls, string2);
            }
            if (bibEntry == null && (bibEntry = BibData.createBibData((String)string2)) instanceof BibEntry && bib2Gls.isWarnUnknownEntryTypesOn()) {
                bib2Gls.warning(teXParser, bib2Gls.getMessage("warning.ignoring.unknown.entry.type", string2));
            }
        }
        try {
            bibEntry.parseContents(teXParser, (TeXObjectList)teXObject, teXObject2);
        }
        catch (BibTeXSyntaxException bibTeXSyntaxException) {
            String string4 = null;
            StringBuilder stringBuilder = null;
            if (bibEntry instanceof BibEntry) {
                string4 = bibEntry.getId();
                if (string4 == null) {
                    throw new IOException(bib2Gls.getMessage("error.invalid.id", bibTeXSyntaxException.getMessage((TeXApp)bib2Gls)), bibTeXSyntaxException);
                }
                if (this.containsSpecialChars(string4)) {
                    bib2Gls.warning(teXParser, bib2Gls.getMessage("warning.spchars.id", string4));
                }
                if (!bib2Gls.hasNonASCIILabelSupport() && this.containsExtendedChars(string4)) {
                    bib2Gls.warning(teXParser, bib2Gls.getMessage("warning.notbasiclatin.id", string4));
                }
            }
            stringBuilder = new StringBuilder();
            for (TeXObject teXObject3 : (TeXObjectList)teXObject) {
                stringBuilder.append(teXObject3.toString(teXParser));
                if (!(teXObject3 instanceof Group)) continue;
                break;
            }
            if (stringBuilder != null && stringBuilder.length() > 0) {
                if (string4 == null) {
                    throw new IOException(bib2Gls.getMessage("error.bib.contents.parse.before", bibEntry.getEntryType(), bibTeXSyntaxException.getMessage((TeXApp)bib2Gls), stringBuilder), bibTeXSyntaxException);
                }
                throw new IOException(bib2Gls.getMessage("error.bib.contents.parse.data.before", bibEntry.getEntryType(), string4, bibTeXSyntaxException.getMessage((TeXApp)bib2Gls), stringBuilder), bibTeXSyntaxException);
            }
            if (string4 != null) {
                throw new IOException(bib2Gls.getMessage("error.bib.contents.parse.data", bibEntry.getEntryType(), string4, bibTeXSyntaxException.getMessage((TeXApp)bib2Gls)), bibTeXSyntaxException);
            }
            throw new IOException(bib2Gls.getMessage("error.bib.contents.parse", bibEntry.getEntryType(), bibTeXSyntaxException.getMessage((TeXApp)bib2Gls)), bibTeXSyntaxException);
        }
        if (bibEntry instanceof BibPreamble) {
            if (bib2Gls.isDebuggingOn() && !string2.equals(string3)) {
                bib2Gls.debug(String.format("@%s => @preamble", string3));
            }
            string = ((BibPreamble)bibEntry).getPreamble();
            TeXObjectList teXObjectList2 = string.expand(teXParser);
            this.resource.setPreamble(teXObjectList2.toString(teXParser), (BibValueList)string);
        } else if (bibEntry instanceof Bib2GlsEntry) {
            ((Bib2GlsEntry)bibEntry).setOriginalEntryType(string3);
            string = ((Bib2GlsEntry)bibEntry).getId();
            if (bib2Gls.isDebuggingOn() && !string2.equals(string3)) {
                bib2Gls.debug(String.format("@%s{%s} => @%s{%s}", string3, string, string2, string));
            }
            if (bib2GlsBibParser.getBibEntry(string) != null) {
                throw new BibTeXSyntaxException(teXParser, "bibtex.error.repeated_entry", new Object[]{string});
            }
            ((Bib2GlsEntry)bibEntry).setBase(bib2GlsBibParser.getBaseFile());
        }
        bib2GlsBibParser.addBibData((BibData)bibEntry);
        if (bibEntry instanceof Bib2GlsMultiEntry) {
            ((Bib2GlsMultiEntry)bibEntry).populate(bib2GlsBibParser);
        }
    }

    public static Bib2GlsEntry createBib2GlsEntry(Bib2Gls bib2Gls, String string) {
        if (string.matches("^(spawned)?entry$")) {
            return new Bib2GlsEntry(bib2Gls, string);
        }
        if (string.matches("^(spawned)?index$")) {
            return new Bib2GlsIndex(bib2Gls, string);
        }
        if (string.matches("^(spawned)?indexplural$")) {
            return new Bib2GlsIndexPlural(bib2Gls, string);
        }
        if (string.matches("^(spawned)?(acronym|abbreviation)$")) {
            return new Bib2GlsAbbrev(bib2Gls, string);
        }
        if (string.matches("^(spawned)?(symbol|number)$")) {
            return new Bib2GlsSymbol(bib2Gls, string);
        }
        if (string.equals("dualentry")) {
            return new Bib2GlsDualEntry(bib2Gls, string);
        }
        if (string.equals("dualentryabbreviation")) {
            return new Bib2GlsDualEntryAbbrev(bib2Gls, string);
        }
        if (string.equals("dualabbreviationentry")) {
            return new Bib2GlsDualAbbrevEntry(bib2Gls, string);
        }
        if (string.equals("dualindexentry")) {
            return new Bib2GlsDualIndexEntry(bib2Gls, string);
        }
        if (string.equals("dualindexsymbol")) {
            return new Bib2GlsDualIndexSymbol(bib2Gls, string);
        }
        if (string.equals("dualindexnumber")) {
            return new Bib2GlsDualIndexSymbol(bib2Gls, string, "number");
        }
        if (string.equals("dualindexabbreviation")) {
            return new Bib2GlsDualIndexAbbrev(bib2Gls, string);
        }
        if (string.equals("tertiaryindexabbreviationentry")) {
            return new Bib2GlsTertiaryIndexAbbrevEntry(bib2Gls, string);
        }
        if (string.equals("dualabbreviation") || string.equals("dualacronym")) {
            return new Bib2GlsDualAbbrev(bib2Gls, string);
        }
        if (string.equals("dualsymbol") || string.equals("dualnumber")) {
            return new Bib2GlsDualSymbol(bib2Gls, string);
        }
        if (string.equals("bibtexentry")) {
            return new Bib2GlsBibTeXEntry(bib2Gls, string);
        }
        if (string.equals("contributor")) {
            return new Bib2GlsContributor(bib2Gls, string);
        }
        if (string.equals("progenitor") || string.matches("^spawnindex(plural)?$")) {
            return new Bib2GlsProgenitor(bib2Gls, string);
        }
        if (string.equals("spawnentry")) {
            return new Bib2GlsSpawnEntry(bib2Gls, string);
        }
        if (string.matches("^spawn(abbreviation|acronym)$")) {
            return new Bib2GlsSpawnAbbrev(bib2Gls, string);
        }
        if (string.matches("^spawn(symbol|number)$")) {
            return new Bib2GlsSpawnSymbol(bib2Gls, string);
        }
        if (string.equals("spawndualindexentry")) {
            return new Bib2GlsSpawnDualIndexEntry(bib2Gls, string);
        }
        return null;
    }

    protected boolean containsSpecialChars(String string) {
        int n;
        int n2 = string.length();
        for (int i = 0; i < n2; i += Character.charCount(n)) {
            n = string.codePointAt(i);
            if (n != 36 && n != 94 && n != 126 && n != 35 && n != 123 && n != 125 && n != 38 && n != 92 && n != 37) continue;
            return true;
        }
        return false;
    }

    protected boolean containsExtendedChars(String string) {
        int n;
        int n2 = string.length();
        for (int i = 0; i < n2; i += Character.charCount(n)) {
            n = string.codePointAt(i);
            if (n <= 127) continue;
            return true;
        }
        return false;
    }
}

