/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bibgls.gls2bib;

import com.dickimawbooks.bibgls.common.Bib2GlsException;
import com.dickimawbooks.bibgls.common.Bib2GlsSyntaxException;
import com.dickimawbooks.bibgls.common.BibGlsArgValue;
import com.dickimawbooks.bibgls.common.BibGlsConverter;
import com.dickimawbooks.bibgls.gls2bib.GlsAddKey;
import com.dickimawbooks.bibgls.gls2bib.GlsData;
import com.dickimawbooks.bibgls.gls2bib.GlsExpandFields;
import com.dickimawbooks.bibgls.gls2bib.GlsSee;
import com.dickimawbooks.bibgls.gls2bib.GlsSetExpandField;
import com.dickimawbooks.bibgls.gls2bib.LongNewGlossaryEntry;
import com.dickimawbooks.bibgls.gls2bib.NewAbbreviation;
import com.dickimawbooks.bibgls.gls2bib.NewDualEntry;
import com.dickimawbooks.bibgls.gls2bib.NewGlossary;
import com.dickimawbooks.bibgls.gls2bib.NewGlossaryEntry;
import com.dickimawbooks.bibgls.gls2bib.NewNumber;
import com.dickimawbooks.bibgls.gls2bib.NewSymbol;
import com.dickimawbooks.bibgls.gls2bib.NewTerm;
import com.dickimawbooks.bibgls.gls2bib.OldAcronym;
import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.GenericCommand;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.latex.AtGobble;
import com.dickimawbooks.texparserlib.latex.GobbleOpt;
import com.dickimawbooks.texparserlib.latex.GobbleOptMandOpt;
import com.dickimawbooks.texparserlib.latex.Overwrite;
import com.dickimawbooks.texparserlib.latex.glossaries.LoadGlsEntries;
import com.dickimawbooks.texparserlib.primitives.Relax;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class Gls2Bib
extends BibGlsConverter {
    public static final String NAME = "convertgls2bib";
    private Vector<GlsData> data;
    private boolean ignoreSortField = true;
    private boolean ignoreTypeField = false;
    private boolean splitOnType = false;
    private boolean ignoreCategoryField = false;
    private boolean splitOnCategory = false;
    private boolean absorbSee = true;
    private boolean expandFields = false;
    private HashMap<String, String> internalFieldMap;
    private HashMap<String, Boolean> expandFieldMap;
    public static final String[] KNOWN_FIELDS = new String[]{"name", "text", "plural", "first", "firstplural", "symbol", "desc", "useri", "userii", "useriii", "useriv", "userv", "uservi"};
    public static final String[] ABBR_FIELDS = new String[]{"short", "shortpl", "long", "longpl", "full", "fullpl"};

    @Override
    protected void initialise(String[] stringArray) throws Bib2GlsException, IOException {
        super.initialise(stringArray);
        if (this.customIgnoreFields != null) {
            for (String string : this.customIgnoreFields) {
                if (string.equals("sort")) {
                    this.ignoreSortField = true;
                    continue;
                }
                if (string.equals("type")) {
                    this.ignoreTypeField = true;
                    continue;
                }
                if (!string.equals("category")) continue;
                this.ignoreCategoryField = true;
            }
        }
        this.initInternalFieldMap();
    }

    private void initInternalFieldMap() {
        if (this.internalFieldMap == null) {
            this.internalFieldMap = new HashMap();
        }
        this.internalFieldMap.put("sortvalue", "sort");
        this.internalFieldMap.put("firstpl", "firstplural");
        this.internalFieldMap.put("desc", "description");
        this.internalFieldMap.put("descplural", "descriptionplural");
        this.internalFieldMap.put("useri", "user1");
        this.internalFieldMap.put("userii", "user2");
        this.internalFieldMap.put("useriii", "user3");
        this.internalFieldMap.put("useriv", "user4");
        this.internalFieldMap.put("userv", "user5");
        this.internalFieldMap.put("uservi", "user6");
        this.internalFieldMap.put("longpl", "longplural");
        this.internalFieldMap.put("shortpl", "shortplural");
    }

    @Override
    public String getFieldName(String string) {
        if (this.ignoreSortField && string.equals("sort")) {
            return null;
        }
        if (this.ignoreTypeField && string.equals("type")) {
            return null;
        }
        if (this.ignoreCategoryField && string.equals("category")) {
            return null;
        }
        return super.getFieldName(string);
    }

    public boolean isAbsorbSeeOn() {
        return this.absorbSee;
    }

    public boolean ignoreSort() {
        return this.ignoreSortField;
    }

    public boolean ignoreType() {
        return this.ignoreTypeField;
    }

    public boolean isSplitTypeOn() {
        return this.splitOnType;
    }

    public boolean ignoreCategory() {
        return this.ignoreCategoryField;
    }

    public boolean isSplitCategoryOn() {
        return this.splitOnCategory;
    }

    @Override
    protected void addPredefinedCommands(TeXParser teXParser) {
        super.addPredefinedCommands(teXParser);
        teXParser.putControlSequence((ControlSequence)new GenericCommand("glslongkey", null, (TeXObject)this.createString("long")));
        teXParser.putControlSequence((ControlSequence)new GenericCommand("glslongpluralkey", null, (TeXObject)this.createString("longplural")));
        teXParser.putControlSequence((ControlSequence)new GenericCommand("glsshortkey", null, (TeXObject)this.createString("short")));
        teXParser.putControlSequence((ControlSequence)new GenericCommand("glsshortpluralkey", null, (TeXObject)this.createString("shortplural")));
        teXParser.putControlSequence((ControlSequence)new NewGlossaryEntry(this));
        teXParser.putControlSequence((ControlSequence)new NewGlossaryEntry("newentry", this));
        teXParser.putControlSequence((ControlSequence)new NewGlossaryEntry("provideglossaryentry", this, true));
        teXParser.putControlSequence((ControlSequence)new LongNewGlossaryEntry(this));
        teXParser.putControlSequence((ControlSequence)new LongNewGlossaryEntry("longprovideglossaryentry", this, true));
        teXParser.putControlSequence((ControlSequence)new NewAbbreviation(this));
        teXParser.putControlSequence((ControlSequence)new NewAbbreviation("newacronym", "acronym", this));
        teXParser.putControlSequence((ControlSequence)new OldAcronym(this));
        teXParser.putControlSequence((ControlSequence)new NewTerm(this));
        teXParser.putControlSequence((ControlSequence)new NewNumber(this));
        teXParser.putControlSequence((ControlSequence)new NewNumber("newnum", this));
        teXParser.putControlSequence((ControlSequence)new NewSymbol(this));
        teXParser.putControlSequence((ControlSequence)new NewSymbol("newsym", this));
        teXParser.putControlSequence((ControlSequence)new NewDualEntry(this));
        teXParser.putControlSequence((ControlSequence)new GlsExpandFields(this));
        teXParser.putControlSequence((ControlSequence)new GlsExpandFields("glsnoexpandfields", false, this));
        teXParser.putControlSequence((ControlSequence)new GlsSetExpandField(this));
        teXParser.putControlSequence((ControlSequence)new GlsSetExpandField("glssetnoexpandfield", false, this));
        teXParser.putControlSequence((ControlSequence)new LoadGlsEntries());
        teXParser.putControlSequence((ControlSequence)new AtGobble("setupglossaries"));
        teXParser.putControlSequence((ControlSequence)new AtGobble("glossariesextrasetup"));
        teXParser.putControlSequence((ControlSequence)new GobbleOpt("makeglossaries"));
        teXParser.putControlSequence((ControlSequence)new Relax("makenoidxglossaries"));
        teXParser.putControlSequence((ControlSequence)new GobbleOpt("GlsXtrLoadResources"));
        teXParser.putControlSequence((ControlSequence)new Relax("noist"));
        teXParser.putControlSequence((ControlSequence)new NewGlossary());
        teXParser.putControlSequence((ControlSequence)new NewGlossary("altnewglossary", 1));
        teXParser.putControlSequence((ControlSequence)new NewGlossary("newignoredglossary", 2));
        teXParser.putControlSequence((ControlSequence)new NewGlossary("provideignoredglossary", 2));
        teXParser.putControlSequence((ControlSequence)new GobbleOpt("GlsSetXdyLanguage", 1, 1, new int[0]));
        teXParser.putControlSequence((ControlSequence)new AtGobble("GlsSetXdyCodePage"));
        teXParser.putControlSequence((ControlSequence)new AtGobble("GlsAddXdyCounters"));
        teXParser.putControlSequence((ControlSequence)new AtGobble("GlsAddXdyAttribute"));
        teXParser.putControlSequence((ControlSequence)new GobbleOpt("GlsAddXdyLocation", 1, 2, new int[0]));
        teXParser.putControlSequence((ControlSequence)new AtGobble("GlsSetXdyLocationClassOrder"));
        teXParser.putControlSequence((ControlSequence)new AtGobble("GlsSetXdyMinRangeLength"));
        teXParser.putControlSequence((ControlSequence)new AtGobble("GlsSetXdyFirstLetterAfterDigits"));
        teXParser.putControlSequence((ControlSequence)new AtGobble("GlsSetXdyNumberGroupOrder"));
        teXParser.putControlSequence((ControlSequence)new AtGobble("GlsAddXdyStyle"));
        teXParser.putControlSequence((ControlSequence)new GobbleOpt("setabbreviationstyle", 1, 1, new int[0]));
        teXParser.putControlSequence((ControlSequence)new AtGobble("setacronymstyle"));
        teXParser.putControlSequence((ControlSequence)new AtGobble("glssetcategoryattribute", 3));
        teXParser.putControlSequence((ControlSequence)new AtGobble("newabbreviationstyle", 3));
        teXParser.putControlSequence((ControlSequence)new AtGobble("newacronymstyle", 3));
        teXParser.putControlSequence((ControlSequence)new AtGobble("setlength", 2));
        teXParser.putControlSequence((ControlSequence)new AtGobble("pagestyle"));
        teXParser.putControlSequence((ControlSequence)new GobbleOpt("glssetwidest", 1, 1, new int[0]));
        teXParser.putControlSequence((ControlSequence)new AtGobble("glsdefpostlink", 2));
        teXParser.putControlSequence((ControlSequence)new AtGobble("glsdefpostname", 2));
        teXParser.putControlSequence((ControlSequence)new AtGobble("glsdefpostdesc", 2));
        teXParser.putControlSequence((ControlSequence)new GlsAddKey());
        teXParser.putControlSequence((ControlSequence)new GlsAddKey("glsaddstoragekey", true));
        teXParser.putControlSequence((ControlSequence)new GlsSee(this));
        teXParser.putControlSequence((ControlSequence)new GlsSee(this, "glsxtrindexseealso"));
        teXParser.putControlSequence((ControlSequence)new GobbleOpt("glsadd", 1, 1, new int[0]));
        teXParser.putControlSequence((ControlSequence)new GobbleOpt("glsaddall", 1, 0, new int[0]));
        if (!this.preambleOnly) {
            teXParser.putControlSequence((ControlSequence)new GobbleOptMandOpt("gls"));
            teXParser.putControlSequence((ControlSequence)new GobbleOptMandOpt("glspl"));
            teXParser.putControlSequence((ControlSequence)new GobbleOptMandOpt("Gls"));
            teXParser.putControlSequence((ControlSequence)new GobbleOptMandOpt("Glspl"));
            teXParser.putControlSequence((ControlSequence)new GobbleOptMandOpt("GLS"));
            teXParser.putControlSequence((ControlSequence)new GobbleOptMandOpt("GLSpl"));
            for (String string : KNOWN_FIELDS) {
                teXParser.putControlSequence((ControlSequence)new GobbleOptMandOpt("gls" + string));
                teXParser.putControlSequence((ControlSequence)new GobbleOptMandOpt("Gls" + string));
                teXParser.putControlSequence((ControlSequence)new GobbleOptMandOpt("GLS" + string));
                teXParser.putControlSequence((ControlSequence)new AtGobble("glsentry" + string));
                teXParser.putControlSequence((ControlSequence)new AtGobble("Glsentry" + string));
                teXParser.putControlSequence((ControlSequence)new GobbleOpt("glsfmt" + string, 1, 1, new int[0]));
                teXParser.putControlSequence((ControlSequence)new GobbleOpt("Glsfmt" + string, 1, 1, new int[0]));
                teXParser.putControlSequence((ControlSequence)new GobbleOpt("GLSfmt" + string, 1, 1, new int[0]));
            }
            for (String string : ABBR_FIELDS) {
                teXParser.putControlSequence((ControlSequence)new AtGobble("glsentry" + string));
                teXParser.putControlSequence((ControlSequence)new AtGobble("Glsentry" + string));
                teXParser.putControlSequence((ControlSequence)new GobbleOptMandOpt("acr" + string));
                teXParser.putControlSequence((ControlSequence)new GobbleOptMandOpt("Acr" + string));
                teXParser.putControlSequence((ControlSequence)new GobbleOptMandOpt("ACR" + string));
                teXParser.putControlSequence((ControlSequence)new GobbleOptMandOpt("glsxtr" + string));
                teXParser.putControlSequence((ControlSequence)new GobbleOptMandOpt("Glsxtr" + string));
                teXParser.putControlSequence((ControlSequence)new GobbleOptMandOpt("GLSxtr" + string));
                teXParser.putControlSequence((ControlSequence)new GobbleOpt("glsfmt" + string, 1, 1, new int[0]));
                teXParser.putControlSequence((ControlSequence)new GobbleOpt("Glsfmt" + string, 1, 1, new int[0]));
                teXParser.putControlSequence((ControlSequence)new GobbleOpt("GLSfmt" + string, 1, 1, new int[0]));
            }
            teXParser.putControlSequence((ControlSequence)new GobbleOpt("glsdisp", 1, 2, new int[0]));
            teXParser.putControlSequence((ControlSequence)new GobbleOpt("glslink", 1, 2, new int[0]));
            teXParser.putControlSequence((ControlSequence)new GobbleOptMandOpt("cgls"));
            teXParser.putControlSequence((ControlSequence)new GobbleOptMandOpt("cglspl"));
            teXParser.putControlSequence((ControlSequence)new GobbleOptMandOpt("cGls"));
            teXParser.putControlSequence((ControlSequence)new GobbleOptMandOpt("cGlspl"));
            teXParser.putControlSequence((ControlSequence)new GobbleOptMandOpt("cGLS"));
            teXParser.putControlSequence((ControlSequence)new GobbleOptMandOpt("cGLSpl"));
            teXParser.putControlSequence((ControlSequence)new GobbleOptMandOpt("pgls"));
            teXParser.putControlSequence((ControlSequence)new GobbleOptMandOpt("pglspl"));
            teXParser.putControlSequence((ControlSequence)new GobbleOptMandOpt("Pgls"));
            teXParser.putControlSequence((ControlSequence)new GobbleOptMandOpt("Pglspl"));
            teXParser.putControlSequence((ControlSequence)new GobbleOptMandOpt("PGLS"));
            teXParser.putControlSequence((ControlSequence)new GobbleOptMandOpt("PGLSpl"));
            teXParser.putControlSequence((ControlSequence)new AtGobble("glsentrynumberlist"));
            teXParser.putControlSequence((ControlSequence)new AtGobble("glsdisplaynumberlist"));
            teXParser.putControlSequence((ControlSequence)new GobbleOpt("chapter", 1, 1, new int[]{42}));
            teXParser.putControlSequence((ControlSequence)new GobbleOpt("printglossary", 1, 0, new int[0]));
            teXParser.putControlSequence((ControlSequence)new GobbleOpt("printnoidxglossary", 1, 0, new int[0]));
            teXParser.putControlSequence((ControlSequence)new Relax("printglossaries"));
            teXParser.putControlSequence((ControlSequence)new Relax("printnoidxglossaries"));
        }
    }

    @Override
    protected boolean isIgnoredPackage(String string) {
        return string.startsWith("glossar");
    }

    @Override
    public boolean newcommandOverride(boolean bl, Overwrite overwrite, String string, String string2, boolean bl2, int n, TeXObject teXObject, TeXObject teXObject2) throws IOException {
        if (string2.equals("newdualentry") && overwrite == Overwrite.FORBID) {
            this.message(this.getMessage(this.getParser(), "gls2bib.override.newdualentry", new Object[0]));
            this.listener.addLaTeXCommand(string2, bl2, n, teXObject, teXObject2);
            return true;
        }
        return false;
    }

    public void addData(GlsData glsData) {
        this.data.add(glsData);
    }

    public boolean hasEntry(String string) {
        for (GlsData glsData : this.data) {
            if (!glsData.getId().equals(string)) continue;
            return true;
        }
        return false;
    }

    public GlsData getEntry(String string) {
        for (GlsData glsData : this.data) {
            if (!glsData.getId().equals(string)) continue;
            return glsData;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process() throws IOException, Bib2GlsException {
        Object object;
        this.listener.requirepackage("etoolbox", null);
        this.data = new Vector();
        this.parser.parse(this.texFile, this.charset);
        PrintWriter printWriter = null;
        HashMap<String, PrintWriter> hashMap = null;
        if (this.splitOnType || this.splitOnCategory) {
            hashMap = new HashMap<String, PrintWriter>();
        }
        try {
            if (this.data.isEmpty()) {
                throw new Bib2GlsException(this.getMessage("gls2bib.no.entries"));
            }
            if (!this.overwriteFiles && this.bibFile.exists()) {
                throw new IOException(this.getMessage("error.file_exists.nooverwrite", this.bibFile, "--overwrite"));
            }
            this.message(this.getMessage("message.writing", this.bibFile));
            if (this.bibCharsetName == null) {
                object = this.getDefaultCharset();
                this.bibCharsetName = ((Charset)object).name();
            } else {
                object = Charset.forName(this.bibCharsetName);
            }
            printWriter = new PrintWriter(this.createBufferedWriter(this.bibFile.toPath(), (Charset)object));
            printWriter.println("% Encoding: " + this.bibCharsetName);
            for (GlsData object2 : this.data) {
                if (this.splitOnType || this.splitOnCategory) {
                    String string;
                    String string2 = this.splitOnType ? object2.getGlossaryType() : null;
                    String string3 = string = this.splitOnCategory ? object2.getCategory() : null;
                    if (string2 == null && string == null) {
                        object2.writeBibEntry(printWriter);
                        continue;
                    }
                    String string4 = string2 == null ? string : (string == null || string2.equals(string) ? string2 : String.format("%s-%s", string2, string));
                    PrintWriter printWriter2 = (PrintWriter)hashMap.get(string4);
                    if (printWriter2 == null) {
                        File file = new File(this.bibFile.getParent(), string4 + ".bib");
                        if (!this.overwriteFiles && file.exists()) {
                            throw new IOException(this.getMessage("error.file_exists.nooverwrite", file, "--overwrite"));
                        }
                        this.message(this.getMessage("message.writing", file));
                        printWriter2 = new PrintWriter(this.createBufferedWriter(file.toPath(), (Charset)object));
                        printWriter2.println("% Encoding: " + this.bibCharsetName);
                        hashMap.put(string4, printWriter2);
                    }
                    object2.writeBibEntry(printWriter2);
                    continue;
                }
                object2.writeBibEntry(printWriter);
            }
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
            if (hashMap != null) {
                object = hashMap.keySet();
                Iterator<GlsData> iterator = object.iterator();
                while (iterator.hasNext()) {
                    String string = (String)((Object)iterator.next());
                    ((PrintWriter)hashMap.get(string)).close();
                }
            }
        }
    }

    @Override
    protected void filterHelp() {
        super.filterHelp();
        this.printSyntaxItem(this.getMessage("gls2bib.syntax.ignore-category", "--[no-]ignore-category"));
        this.printSyntaxItem(this.getMessage("gls2bib.syntax.ignore-type", "--[no-]ignore-type"));
        this.printSyntaxItem(this.getMessage("gls2bib.syntax.ignore-sort", "--[no-]ignore-sort"));
    }

    @Override
    protected void ioHelp() {
        super.ioHelp();
        this.printSyntaxItem(this.getMessage("gls2bib.syntax.split-on-type", "--[no-]split-on-type", "-t"));
        this.printSyntaxItem(this.getMessage("gls2bib.syntax.split-on-category", "--[no-]split-on-category", "-c"));
    }

    @Override
    protected void adjustHelp() {
        super.adjustHelp();
        this.printSyntaxItem(this.getMessage("gls2bib.syntax.absorb-see", "--[no-]absorb-see"));
    }

    @Override
    protected void syntaxInfo() {
        this.printSyntaxItem(this.getMessage("gls2bib.syntax.info", "bib2gls"));
    }

    @Override
    protected int argCount(String string) {
        if (string.equals("--internal-field-map")) {
            return 1;
        }
        return super.argCount(string);
    }

    @Override
    protected boolean parseArg(ArrayDeque<String> arrayDeque, String string, BibGlsArgValue[] bibGlsArgValueArray) throws Bib2GlsSyntaxException {
        if (string.equals("--ignore-sort")) {
            this.ignoreSortField = true;
        } else if (string.equals("--no-ignore-sort")) {
            this.ignoreSortField = false;
        } else if (string.equals("--ignore-type")) {
            this.ignoreTypeField = true;
        } else if (string.equals("--no-ignore-type")) {
            this.ignoreTypeField = false;
        } else if (string.equals("--split-on-type") || string.equals("-t")) {
            this.splitOnType = true;
            this.ignoreTypeField = true;
            this.overwriteFiles = false;
        } else if (string.equals("--no-split-on-type")) {
            this.splitOnType = false;
        } else if (string.equals("--ignore-category")) {
            this.ignoreCategoryField = true;
        } else if (string.equals("--no-ignore-category")) {
            this.ignoreCategoryField = false;
        } else if (string.equals("--split-on-category") || string.equals("-c")) {
            this.splitOnCategory = true;
            this.ignoreCategoryField = true;
            this.overwriteFiles = false;
        } else if (string.equals("--no-split-on-category")) {
            this.splitOnCategory = false;
        } else if (string.equals("--absorb-see")) {
            this.absorbSee = true;
        } else if (string.equals("--no-absorb-see")) {
            this.absorbSee = false;
        } else if (this.isListArg(arrayDeque, string, "--internal-field-map", bibGlsArgValueArray)) {
            if (bibGlsArgValueArray[0] == null) {
                throw new Bib2GlsSyntaxException(this.getMessage("common.missing.arg.value", string));
            }
            if (this.internalFieldMap == null) {
                this.internalFieldMap = new HashMap();
            }
            for (String string2 : bibGlsArgValueArray[0].listValue()) {
                String[] stringArray = string2.split(" *= *");
                if (stringArray.length != 2) {
                    throw new Bib2GlsSyntaxException(this.getMessage("datatool2bib.syntax.invalid_map", string2, string));
                }
                this.internalFieldMap.put(stringArray[0], stringArray[1]);
            }
        } else {
            return super.parseArg(arrayDeque, string, bibGlsArgValueArray);
        }
        return true;
    }

    public boolean fieldExpansionOn(String string) {
        Boolean bl;
        if (this.expandFieldMap != null && (bl = this.expandFieldMap.get(string)) != null) {
            return bl;
        }
        return this.expandFields;
    }

    public void setFieldExpansion(boolean bl) {
        this.expandFields = bl;
    }

    public void setFieldExpansion(String string, boolean bl) {
        String string2 = this.internalFieldMap.get(string);
        if (string2 != null) {
            string = string2;
        }
        if (this.expandFieldMap == null) {
            this.expandFieldMap = new HashMap();
        }
        this.expandFieldMap.put(string, bl);
    }

    public String getApplicationName() {
        return NAME;
    }

    @Override
    public String getCopyrightStartYear() {
        return "2017";
    }

    public static void main(String[] stringArray) {
        Gls2Bib gls2Bib = new Gls2Bib();
        gls2Bib.run(stringArray);
    }
}

