/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control.table;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.CustomMenuItem;
import javafx.scene.control.TableColumn;
import org.controlsfx.control.table.DupeCounter;
import org.controlsfx.control.table.FilterPanel;
import org.controlsfx.control.table.FilterValue;
import org.controlsfx.control.table.TableFilter;

public final class ColumnFilter<T, R> {
    private final TableFilter<T> tableFilter;
    private final TableColumn<T, R> tableColumn;
    private final ObservableList<FilterValue<T, R>> filterValues;
    private final DupeCounter<R> filterValuesDupeCounter;
    private final DupeCounter<R> visibleValuesDupeCounter;
    private final HashSet<R> unselectedValues;
    private final HashMap<CellIdentity<T>, ChangeListener<R>> trackedCells;
    private boolean lastFilter;
    private boolean isDirty;
    private BiPredicate<String, String> searchStrategy;
    private volatile FilterPanel filterPanel;
    private boolean initialized;
    private final ListChangeListener<T> backingListListener;
    private final ListChangeListener<T> itemsListener;
    private final ChangeListener<R> changeListener;
    private final ListChangeListener<FilterValue<T, R>> filterValueListChangeListener;

    /*
     * Exception decompiling
     */
    ColumnFilter(TableFilter<T> tableFilter, TableColumn<T, R> tableColumn) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void setFilterPanel(FilterPanel filterPanel) {
        this.filterPanel = filterPanel;
    }

    FilterPanel getFilterPanel() {
        return this.filterPanel;
    }

    public void initialize() {
        if (!this.initialized) {
            this.initializeListeners();
            this.initializeValues();
            this.initialized = true;
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void selectValue(Object value) {
        this.filterPanel.selectValue(value);
    }

    public void unselectValue(Object value) {
        this.filterPanel.unSelectValue(value);
    }

    public void selectAllValues() {
        this.filterPanel.selectAllValues();
    }

    public void unSelectAllValues() {
        this.filterPanel.unSelectAllValues();
    }

    boolean wasLastFiltered() {
        return this.lastFilter;
    }

    boolean hasUnselections() {
        return this.unselectedValues.size() != 0;
    }

    public void setSearchStrategy(BiPredicate<String, String> searchStrategy) {
        this.searchStrategy = searchStrategy;
    }

    public BiPredicate<String, String> getSearchStrategy() {
        return this.searchStrategy;
    }

    public boolean isFiltered() {
        return this.isDirty || this.unselectedValues.size() > 0;
    }

    public boolean valueIsVisible(R value) {
        return this.visibleValuesDupeCounter.get(value) > 0;
    }

    public void applyFilter() {
        this.tableFilter.executeFilter();
        this.lastFilter = true;
        this.tableFilter.getColumnFilters().stream().filter(c -> !c.equals(this)).forEach(c -> {
            c.lastFilter = false;
        });
        this.tableFilter.getColumnFilters().stream().flatMap(c -> c.filterValues.stream()).forEach(FilterValue::refreshScope);
        this.isDirty = false;
    }

    public ObservableList<FilterValue<T, R>> getFilterValues() {
        return this.filterValues;
    }

    public TableColumn<T, R> getTableColumn() {
        return this.tableColumn;
    }

    public TableFilter<T> getTableFilter() {
        return this.tableFilter;
    }

    void resetAllFilters() {
        this.tableFilter.getColumnFilters().stream().flatMap(c -> c.filterValues.stream()).forEach(fv -> fv.selectedProperty().set(true));
        this.tableFilter.resetFilter();
        this.tableFilter.getColumnFilters().forEach(c -> {
            c.lastFilter = false;
        });
        this.tableFilter.getColumnFilters().stream().flatMap(c -> c.filterValues.stream()).forEach(FilterValue::refreshScope);
        this.isDirty = false;
    }

    boolean evaluate(T item) {
        ObservableValue<R> value = this.tableColumn.getCellObservableValue(item);
        return this.unselectedValues.size() == 0 || !this.unselectedValues.contains(value.getValue());
    }

    private void initializeValues() {
        this.tableFilter.getBackingList().forEach(t -> this.addBackingItem(t, this.tableColumn.getCellObservableValue(t)));
        this.tableFilter.getTableView().getItems().stream().map(this.tableColumn::getCellObservableValue).forEach(this::addVisibleItem);
    }

    private void addBackingItem(T item, ObservableValue<R> cellValue) {
        if (cellValue == null) {
            return;
        }
        if (this.filterValuesDupeCounter.add(cellValue.getValue()) == 1) {
            this.filterValues.add(new FilterValue(cellValue.getValue(), this));
        }
        CellIdentity<T> trackedCellValue = new CellIdentity<T>(item);
        WeakChangeListener<R> cellListener = new WeakChangeListener<R>(this.changeListener);
        cellValue.addListener(cellListener);
        this.trackedCells.put(trackedCellValue, cellListener);
    }

    private void removeBackingItem(T item, ObservableValue<R> cellValue) {
        if (cellValue == null) {
            return;
        }
        this.removeValue(cellValue.getValue());
        ChangeListener<R> listener = this.trackedCells.get(new CellIdentity<T>(item));
        cellValue.removeListener(listener);
        this.trackedCells.remove(new CellIdentity<T>(item));
    }

    private void removeValue(R value) {
        boolean removedLastDuplicate;
        boolean bl = removedLastDuplicate = this.filterValuesDupeCounter.remove(value) == 0;
        if (removedLastDuplicate) {
            Optional<FilterValue> existingFilterValue = this.getFilterValues().stream().filter(fv -> Objects.equals(fv.getValue(), value)).findAny();
            existingFilterValue.ifPresent(trFilterValue -> this.getFilterValues().remove(trFilterValue));
        }
    }

    private void addVisibleItem(ObservableValue<R> cellValue) {
        if (cellValue != null) {
            this.visibleValuesDupeCounter.add(cellValue.getValue());
        }
    }

    private void removeVisibleItem(ObservableValue<R> cellValue) {
        if (cellValue != null) {
            this.visibleValuesDupeCounter.remove(cellValue.getValue());
        }
    }

    private void initializeListeners() {
        this.tableFilter.getBackingList().addListener(new WeakListChangeListener<T>(this.backingListListener));
        this.tableFilter.getTableView().getItems().addListener(new WeakListChangeListener<T>(this.itemsListener));
        this.filterValues.addListener(new WeakListChangeListener<FilterValue<T, R>>(this.filterValueListChangeListener));
    }

    private void attachContextMenu() {
        ContextMenu contextMenu = new ContextMenu();
        CustomMenuItem item = FilterPanel.getInMenuItem(this, contextMenu);
        contextMenu.getStyleClass().add("column-filter");
        contextMenu.getItems().add(item);
        this.tableColumn.setContextMenu(contextMenu);
        contextMenu.setOnShowing(ae -> this.initialize());
    }

    private static final class CellIdentity<T> {
        private final T item;

        CellIdentity(T item) {
            this.item = item;
        }

        public boolean equals(Object other) {
            return this.item == ((CellIdentity)other).item;
        }

        public int hashCode() {
            return System.identityHashCode(this.item);
        }
    }
}

