/*
 * Decompiled with CFR 0.152.
 */
package mediathek.update;

import java.awt.Frame;
import javafx.application.Platform;
import javafx.scene.Scene;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javax.swing.JComponent;
import mediathek.config.Konstanten;
import mediathek.gui.dialog.StandardCloseDialog;
import mediathek.tool.GuiFunktionen;
import mediathek.update.ServerProgramInformation;
import mediathek.update.UpdateNotificationPanel;

public class UpdateNotificationDialog
extends StandardCloseDialog {
    private final ServerProgramInformation programInformation;
    private final UpdateNotificationPanel panel = new UpdateNotificationPanel();
    private WebView browser;
    private WebEngine webEngine;

    public UpdateNotificationDialog(Frame owner, String title, ServerProgramInformation progInfo) {
        super(owner, title, true);
        this.programInformation = progInfo;
        this.setupDialogInformation();
        this.setupFxWebView();
        this.pack();
        GuiFunktionen.centerOnScreen(this, false);
    }

    private void setupFxWebView() {
        Platform.runLater(() -> {
            this.browser = new WebView();
            Scene scene = new Scene(this.browser);
            this.webEngine = this.browser.getEngine();
            this.webEngine.load("https://mediathekview.de/changelogs");
            this.panel.getFxPanel().setScene(scene);
        });
    }

    private void setupDialogInformation() {
        String label = "MediathekView " + this.programInformation.getVersion() + " ist verf\u00fcgbar - Sie haben Version " + Konstanten.MVVERSION;
        this.panel.getReleaseInfoLabel().setText(label);
    }

    @Override
    public JComponent createContentPanel() {
        return this.panel;
    }
}

