/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.concurrent;

import io.opentracing.Scope;
import io.opentracing.Tracer;
import io.opentracing.contrib.concurrent.TracedRunnable;
import java.util.concurrent.Executor;

public class TracedExecutor
implements Executor {
    protected final Tracer tracer;
    private final Executor delegate;
    private final boolean traceWithActiveSpanOnly;

    public TracedExecutor(Executor executor, Tracer tracer) {
        this(executor, tracer, true);
    }

    public TracedExecutor(Executor executor, Tracer tracer, boolean traceWithActiveSpanOnly) {
        this.delegate = executor;
        this.tracer = tracer;
        this.traceWithActiveSpanOnly = traceWithActiveSpanOnly;
    }

    @Override
    public void execute(Runnable runnable) {
        Scope scope = this.createScope("execute");
        try {
            this.delegate.execute(this.tracer.activeSpan() == null ? runnable : new TracedRunnable(runnable, this.tracer));
        }
        finally {
            if (scope != null) {
                scope.close();
            }
        }
    }

    Scope createScope(String operationName) {
        if (this.tracer.activeSpan() == null && !this.traceWithActiveSpanOnly) {
            return this.tracer.buildSpan(operationName).startActive(true);
        }
        return null;
    }
}

