/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.events;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.marshall.SerializeWith;
import org.keycloak.models.cache.infinispan.RealmCacheManager;
import org.keycloak.models.cache.infinispan.events.InvalidationEvent;
import org.keycloak.models.cache.infinispan.events.RealmCacheInvalidationEvent;

@SerializeWith(value=ExternalizerImpl.class)
public class RealmUpdatedEvent
extends InvalidationEvent
implements RealmCacheInvalidationEvent {
    private String realmId;
    private String realmName;

    public static RealmUpdatedEvent create(String realmId, String realmName) {
        RealmUpdatedEvent event = new RealmUpdatedEvent();
        event.realmId = realmId;
        event.realmName = realmName;
        return event;
    }

    @Override
    public String getId() {
        return this.realmId;
    }

    public String toString() {
        return String.format("RealmUpdatedEvent [ realmId=%s, realmName=%s ]", this.realmId, this.realmName);
    }

    @Override
    public void addInvalidations(RealmCacheManager realmCache, Set<String> invalidations) {
        realmCache.realmUpdated(this.realmId, this.realmName, invalidations);
    }

    public static class ExternalizerImpl
    implements Externalizer<RealmUpdatedEvent> {
        private static final int VERSION_1 = 1;

        public void writeObject(ObjectOutput output, RealmUpdatedEvent obj) throws IOException {
            output.writeByte(1);
            MarshallUtil.marshallString((String)obj.realmId, (ObjectOutput)output);
            MarshallUtil.marshallString((String)obj.realmName, (ObjectOutput)output);
        }

        public RealmUpdatedEvent readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            switch (input.readByte()) {
                case 1: {
                    return this.readObjectVersion1(input);
                }
            }
            throw new IOException("Unknown version");
        }

        public RealmUpdatedEvent readObjectVersion1(ObjectInput input) throws IOException, ClassNotFoundException {
            RealmUpdatedEvent res = new RealmUpdatedEvent();
            res.realmId = MarshallUtil.unmarshallString((ObjectInput)input);
            res.realmName = MarshallUtil.unmarshallString((ObjectInput)input);
            return res;
        }
    }
}

