/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.client.admin.cli.commands;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.jboss.aesh.cl.Arguments;
import org.jboss.aesh.cl.Option;
import org.jboss.aesh.console.command.Command;
import org.keycloak.client.admin.cli.aesh.Globals;
import org.keycloak.client.admin.cli.commands.KcAdmCmd;
import org.keycloak.client.admin.cli.util.FilterUtil;
import org.keycloak.client.admin.cli.util.HttpUtil;
import org.keycloak.client.admin.cli.util.IoUtil;
import org.keycloak.client.admin.cli.util.ReturnFields;

public abstract class AbstractGlobalOptionsCmd
implements Command {
    @Option(shortName=120, description="Print full stack trace when exiting with error", hasValue=false)
    boolean dumpTrace;
    @Option(name="help", description="Print command specific help", hasValue=false)
    boolean help;
    @Arguments
    List<String> args;

    protected void initFromParent(AbstractGlobalOptionsCmd parent) {
        this.dumpTrace = parent.dumpTrace;
        this.help = parent.help;
        this.args = parent.args;
    }

    protected void processGlobalOptions() {
        Globals.dumpTrace = this.dumpTrace;
    }

    protected boolean printHelp() {
        if (this.help || this.nothingToDo()) {
            IoUtil.printOut(this.help());
            return true;
        }
        return false;
    }

    protected boolean nothingToDo() {
        return false;
    }

    protected String help() {
        return KcAdmCmd.usage();
    }

    protected String composeAdminRoot(String server) {
        return HttpUtil.normalize(server) + "admin";
    }

    protected void requireValue(Iterator<String> it, String option) {
        if (!it.hasNext()) {
            throw new IllegalArgumentException("Option " + option + " requires a value");
        }
    }

    protected String extractTypeNameFromUri(String resourceUrl) {
        String type = this.extractLastComponentOfUri(resourceUrl);
        if (type.endsWith("s")) {
            type = type.substring(0, type.length() - 1);
        }
        return type;
    }

    protected String extractLastComponentOfUri(String resourceUrl) {
        int endPos = resourceUrl.endsWith("/") ? resourceUrl.length() - 2 : resourceUrl.length() - 1;
        int pos = resourceUrl.lastIndexOf("/", endPos);
        pos = pos == -1 ? 0 : pos;
        return resourceUrl.substring(pos + 1, endPos + 1);
    }

    protected JsonNode applyFieldFilter(ObjectMapper mapper, JsonNode rootNode, ReturnFields returnFields) {
        try {
            return FilterUtil.copyFilteredObject(rootNode, returnFields);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to apply fields filter", e);
        }
    }
}

