/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan;

import java.util.List;
import org.wildfly.clustering.ejb.infinispan.ImmutableBeanEntry;
import org.wildfly.clustering.ejb.infinispan.Scheduler;
import org.wildfly.clustering.infinispan.spi.distribution.Locality;

public class CompositeScheduler<I>
implements Scheduler<I> {
    private final List<Scheduler<I>> schedulers;

    public CompositeScheduler(List<Scheduler<I>> schedulers) {
        this.schedulers = schedulers;
    }

    @Override
    public void schedule(I id) {
        for (Scheduler<I> scheduler : this.schedulers) {
            scheduler.schedule(id);
        }
    }

    @Override
    public void schedule(I id, ImmutableBeanEntry<I> entry) {
        for (Scheduler<I> scheduler : this.schedulers) {
            scheduler.schedule(id, entry);
        }
    }

    @Override
    public void prepareRescheduling(I id) {
        for (Scheduler<I> scheduler : this.schedulers) {
            scheduler.prepareRescheduling(id);
        }
    }

    @Override
    public void cancel(I id) {
        for (Scheduler<I> scheduler : this.schedulers) {
            scheduler.cancel(id);
        }
    }

    @Override
    public void cancel(Locality locality) {
        for (Scheduler<I> scheduler : this.schedulers) {
            scheduler.cancel(locality);
        }
    }

    @Override
    public void close() {
        for (Scheduler<I> scheduler : this.schedulers) {
            scheduler.close();
        }
    }
}

