/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah;

import com.googlecode.javaewah.RunningLengthWord;

public final class BufferedRunningLengthWord
implements Cloneable {
    protected int literalWordOffset = 0;
    protected int numberOfLiteralWords;
    protected boolean runningBit;
    protected long runningLength;

    public BufferedRunningLengthWord(long a) {
        this.numberOfLiteralWords = (int)(a >>> 33);
        this.runningBit = (a & 1L) != 0L;
        this.runningLength = (int)(a >>> 1 & 0xFFFFFFFFL);
    }

    public BufferedRunningLengthWord(RunningLengthWord rlw) {
        this(rlw.buffer.getWord(rlw.position));
    }

    public void discardFirstWords(long x) {
        if (this.runningLength >= x) {
            this.runningLength -= x;
            return;
        }
        this.runningLength = 0L;
        this.literalWordOffset = (int)((long)this.literalWordOffset + (x -= this.runningLength));
        this.numberOfLiteralWords = (int)((long)this.numberOfLiteralWords - x);
    }

    public int getNumberOfLiteralWords() {
        return this.numberOfLiteralWords;
    }

    public boolean getRunningBit() {
        return this.runningBit;
    }

    public long getRunningLength() {
        return this.runningLength;
    }

    public void reset(long a) {
        this.numberOfLiteralWords = (int)(a >>> 33);
        this.runningBit = (a & 1L) != 0L;
        this.runningLength = (int)(a >>> 1 & 0xFFFFFFFFL);
        this.literalWordOffset = 0;
    }

    public void reset(RunningLengthWord rlw) {
        this.reset(rlw.buffer.getWord(rlw.position));
    }

    public void setNumberOfLiteralWords(int number) {
        this.numberOfLiteralWords = number;
    }

    public void setRunningBit(boolean b) {
        this.runningBit = b;
    }

    public void setRunningLength(long number) {
        this.runningLength = number;
    }

    public long size() {
        return this.runningLength + (long)this.numberOfLiteralWords;
    }

    public String toString() {
        return "running bit = " + this.getRunningBit() + " running length = " + this.getRunningLength() + " number of lit. words " + this.getNumberOfLiteralWords();
    }

    public BufferedRunningLengthWord clone() throws CloneNotSupportedException {
        BufferedRunningLengthWord answer = (BufferedRunningLengthWord)super.clone();
        answer.literalWordOffset = this.literalWordOffset;
        answer.numberOfLiteralWords = this.numberOfLiteralWords;
        answer.runningBit = this.runningBit;
        answer.runningLength = this.runningLength;
        return answer;
    }
}

