/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.infinispan.client.manager;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.transaction.TransactionManager;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.NearCacheConfiguration;
import org.infinispan.client.hotrod.configuration.TransactionMode;
import org.infinispan.client.hotrod.event.impl.ClientListenerNotifier;
import org.infinispan.client.hotrod.near.NearCacheService;
import org.wildfly.clustering.Registrar;
import org.wildfly.clustering.infinispan.client.RegisteredRemoteCache;
import org.wildfly.clustering.infinispan.client.RemoteCacheContainer;

public class RemoteCacheManager
extends org.infinispan.client.hotrod.RemoteCacheManager
implements RemoteCacheContainer {
    private final Map<String, Function<ClientListenerNotifier, NearCacheService<?, ?>>> nearCacheFactories = new ConcurrentHashMap();
    private final String name;
    private final Registrar<String> registrar;

    public RemoteCacheManager(String name, Configuration configuration, Registrar<String> registrar) {
        super(configuration, false);
        this.name = name;
        this.registrar = registrar;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public <K, V> RemoteCache<K, V> getCache(String cacheName, boolean forceReturnValue, TransactionMode transactionMode, TransactionManager transactionManager) {
        return new RegisteredRemoteCache(this, super.getCache(cacheName, forceReturnValue, transactionMode, transactionManager), this.registrar);
    }

    @Override
    public <K, V> RemoteCacheContainer.NearCacheRegistration registerNearCacheFactory(final String cacheName, Function<ClientListenerNotifier, NearCacheService<K, V>> factory) {
        final Map<String, Function<ClientListenerNotifier, NearCacheService<?, ?>>> factories = this.nearCacheFactories;
        factories.put(cacheName, factory);
        return new RemoteCacheContainer.NearCacheRegistration(){

            @Override
            public void close() {
                factories.remove(cacheName);
            }
        };
    }

    protected <K, V> NearCacheService<K, V> createNearCacheService(String cacheName, NearCacheConfiguration config) {
        Function<ClientListenerNotifier, NearCacheService<?, ?>> factory = cacheName != null ? this.nearCacheFactories.get(cacheName) : null;
        return factory != null ? factory.apply(this.listenerNotifier) : super.createNearCacheService(cacheName, config);
    }
}

