/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.crypto;

import java.io.UnsupportedEncodingException;
import org.keycloak.crypto.HashException;
import org.keycloak.provider.Provider;

public interface HashProvider
extends Provider {
    default public byte[] hash(String input) throws HashException {
        try {
            byte[] inputBytes = input.getBytes("UTF-8");
            return this.hash(inputBytes);
        }
        catch (UnsupportedEncodingException e) {
            throw new HashException("Unsupported encoding when trying to hash", (Throwable)e);
        }
    }

    public byte[] hash(byte[] var1) throws HashException;

    default public void close() {
    }
}

