/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml.common.constants;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;

public enum JBossSAMLConstants {
    ARTIFACT(JBossSAMLURIConstants.PROTOCOL_NSURI, "Artifact"),
    ARTIFACT_RESOLVE(JBossSAMLURIConstants.PROTOCOL_NSURI, "ArtifactResolve"),
    ARTIFACT_RESPONSE(JBossSAMLURIConstants.PROTOCOL_NSURI, "ArtifactResponse"),
    ASSERTION_ID_REQUEST(JBossSAMLURIConstants.PROTOCOL_NSURI, "AssertionIDRequest"),
    ATTRIBUTE_QUERY(JBossSAMLURIConstants.PROTOCOL_NSURI, "AttributeQuery"),
    AUTHN_QUERY(JBossSAMLURIConstants.PROTOCOL_NSURI, "AuthnQuery"),
    AUTHN_REQUEST(JBossSAMLURIConstants.PROTOCOL_NSURI, "AuthnRequest"),
    AUTHZ_DECISION_QUERY(JBossSAMLURIConstants.PROTOCOL_NSURI, "AuthzDecisionQuery"),
    EXTENSIONS__PROTOCOL(JBossSAMLURIConstants.PROTOCOL_NSURI, "Extensions"),
    GET_COMPLETE(JBossSAMLURIConstants.PROTOCOL_NSURI, "GetComplete"),
    IDP_ENTRY(JBossSAMLURIConstants.PROTOCOL_NSURI, "IDPEntry"),
    IDP_LIST(JBossSAMLURIConstants.PROTOCOL_NSURI, "IDPList"),
    LOGOUT_REQUEST(JBossSAMLURIConstants.PROTOCOL_NSURI, "LogoutRequest"),
    LOGOUT_RESPONSE(JBossSAMLURIConstants.PROTOCOL_NSURI, "LogoutResponse"),
    MANAGE_NAMEID_REQUEST(JBossSAMLURIConstants.PROTOCOL_NSURI, "ManageNameIDRequest"),
    MANAGE_NAMEID_RESPONSE(JBossSAMLURIConstants.PROTOCOL_NSURI, "ManageNameIDResponse"),
    NAMEID_MAPPING_REQUEST(JBossSAMLURIConstants.PROTOCOL_NSURI, "NameIDMappingRequest"),
    NAMEID_MAPPING_RESPONSE(JBossSAMLURIConstants.PROTOCOL_NSURI, "NameIDMappingResponse"),
    NAMEID_POLICY(JBossSAMLURIConstants.PROTOCOL_NSURI, "NameIDPolicy"),
    NEW_ENCRYPTEDID(JBossSAMLURIConstants.PROTOCOL_NSURI, "NewEncryptedID"),
    NEWID(JBossSAMLURIConstants.PROTOCOL_NSURI, "NewID"),
    REQUESTED_AUTHN_CONTEXT(JBossSAMLURIConstants.PROTOCOL_NSURI, "RequestedAuthnContext"),
    REQUESTERID(JBossSAMLURIConstants.PROTOCOL_NSURI, "RequesterID"),
    RESPONSE__PROTOCOL(JBossSAMLURIConstants.PROTOCOL_NSURI, "Response"),
    SCOPING(JBossSAMLURIConstants.PROTOCOL_NSURI, "Scoping"),
    SESSION_INDEX(JBossSAMLURIConstants.PROTOCOL_NSURI, "SessionIndex"),
    STATUS_CODE(JBossSAMLURIConstants.PROTOCOL_NSURI, "StatusCode"),
    STATUS_DETAIL(JBossSAMLURIConstants.PROTOCOL_NSURI, "StatusDetail"),
    STATUS_MESSAGE(JBossSAMLURIConstants.PROTOCOL_NSURI, "StatusMessage"),
    STATUS(JBossSAMLURIConstants.PROTOCOL_NSURI, "Status"),
    SUBJECT_QUERY(JBossSAMLURIConstants.PROTOCOL_NSURI, "SubjectQuery"),
    TERMINATE(JBossSAMLURIConstants.PROTOCOL_NSURI, "Terminate"),
    ACTION(JBossSAMLURIConstants.ASSERTION_NSURI, "Action"),
    ADVICE(JBossSAMLURIConstants.ASSERTION_NSURI, "Advice"),
    ASSERTION(JBossSAMLURIConstants.ASSERTION_NSURI, "Assertion"),
    ASSERTION_ID_REF(JBossSAMLURIConstants.ASSERTION_NSURI, "AssertionIDRef"),
    ASSERTION_URI_REF(JBossSAMLURIConstants.ASSERTION_NSURI, "AssertionURIRef"),
    ATTRIBUTE(JBossSAMLURIConstants.ASSERTION_NSURI, "Attribute"),
    ATTRIBUTE_STATEMENT(JBossSAMLURIConstants.ASSERTION_NSURI, "AttributeStatement"),
    ATTRIBUTE_VALUE(JBossSAMLURIConstants.ASSERTION_NSURI, "AttributeValue"),
    AUDIENCE(JBossSAMLURIConstants.ASSERTION_NSURI, "Audience"),
    AUDIENCE_RESTRICTION(JBossSAMLURIConstants.ASSERTION_NSURI, "AudienceRestriction"),
    AUTHENTICATING_AUTHORITY(JBossSAMLURIConstants.ASSERTION_NSURI, "AuthenticatingAuthority"),
    AUTHN_CONTEXT(JBossSAMLURIConstants.ASSERTION_NSURI, "AuthnContext"),
    AUTHN_CONTEXT_CLASS_REF(JBossSAMLURIConstants.ASSERTION_NSURI, "AuthnContextClassRef"),
    AUTHN_CONTEXT_DECL(JBossSAMLURIConstants.ASSERTION_NSURI, "AuthnContextDecl"),
    AUTHN_CONTEXT_DECL_REF(JBossSAMLURIConstants.ASSERTION_NSURI, "AuthnContextDeclRef"),
    AUTHN_STATEMENT(JBossSAMLURIConstants.ASSERTION_NSURI, "AuthnStatement"),
    AUTHZ_DECISION_STATEMENT(JBossSAMLURIConstants.ASSERTION_NSURI, "AuthzDecisionStatement"),
    BASEID(JBossSAMLURIConstants.ASSERTION_NSURI, "BaseID"),
    CONDITION(JBossSAMLURIConstants.ASSERTION_NSURI, "Condition"),
    CONDITIONS(JBossSAMLURIConstants.ASSERTION_NSURI, "Conditions"),
    ENCRYPTED_ASSERTION(JBossSAMLURIConstants.ASSERTION_NSURI, "EncryptedAssertion"),
    ENCRYPTED_ATTRIBUTE(JBossSAMLURIConstants.ASSERTION_NSURI, "EncryptedAttribute"),
    ENCRYPTED_ID(JBossSAMLURIConstants.ASSERTION_NSURI, "EncryptedID"),
    EVIDENCE(JBossSAMLURIConstants.ASSERTION_NSURI, "Evidence"),
    ISSUER(JBossSAMLURIConstants.ASSERTION_NSURI, "Issuer"),
    NAMEID(JBossSAMLURIConstants.ASSERTION_NSURI, "NameID"),
    ONE_TIME_USE(JBossSAMLURIConstants.ASSERTION_NSURI, "OneTimeUse"),
    PROXY_RESTRICTION(JBossSAMLURIConstants.ASSERTION_NSURI, "ProxyRestriction"),
    STATEMENT(JBossSAMLURIConstants.ASSERTION_NSURI, "Statement"),
    SUBJECT_CONFIRMATION_DATA(JBossSAMLURIConstants.ASSERTION_NSURI, "SubjectConfirmationData"),
    SUBJECT_CONFIRMATION(JBossSAMLURIConstants.ASSERTION_NSURI, "SubjectConfirmation"),
    SUBJECT_LOCALITY(JBossSAMLURIConstants.ASSERTION_NSURI, "SubjectLocality"),
    SUBJECT(JBossSAMLURIConstants.ASSERTION_NSURI, "Subject"),
    ADDITIONAL_METADATA_LOCATION(JBossSAMLURIConstants.METADATA_NSURI, "AdditionalMetadataLocation"),
    AFFILIATE_MEMBER(JBossSAMLURIConstants.METADATA_NSURI, "AffiliateMember"),
    AFFILIATION_DESCRIPTOR(JBossSAMLURIConstants.METADATA_NSURI, "AffiliationDescriptor"),
    ARTIFACT_RESOLUTION_SERVICE(JBossSAMLURIConstants.METADATA_NSURI, "ArtifactResolutionService"),
    ASSERTION_CONSUMER_SERVICE(JBossSAMLURIConstants.METADATA_NSURI, "AssertionConsumerService"),
    ASSERTION_ID_REQUEST_SERVICE(JBossSAMLURIConstants.METADATA_NSURI, "AssertionIDRequestService"),
    ATTRIBUTE_AUTHORITY_DESCRIPTOR(JBossSAMLURIConstants.METADATA_NSURI, "AttributeAuthorityDescriptor"),
    ATTRIBUTE_CONSUMING_SERVICE(JBossSAMLURIConstants.METADATA_NSURI, "AttributeConsumingService"),
    ATTRIBUTE_PROFILE(JBossSAMLURIConstants.METADATA_NSURI, "AttributeProfile"),
    ATTRIBUTE_SERVICE(JBossSAMLURIConstants.METADATA_NSURI, "AttributeService"),
    AUTHN_AUTHORITY_DESCRIPTOR(JBossSAMLURIConstants.METADATA_NSURI, "AuthnAuthorityDescriptor"),
    AUTHN_QUERY_SERVICE(JBossSAMLURIConstants.METADATA_NSURI, "AuthnQueryService"),
    AUTHZ_SERVICE(JBossSAMLURIConstants.METADATA_NSURI, "AuthzService"),
    COMPANY(JBossSAMLURIConstants.METADATA_NSURI, "Company"),
    CONTACT_PERSON(JBossSAMLURIConstants.METADATA_NSURI, "ContactPerson"),
    EMAIL_ADDRESS(JBossSAMLURIConstants.METADATA_NSURI, "EmailAddress"),
    ENCRYPTION_METHOD(JBossSAMLURIConstants.METADATA_NSURI, "EncryptionMethod"),
    ENTITIES_DESCRIPTOR(JBossSAMLURIConstants.METADATA_NSURI, "EntitiesDescriptor"),
    ENTITY_DESCRIPTOR(JBossSAMLURIConstants.METADATA_NSURI, "EntityDescriptor"),
    EXTENSIONS__METADATA(JBossSAMLURIConstants.METADATA_NSURI, "Extensions"),
    GIVEN_NAME(JBossSAMLURIConstants.METADATA_NSURI, "GivenName"),
    IDP_SSO_DESCRIPTOR(JBossSAMLURIConstants.METADATA_NSURI, "IDPSSODescriptor"),
    KEY_DESCRIPTOR(JBossSAMLURIConstants.METADATA_NSURI, "KeyDescriptor"),
    MANAGE_NAMEID_SERVICE(JBossSAMLURIConstants.METADATA_NSURI, "ManageNameIDService"),
    NAMEID_FORMAT(JBossSAMLURIConstants.METADATA_NSURI, "NameIDFormat"),
    NAMEID_MAPPING_SERVICE(JBossSAMLURIConstants.METADATA_NSURI, "NameIDMappingService"),
    ORGANIZATION_DISPLAY_NAME(JBossSAMLURIConstants.METADATA_NSURI, "OrganizationDisplayName"),
    ORGANIZATION_NAME(JBossSAMLURIConstants.METADATA_NSURI, "OrganizationName"),
    ORGANIZATION(JBossSAMLURIConstants.METADATA_NSURI, "Organization"),
    ORGANIZATION_URL(JBossSAMLURIConstants.METADATA_NSURI, "OrganizationURL"),
    ORGANIZATION_URL_ALT(JBossSAMLURIConstants.METADATA_NSURI, "OrganizationUrl"),
    PDP_DESCRIPTOR(JBossSAMLURIConstants.METADATA_NSURI, "PDPDescriptor"),
    REQUESTED_ATTRIBUTE(JBossSAMLURIConstants.METADATA_NSURI, "RequestedAttribute"),
    ROLE_DESCRIPTOR(JBossSAMLURIConstants.METADATA_NSURI, "RoleDescriptor"),
    SERVICE_DESCRIPTION(JBossSAMLURIConstants.METADATA_NSURI, "ServiceDescription"),
    SERVICE_NAME(JBossSAMLURIConstants.METADATA_NSURI, "ServiceName"),
    SINGLE_LOGOUT_SERVICE(JBossSAMLURIConstants.METADATA_NSURI, "SingleLogoutService"),
    SINGLE_SIGNON_SERVICE(JBossSAMLURIConstants.METADATA_NSURI, "SingleSignOnService"),
    SP_SSO_DESCRIPTOR(JBossSAMLURIConstants.METADATA_NSURI, "SPSSODescriptor"),
    SURNAME(JBossSAMLURIConstants.METADATA_NSURI, "SurName"),
    TELEPHONE_NUMBER(JBossSAMLURIConstants.METADATA_NSURI, "TelephoneNumber"),
    RELAY_STATE(JBossSAMLURIConstants.ECP_PROFILE, "RelayState"),
    REQUEST(JBossSAMLURIConstants.ECP_PROFILE, "Request"),
    RESPONSE__ECP(JBossSAMLURIConstants.ECP_PROFILE, "Response"),
    SIGNATURE(JBossSAMLURIConstants.XMLDSIG_NSURI, "Signature"),
    DSA_KEY_VALUE(JBossSAMLURIConstants.XMLDSIG_NSURI, "DSAKeyValue"),
    KEY_INFO(JBossSAMLURIConstants.XMLDSIG_NSURI, "KeyInfo"),
    KEY_VALUE(JBossSAMLURIConstants.XMLDSIG_NSURI, "KeyValue"),
    RSA_KEY_VALUE(JBossSAMLURIConstants.XMLDSIG_NSURI, "RSAKeyValue"),
    X509_CERT(JBossSAMLURIConstants.XMLDSIG_NSURI, "X509Certificate"),
    X509_DATA(JBossSAMLURIConstants.XMLDSIG_NSURI, "X509Data"),
    ADDRESS("Address"),
    ALLOW_CREATE("AllowCreate"),
    ASSERTION_CONSUMER_SERVICE_URL("AssertionConsumerServiceURL"),
    ASSERTION_CONSUMER_SERVICE_INDEX("AssertionConsumerServiceIndex"),
    ATTRIBUTE_CONSUMING_SERVICE_INDEX("AttributeConsumingServiceIndex"),
    AUTHN_INSTANT("AuthnInstant"),
    AUTHN_REQUESTS_SIGNED("AuthnRequestsSigned"),
    BINDING("Binding"),
    CACHE_DURATION("cacheDuration"),
    COMPARISON("Comparison"),
    CONSENT("Consent"),
    CONTACT_TYPE("contactType"),
    DESTINATION("Destination"),
    DNS_NAME("DNSName"),
    ENCODING("Encoding"),
    ENCRYPTED_KEY("EncryptedKey"),
    ENTITY_ID("entityID"),
    FORMAT("Format"),
    FRIENDLY_NAME("FriendlyName"),
    FORCE_AUTHN("ForceAuthn"),
    ID("ID"),
    INDEX("index"),
    INPUT_CONTEXT_ONLY("InputContextOnly"),
    IN_RESPONSE_TO("InResponseTo"),
    ISDEFAULT("isDefault"),
    IS_REQUIRED("isRequired"),
    IS_PASSIVE("IsPassive"),
    ISSUE_INSTANT("IssueInstant"),
    LOCATION("Location"),
    METHOD("Method"),
    NAME("Name"),
    NAME_FORMAT("NameFormat"),
    NAME_QUALIFIER("NameQualifier"),
    NOT_BEFORE("NotBefore"),
    NOT_ON_OR_AFTER("NotOnOrAfter"),
    PROTOCOL_BINDING("ProtocolBinding"),
    PROTOCOL_SUPPORT_ENUMERATION("protocolSupportEnumeration"),
    PROVIDER_NAME("ProviderName"),
    REASON("Reason"),
    RECIPIENT("Recipient"),
    REQUEST_ABSTRACT("RequestAbstract"),
    RESPONSE_LOCATION("ResponseLocation"),
    RETURN_CONTEXT("ReturnContext"),
    SP_PROVIDED_ID("SPProvidedID"),
    SP_NAME_QUALIFIER("SPNameQualifier"),
    STATUS_RESPONSE_TYPE("StatusResponseType"),
    TYPE("type"),
    USE("use"),
    VALUE("Value"),
    VALID_UNTIL("validUntil"),
    VERSION("Version"),
    WANT_AUTHN_REQUESTS_SIGNED("WantAuthnRequestsSigned"),
    WANT_ASSERTIONS_SIGNED("WantAssertionsSigned"),
    XACML_AUTHZ_DECISION_QUERY("XACMLAuthzDecisionQuery"),
    XACML_AUTHZ_DECISION_QUERY_TYPE("XACMLAuthzDecisionQueryType"),
    XACML_AUTHZ_DECISION_STATEMENT_TYPE("XACMLAuthzDecisionStatementType"),
    REQUEST_AUTHENTICATED("RequestAuthenticated"),
    UNSOLICITED_RESPONSE_TARGET("TARGET"),
    UNSOLICITED_RESPONSE_SAML_VERSION("SAML_VERSION"),
    UNSOLICITED_RESPONSE_SAML_BINDING("SAML_BINDING"),
    LANG("lang"),
    LANG_EN("en"),
    METADATA_MIME("application/samlmetadata+xml"),
    SIGNATURE_SHA1_WITH_DSA("http://www.w3.org/2000/09/xmldsig#dsa-sha1"),
    SIGNATURE_SHA1_WITH_RSA("http://www.w3.org/2000/09/xmldsig#rsa-sha1"),
    VERSION_2_0("2.0"),
    RESPONSE("Response"),
    EXTENSIONS("Extensions"),
    UNKNOWN_VALUE(null);

    private final QName asQName;
    private final JBossSAMLURIConstants nsUri;
    private static final ReverseLookup REVERSE_LOOKUP;

    private JBossSAMLConstants(String name) {
        this.asQName = name == null ? null : new QName(name);
        this.nsUri = null;
    }

    private JBossSAMLConstants(JBossSAMLURIConstants namespaceUri, String name) {
        this.nsUri = namespaceUri;
        this.asQName = name == null ? null : new QName(namespaceUri.get(), name);
    }

    public String get() {
        return this.asQName == null ? null : this.asQName.getLocalPart();
    }

    public QName getAsQName() {
        return this.asQName;
    }

    public JBossSAMLURIConstants getNsUri() {
        return this.nsUri;
    }

    public static JBossSAMLConstants from(String key, JBossSAMLConstants defaultValue) {
        JBossSAMLConstants res = REVERSE_LOOKUP.from(key);
        return res == null ? defaultValue : res;
    }

    public static JBossSAMLConstants from(String key) {
        return JBossSAMLConstants.from(key, UNKNOWN_VALUE);
    }

    public static JBossSAMLConstants from(QName name) {
        JBossSAMLConstants res = REVERSE_LOOKUP.from(name);
        return res == null ? UNKNOWN_VALUE : res;
    }

    static {
        REVERSE_LOOKUP = new ReverseLookup();
    }

    private static class ReverseLookup {
        private static final Map<QName, JBossSAMLConstants> QNAME_CONSTANTS;
        private static final Map<String, JBossSAMLConstants> CONSTANTS;

        private ReverseLookup() {
        }

        public JBossSAMLConstants from(String key) {
            return CONSTANTS.get(key);
        }

        public JBossSAMLConstants from(QName key) {
            return QNAME_CONSTANTS.get(key);
        }

        static {
            HashMap<QName, JBossSAMLConstants> q = new HashMap<QName, JBossSAMLConstants>(JBossSAMLConstants.values().length);
            HashMap<String, JBossSAMLConstants> m = new HashMap<String, JBossSAMLConstants>(JBossSAMLConstants.values().length);
            for (JBossSAMLConstants c : JBossSAMLConstants.values()) {
                JBossSAMLConstants old = q.put(c.getAsQName(), c);
                if (old != null) {
                    throw new IllegalStateException("Same name " + c.getAsQName() + " used for two distinct constants: " + (Object)((Object)c) + ", " + (Object)((Object)old));
                }
                String key = c.get();
                old = m.put(key, c);
                if (old == null) continue;
                if (old != null && c.getAsQName().equals(old.getAsQName())) {
                    throw new IllegalStateException("Same name " + key + " used for two distinct constants: " + (Object)((Object)c) + ", " + (Object)((Object)old));
                }
                m.put(key, null);
            }
            QNAME_CONSTANTS = Collections.unmodifiableMap(q);
            CONSTANTS = Collections.unmodifiableMap(m);
        }
    }
}

