/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.conduits;

import io.undertow.util.WorkerUtils;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeUnit;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.AbstractStreamSinkConduit;
import org.xnio.conduits.StreamSinkConduit;

public class RateLimitingStreamSinkConduit
extends AbstractStreamSinkConduit<StreamSinkConduit> {
    private final long time;
    private final int bytes;
    private boolean writesResumed = false;
    private int byteCount = 0;
    private long startTime = 0L;
    private long nextSendTime = 0L;
    private boolean scheduled = false;

    public RateLimitingStreamSinkConduit(StreamSinkConduit next, int bytes, long time, TimeUnit timeUnit) {
        super(next);
        this.writesResumed = next.isWriteResumed();
        this.time = timeUnit.toMillis(time);
        this.bytes = bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(ByteBuffer src) throws IOException {
        if (!this.canSend()) {
            return 0;
        }
        int bytes = this.bytes - this.byteCount;
        int old = src.limit();
        if (src.remaining() > bytes) {
            src.limit(src.position() + bytes);
        }
        try {
            int written = super.write(src);
            this.handleWritten(written);
            int n = written;
            return n;
        }
        finally {
            src.limit(old);
        }
    }

    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        if (!this.canSend()) {
            return 0L;
        }
        int bytes = this.bytes - this.byteCount;
        long written = super.transferFrom(src, position, Math.min(count, (long)bytes));
        this.handleWritten(written);
        return written;
    }

    public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
        if (!this.canSend()) {
            return 0L;
        }
        int bytes = this.bytes - this.byteCount;
        long written = super.transferFrom(source, Math.min(count, (long)bytes), throughBuffer);
        this.handleWritten(written);
        return written;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long write(ByteBuffer[] srcs, int offs, int len) throws IOException {
        if (!this.canSend()) {
            return 0L;
        }
        int old = 0;
        int adjPos = -1;
        long rem = this.bytes - this.byteCount;
        for (int i = offs; i < offs + len; ++i) {
            ByteBuffer buf = srcs[i];
            if ((rem -= (long)buf.remaining()) >= 0L) continue;
            adjPos = i;
            old = buf.limit();
            buf.limit((int)((long)buf.limit() + rem));
            break;
        }
        try {
            long written = adjPos == -1 ? super.write(srcs, offs, len) : super.write(srcs, offs, adjPos - offs + 1);
            this.handleWritten(written);
            long l = written;
            return l;
        }
        finally {
            if (adjPos != -1) {
                ByteBuffer buf = srcs[adjPos];
                buf.limit(old);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int writeFinal(ByteBuffer src) throws IOException {
        if (!this.canSend()) {
            return 0;
        }
        int bytes = this.bytes - this.byteCount;
        int old = src.limit();
        if (src.remaining() > bytes) {
            src.limit(src.position() + bytes);
        }
        try {
            int written = super.writeFinal(src);
            this.handleWritten(written);
            int n = written;
            return n;
        }
        finally {
            src.limit(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long writeFinal(ByteBuffer[] srcs, int offs, int len) throws IOException {
        if (!this.canSend()) {
            return 0L;
        }
        int old = 0;
        int adjPos = -1;
        long rem = this.bytes - this.byteCount;
        for (int i = offs; i < offs + len; ++i) {
            ByteBuffer buf = srcs[i];
            if ((rem -= (long)buf.remaining()) >= 0L) continue;
            adjPos = i;
            old = buf.limit();
            buf.limit((int)((long)buf.limit() + rem));
            break;
        }
        try {
            long written = adjPos == -1 ? super.writeFinal(srcs, offs, len) : super.writeFinal(srcs, offs, adjPos - offs + 1);
            this.handleWritten(written);
            long l = written;
            return l;
        }
        finally {
            if (adjPos != -1) {
                ByteBuffer buf = srcs[adjPos];
                buf.limit(old);
            }
        }
    }

    public void resumeWrites() {
        this.writesResumed = true;
        if (this.canSend()) {
            super.resumeWrites();
        }
    }

    public void suspendWrites() {
        this.writesResumed = false;
        super.suspendWrites();
    }

    public void wakeupWrites() {
        this.writesResumed = true;
        if (this.canSend()) {
            super.wakeupWrites();
        }
    }

    public boolean isWriteResumed() {
        return this.writesResumed;
    }

    public void awaitWritable() throws IOException {
        long toGo = this.nextSendTime - System.currentTimeMillis();
        if (toGo > 0L) {
            try {
                Thread.sleep(toGo);
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException();
            }
        }
        super.awaitWritable();
    }

    public void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
        long toGo = this.nextSendTime - System.currentTimeMillis();
        if (toGo > 0L) {
            try {
                Thread.sleep(Math.min(toGo, timeUnit.toMillis(time)));
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException();
            }
            return;
        }
        super.awaitWritable(time, timeUnit);
    }

    private boolean canSend() {
        if (this.byteCount < this.bytes) {
            return true;
        }
        if (System.currentTimeMillis() > this.nextSendTime) {
            this.byteCount = 0;
            this.startTime = 0L;
            this.nextSendTime = 0L;
            return true;
        }
        if (this.writesResumed) {
            this.handleWritesResumedWhenBlocked();
        }
        return false;
    }

    private void handleWritten(long written) {
        if (written == 0L) {
            return;
        }
        this.byteCount = (int)((long)this.byteCount + written);
        if (this.byteCount < this.bytes) {
            if (this.startTime == 0L) {
                this.startTime = System.currentTimeMillis();
                this.nextSendTime = System.currentTimeMillis() + this.time;
            }
        } else {
            if (this.startTime == 0L) {
                this.startTime = System.currentTimeMillis();
            }
            this.nextSendTime = this.startTime + this.time;
            if (this.writesResumed) {
                this.handleWritesResumedWhenBlocked();
            }
        }
    }

    private void handleWritesResumedWhenBlocked() {
        if (this.scheduled) {
            return;
        }
        this.scheduled = true;
        ((StreamSinkConduit)this.next).suspendWrites();
        long millis = this.nextSendTime - System.currentTimeMillis();
        WorkerUtils.executeAfter(this.getWriteThread(), new Runnable(){

            @Override
            public void run() {
                RateLimitingStreamSinkConduit.this.scheduled = false;
                if (RateLimitingStreamSinkConduit.this.writesResumed) {
                    ((StreamSinkConduit)RateLimitingStreamSinkConduit.this.next).wakeupWrites();
                }
            }
        }, millis, TimeUnit.MILLISECONDS);
    }
}

