/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.singleton;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.jboss.as.clustering.controller.Capability;
import org.jboss.as.clustering.controller.CapabilityServiceNameProvider;
import org.jboss.as.clustering.controller.CommonUnaryRequirement;
import org.jboss.as.clustering.controller.ResourceServiceConfigurator;
import org.jboss.as.clustering.dmr.ModelNodes;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.FunctionalService;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.singleton.SingletonElectionPolicy;
import org.wildfly.clustering.singleton.election.NamePreference;
import org.wildfly.clustering.singleton.election.Preference;
import org.wildfly.clustering.singleton.election.PreferredSingletonElectionPolicy;
import org.wildfly.extension.clustering.singleton.ElectionPolicyResourceDefinition;
import org.wildfly.extension.clustering.singleton.election.OutboundSocketBindingPreference;

public abstract class ElectionPolicyServiceConfigurator
extends CapabilityServiceNameProvider
implements ResourceServiceConfigurator,
Supplier<SingletonElectionPolicy>,
UnaryOperator<SingletonElectionPolicy> {
    private volatile List<Preference> preferences;
    private volatile List<Dependency> dependencies;

    protected ElectionPolicyServiceConfigurator(PathAddress address) {
        super((Capability)ElectionPolicyResourceDefinition.Capability.ELECTION_POLICY, address);
    }

    @Override
    public SingletonElectionPolicy apply(SingletonElectionPolicy policy) {
        return this.preferences.isEmpty() ? policy : new PreferredSingletonElectionPolicy(policy, this.preferences);
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        ServiceBuilder builder = target.addService(this.getServiceName());
        Consumer policy = builder.provides(new ServiceName[]{this.getServiceName()});
        for (Dependency dependency : this.dependencies) {
            dependency.register(builder);
        }
        FunctionalService service = new FunctionalService(policy, (Function)this, (Supplier)this);
        return builder.setInstance((Service)service);
    }

    public ServiceConfigurator configure(OperationContext context, ModelNode model) throws OperationFailedException {
        List socketBindingPreferences = ModelNodes.optionalList((ModelNode)ElectionPolicyResourceDefinition.Attribute.SOCKET_BINDING_PREFERENCES.resolveModelAttribute((ExpressionResolver)context, model)).orElse(Collections.emptyList());
        List namePreferences = ModelNodes.optionalList((ModelNode)ElectionPolicyResourceDefinition.Attribute.NAME_PREFERENCES.resolveModelAttribute((ExpressionResolver)context, model)).orElse(Collections.emptyList());
        ArrayList<Preference> preferences = new ArrayList<Preference>(socketBindingPreferences.size() + namePreferences.size());
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>(socketBindingPreferences.size());
        for (ModelNode preference : socketBindingPreferences) {
            ServiceSupplierDependency binding = new ServiceSupplierDependency(CommonUnaryRequirement.OUTBOUND_SOCKET_BINDING.getServiceName(context, preference.asString()));
            preferences.add(new OutboundSocketBindingPreference((Supplier<OutboundSocketBinding>)binding));
            dependencies.add((Dependency)binding);
        }
        for (ModelNode preference : namePreferences) {
            preferences.add((Preference)new NamePreference(preference.asString()));
        }
        this.dependencies = dependencies;
        this.preferences = preferences;
        return this;
    }
}

