/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.jboss.as.server.deployment.SetupAction;
import org.jboss.as.weld.ServiceNames;
import org.jboss.as.weld.WeldBootstrapService;
import org.jboss.as.weld.logging.WeldLogger;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StabilityMonitor;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.security.manager.WildFlySecurityManager;

public class WeldStartCompletionService
implements Service {
    public static final ServiceName SERVICE_NAME = ServiceNames.WELD_START_COMPLETION_SERVICE_NAME;
    private final Supplier<WeldBootstrapService> bootstrapSupplier;
    private final Supplier<ExecutorService> executorServiceSupplier;
    private final List<SetupAction> setupActions;
    private final ClassLoader classLoader;
    private final List<ServiceController> serviceControllers;
    private final AtomicBoolean runOnce = new AtomicBoolean();

    public WeldStartCompletionService(Supplier<WeldBootstrapService> bootstrapSupplier, Supplier<ExecutorService> executorServiceSupplier, List<SetupAction> setupActions, ClassLoader classLoader, List<ServiceController> serviceControllers) {
        this.bootstrapSupplier = bootstrapSupplier;
        this.executorServiceSupplier = executorServiceSupplier;
        this.setupActions = setupActions;
        this.classLoader = classLoader;
        this.serviceControllers = serviceControllers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(final StartContext context) throws StartException {
        if (!this.runOnce.compareAndSet(false, true)) {
            return;
        }
        ExecutorService executor = this.executorServiceSupplier.get();
        Runnable task = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                StabilityMonitor monitor = new StabilityMonitor();
                for (ServiceController controller : WeldStartCompletionService.this.serviceControllers) {
                    monitor.addController(controller);
                }
                try {
                    monitor.awaitStability();
                }
                catch (InterruptedException ex) {
                    context.failed(new StartException((Throwable)ex));
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(ex);
                }
                finally {
                    monitor.clear();
                }
                ClassLoader oldTccl = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
                try {
                    for (SetupAction action : WeldStartCompletionService.this.setupActions) {
                        action.setup(null);
                    }
                    WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)WeldStartCompletionService.this.classLoader);
                    ((WeldBootstrapService)WeldStartCompletionService.this.bootstrapSupplier.get()).getBootstrap().endInitialization();
                }
                finally {
                    for (SetupAction action : WeldStartCompletionService.this.setupActions) {
                        try {
                            action.teardown(null);
                        }
                        catch (Exception e) {
                            WeldLogger.DEPLOYMENT_LOGGER.exceptionClearingThreadState(e);
                        }
                    }
                    WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)oldTccl);
                    context.complete();
                }
            }
        };
        try {
            executor.execute(task);
        }
        catch (RejectedExecutionException e) {
            task.run();
        }
        finally {
            context.asynchronous();
        }
    }

    public void stop(StopContext context) {
    }
}

