/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.handlers.FilenameTabCompleter;
import org.jboss.as.cli.impl.BytesCompleter;
import org.jboss.as.cli.impl.DeploymentItemCompleter;
import org.jboss.as.cli.operation.OperationRequestAddress;
import org.jboss.as.cli.operation.impl.CapabilityReferenceCompleter;
import org.jboss.as.cli.operation.impl.DefaultOperationCandidatesProvider;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestAddress;
import org.jboss.as.cli.parsing.CharacterHandler;
import org.jboss.as.cli.parsing.DefaultParsingState;
import org.jboss.as.cli.parsing.GlobalCharacterHandlers;
import org.jboss.as.cli.parsing.ParsingContext;
import org.jboss.as.cli.parsing.ParsingStateCallbackHandler;
import org.jboss.as.cli.parsing.StateParser;
import org.jboss.as.cli.parsing.WordCharacterHandler;
import org.jboss.as.cli.parsing.arguments.ArgumentValueState;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.logging.Logger;

public class ValueTypeCompleter
implements CommandLineCompleter {
    private static final Logger LOG = Logger.getLogger(ValueTypeCompleter.class);
    private static final List<ModelNode> BOOLEAN_LIST = new ArrayList<ModelNode>(2);
    private final ModelNode propDescr;
    private Instance currentInstance;
    private CommandContext ctx;
    private final OperationRequestAddress address;
    private String buffer;
    private final CapabilityCompleterFactory factory;

    public ValueTypeCompleter(ModelNode propDescr) {
        this(propDescr, new DefaultOperationRequestAddress());
    }

    public ValueTypeCompleter(ModelNode propDescr, CapabilityCompleterFactory factory) {
        this(propDescr, new DefaultOperationRequestAddress(), factory);
    }

    public ValueTypeCompleter(ModelNode propDescr, OperationRequestAddress address) {
        this(propDescr, address, null);
    }

    public ValueTypeCompleter(ModelNode propDescr, OperationRequestAddress address, CapabilityCompleterFactory factory) {
        if (propDescr == null || !propDescr.isDefined()) {
            throw new IllegalArgumentException("property description is null or undefined.");
        }
        this.propDescr = propDescr;
        this.address = address;
        this.factory = factory == null ? (a, p) -> new CapabilityReferenceCompleter(a, p) : factory;
    }

    @Override
    public int complete(CommandContext ctx, String buffer, int cursor, List<String> candidates) {
        ValueTypeCallbackHandler handler;
        this.ctx = ctx;
        this.buffer = buffer;
        try {
            handler = this.parse(buffer);
        }
        catch (CommandFormatException e) {
            LOG.warn((Object)e.getLocalizedMessage(), e);
            return -1;
        }
        try {
            Collection<String> foundCandidates = handler.getCandidates(this.propDescr);
            if (foundCandidates.isEmpty()) {
                return -1;
            }
            candidates.addAll(foundCandidates);
            return handler.getCompletionIndex();
        }
        catch (RuntimeException ex) {
            LOG.warn((Object)ex.getLocalizedMessage(), ex);
            return -1;
        }
    }

    protected ValueTypeCallbackHandler parse(String line) throws CommandFormatException {
        ValueTypeCallbackHandler valueTypeHandler = new ValueTypeCallbackHandler(false);
        StateParser.parse(line, valueTypeHandler, InitialValueState.INSTANCE);
        return valueTypeHandler;
    }

    private static boolean typeEquals(ModelNode mn, ModelType type) {
        ModelType mt;
        try {
            mt = mn.asType();
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
        return mt.equals((Object)type);
    }

    private static boolean isObject(ModelNode mn) {
        try {
            mn.asType();
        }
        catch (IllegalArgumentException ex) {
            return true;
        }
        return false;
    }

    static {
        BOOLEAN_LIST.add(new ModelNode(Boolean.FALSE));
        BOOLEAN_LIST.add(new ModelNode(Boolean.TRUE));
    }

    public static class TextState
    extends ValueTypeCandidatesState {
        public static final String ID = "TEXT";
        public static final TextState INSTANCE = new TextState();

        public TextState() {
            super(ID);
            this.setHandleEntrance(true);
            this.setDefaultHandler(WordCharacterHandler.IGNORE_LB_ESCAPE_ON);
            this.leaveState(',');
            this.leaveState('=');
            this.leaveState('}');
            this.leaveState(']');
        }
    }

    public static class BytesState
    extends DefaultParsingState {
        public static final String ID = "BYTES_VALUE";
        public static final BytesState INSTANCE = new BytesState();

        public BytesState() {
            super(ID);
            this.setHandleEntrance(true);
            this.leaveState('}');
            this.setDefaultHandler(WordCharacterHandler.IGNORE_LB_ESCAPE_ON);
        }
    }

    public static class EqualsState
    extends ValueTypeCandidatesState {
        public static final String ID = "EQ";
        public static final EqualsState INSTANCE = new EqualsState();

        public EqualsState() {
            super(ID);
            this.setIgnoreWhitespaces(true);
            this.setDefaultHandler(new CharacterHandler(){

                @Override
                public void handle(ParsingContext ctx) throws CommandFormatException {
                    if (ctx.getCharacter() == 'b') {
                        int tokenLength = ArgumentValueState.getBytesToken(ctx);
                        if (tokenLength > 0) {
                            ctx.enterState(BytesState.INSTANCE);
                        } else {
                            ctx.enterState(TextState.INSTANCE);
                        }
                    } else {
                        ctx.enterState(TextState.INSTANCE);
                    }
                }
            });
            this.putHandler('>', GlobalCharacterHandlers.NOOP_CHARACTER_HANDLER);
            this.enterState('{', StartObjectState.INSTANCE);
            this.enterState('[', StartListState.INSTANCE);
            this.addCandidate("{");
            this.addCandidate("[");
            this.setReturnHandler(GlobalCharacterHandlers.LEAVE_STATE_HANDLER);
        }
    }

    public static class PropertyState
    extends DefaultParsingState
    implements ValueTypeCandidatesProvider {
        public static final String ID = "PROP";
        public static final PropertyState INSTANCE = new PropertyState();
        private final Collection<String> candidates = new ArrayList<String>(2);

        public PropertyState() {
            super(ID);
            this.setEnterHandler(new CharacterHandler(){

                @Override
                public void handle(ParsingContext ctx) throws CommandFormatException {
                    char ch = ctx.getCharacter();
                    CharacterHandler handler = this.getHandler(ch);
                    handler.handle(ctx);
                }
            });
            this.enterState('{', StartObjectState.INSTANCE);
            this.enterState('[', StartListState.INSTANCE);
            this.setDefaultHandler(WordCharacterHandler.IGNORE_LB_ESCAPE_ON);
            this.enterState('=', EqualsState.INSTANCE);
            this.setReturnHandler(new CharacterHandler(){

                @Override
                public void handle(ParsingContext ctx) throws CommandFormatException {
                    ctx.leaveState();
                }
            });
            this.leaveState(',');
            this.leaveState(']');
            this.leaveState('}');
            this.candidates.add("=");
        }

        @Override
        public Collection<String> getCandidates(String chunk) {
            return this.candidates;
        }
    }

    public static class ListItemSeparatorState
    extends DefaultParsingState
    implements ValueTypeCandidatesProvider {
        public static final String ID = "ITMSEP";
        public static final ListItemSeparatorState INSTANCE = new ListItemSeparatorState();

        public ListItemSeparatorState() {
            super(ID);
            this.setEnterHandler(new CharacterHandler(){

                @Override
                public void handle(ParsingContext ctx) throws CommandFormatException {
                    if (!ctx.isEndOfContent()) {
                        ctx.advanceLocation(1);
                    }
                    ctx.leaveState();
                }
            });
        }

        @Override
        public Collection<String> getCandidates(String chunk) {
            return Collections.emptyList();
        }
    }

    public static class PropertyListState
    extends DefaultParsingState {
        public static final String ID = "PROPLIST";
        public static final PropertyListState INSTANCE = new PropertyListState();

        public PropertyListState() {
            super(ID);
            this.setEnterHandler(new CharacterHandler(){

                @Override
                public void handle(ParsingContext ctx) throws CommandFormatException {
                    ctx.enterState(PropertyState.INSTANCE);
                }
            });
            this.setDefaultHandler(new CharacterHandler(){

                @Override
                public void handle(ParsingContext ctx) throws CommandFormatException {
                    ctx.enterState(PropertyState.INSTANCE);
                }
            });
            this.setReturnHandler(new CharacterHandler(){

                @Override
                public void handle(ParsingContext ctx) throws CommandFormatException {
                    if (ctx.isEndOfContent()) {
                        ctx.leaveState();
                        return;
                    }
                    char ch = ctx.getCharacter();
                    this.getHandler(ch).handle(ctx);
                }
            });
            this.enterState(',', ListItemSeparatorState.INSTANCE);
            this.leaveState(']');
            this.leaveState('}');
            this.setIgnoreWhitespaces(true);
        }
    }

    public static class StartListState
    extends DefaultParsingState {
        public static final String ID = "LST";
        private static StartListState INSTANCE = new StartListState();

        public StartListState() {
            super(ID);
            this.setDefaultHandler(new CharacterHandler(){

                @Override
                public void handle(ParsingContext ctx) throws CommandFormatException {
                    ctx.enterState(PropertyListState.INSTANCE);
                }
            });
            this.setIgnoreWhitespaces(true);
            this.setReturnHandler(new CharacterHandler(){

                @Override
                public void handle(ParsingContext ctx) throws CommandFormatException {
                    ctx.leaveState();
                }
            });
        }
    }

    public static class StartObjectState
    extends DefaultParsingState {
        public static final String ID = "OBJ";
        private static StartObjectState INSTANCE = new StartObjectState();

        public StartObjectState() {
            super(ID);
            this.setDefaultHandler(new CharacterHandler(){

                @Override
                public void handle(ParsingContext ctx) throws CommandFormatException {
                    ctx.enterState(PropertyListState.INSTANCE);
                }
            });
            this.setIgnoreWhitespaces(true);
            this.setReturnHandler(new CharacterHandler(){

                @Override
                public void handle(ParsingContext ctx) throws CommandFormatException {
                    ctx.leaveState();
                }
            });
        }
    }

    public static class InitialValueState
    extends ValueTypeCandidatesState {
        public static final String ID = "INITVAL";
        public static final InitialValueState INSTANCE = new InitialValueState();

        public InitialValueState() {
            this(PropertyState.INSTANCE);
        }

        public InitialValueState(PropertyState prop) {
            super(ID);
            this.enterState('{', StartObjectState.INSTANCE);
            this.enterState('[', StartListState.INSTANCE);
            this.setDefaultHandler(new CharacterHandler(){

                @Override
                public void handle(ParsingContext ctx) throws CommandFormatException {
                    ctx.enterState(PropertyListState.INSTANCE);
                }
            });
            this.addCandidate("{");
            this.addCandidate("[");
            this.addCandidates(prop.getCandidates(null));
        }
    }

    static abstract class ValueTypeCandidatesState
    extends DefaultParsingState
    implements ValueTypeCandidatesProvider {
        private final Collection<String> candidates = new ArrayList<String>();

        ValueTypeCandidatesState(String id) {
            super(id);
        }

        protected void addCandidate(String candidate) {
            this.candidates.add(candidate);
        }

        protected void addCandidates(Collection<String> candidates) {
            this.candidates.addAll(candidates);
        }

        @Override
        public Collection<String> getCandidates(String chunk) {
            if (this.candidates.isEmpty()) {
                return Collections.emptyList();
            }
            if (chunk == null || chunk.length() == 0) {
                return this.candidates;
            }
            ArrayList<String> filtered = new ArrayList<String>(this.candidates.size());
            for (String candidate : this.candidates) {
                if (!candidate.startsWith(chunk)) continue;
                filtered.add(candidate);
            }
            return filtered;
        }
    }

    public static interface ValueTypeCandidatesProvider {
        public Collection<String> getCandidates(String var1);
    }

    private final class ValueTypeCallbackHandler
    implements ParsingStateCallbackHandler {
        private static final String offsetStep = "  ";
        private final boolean logging;
        private int offset;
        private StringBuilder propBuf = new StringBuilder();
        private String lastEnteredState;
        private int lastStateIndex;
        private char lastStateChar;
        private int valLength;

        ValueTypeCallbackHandler(boolean logging) {
            this.logging = logging;
        }

        private List<String> getCandidatesFromMetadata(ModelNode propType, String path) {
            ArrayList<String> candidates = null;
            if (propType.has("filesystem-path") && propType.get("filesystem-path").asBoolean()) {
                FilenameTabCompleter completer = FilenameTabCompleter.newCompleter(ValueTypeCompleter.this.ctx);
                candidates = new ArrayList<String>();
                completer.complete(ValueTypeCompleter.this.ctx, path, this.offset, candidates);
                if (candidates.isEmpty()) {
                    return null;
                }
                if (candidates.size() == 1) {
                    String candidate = (String)candidates.get(0);
                    int sepIndex = path.lastIndexOf(File.separator);
                    String lastPath = path;
                    if (sepIndex >= 0 && sepIndex < path.length() - 1) {
                        lastPath = path.substring(sepIndex + 1);
                    }
                    if (candidate.equals(lastPath)) {
                        candidates.clear();
                        return candidates;
                    }
                }
                this.valLength = path.lastIndexOf(File.separator) + 1;
                if (Util.isWindows()) {
                    int i = path.lastIndexOf(File.separator);
                    if (i >= 0) {
                        this.valLength = 2;
                    }
                    if (candidates.size() == 1) {
                        String candidate = (String)candidates.get(0);
                        if (candidate.endsWith(File.separator)) {
                            candidate = candidate + File.separator;
                        }
                        candidates.set(0, candidate);
                    }
                }
            } else if (propType.has("relative-to") && propType.get("relative-to").asBoolean()) {
                DeploymentItemCompleter completer = new DeploymentItemCompleter(ValueTypeCompleter.this.address);
                candidates = new ArrayList();
                this.valLength = completer.complete(ValueTypeCompleter.this.ctx, path, this.offset, candidates);
                if (candidates.isEmpty()) {
                    return null;
                }
            } else if (propType.has("capability-reference")) {
                String candidate;
                CapabilityReferenceCompleter completer = ValueTypeCompleter.this.factory.newCompleter(ValueTypeCompleter.this.address, propType.get("capability-reference").asString());
                candidates = new ArrayList();
                completer.complete(ValueTypeCompleter.this.ctx, path, this.offset, candidates);
                if (candidates.isEmpty()) {
                    return null;
                }
                if (candidates.size() == 1 && (candidate = (String)candidates.get(0)).equals(path)) {
                    candidates.clear();
                    return candidates;
                }
            }
            return candidates;
        }

        public int getCompletionIndex() {
            switch (this.lastStateChar) {
                case ',': 
                case '=': 
                case '[': 
                case ']': 
                case '{': 
                case '}': {
                    if (ValueTypeCompleter.this.currentInstance != null && ValueTypeCompleter.this.currentInstance.parent == null && ValueTypeCompleter.this.currentInstance.isComplete()) {
                        return 0;
                    }
                    return this.lastStateIndex + (this.valLength == 0 ? 1 : this.valLength);
                }
            }
            return this.lastStateIndex + this.valLength;
        }

        public Collection<String> getCandidates(ModelNode propDescr) {
            if (propDescr == null || !propDescr.isDefined()) {
                return Collections.emptyList();
            }
            if (!propDescr.has("value-type")) {
                return Collections.emptyList();
            }
            if (this.lastEnteredState == null && propDescr.has("type")) {
                ModelNode mt = propDescr.get("type");
                if (ValueTypeCompleter.typeEquals(mt, ModelType.OBJECT)) {
                    return Collections.singletonList("{");
                }
                if (ValueTypeCompleter.typeEquals(mt, ModelType.LIST)) {
                    return Collections.singletonList("[");
                }
            }
            ModelNode propType = null;
            if (ValueTypeCompleter.this.currentInstance != null) {
                propType = ValueTypeCompleter.this.currentInstance.getType();
            }
            if (propType == null) {
                return Collections.emptyList();
            }
            if (ValueTypeCompleter.this.currentInstance.parent == null && ValueTypeCompleter.this.currentInstance.isComplete()) {
                this.lastStateIndex = 0;
                return Collections.singletonList(ValueTypeCompleter.this.buffer);
            }
            Instance.Property last = ValueTypeCompleter.this.currentInstance.getLastProperty();
            HashSet<String> presentProperties = new HashSet<String>();
            for (Instance.Property p : ValueTypeCompleter.this.currentInstance.properties) {
                if (p.value == null) continue;
                presentProperties.add(p.name);
            }
            String nameChunk = null;
            if (last != null && !this.lastEnteredState.equals("EQ") && last.value == null) {
                nameChunk = last.name;
            }
            List<Property> properties = ValueTypeCompleter.isObject(propType) ? propType.asPropertyList() : Collections.emptyList();
            DefaultOperationCandidatesProvider.PropertyVisibility visibility = new DefaultOperationCandidatesProvider.PropertyVisibility(properties, presentProperties, nameChunk);
            if (this.lastEnteredState.equals("ITMSEP") || last == null) {
                return this.completeNewProperty(propType, visibility);
            }
            if (this.lastEnteredState.equals("EQ")) {
                if (!ValueTypeCompleter.isObject(propType)) {
                    return Collections.emptyList();
                }
                if (ValueTypeCompleter.this.currentInstance instanceof ListInstance) {
                    return Collections.emptyList();
                }
                ModelNode pType = propType.get(last.name);
                if (pType.has("type")) {
                    ModelNode mt = pType.get("type");
                    if (ValueTypeCompleter.typeEquals(mt, ModelType.OBJECT)) {
                        return Collections.singletonList("{");
                    }
                    if (ValueTypeCompleter.typeEquals(mt, ModelType.LIST)) {
                        return Collections.singletonList("[");
                    }
                }
                ArrayList<String> candidates = new ArrayList<String>();
                boolean complete = this.getSimpleValues(propType, last.name, "", candidates);
                if (complete) {
                    return this.getCompletedValueCandidates(propType, visibility);
                }
                return candidates;
            }
            if (last.value != null) {
                if (last.name != null) {
                    if (!ValueTypeCompleter.isObject(propType)) {
                        return Collections.emptyList();
                    }
                    if (last.value.isComplete()) {
                        return this.getCompletedValueCandidates(propType, visibility);
                    }
                    ArrayList<String> candidates = new ArrayList<String>();
                    boolean complete = this.getSimpleValues(propType, last.name, last.value.asString(), candidates);
                    if (complete) {
                        return this.getCompletedValueCandidates(propType, visibility);
                    }
                    return candidates;
                }
                if (ValueTypeCompleter.this.currentInstance instanceof ListInstance && !ValueTypeCompleter.this.currentInstance.isComplete()) {
                    if (last.value instanceof SimpleInstance && ValueTypeCompleter.isObject(propType)) {
                        return Collections.emptyList();
                    }
                    if (((ValueTypeCompleter)ValueTypeCompleter.this).currentInstance.type.has("capability-reference")) {
                        return this.getCapabilitiesListContent(last);
                    }
                    ArrayList<String> candidates = new ArrayList<String>();
                    this.getSimpleValues(((ValueTypeCompleter)ValueTypeCompleter.this).currentInstance.type, null, last.value.asString(), candidates);
                    if (candidates.isEmpty() && (ValueTypeCompleter.isObject(propType) || propType.asType() == ModelType.LIST)) {
                        candidates.add("]");
                        candidates.add(",");
                    }
                    Collections.sort(candidates);
                    return candidates;
                }
                return Collections.emptyList();
            }
            if (last.name != null) {
                ArrayList<String> candidates = new ArrayList<String>();
                if (!ValueTypeCompleter.isObject(propType)) {
                    return Collections.emptyList();
                }
                visibility.addCandidates(candidates);
                if (candidates.size() == 1 && last.name.equals(candidates.get(0))) {
                    candidates.set(0, last.name + "=");
                }
                Collections.sort(candidates);
                return candidates;
            }
            return Collections.emptyList();
        }

        private Set<String> getAllCapabilities() {
            String staticPart = ((ValueTypeCompleter)ValueTypeCompleter.this).currentInstance.type.get("capability-reference").asString();
            List<String> names = ValueTypeCompleter.this.factory.newCompleter(ValueTypeCompleter.this.address, staticPart).getCapabilityReferenceNames(ValueTypeCompleter.this.ctx, ValueTypeCompleter.this.address, staticPart);
            HashSet<String> allSet = new HashSet<String>();
            allSet.addAll(names);
            return allSet;
        }

        private Set<String> getPresentCapabilities() {
            HashSet<String> presentSet = new HashSet<String>();
            for (Instance.Property p : ValueTypeCompleter.this.currentInstance.properties) {
                presentSet.add(p.value.asString());
            }
            return presentSet;
        }

        private List<String> getCapabilitiesListContent(Instance.Property last) {
            Set<String> presentSet;
            String val = last == null ? "" : last.value.asString();
            String staticPart = ((ValueTypeCompleter)ValueTypeCompleter.this).currentInstance.type.get("capability-reference").asString();
            Set<String> allSet = this.getAllCapabilities();
            if (allSet.equals(presentSet = this.getPresentCapabilities())) {
                this.valLength = ValueTypeCompleter.this.buffer.length() - this.lastStateIndex;
                return Collections.singletonList("]");
            }
            CapabilityReferenceCompleter completer = ValueTypeCompleter.this.factory.newCompleter(ValueTypeCompleter.this.address, staticPart);
            ArrayList<String> candidates = new ArrayList<String>();
            completer.complete(ValueTypeCompleter.this.ctx, val, this.offset, candidates);
            if (candidates.size() == 1 && ((String)candidates.get(0)).equals(val)) {
                this.valLength = ValueTypeCompleter.this.buffer.length() - this.lastStateIndex;
                candidates.set(0, ",");
            }
            candidates.removeAll(presentSet);
            Collections.sort(candidates);
            return candidates;
        }

        private List<String> getCompletedValueCandidates(ModelNode propType, DefaultOperationCandidatesProvider.PropertyVisibility visibility) {
            this.valLength = ValueTypeCompleter.this.buffer.length() - this.lastStateIndex;
            if (propType.getType() == ModelType.OBJECT) {
                if (visibility.hasMore()) {
                    return Collections.singletonList(",");
                }
                return Collections.singletonList("}");
            }
            return Collections.emptyList();
        }

        /*
         * Enabled aggressive block sorting
         */
        private boolean getSimpleValues(ModelNode propType, String name, String radical, List<String> candidates) {
            List allowed;
            block10: {
                if (name != null) {
                    propType = propType.get(name);
                }
                if (!propType.has("allowed")) {
                    if (this.isBoolean(propType)) {
                        allowed = BOOLEAN_LIST;
                        break block10;
                    } else {
                        if (this.isBytes(propType)) {
                            if (radical.endsWith("}")) {
                                return true;
                            }
                            BytesCompleter.INSTANCE.complete(ValueTypeCompleter.this.ctx, radical, 0, candidates);
                            return false;
                        }
                        List<String> c = this.getCandidatesFromMetadata(propType, radical);
                        if (c != null) {
                            if (c.isEmpty()) {
                                return true;
                            }
                            candidates.addAll(c);
                        }
                        return false;
                    }
                }
                allowed = propType.get("allowed").asList();
            }
            boolean isComplete = false;
            for (ModelNode candidate : allowed) {
                String c = candidate.asString();
                if (!c.startsWith(radical)) continue;
                if (c.equals(radical)) {
                    isComplete = true;
                    break;
                }
                candidates.add(candidate.asString());
            }
            Collections.sort(candidates);
            return isComplete;
        }

        private Collection<String> completeNewProperty(ModelNode propType, DefaultOperationCandidatesProvider.PropertyVisibility visibility) {
            if (ValueTypeCompleter.this.currentInstance instanceof ListInstance) {
                try {
                    ModelType mt = propType.asType();
                    if (mt.equals((Object)ModelType.BOOLEAN)) {
                        ArrayList<String> candidates = new ArrayList<String>();
                        for (ModelNode candidate : BOOLEAN_LIST) {
                            candidates.add(candidate.asString());
                        }
                        Collections.sort(candidates);
                        return candidates;
                    }
                    List<String> candidates = null;
                    if (mt.equals((Object)ModelType.OBJECT)) {
                        candidates = this.getCandidatesFromMetadata(propType, "");
                        if (candidates == null) {
                            candidates = new ArrayList<String>();
                            candidates.add("{");
                        }
                    } else {
                        if (mt.equals((Object)ModelType.LIST)) {
                            return Collections.singletonList("[");
                        }
                        candidates = ((ValueTypeCompleter)ValueTypeCompleter.this).currentInstance.type.has("capability-reference") ? this.getCapabilitiesListContent(null) : this.getCandidatesFromMetadata(((ValueTypeCompleter)ValueTypeCompleter.this).currentInstance.type, "");
                    }
                    if (candidates != null) {
                        return candidates;
                    }
                    return Collections.emptyList();
                }
                catch (IllegalArgumentException ex) {
                    return Collections.singletonList("{");
                }
            }
            if (propType.getType() == ModelType.OBJECT) {
                ArrayList<String> candidates = new ArrayList<String>();
                if (propType.keys().isEmpty()) {
                    candidates.add("}");
                } else {
                    visibility.addCandidates(candidates);
                }
                return candidates;
            }
            return Collections.emptyList();
        }

        protected boolean isBoolean(ModelNode propType) {
            if (propType.has("type")) {
                return ValueTypeCompleter.typeEquals(propType.get("type"), ModelType.BOOLEAN);
            }
            return false;
        }

        protected boolean isBytes(ModelNode propType) {
            if (propType.has("type")) {
                return ValueTypeCompleter.typeEquals(propType.get("type"), ModelType.BYTES);
            }
            return false;
        }

        @Override
        public void enteredState(ParsingContext ctx) throws CommandFormatException {
            this.lastEnteredState = ctx.getState().getId();
            this.lastStateIndex = ctx.getLocation();
            this.lastStateChar = ctx.getCharacter();
            if (this.logging) {
                StringBuilder buf = new StringBuilder();
                for (int i = 0; i < this.offset; ++i) {
                    buf.append(offsetStep);
                }
                buf.append("entered '" + this.lastStateChar + "' " + this.lastEnteredState);
                System.out.println(buf.toString());
                if (this.lastEnteredState.equals("PROPLIST")) {
                    ++this.offset;
                }
            }
            switch (this.lastEnteredState) {
                case "LST": 
                case "OBJ": {
                    if (ValueTypeCompleter.this.currentInstance == null) {
                        ValueTypeCompleter.this.currentInstance = Instance.newInstance(null, "" + this.lastStateChar);
                        ((ValueTypeCompleter)ValueTypeCompleter.this).currentInstance.type = ValueTypeCompleter.this.propDescr;
                        break;
                    }
                    ValueTypeCompleter.this.currentInstance = ValueTypeCompleter.this.currentInstance.newPropertyValue("" + this.lastStateChar);
                    break;
                }
                case "PROP": {
                    if (ValueTypeCompleter.this.currentInstance == null) {
                        throw new CommandFormatException("Invalid syntax.");
                    }
                    ValueTypeCompleter.this.currentInstance.newProperty();
                    break;
                }
                case "EQ": {
                    if (ValueTypeCompleter.this.currentInstance == null) {
                        throw new CommandFormatException("Invalid syntax.");
                    }
                    ValueTypeCompleter.this.currentInstance.setPropertyName(this.propBuf.toString());
                    this.propBuf.setLength(0);
                }
            }
        }

        @Override
        public void leavingState(ParsingContext ctx) throws CommandFormatException {
            String id = ctx.getState().getId();
            if (this.logging) {
                if (id.equals("PROPLIST")) {
                    --this.offset;
                }
                StringBuilder buf = new StringBuilder();
                for (int i = 0; i < this.offset; ++i) {
                    buf.append(offsetStep);
                }
                buf.append("leaving '" + ctx.getCharacter() + "' " + id);
                System.out.println(buf.toString());
            }
            switch (id) {
                case "TEXT": 
                case "PROP": {
                    if (this.propBuf.length() <= 0) break;
                    ValueTypeCompleter.this.currentInstance.endProperty(this.propBuf.toString(), false);
                    this.propBuf.setLength(0);
                    break;
                }
                case "BYTES_VALUE": {
                    ValueTypeCompleter.this.currentInstance.endProperty(this.propBuf.toString(), true);
                    if (ctx.isEndOfContent()) break;
                    ((ValueTypeCompleter)ValueTypeCompleter.this).currentInstance.current.value.setComplete(ctx.getCharacter());
                    if (ctx.getCharacter() != '}') break;
                    ctx.advanceLocation(1);
                    break;
                }
                case "LST": 
                case "OBJ": {
                    if (ctx.isEndOfContent()) break;
                    ValueTypeCompleter.this.currentInstance = ValueTypeCompleter.this.currentInstance.setComplete(ctx.getCharacter());
                    if (ctx.getCharacter() != '}' && ctx.getCharacter() != ']') break;
                    ctx.advanceLocation(1);
                }
            }
        }

        @Override
        public void character(ParsingContext ctx) throws CommandFormatException {
            String id = ctx.getState().getId();
            if (this.logging) {
                StringBuilder buf = new StringBuilder();
                for (int i = 0; i < this.offset; ++i) {
                    buf.append(offsetStep);
                }
                buf.append("char '" + ctx.getCharacter() + "' " + id);
                System.out.println(buf.toString());
            }
            if (id.equals("PROP")) {
                char ch = ctx.getCharacter();
                if (ch != '\"' && !Character.isWhitespace(ch)) {
                    this.propBuf.append(ch);
                }
            } else if (id.equals("TEXT") || id.equals("BYTES_VALUE")) {
                this.propBuf.append(ctx.getCharacter());
            } else if (id.equals("ESCAPED_CHARACTER")) {
                this.propBuf.append(ctx.getCharacter());
            }
        }
    }

    public static interface CapabilityCompleterFactory {
        public CapabilityReferenceCompleter newCompleter(OperationRequestAddress var1, String var2);
    }

    private static class BytesInstance
    extends Instance {
        private final String value;

        public BytesInstance(Instance parent, String value) {
            super(parent);
            this.value = value;
        }

        @Override
        public String asString() {
            return this.value;
        }

        @Override
        boolean isCompliantType(ModelNode t) {
            return t.getType() == ModelType.BYTES;
        }

        @Override
        boolean isTerminalChar(char c) {
            return c == '}';
        }

        @Override
        ModelNode retrieveType() {
            return null;
        }
    }

    private static class SimpleInstance
    extends Instance {
        private final String value;

        public SimpleInstance(Instance parent, String value) {
            super(parent);
            this.value = value;
        }

        @Override
        public String asString() {
            return this.value;
        }

        @Override
        boolean isCompliantType(ModelNode t) {
            return !ValueTypeCompleter.typeEquals(t, ModelType.OBJECT) && !ValueTypeCompleter.typeEquals(t, ModelType.LIST);
        }

        @Override
        boolean isTerminalChar(char c) {
            return false;
        }

        @Override
        ModelNode retrieveType() {
            return null;
        }
    }

    private static class ComplexInstance
    extends Instance {
        public ComplexInstance(Instance parent) {
            super(parent);
        }

        @Override
        boolean isTerminalChar(char c) {
            return c == '}';
        }

        @Override
        public void endProperty(String content, boolean isBytes) {
            if (this.current.name == null) {
                this.current.name = content;
                return;
            }
            super.endProperty(content, isBytes);
        }

        @Override
        boolean isCompliantType(ModelNode t) {
            return ValueTypeCompleter.typeEquals(t, ModelType.OBJECT);
        }

        @Override
        ModelNode retrieveType() {
            if (this.current.name != null) {
                ModelNode vt;
                if (this.type.has(this.current.name)) {
                    return this.type.get(this.current.name);
                }
                if (this.type.has("value-type") && (vt = this.type.get("value-type")).has(this.current.name)) {
                    return vt.get(this.current.name);
                }
            }
            return null;
        }
    }

    private static class ListInstance
    extends Instance {
        public ListInstance(Instance parent) {
            super(parent);
        }

        @Override
        boolean isTerminalChar(char c) {
            return c == ']';
        }

        @Override
        boolean isCompliantType(ModelNode t) {
            return ValueTypeCompleter.typeEquals(t, ModelType.LIST);
        }

        @Override
        ModelNode retrieveType() {
            if (this.type.has("value-type")) {
                return this.type.get("value-type");
            }
            return null;
        }
    }

    private static abstract class Instance {
        private final Instance parent;
        private final List<Property> properties = new ArrayList<Property>();
        protected Property current;
        private boolean complete;
        protected ModelNode type;

        static Instance newInstance(Instance parent, String c) {
            switch (c) {
                case "[": {
                    return new ListInstance(parent);
                }
                case "{": {
                    return new ComplexInstance(parent);
                }
            }
            return new SimpleInstance(parent, c);
        }

        Instance(Instance parent) {
            this.parent = parent;
        }

        ModelNode getType() {
            if (this.type == null) {
                return null;
            }
            if (this.type.has("value-type")) {
                return this.type.get("value-type");
            }
            return this.type;
        }

        abstract boolean isCompliantType(ModelNode var1);

        Instance setComplete(char c) {
            this.complete = this.isTerminalChar(c);
            if (this.complete) {
                return this.parent == null ? this : this.parent;
            }
            return this;
        }

        abstract boolean isTerminalChar(char var1);

        boolean isComplete() {
            return this.complete;
        }

        void newProperty() {
            this.current = new Property();
            this.properties.add(this.current);
        }

        public Property getLastProperty() {
            if (this.properties.isEmpty()) {
                return null;
            }
            return this.properties.get(this.properties.size() - 1);
        }

        public void endProperty(String content, boolean isBytes) {
            if (this.current.value == null) {
                if (isBytes) {
                    this.current.value = new BytesInstance(this, content);
                } else {
                    this.current.value = new SimpleInstance(this, content);
                }
            }
        }

        private Instance newPropertyValue(String c) throws CommandFormatException {
            if (this.current == null) {
                throw new CommandFormatException("Invalid syntax");
            }
            this.current.value = Instance.newInstance(this, c);
            ((Property)this.current).value.type = this.retrieveType();
            return this.current.value;
        }

        abstract ModelNode retrieveType();

        private void setPropertyName(String name) throws CommandFormatException {
            if (this.current == null) {
                throw new CommandFormatException("Invalid syntax");
            }
            this.current.name = name;
        }

        public String asString() {
            return null;
        }

        private boolean contains(String p) {
            boolean found = false;
            for (Property prop : this.properties) {
                if (prop.name == null || !prop.name.equals(p) || prop.value == null) continue;
                found = true;
                break;
            }
            return found;
        }

        static class Property {
            private String name;
            private Instance value;

            Property() {
            }
        }
    }
}

