/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.sts.registry;

import java.io.File;
import java.io.IOException;
import org.picketlink.common.PicketLinkLogger;
import org.picketlink.common.PicketLinkLoggerFactory;

public abstract class FileBasedSTSOperations {
    protected static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    protected File directory;

    public FileBasedSTSOperations() {
        StringBuilder builder = new StringBuilder();
        builder.append(System.getProperty("user.home"));
        builder.append(System.getProperty("file.separator") + "picketlink-store");
        builder.append(System.getProperty("file.separator") + "sts");
        this.directory = new File(builder.toString());
        if (!this.directory.exists()) {
            this.directory.mkdirs();
        }
    }

    protected File create(String fileName) {
        if (fileName == null) {
            throw logger.nullArgumentError("file name");
        }
        File createdFile = new File(fileName);
        if (!createdFile.exists()) {
            try {
                createdFile.createNewFile();
            }
            catch (IOException ioe) {
                logger.debug("Error creating file: " + ioe.getMessage());
                ioe.printStackTrace();
            }
        }
        return createdFile;
    }
}

