/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.deployment;

import io.undertow.servlet.api.AuthMethodConfig;
import io.undertow.util.QueryParameterUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Map;

public class AuthMethodParser {
    public static final String UTF_8 = "UTF-8";

    public static List<AuthMethodConfig> parse(String methods, Map<String, String> replacements) {
        try {
            String[] parts;
            if (methods == null || methods.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<AuthMethodConfig> ret = new ArrayList<AuthMethodConfig>();
            for (String part : parts = methods.split(",")) {
                if (part.isEmpty()) continue;
                int index = part.indexOf(63);
                if (index == -1) {
                    ret.add(AuthMethodParser.createAuthMethodConfig(part, replacements));
                    continue;
                }
                String name = part.substring(0, index);
                Map props = QueryParameterUtils.parseQueryString((String)part.substring(index + 1), (String)UTF_8);
                AuthMethodConfig authMethodConfig = AuthMethodParser.createAuthMethodConfig(name, replacements);
                for (Map.Entry entry : props.entrySet()) {
                    Deque val = (Deque)entry.getValue();
                    if (val.isEmpty()) {
                        authMethodConfig.getProperties().put(entry.getKey(), "");
                        continue;
                    }
                    authMethodConfig.getProperties().put(entry.getKey(), val.getFirst());
                }
                ret.add(authMethodConfig);
            }
            return ret;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static AuthMethodConfig createAuthMethodConfig(String part, Map<String, String> replacements) throws UnsupportedEncodingException {
        String name = URLDecoder.decode(part, UTF_8);
        if (replacements.containsKey(name)) {
            return new AuthMethodConfig(replacements.get(name));
        }
        return new AuthMethodConfig(name);
    }

    private AuthMethodParser() {
    }
}

