/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.persistence.AddressQueueStatus;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.Bindings;
import org.apache.activemq.artemis.core.postoffice.PostOffice;
import org.apache.activemq.artemis.core.postoffice.QueueBinding;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.metrics.MetricsManager;
import org.apache.activemq.artemis.utils.CompositeAddress;
import org.apache.activemq.artemis.utils.PrefixUtil;

public class AddressInfo {
    private long id;
    private long pauseStatusRecord = -1L;
    private final SimpleString name;
    private boolean autoCreated = false;
    private static final EnumSet<RoutingType> EMPTY_ROUTING_TYPES = EnumSet.noneOf(RoutingType.class);
    private EnumSet<RoutingType> routingTypes;
    private RoutingType firstSeen;
    private boolean internal = false;
    private volatile long routedMessageCount = 0L;
    private static final AtomicLongFieldUpdater<AddressInfo> routedMessageCountUpdater = AtomicLongFieldUpdater.newUpdater(AddressInfo.class, "routedMessageCount");
    private volatile long unRoutedMessageCount = 0L;
    private static final AtomicLongFieldUpdater<AddressInfo> unRoutedMessageCountUpdater = AtomicLongFieldUpdater.newUpdater(AddressInfo.class, "unRoutedMessageCount");
    private long bindingRemovedTimestamp = -1L;
    private volatile boolean paused = false;
    private PostOffice postOffice;
    private StorageManager storageManager;

    public AddressInfo(SimpleString name) {
        this(name, EnumSet.noneOf(RoutingType.class));
    }

    public AddressInfo(SimpleString name, EnumSet<RoutingType> routingTypes) {
        this.name = CompositeAddress.extractAddressName((SimpleString)name);
        this.setRoutingTypes(routingTypes);
    }

    public AddressInfo(SimpleString name, RoutingType routingType) {
        this.name = CompositeAddress.extractAddressName((SimpleString)name);
        this.addRoutingType(routingType);
    }

    public boolean isAutoCreated() {
        return this.autoCreated;
    }

    public AddressInfo setAutoCreated(boolean autoCreated) {
        this.autoCreated = autoCreated;
        return this;
    }

    public SimpleString getName() {
        return this.name;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getId() {
        return this.id;
    }

    public EnumSet<RoutingType> getRoutingTypes() {
        return this.routingTypes == null ? EMPTY_ROUTING_TYPES : this.routingTypes;
    }

    public AddressInfo setRoutingTypes(EnumSet<RoutingType> routingTypes) {
        this.routingTypes = routingTypes;
        this.firstSeen = routingTypes != null && !routingTypes.isEmpty() ? (RoutingType)routingTypes.iterator().next() : null;
        return this;
    }

    public AddressInfo addRoutingType(RoutingType routingType) {
        if (routingType != null) {
            if (this.routingTypes == null || this.routingTypes.isEmpty()) {
                this.routingTypes = EnumSet.of(routingType);
                this.firstSeen = routingType;
            } else {
                this.routingTypes.add(routingType);
            }
        }
        return this;
    }

    public RoutingType getRoutingType() {
        return this.firstSeen;
    }

    public long getBindingRemovedTimestamp() {
        return this.bindingRemovedTimestamp;
    }

    public void setBindingRemovedTimestamp(long bindingRemovedTimestamp) {
        this.bindingRemovedTimestamp = bindingRemovedTimestamp;
    }

    public synchronized void reloadPause(long recordID) {
        if (this.pauseStatusRecord >= 0L) {
            try {
                this.storageManager.deleteAddressStatus(this.pauseStatusRecord);
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.unableToDeleteQueueStatus(e);
            }
        }
        this.pauseStatusRecord = recordID;
        try {
            Bindings bindings = this.postOffice.lookupBindingsForAddress(this.getName());
            if (bindings != null) {
                for (Binding binding : bindings.getBindings()) {
                    if (!(binding instanceof QueueBinding)) continue;
                    ((QueueBinding)binding).getQueue().pause(false);
                }
            }
        }
        catch (Throwable e) {
            ActiveMQServerLogger.LOGGER.warn(e.getMessage(), e);
        }
        this.paused = true;
    }

    public synchronized void pause(boolean persist) {
        if (this.postOffice == null) {
            throw new IllegalStateException("");
        }
        if (this.storageManager == null && persist) {
            throw new IllegalStateException("");
        }
        try {
            Bindings bindings;
            if (persist) {
                if (this.pauseStatusRecord >= 0L) {
                    try {
                        this.storageManager.deleteAddressStatus(this.pauseStatusRecord);
                    }
                    catch (Exception e) {
                        ActiveMQServerLogger.LOGGER.unableToDeleteQueueStatus(e);
                    }
                }
                this.pauseStatusRecord = this.storageManager.storeAddressStatus(this.getId(), AddressQueueStatus.PAUSED);
            }
            if ((bindings = this.postOffice.lookupBindingsForAddress(this.getName())) != null) {
                for (Binding binding : bindings.getBindings()) {
                    if (!(binding instanceof QueueBinding)) continue;
                    ((QueueBinding)binding).getQueue().pause(false);
                }
            }
            this.paused = true;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public synchronized void resume() {
        if (this.postOffice == null) {
            throw new IllegalStateException("");
        }
        if (this.storageManager == null && this.pauseStatusRecord > 0L) {
            throw new IllegalStateException("");
        }
        if (!this.paused) {
            return;
        }
        try {
            Bindings bindings;
            if (this.pauseStatusRecord > 0L) {
                this.storageManager.deleteAddressStatus(this.pauseStatusRecord);
            }
            if ((bindings = this.postOffice.lookupBindingsForAddress(this.getName())) != null) {
                for (Binding binding : bindings.getBindings()) {
                    if (!(binding instanceof QueueBinding)) continue;
                    ((QueueBinding)binding).getQueue().resume();
                }
            }
            this.paused = false;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    boolean isPersisted() {
        return this.paused && this.pauseStatusRecord > 0L;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setPostOffice(PostOffice postOffice) {
        this.postOffice = postOffice;
    }

    public void setStorageManager(StorageManager storageManager) {
        this.storageManager = storageManager;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append("Address [name=").append((CharSequence)this.name);
        buff.append(", id=").append(this.id);
        buff.append(", routingTypes={");
        for (RoutingType routingType : this.getRoutingTypes()) {
            buff.append(routingType.toString()).append(",");
        }
        if (buff.charAt(buff.length() - 1) == ',') {
            buff.deleteCharAt(buff.length() - 1);
        }
        buff.append("}");
        buff.append(", autoCreated=").append(this.autoCreated);
        buff.append(", paused=").append(this.paused);
        buff.append("]");
        return buff.toString();
    }

    public boolean isInternal() {
        return this.internal;
    }

    public void setInternal(boolean internal) {
        this.internal = internal;
    }

    public AddressInfo create(SimpleString name, RoutingType routingType) {
        AddressInfo info = new AddressInfo(name, routingType);
        info.setInternal(this.internal);
        if (this.paused) {
            info.pause(this.pauseStatusRecord > 0L);
        }
        return info;
    }

    public AddressInfo getAddressAndRoutingType(Map<SimpleString, RoutingType> prefixes) {
        for (Map.Entry<SimpleString, RoutingType> entry : prefixes.entrySet()) {
            if (!this.getName().startsWith(entry.getKey())) continue;
            AddressInfo newAddressInfo = this.create(PrefixUtil.removePrefix((SimpleString)this.getName(), (SimpleString)entry.getKey()), entry.getValue());
            return newAddressInfo;
        }
        return this;
    }

    public long incrementRoutedMessageCount() {
        return routedMessageCountUpdater.incrementAndGet(this);
    }

    public long incrementUnRoutedMessageCount() {
        return unRoutedMessageCountUpdater.incrementAndGet(this);
    }

    public long getRoutedMessageCount() {
        return routedMessageCountUpdater.get(this);
    }

    public long getUnRoutedMessageCount() {
        return unRoutedMessageCountUpdater.get(this);
    }

    public void registerMeters(MetricsManager metricsManager) {
        if (metricsManager != null) {
            metricsManager.registerAddressGauge(this.name.toString(), builder -> {
                builder.register("routed.message.count", this, metrics -> this.getRoutedMessageCount(), "number of messages routed to one or more bindings");
                builder.register("unrouted.message.count", this, metrics -> this.getUnRoutedMessageCount(), "number of messages not routed to any bindings");
            });
        }
    }

    public void unregisterMeters(MetricsManager metricsManager) {
        if (metricsManager != null) {
            metricsManager.remove("address." + this.name);
        }
    }
}

