/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jts.orbspecific.javaidl.recoverycoordinators;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.objectstore.ParticipantStore;
import com.arjuna.ats.arjuna.objectstore.StoreManager;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.internal.jts.Implementations;
import com.arjuna.ats.internal.jts.ORBManager;
import com.arjuna.ats.internal.jts.orbspecific.javaidl.recoverycoordinators.JavaIdlRCDefaultServant;
import com.arjuna.ats.internal.jts.orbspecific.javaidl.recoverycoordinators.JavaIdlRCShutdown;
import com.arjuna.ats.internal.jts.orbspecific.javaidl.recoverycoordinators.ORBRunner;
import com.arjuna.ats.internal.jts.recovery.recoverycoordinators.GenericRecoveryCreator;
import com.arjuna.ats.internal.jts.recovery.recoverycoordinators.RecoveryServiceInit;
import com.arjuna.ats.jts.common.jtsPropertyManager;
import com.arjuna.ats.jts.logging.jtsLogger;
import com.arjuna.orbportability.OA;
import com.arjuna.orbportability.ORB;
import com.arjuna.orbportability.RootOA;
import java.util.Properties;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CosTransactions.RecoveryCoordinatorHelper;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.IdUniquenessPolicyValue;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.RequestProcessingPolicyValue;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer.ServantRetentionPolicyValue;

public class JavaIdlRCServiceInit
implements RecoveryServiceInit {
    private static final String POA_NAME_PREFIX = "RcvCo-";
    private static String OBJ_KEY_PREFIX = "";
    protected static POA _poa = null;
    static String RC_ID = "RecoveryManager";
    static String RC_KEY = JavaIdlRCServiceInit.initRCKey();
    protected static ORB _orb = null;
    protected static RootOA _oa = null;
    protected static String uid4Recovery = "0:ffff52e38d0c:c91:4140398c:0";

    private static POA getRCPOA() {
        String rcServiceName = GenericRecoveryCreator.getRecCoordServiceName();
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug((java.lang.Object)("JavaIdlRCServiceInit.getRCPOA " + rcServiceName));
        }
        if (_poa == null) {
            String domainName = "recovery_coordinator";
            String poaName = POA_NAME_PREFIX + rcServiceName + domainName;
            try {
                POA rootPOA = _oa.rootPoa();
                if (rootPOA == null) {
                    jtsLogger.i18NLogger.warn_orbspecific_jacorb_recoverycoordinators_JacOrbRCServiceInit_8();
                    return null;
                }
                Policy[] policies = null;
                policies = new Policy[]{rootPOA.create_lifespan_policy(LifespanPolicyValue.PERSISTENT), rootPOA.create_servant_retention_policy(ServantRetentionPolicyValue.NON_RETAIN), rootPOA.create_id_assignment_policy(IdAssignmentPolicyValue.USER_ID), rootPOA.create_id_uniqueness_policy(IdUniquenessPolicyValue.MULTIPLE_ID), rootPOA.create_request_processing_policy(RequestProcessingPolicyValue.USE_DEFAULT_SERVANT)};
                _poa = rootPOA.create_POA(poaName, rootPOA.the_POAManager(), policies);
                _oa.addPreShutdown(new JavaIdlRCShutdown());
            }
            catch (Exception ex) {
                jtsLogger.i18NLogger.warn_orbspecific_jacorb_recoverycoordinators_JacOrbRCServiceInit_1(ex);
            }
        }
        return _poa;
    }

    private static void initORBandOA() throws InvalidName {
        if (!ORBManager.isInitialised()) {
            _orb = ORB.getInstance("RecoveryServer");
            String recoveryManagerPort = "" + jtsPropertyManager.getJTSEnvironmentBean().getRecoveryManagerPort();
            String recoveryManagerAddr = jtsPropertyManager.getJTSEnvironmentBean().getRecoveryManagerAddress();
            jtsLogger.logger.debugf("Starting RecoveryServer ORB on port %s and address %s", (java.lang.Object)recoveryManagerPort, (java.lang.Object)recoveryManagerAddr);
            Properties p = new Properties();
            p.setProperty("com.sun.CORBA.POA.ORBPersistentServerPort", recoveryManagerPort);
            p.setProperty("com.sun.CORBA.POA.ORBServerId", recoveryManagerPort);
            if (recoveryManagerAddr != null && recoveryManagerAddr.length() > 0) {
                p.setProperty("OAIAddr", recoveryManagerAddr);
            }
            try {
                _orb.initORB((String[])null, p);
                _oa = OA.getRootOA(_orb);
                _oa.initOA();
            }
            catch (RuntimeException e) {
                ORBManager.reset();
                _orb.shutdown();
                throw e;
            }
            ORBManager.setORB(_orb);
            ORBManager.setPOA(_oa);
        } else {
            _orb = ORBManager.getORB();
            _oa = (RootOA)ORBManager.getPOA();
            jtsLogger.i18NLogger.info_orbspecific_jacorb_recoverycoordinators_JacOrbRCServiceInit_6a();
        }
    }

    @Override
    public boolean startRCservice() {
        try {
            JavaIdlRCServiceInit.initORBandOA();
            POA ourPOA = JavaIdlRCServiceInit.getRCPOA();
            if (ourPOA == null) {
                return false;
            }
            Implementations.initialise();
            JavaIdlRCDefaultServant theButler = new JavaIdlRCDefaultServant(_orb.orb());
            ourPOA.set_servant((Servant)theButler);
            Object obj = ourPOA.create_reference_with_id(RC_ID.getBytes(), RecoveryCoordinatorHelper.id());
            String reference = _orb.orb().object_to_string(obj);
            try {
                OutputObjectState oState = new OutputObjectState();
                oState.packString(reference);
                ParticipantStore txLog = StoreManager.getCommunicationStore();
                txLog.write_committed(new Uid(uid4Recovery), JavaIdlRCServiceInit.type(), oState);
            }
            catch (SecurityException sex) {
                jtsLogger.i18NLogger.fatal_orbspecific_jacorb_recoverycoordinators_JacOrbRCServiceInit_5();
            }
            if (jtsLogger.logger.isDebugEnabled()) {
                jtsLogger.logger.debug((java.lang.Object)"JavaIdlRCServiceInit - set default servant and activated");
            }
            _oa.rootPoa().the_POAManager().activate();
            ORBRunner _runOA = new ORBRunner();
            return true;
        }
        catch (Exception ex) {
            jtsLogger.i18NLogger.warn_orbspecific_jacorb_recoverycoordinators_JacOrbRCServiceInit_3(ex);
            return false;
        }
    }

    public static void shutdownRCService() {
        _poa = null;
    }

    public static String type() {
        return "/RecoveryCoordinator";
    }

    private static String initRCKey() {
        String domainName = "recovery_coordinator";
        String poaName = POA_NAME_PREFIX + GenericRecoveryCreator.getRecCoordServiceName() + domainName;
        return OBJ_KEY_PREFIX + poaName + '/' + RC_ID;
    }
}

