/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.requestcontroller;

import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.as.server.suspend.ServerActivityCallback;
import org.wildfly.extension.requestcontroller.RequestController;
import org.wildfly.extension.requestcontroller.RunResult;

public class ControlPoint {
    private static final AtomicIntegerFieldUpdater<ControlPoint> activeRequestCountUpdater = AtomicIntegerFieldUpdater.newUpdater(ControlPoint.class, "activeRequestCount");
    private static final AtomicReferenceFieldUpdater<ControlPoint, ServerActivityCallback> listenerUpdater = AtomicReferenceFieldUpdater.newUpdater(ControlPoint.class, ServerActivityCallback.class, "listener");
    private final RequestController controller;
    private final String deployment;
    private final String entryPoint;
    private final boolean trackIndividualControlPoints;
    private volatile int activeRequestCount = 0;
    private volatile boolean paused = false;
    private volatile ServerActivityCallback listener = null;
    private int referenceCount = 0;

    ControlPoint(RequestController controller, String deployment, String entryPoint, boolean trackIndividualControlPoints) {
        this.controller = controller;
        this.deployment = deployment;
        this.entryPoint = entryPoint;
        this.trackIndividualControlPoints = trackIndividualControlPoints;
    }

    public String getEntryPoint() {
        return this.entryPoint;
    }

    public String getDeployment() {
        return this.deployment;
    }

    public void pause(ServerActivityCallback requestCountListener) {
        if (this.paused) {
            throw ServerLogger.ROOT_LOGGER.serverAlreadyPaused();
        }
        this.paused = true;
        listenerUpdater.set(this, requestCountListener);
        if (activeRequestCountUpdater.get(this) == 0 && listenerUpdater.compareAndSet(this, requestCountListener, null)) {
            requestCountListener.done();
        }
    }

    public void resume() {
        this.paused = false;
        ServerActivityCallback listener = listenerUpdater.get(this);
        if (listener != null) {
            listenerUpdater.compareAndSet(this, listener, null);
        }
    }

    public RunResult beginRequest() throws Exception {
        RunResult runResult;
        if (this.paused) {
            return RunResult.REJECTED;
        }
        if (this.trackIndividualControlPoints) {
            activeRequestCountUpdater.incrementAndGet(this);
        }
        if ((runResult = this.controller.beginRequest(false)) == RunResult.REJECTED) {
            this.decreaseRequestCount();
        }
        return runResult;
    }

    public RunResult forceBeginRequest() throws Exception {
        if (this.trackIndividualControlPoints) {
            activeRequestCountUpdater.incrementAndGet(this);
        }
        return this.controller.beginRequest(true);
    }

    void beginExistingRequest() {
        if (this.trackIndividualControlPoints) {
            activeRequestCountUpdater.incrementAndGet(this);
        }
    }

    public void requestComplete() {
        this.decreaseRequestCount();
        this.controller.requestComplete();
    }

    private void decreaseRequestCount() {
        if (this.trackIndividualControlPoints) {
            ServerActivityCallback listener;
            int result = activeRequestCountUpdater.decrementAndGet(this);
            if (this.paused && result == 0 && (listener = listenerUpdater.get(this)) != null && listenerUpdater.compareAndSet(this, listener, null)) {
                listener.done();
            }
        }
    }

    public void queueTask(Runnable task, Executor taskExecutor, long timeout, Runnable timeoutTask, boolean rejectOnSuspend) {
        this.controller.queueTask(this, task, taskExecutor, timeout, timeoutTask, rejectOnSuspend, false);
    }

    public void forceQueueTask(Runnable task, Executor taskExecutor) {
        this.controller.queueTask(this, task, taskExecutor, -1L, null, false, true);
    }

    public boolean isPaused() {
        return this.paused;
    }

    public int getActiveRequestCount() {
        return activeRequestCountUpdater.get(this);
    }

    synchronized int increaseReferenceCount() {
        return ++this.referenceCount;
    }

    synchronized int decreaseReferenceCount() {
        return --this.referenceCount;
    }
}

